/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.tableoutput;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.SourceToTargetMapping;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.tableoutput.TableOutputMeta;
import org.pentaho.di.ui.core.database.dialog.DatabaseExplorerDialog;
import org.pentaho.di.ui.core.database.dialog.SQLEditor;
import org.pentaho.di.ui.core.dialog.EnterMappingDialog;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class TableOutputDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = TableOutputMeta.class;
    private CTabFolder wTabFolder;
    private FormData fdTabFolder;
    private CTabItem wMainTab;
    private CTabItem wFieldsTab;
    private FormData fdMainComp;
    private FormData fdFieldsComp;
    private CCombo wConnection;
    private Label wlSchema;
    private TextVar wSchema;
    private FormData fdlSchema;
    private FormData fdSchema;
    private FormData fdbSchema;
    private Button wbSchema;
    private Label wlTable;
    private Button wbTable;
    private TextVar wTable;
    private FormData fdlTable;
    private FormData fdbTable;
    private FormData fdTable;
    private Label wlCommit;
    private TextVar wCommit;
    private FormData fdlCommit;
    private FormData fdCommit;
    private Label wlTruncate;
    private Button wTruncate;
    private FormData fdlTruncate;
    private FormData fdTruncate;
    private Label wlIgnore;
    private Button wIgnore;
    private FormData fdlIgnore;
    private FormData fdIgnore;
    private Label wlSpecifyFields;
    private Button wSpecifyFields;
    private FormData fdlSpecifyFields;
    private FormData fdSpecifyFields;
    private Label wlBatch;
    private Button wBatch;
    private FormData fdlBatch;
    private FormData fdBatch;
    private Label wlUsePart;
    private Button wUsePart;
    private FormData fdlUsePart;
    private FormData fdUsePart;
    private Label wlPartField;
    private ComboVar wPartField;
    private FormData fdlPartField;
    private FormData fdPartField;
    private Label wlPartMonthly;
    private Button wPartMonthly;
    private FormData fdlPartMonthly;
    private FormData fdPartMonthly;
    private Label wlPartDaily;
    private Button wPartDaily;
    private FormData fdlPartDaily;
    private FormData fdPartDaily;
    private Label wlNameInField;
    private Button wNameInField;
    private FormData fdlNameInField;
    private FormData fdNameInField;
    private Label wlNameField;
    private ComboVar wNameField;
    private FormData fdlNameField;
    private FormData fdNameField;
    private Label wlNameInTable;
    private Button wNameInTable;
    private FormData fdlNameInTable;
    private FormData fdNameInTable;
    private Label wlReturnKeys;
    private Button wReturnKeys;
    private FormData fdlReturnKeys;
    private FormData fdReturnKeys;
    private Label wlReturnField;
    private TextVar wReturnField;
    private FormData fdlReturnField;
    private FormData fdReturnField;
    private Label wlFields;
    private TableView wFields;
    private Button wGetFields;
    private FormData fdGetFields;
    private Button wDoMapping;
    private FormData fdDoMapping;
    private TableOutputMeta input;
    private Map<String, Integer> inputFields;
    private ColumnInfo[] ciFields;
    private boolean gotPreviousFields = false;
    private List<ColumnInfo> tableFieldColumns = new ArrayList<ColumnInfo>();

    public TableOutputDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (TableOutputMeta)in;
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TableOutputDialog.this.input.setChanged();
            }
        };
        ModifyListener lsTableMod = new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                TableOutputDialog.this.input.setChanged();
                TableOutputDialog.this.setTableFieldCombo();
            }
        };
        SelectionAdapter lsSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableOutputDialog.this.input.setChanged();
                TableOutputDialog.this.setTableFieldCombo();
            }
        };
        this.backupChanged = this.input.hasChanged();
        int middle = this.props.getMiddlePct();
        int margin = 4;
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.DialogTitle", (String[])new String[0]));
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"System.Label.StepName", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wStepname, middle, margin);
        if (this.input.getDatabaseMeta() == null && this.transMeta.nrDatabases() == 1) {
            this.wConnection.select(0);
        }
        this.wConnection.addModifyListener(lsMod);
        this.wConnection.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                TableOutputDialog.this.setFlags();
            }
        });
        this.wConnection.addSelectionListener((SelectionListener)lsSelection);
        this.wlSchema = new Label((Composite)this.shell, 131072);
        this.wlSchema.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.TargetSchema.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSchema);
        this.fdlSchema = new FormData();
        this.fdlSchema.left = new FormAttachment(0, 0);
        this.fdlSchema.right = new FormAttachment(middle, -margin);
        this.fdlSchema.top = new FormAttachment((Control)this.wConnection, margin * 2);
        this.wlSchema.setLayoutData((Object)this.fdlSchema);
        this.wbSchema = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbSchema);
        this.wbSchema.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.fdbSchema = new FormData();
        this.fdbSchema.top = new FormAttachment((Control)this.wConnection, 2 * margin);
        this.fdbSchema.right = new FormAttachment(100, 0);
        this.wbSchema.setLayoutData((Object)this.fdbSchema);
        this.wSchema = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wSchema);
        this.wSchema.addModifyListener(lsTableMod);
        this.fdSchema = new FormData();
        this.fdSchema.left = new FormAttachment(middle, 0);
        this.fdSchema.top = new FormAttachment((Control)this.wConnection, margin * 2);
        this.fdSchema.right = new FormAttachment((Control)this.wbSchema, -margin);
        this.wSchema.setLayoutData(this.fdSchema);
        this.wlTable = new Label((Composite)this.shell, 131072);
        this.wlTable.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.TargetTable.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTable);
        this.fdlTable = new FormData();
        this.fdlTable.left = new FormAttachment(0, 0);
        this.fdlTable.right = new FormAttachment(middle, -margin);
        this.fdlTable.top = new FormAttachment((Control)this.wbSchema, margin);
        this.wlTable.setLayoutData((Object)this.fdlTable);
        this.wbTable = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbTable);
        this.wbTable.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.fdbTable = new FormData();
        this.fdbTable.right = new FormAttachment(100, 0);
        this.fdbTable.top = new FormAttachment((Control)this.wbSchema, margin);
        this.wbTable.setLayoutData((Object)this.fdbTable);
        this.wTable = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wTable);
        this.wTable.addModifyListener(lsTableMod);
        this.fdTable = new FormData();
        this.fdTable.top = new FormAttachment((Control)this.wbSchema, margin);
        this.fdTable.left = new FormAttachment(middle, 0);
        this.fdTable.right = new FormAttachment((Control)this.wbTable, -margin);
        this.wTable.setLayoutData(this.fdTable);
        this.wlCommit = new Label((Composite)this.shell, 131072);
        this.wlCommit.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.CommitSize.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCommit);
        this.fdlCommit = new FormData();
        this.fdlCommit.left = new FormAttachment(0, 0);
        this.fdlCommit.right = new FormAttachment(middle, -margin);
        this.fdlCommit.top = new FormAttachment((Control)this.wbTable, margin);
        this.wlCommit.setLayoutData((Object)this.fdlCommit);
        this.wCommit = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wCommit);
        this.wCommit.addModifyListener(lsMod);
        this.fdCommit = new FormData();
        this.fdCommit.left = new FormAttachment(middle, 0);
        this.fdCommit.top = new FormAttachment((Control)this.wbTable, margin);
        this.fdCommit.right = new FormAttachment(100, 0);
        this.wCommit.setLayoutData(this.fdCommit);
        this.wlTruncate = new Label((Composite)this.shell, 131072);
        this.wlTruncate.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.TruncateTable.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTruncate);
        this.fdlTruncate = new FormData();
        this.fdlTruncate.left = new FormAttachment(0, 0);
        this.fdlTruncate.top = new FormAttachment((Control)this.wCommit, margin);
        this.fdlTruncate.right = new FormAttachment(middle, -margin);
        this.wlTruncate.setLayoutData((Object)this.fdlTruncate);
        this.wTruncate = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wTruncate);
        this.fdTruncate = new FormData();
        this.fdTruncate.left = new FormAttachment(middle, 0);
        this.fdTruncate.top = new FormAttachment((Control)this.wCommit, margin);
        this.fdTruncate.right = new FormAttachment(100, 0);
        this.wTruncate.setLayoutData((Object)this.fdTruncate);
        SelectionAdapter lsSelMod = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TableOutputDialog.this.input.setChanged();
            }
        };
        this.wTruncate.addSelectionListener((SelectionListener)lsSelMod);
        this.wlIgnore = new Label((Composite)this.shell, 131072);
        this.wlIgnore.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.IgnoreInsertErrors.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlIgnore);
        this.fdlIgnore = new FormData();
        this.fdlIgnore.left = new FormAttachment(0, 0);
        this.fdlIgnore.top = new FormAttachment((Control)this.wTruncate, margin);
        this.fdlIgnore.right = new FormAttachment(middle, -margin);
        this.wlIgnore.setLayoutData((Object)this.fdlIgnore);
        this.wIgnore = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wIgnore);
        this.fdIgnore = new FormData();
        this.fdIgnore.left = new FormAttachment(middle, 0);
        this.fdIgnore.top = new FormAttachment((Control)this.wTruncate, margin);
        this.fdIgnore.right = new FormAttachment(100, 0);
        this.wIgnore.setLayoutData((Object)this.fdIgnore);
        this.wIgnore.addSelectionListener((SelectionListener)lsSelMod);
        this.wlSpecifyFields = new Label((Composite)this.shell, 131072);
        this.wlSpecifyFields.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.SpecifyFields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSpecifyFields);
        this.fdlSpecifyFields = new FormData();
        this.fdlSpecifyFields.left = new FormAttachment(0, 0);
        this.fdlSpecifyFields.top = new FormAttachment((Control)this.wIgnore, margin);
        this.fdlSpecifyFields.right = new FormAttachment(middle, -margin);
        this.wlSpecifyFields.setLayoutData((Object)this.fdlSpecifyFields);
        this.wSpecifyFields = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wSpecifyFields);
        this.fdSpecifyFields = new FormData();
        this.fdSpecifyFields.left = new FormAttachment(middle, 0);
        this.fdSpecifyFields.top = new FormAttachment((Control)this.wIgnore, margin);
        this.fdSpecifyFields.right = new FormAttachment(100, 0);
        this.wSpecifyFields.setLayoutData((Object)this.fdSpecifyFields);
        this.wSpecifyFields.addSelectionListener((SelectionListener)lsSelMod);
        this.wSpecifyFields.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TableOutputDialog.this.setFlags();
            }
        });
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wMainTab = new CTabItem(this.wTabFolder, 0);
        this.wMainTab.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.MainTab.CTabItem", (String[])new String[0]));
        FormLayout mainLayout = new FormLayout();
        mainLayout.marginWidth = 3;
        mainLayout.marginHeight = 3;
        Composite wMainComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wMainComp);
        wMainComp.setLayout((Layout)mainLayout);
        this.wlUsePart = new Label(wMainComp, 131072);
        this.wlUsePart.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.UsePart.Label", (String[])new String[0]));
        this.wlUsePart.setToolTipText(BaseMessages.getString(PKG, (String)"TableOutputDialog.UsePart.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wlUsePart);
        this.fdlUsePart = new FormData();
        this.fdlUsePart.left = new FormAttachment(0, 0);
        this.fdlUsePart.top = new FormAttachment((Control)this.wSpecifyFields, margin * 5);
        this.fdlUsePart.right = new FormAttachment(middle, -margin);
        this.wlUsePart.setLayoutData((Object)this.fdlUsePart);
        this.wUsePart = new Button(wMainComp, 32);
        this.props.setLook((Control)this.wUsePart);
        this.fdUsePart = new FormData();
        this.fdUsePart.left = new FormAttachment(middle, 0);
        this.fdUsePart.top = new FormAttachment((Control)this.wSpecifyFields, margin * 5);
        this.fdUsePart.right = new FormAttachment(100, 0);
        this.wUsePart.setLayoutData((Object)this.fdUsePart);
        this.wUsePart.addSelectionListener((SelectionListener)lsSelMod);
        this.wUsePart.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (TableOutputDialog.this.wUsePart.getSelection()) {
                    TableOutputDialog.this.wNameInField.setSelection(false);
                }
                TableOutputDialog.this.setFlags();
            }
        });
        this.wlPartField = new Label(wMainComp, 131072);
        this.wlPartField.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.PartField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlPartField);
        this.fdlPartField = new FormData();
        this.fdlPartField.top = new FormAttachment((Control)this.wUsePart, margin);
        this.fdlPartField.left = new FormAttachment(0, 0);
        this.fdlPartField.right = new FormAttachment(middle, -margin);
        this.wlPartField.setLayoutData((Object)this.fdlPartField);
        this.wPartField = new ComboVar((VariableSpace)this.transMeta, wMainComp, 18436);
        this.props.setLook((Control)this.wPartField);
        this.wPartField.addModifyListener(lsMod);
        this.fdPartField = new FormData();
        this.fdPartField.top = new FormAttachment((Control)this.wUsePart, margin);
        this.fdPartField.left = new FormAttachment(middle, 0);
        this.fdPartField.right = new FormAttachment(100, 0);
        this.wPartField.setLayoutData(this.fdPartField);
        this.wPartField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)TableOutputDialog.this.shell.getDisplay(), 1);
                TableOutputDialog.this.shell.setCursor(busy);
                TableOutputDialog.this.getFields();
                TableOutputDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.wlPartMonthly = new Label(wMainComp, 131072);
        this.wlPartMonthly.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.PartMonthly.Label", (String[])new String[0]));
        this.wlPartMonthly.setToolTipText(BaseMessages.getString(PKG, (String)"TableOutputDialog.PartMonthly.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wlPartMonthly);
        this.fdlPartMonthly = new FormData();
        this.fdlPartMonthly.left = new FormAttachment(0, 0);
        this.fdlPartMonthly.top = new FormAttachment((Control)this.wPartField, margin);
        this.fdlPartMonthly.right = new FormAttachment(middle, -margin);
        this.wlPartMonthly.setLayoutData((Object)this.fdlPartMonthly);
        this.wPartMonthly = new Button(wMainComp, 16);
        this.props.setLook((Control)this.wPartMonthly);
        this.fdPartMonthly = new FormData();
        this.fdPartMonthly.left = new FormAttachment(middle, 0);
        this.fdPartMonthly.top = new FormAttachment((Control)this.wPartField, margin);
        this.fdPartMonthly.right = new FormAttachment(100, 0);
        this.wPartMonthly.setLayoutData((Object)this.fdPartMonthly);
        this.wPartMonthly.addSelectionListener((SelectionListener)lsSelMod);
        this.wPartMonthly.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TableOutputDialog.this.wPartMonthly.setSelection(true);
                TableOutputDialog.this.wPartDaily.setSelection(false);
            }
        });
        this.wlPartDaily = new Label(wMainComp, 131072);
        this.wlPartDaily.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.PartDaily.Label", (String[])new String[0]));
        this.wlPartDaily.setToolTipText(BaseMessages.getString(PKG, (String)"TableOutputDialog.PartDaily.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wlPartDaily);
        this.fdlPartDaily = new FormData();
        this.fdlPartDaily.left = new FormAttachment(0, 0);
        this.fdlPartDaily.top = new FormAttachment((Control)this.wPartMonthly, margin);
        this.fdlPartDaily.right = new FormAttachment(middle, -margin);
        this.wlPartDaily.setLayoutData((Object)this.fdlPartDaily);
        this.wPartDaily = new Button(wMainComp, 16);
        this.props.setLook((Control)this.wPartDaily);
        this.fdPartDaily = new FormData();
        this.fdPartDaily.left = new FormAttachment(middle, 0);
        this.fdPartDaily.top = new FormAttachment((Control)this.wPartMonthly, margin);
        this.fdPartDaily.right = new FormAttachment(100, 0);
        this.wPartDaily.setLayoutData((Object)this.fdPartDaily);
        this.wPartDaily.addSelectionListener((SelectionListener)lsSelMod);
        this.wPartDaily.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TableOutputDialog.this.wPartDaily.setSelection(true);
                TableOutputDialog.this.wPartMonthly.setSelection(false);
            }
        });
        this.wlBatch = new Label(wMainComp, 131072);
        this.wlBatch.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.Batch.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlBatch);
        this.fdlBatch = new FormData();
        this.fdlBatch.left = new FormAttachment(0, 0);
        this.fdlBatch.top = new FormAttachment((Control)this.wPartDaily, 5 * margin);
        this.fdlBatch.right = new FormAttachment(middle, -margin);
        this.wlBatch.setLayoutData((Object)this.fdlBatch);
        this.wBatch = new Button(wMainComp, 32);
        this.props.setLook((Control)this.wBatch);
        this.fdBatch = new FormData();
        this.fdBatch.left = new FormAttachment(middle, 0);
        this.fdBatch.top = new FormAttachment((Control)this.wPartDaily, 5 * margin);
        this.fdBatch.right = new FormAttachment(100, 0);
        this.wBatch.setLayoutData((Object)this.fdBatch);
        this.wBatch.addSelectionListener((SelectionListener)lsSelMod);
        this.wBatch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TableOutputDialog.this.setFlags();
            }
        });
        this.wlNameInField = new Label(wMainComp, 131072);
        this.wlNameInField.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.NameInField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlNameInField);
        this.fdlNameInField = new FormData();
        this.fdlNameInField.left = new FormAttachment(0, 0);
        this.fdlNameInField.top = new FormAttachment((Control)this.wBatch, margin * 5);
        this.fdlNameInField.right = new FormAttachment(middle, -margin);
        this.wlNameInField.setLayoutData((Object)this.fdlNameInField);
        this.wNameInField = new Button(wMainComp, 32);
        this.props.setLook((Control)this.wNameInField);
        this.fdNameInField = new FormData();
        this.fdNameInField.left = new FormAttachment(middle, 0);
        this.fdNameInField.top = new FormAttachment((Control)this.wBatch, margin * 5);
        this.fdNameInField.right = new FormAttachment(100, 0);
        this.wNameInField.setLayoutData((Object)this.fdNameInField);
        this.wNameInField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                if (TableOutputDialog.this.wNameInField.getSelection()) {
                    TableOutputDialog.this.wUsePart.setSelection(false);
                }
                TableOutputDialog.this.setFlags();
            }
        });
        this.wlNameField = new Label(wMainComp, 131072);
        this.wlNameField.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.NameField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlNameField);
        this.fdlNameField = new FormData();
        this.fdlNameField.left = new FormAttachment(0, 0);
        this.fdlNameField.top = new FormAttachment((Control)this.wNameInField, margin);
        this.fdlNameField.right = new FormAttachment(middle, -margin);
        this.wlNameField.setLayoutData((Object)this.fdlNameField);
        this.wNameField = new ComboVar((VariableSpace)this.transMeta, wMainComp, 18436);
        this.props.setLook((Control)this.wNameField);
        this.wNameField.addModifyListener(lsMod);
        this.fdNameField = new FormData();
        this.fdNameField.left = new FormAttachment(middle, 0);
        this.fdNameField.top = new FormAttachment((Control)this.wNameInField, margin);
        this.fdNameField.right = new FormAttachment(100, 0);
        this.wNameField.setLayoutData(this.fdNameField);
        this.wNameField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)TableOutputDialog.this.shell.getDisplay(), 1);
                TableOutputDialog.this.shell.setCursor(busy);
                TableOutputDialog.this.getFields();
                TableOutputDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.wlNameInTable = new Label(wMainComp, 131072);
        this.wlNameInTable.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.NameInTable.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlNameInTable);
        this.fdlNameInTable = new FormData();
        this.fdlNameInTable.left = new FormAttachment(0, 0);
        this.fdlNameInTable.top = new FormAttachment((Control)this.wNameField, margin);
        this.fdlNameInTable.right = new FormAttachment(middle, -margin);
        this.wlNameInTable.setLayoutData((Object)this.fdlNameInTable);
        this.wNameInTable = new Button(wMainComp, 32);
        this.props.setLook((Control)this.wNameInTable);
        this.fdNameInTable = new FormData();
        this.fdNameInTable.left = new FormAttachment(middle, 0);
        this.fdNameInTable.top = new FormAttachment((Control)this.wNameField, margin);
        this.fdNameInTable.right = new FormAttachment(100, 0);
        this.wNameInTable.setLayoutData((Object)this.fdNameInTable);
        this.wNameInTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TableOutputDialog.this.setFlags();
            }
        });
        this.wlReturnKeys = new Label(wMainComp, 131072);
        this.wlReturnKeys.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.ReturnKeys.Label", (String[])new String[0]));
        this.wlReturnKeys.setToolTipText(BaseMessages.getString(PKG, (String)"TableOutputDialog.ReturnKeys.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wlReturnKeys);
        this.fdlReturnKeys = new FormData();
        this.fdlReturnKeys.left = new FormAttachment(0, 0);
        this.fdlReturnKeys.top = new FormAttachment((Control)this.wNameInTable, margin * 5);
        this.fdlReturnKeys.right = new FormAttachment(middle, -margin);
        this.wlReturnKeys.setLayoutData((Object)this.fdlReturnKeys);
        this.wReturnKeys = new Button(wMainComp, 32);
        this.props.setLook((Control)this.wReturnKeys);
        this.fdReturnKeys = new FormData();
        this.fdReturnKeys.left = new FormAttachment(middle, 0);
        this.fdReturnKeys.top = new FormAttachment((Control)this.wNameInTable, margin * 5);
        this.fdReturnKeys.right = new FormAttachment(100, 0);
        this.wReturnKeys.setLayoutData((Object)this.fdReturnKeys);
        this.wReturnKeys.addSelectionListener((SelectionListener)lsSelMod);
        this.wReturnKeys.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TableOutputDialog.this.setFlags();
            }
        });
        this.wlReturnField = new Label(wMainComp, 131072);
        this.wlReturnField.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.ReturnField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlReturnField);
        this.fdlReturnField = new FormData();
        this.fdlReturnField.left = new FormAttachment(0, 0);
        this.fdlReturnField.right = new FormAttachment(middle, -margin);
        this.fdlReturnField.top = new FormAttachment((Control)this.wReturnKeys, margin);
        this.wlReturnField.setLayoutData((Object)this.fdlReturnField);
        this.wReturnField = new TextVar((VariableSpace)this.transMeta, wMainComp, 18436);
        this.props.setLook((Control)this.wReturnField);
        this.wReturnField.addModifyListener(lsMod);
        this.fdReturnField = new FormData();
        this.fdReturnField.left = new FormAttachment(middle, 0);
        this.fdReturnField.top = new FormAttachment((Control)this.wReturnKeys, margin);
        this.fdReturnField.right = new FormAttachment(100, 0);
        this.wReturnField.setLayoutData(this.fdReturnField);
        this.fdMainComp = new FormData();
        this.fdMainComp.left = new FormAttachment(0, 0);
        this.fdMainComp.top = new FormAttachment(0, 0);
        this.fdMainComp.right = new FormAttachment(100, 0);
        this.fdMainComp.bottom = new FormAttachment(100, 0);
        wMainComp.setLayoutData((Object)this.fdMainComp);
        wMainComp.layout();
        this.wMainTab.setControl((Control)wMainComp);
        this.wFieldsTab = new CTabItem(this.wTabFolder, 0);
        this.wFieldsTab.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.FieldsTab.CTabItem.Title", (String[])new String[0]));
        Composite wFieldsComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wFieldsComp);
        FormLayout fieldsCompLayout = new FormLayout();
        fieldsCompLayout.marginWidth = 5;
        fieldsCompLayout.marginHeight = 5;
        wFieldsComp.setLayout((Layout)fieldsCompLayout);
        this.wlFields = new Label(wFieldsComp, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.InsertFields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFields);
        FormData fdlUpIns = new FormData();
        fdlUpIns.left = new FormAttachment(0, 0);
        fdlUpIns.top = new FormAttachment(0, margin);
        this.wlFields.setLayoutData((Object)fdlUpIns);
        int tableCols = 2;
        int UpInsRows = this.input.getFieldStream() != null ? this.input.getFieldStream().length : 1;
        this.ciFields = new ColumnInfo[tableCols];
        this.ciFields[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"TableOutputDialog.ColumnInfo.TableField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciFields[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"TableOutputDialog.ColumnInfo.StreamField", (String[])new String[0]), 2, new String[]{""}, false);
        this.tableFieldColumns.add(this.ciFields[0]);
        this.wFields = new TableView((VariableSpace)this.transMeta, wFieldsComp, 68354, this.ciFields, UpInsRows, lsMod, this.props);
        this.wGetFields = new Button(wFieldsComp, 8);
        this.wGetFields.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.GetFields.Button", (String[])new String[0]));
        this.fdGetFields = new FormData();
        this.fdGetFields.top = new FormAttachment((Control)this.wlFields, margin);
        this.fdGetFields.right = new FormAttachment(100, 0);
        this.wGetFields.setLayoutData((Object)this.fdGetFields);
        this.wDoMapping = new Button(wFieldsComp, 8);
        this.wDoMapping.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.DoMapping.Button", (String[])new String[0]));
        this.fdDoMapping = new FormData();
        this.fdDoMapping.top = new FormAttachment((Control)this.wGetFields, margin);
        this.fdDoMapping.right = new FormAttachment(100, 0);
        this.wDoMapping.setLayoutData((Object)this.fdDoMapping);
        this.wDoMapping.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                TableOutputDialog.this.generateMappings();
            }
        });
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        fdFields.right = new FormAttachment((Control)this.wDoMapping, -margin);
        fdFields.bottom = new FormAttachment(100, -2 * margin);
        this.wFields.setLayoutData(fdFields);
        this.fdFieldsComp = new FormData();
        this.fdFieldsComp.left = new FormAttachment(0, 0);
        this.fdFieldsComp.top = new FormAttachment(0, 0);
        this.fdFieldsComp.right = new FormAttachment(100, 0);
        this.fdFieldsComp.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)this.fdFieldsComp);
        wFieldsComp.layout();
        this.wFieldsTab.setControl((Control)wFieldsComp);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StepMeta stepMeta = TableOutputDialog.this.transMeta.findStep(TableOutputDialog.this.stepname);
                if (stepMeta != null) {
                    try {
                        RowMetaInterface row = TableOutputDialog.this.transMeta.getPrevStepFields(stepMeta);
                        for (int i = 0; i < row.size(); ++i) {
                            TableOutputDialog.this.inputFields.put(row.getValueMeta(i).getName(), i);
                        }
                        TableOutputDialog.this.setComboBoxes();
                    }
                    catch (KettleException e) {
                        TableOutputDialog.this.logError(BaseMessages.getString((Class)PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                    }
                }
            }
        };
        new Thread(runnable).start();
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCreate = new Button((Composite)this.shell, 8);
        this.wCreate.setText(BaseMessages.getString(PKG, (String)"System.Button.SQL", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel, this.wCreate}, margin, null);
        this.fdTabFolder = new FormData();
        this.fdTabFolder.left = new FormAttachment(0, 0);
        this.fdTabFolder.top = new FormAttachment((Control)this.wSpecifyFields, margin);
        this.fdTabFolder.right = new FormAttachment(100, 0);
        this.fdTabFolder.bottom = new FormAttachment((Control)this.wOK, -margin);
        this.wTabFolder.setLayoutData((Object)this.fdTabFolder);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                TableOutputDialog.this.ok();
            }
        };
        this.lsCreate = new Listener(){

            public void handleEvent(Event e) {
                TableOutputDialog.this.sql();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                TableOutputDialog.this.cancel();
            }
        };
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                TableOutputDialog.this.get();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wCreate.addListener(13, this.lsCreate);
        this.wCancel.addListener(13, this.lsCancel);
        this.wGetFields.addListener(13, this.lsGet);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TableOutputDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wCommit.addSelectionListener(this.lsDef);
        this.wSchema.addSelectionListener(this.lsDef);
        this.wTable.addSelectionListener(this.lsDef);
        this.wPartField.addSelectionListener(this.lsDef);
        this.wNameField.addSelectionListener(this.lsDef);
        this.wReturnField.addSelectionListener(this.lsDef);
        this.wbTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableOutputDialog.this.getTableName();
            }
        });
        this.wbSchema.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableOutputDialog.this.getSchemaNames();
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                TableOutputDialog.this.cancel();
            }
        });
        this.wTabFolder.setSelection(0);
        this.setSize();
        this.getData();
        this.setTableFieldCombo();
        this.input.setChanged(this.backupChanged);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void getFields() {
        if (!this.gotPreviousFields) {
            try {
                String field = this.wNameField.getText();
                String partfield = this.wPartField.getText();
                RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
                if (r != null) {
                    this.wNameField.setItems(r.getFieldNames());
                    this.wPartField.setItems(r.getFieldNames());
                }
                if (field != null) {
                    this.wNameField.setText(field);
                }
                if (partfield != null) {
                    this.wPartField.setText(partfield);
                }
            }
            catch (KettleException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TableOutputDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableOutputDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
            this.gotPreviousFields = true;
        }
    }

    private void generateMappings() {
        EnterMappingDialog d;
        RowMetaInterface targetFields;
        RowMetaInterface sourceFields;
        try {
            sourceFields = this.transMeta.getPrevStepFields(this.stepMeta);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TableOutputDialog.DoMapping.UnableToFindSourceFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableOutputDialog.DoMapping.UnableToFindSourceFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        this.input.setDatabaseMeta(this.transMeta.findDatabase(this.wConnection.getText()));
        this.input.setTableName(this.transMeta.environmentSubstitute(this.wTable.getText()));
        StepMetaInterface stepMetaInterface = this.stepMeta.getStepMetaInterface();
        try {
            targetFields = stepMetaInterface.getRequiredFields((VariableSpace)this.transMeta);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TableOutputDialog.DoMapping.UnableToFindTargetFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableOutputDialog.DoMapping.UnableToFindTargetFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        String[] inputNames = new String[sourceFields.size()];
        for (int i = 0; i < sourceFields.size(); ++i) {
            ValueMetaInterface value = sourceFields.getValueMeta(i);
            inputNames[i] = value.getName() + "            (" + value.getOrigin() + ")";
        }
        List<SourceToTargetMapping> mappings = new ArrayList<SourceToTargetMapping>();
        StringBuilder missingSourceFields = new StringBuilder();
        StringBuilder missingTargetFields = new StringBuilder();
        int nrFields = this.wFields.nrNonEmpty();
        for (int i = 0; i < nrFields; ++i) {
            int targetIndex;
            TableItem item = this.wFields.getNonEmpty(i);
            String source = item.getText(2);
            String target = item.getText(1);
            int sourceIndex = sourceFields.indexOfValue(source);
            if (sourceIndex < 0) {
                missingSourceFields.append(Const.CR).append("   ").append(source).append(" --> ").append(target);
            }
            if ((targetIndex = targetFields.indexOfValue(target)) < 0) {
                missingTargetFields.append(Const.CR).append("   ").append(source).append(" --> ").append(target);
            }
            if (sourceIndex < 0 || targetIndex < 0) continue;
            SourceToTargetMapping mapping = new SourceToTargetMapping(sourceIndex, targetIndex);
            mappings.add(mapping);
        }
        if (missingSourceFields.length() > 0 || missingTargetFields.length() > 0) {
            String message = "";
            if (missingSourceFields.length() > 0) {
                message = message + BaseMessages.getString(PKG, (String)"TableOutputDialog.DoMapping.SomeSourceFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            if (missingTargetFields.length() > 0) {
                message = message + BaseMessages.getString(PKG, (String)"TableOutputDialog.DoMapping.SomeTargetFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            message = message + Const.CR;
            message = message + BaseMessages.getString(PKG, (String)"TableOutputDialog.DoMapping.SomeFieldsNotFoundContinue", (String[])new String[0]) + Const.CR;
            MessageDialog.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
            boolean goOn = MessageDialog.openConfirm((Shell)this.shell, (String)BaseMessages.getString(PKG, (String)"TableOutputDialog.DoMapping.SomeFieldsNotFoundTitle", (String[])new String[0]), (String)message);
            if (!goOn) {
                return;
            }
        }
        if ((mappings = (d = new EnterMappingDialog(this.shell, sourceFields.getFieldNames(), targetFields.getFieldNames(), mappings)).open()) != null) {
            this.wFields.table.removeAll();
            this.wFields.table.setItemCount(mappings.size());
            for (int i = 0; i < mappings.size(); ++i) {
                SourceToTargetMapping mapping = mappings.get(i);
                TableItem item = this.wFields.table.getItem(i);
                item.setText(2, sourceFields.getValueMeta(mapping.getSourcePosition()).getName());
                item.setText(1, targetFields.getValueMeta(mapping.getTargetPosition()).getName());
            }
            this.wFields.setRowNums();
            this.wFields.optWidth(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSchemaNames() {
        DatabaseMeta databaseMeta = this.transMeta.findDatabase(this.wConnection.getText());
        if (databaseMeta != null) {
            Database database = new Database(loggingObject, databaseMeta);
            try {
                database.connect();
                String[] schemas = database.getSchemas();
                if (null != schemas && schemas.length > 0) {
                    EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, schemas = Const.sortStrings((String[])schemas), BaseMessages.getString(PKG, (String)"TableOutputDialog.AvailableSchemas.Title", (String[])new String[]{this.wConnection.getText()}), BaseMessages.getString(PKG, (String)"TableOutputDialog.AvailableSchemas.Message", (String[])new String[]{this.wConnection.getText()}));
                    String d = dialog.open();
                    if (d != null) {
                        this.wSchema.setText(Const.NVL((String)d, (String)""));
                        this.setTableFieldCombo();
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"TableOutputDialog.NoSchema.Error", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"TableOutputDialog.GetSchemas.Error", (String[])new String[0]));
                    mb.open();
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableOutputDialog.ErrorGettingSchemas", (String[])new String[0]), e);
            }
            finally {
                database.disconnect();
            }
        }
    }

    private void setTableFieldCombo() {
        Runnable fieldLoader = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!(TableOutputDialog.this.wTable.isDisposed() || TableOutputDialog.this.wConnection.isDisposed() || TableOutputDialog.this.wSchema.isDisposed())) {
                    DatabaseMeta ci;
                    String tableName = TableOutputDialog.this.wTable.getText();
                    String connectionName = TableOutputDialog.this.wConnection.getText();
                    String schemaName = TableOutputDialog.this.wSchema.getText();
                    for (ColumnInfo colInfo : TableOutputDialog.this.tableFieldColumns) {
                        colInfo.setComboValues(new String[0]);
                    }
                    if (!Utils.isEmpty((CharSequence)tableName) && (ci = TableOutputDialog.this.transMeta.findDatabase(connectionName)) != null) {
                        Database db = new Database(BaseStepDialog.loggingObject, ci);
                        try {
                            String[] fieldNames;
                            db.connect();
                            String schemaTable = ci.getQuotedSchemaTableCombination(TableOutputDialog.this.transMeta.environmentSubstitute(schemaName), TableOutputDialog.this.transMeta.environmentSubstitute(tableName));
                            RowMetaInterface r = db.getTableFields(schemaTable);
                            if (null != r && null != (fieldNames = r.getFieldNames())) {
                                for (ColumnInfo colInfo : TableOutputDialog.this.tableFieldColumns) {
                                    colInfo.setComboValues(fieldNames);
                                }
                            }
                        }
                        catch (Exception e) {
                            for (ColumnInfo colInfo : TableOutputDialog.this.tableFieldColumns) {
                                colInfo.setComboValues(new String[0]);
                            }
                        }
                        finally {
                            try {
                                if (db != null) {
                                    db.disconnect();
                                }
                            }
                            catch (Exception ignored) {
                                db = null;
                            }
                        }
                    }
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.ciFields[1].setComboValues(fieldNames);
    }

    public void setFlags() {
        boolean returnKeys = this.wReturnKeys.getSelection();
        boolean useBatch = this.wBatch.getSelection() && !this.transMeta.isUsingUniqueConnections() && !returnKeys;
        boolean enableBatch = !returnKeys && !this.transMeta.isUsingUniqueConnections();
        boolean useIgnore = !useBatch;
        boolean usePartitioning = this.wUsePart.getSelection();
        boolean isTableNameInField = this.wNameInField.getSelection();
        boolean enableTruncate = !usePartitioning && !isTableNameInField;
        boolean useTruncate = this.wTruncate.getSelection() && enableTruncate;
        boolean useTablename = !isTableNameInField;
        this.wUsePart.setSelection(usePartitioning);
        this.wNameInField.setSelection(isTableNameInField);
        this.wBatch.setSelection(useBatch);
        this.wReturnKeys.setSelection(returnKeys);
        this.wTruncate.setSelection(useTruncate);
        this.wIgnore.setEnabled(useIgnore);
        this.wlIgnore.setEnabled(useIgnore);
        this.wlPartMonthly.setEnabled(usePartitioning);
        this.wPartMonthly.setEnabled(usePartitioning);
        this.wlPartDaily.setEnabled(usePartitioning);
        this.wPartDaily.setEnabled(usePartitioning);
        this.wlPartField.setEnabled(usePartitioning);
        this.wPartField.setEnabled(usePartitioning);
        this.wlNameField.setEnabled(isTableNameInField);
        this.wNameField.setEnabled(isTableNameInField);
        this.wlNameInTable.setEnabled(isTableNameInField);
        this.wNameInTable.setEnabled(isTableNameInField);
        this.wlTable.setEnabled(useTablename);
        this.wTable.setEnabled(useTablename);
        this.wlTruncate.setEnabled(enableTruncate);
        this.wTruncate.setEnabled(enableTruncate);
        this.wlReturnField.setEnabled(returnKeys);
        this.wReturnField.setEnabled(returnKeys);
        this.wlBatch.setEnabled(enableBatch);
        this.wBatch.setEnabled(enableBatch);
        boolean specifyFields = this.wSpecifyFields.getSelection();
        this.wFields.setEnabled(specifyFields);
        this.wGetFields.setEnabled(specifyFields);
        this.wDoMapping.setEnabled(specifyFields);
        this.wlNameInTable.setEnabled(isTableNameInField && !specifyFields);
        this.wNameInTable.setEnabled(isTableNameInField && !specifyFields);
        DatabaseMeta databaseMeta = this.transMeta.findDatabase(this.wConnection.getText());
        if (databaseMeta != null) {
            if (!databaseMeta.supportsAutoGeneratedKeys()) {
                this.wReturnKeys.setEnabled(false);
                this.wReturnKeys.setSelection(false);
                this.wReturnField.setEnabled(false);
                this.wReturnField.setText("");
            } else {
                this.wReturnKeys.setEnabled(true);
                this.wReturnField.setEnabled(true);
            }
        } else {
            this.wReturnKeys.setEnabled(true);
            this.wReturnField.setEnabled(true);
        }
    }

    public void getData() {
        if (this.input.getSchemaName() != null) {
            this.wSchema.setText(this.input.getSchemaName());
        }
        if (this.input.getTableName() != null) {
            this.wTable.setText(this.input.getTableName());
        }
        if (this.input.getDatabaseMeta() != null) {
            this.wConnection.setText(this.input.getDatabaseMeta().getName());
        }
        this.wTruncate.setSelection(this.input.truncateTable());
        this.wIgnore.setSelection(this.input.ignoreErrors());
        this.wBatch.setSelection(this.input.useBatchUpdate());
        this.wCommit.setText(this.input.getCommitSize());
        this.wUsePart.setSelection(this.input.isPartitioningEnabled());
        this.wPartDaily.setSelection(this.input.isPartitioningDaily());
        this.wPartMonthly.setSelection(this.input.isPartitioningMonthly());
        if (this.input.getPartitioningField() != null) {
            this.wPartField.setText(this.input.getPartitioningField());
        }
        this.wNameInField.setSelection(this.input.isTableNameInField());
        if (this.input.getTableNameField() != null) {
            this.wNameField.setText(this.input.getTableNameField());
        }
        this.wNameInTable.setSelection(this.input.isTableNameInTable());
        this.wReturnKeys.setSelection(this.input.isReturningGeneratedKeys());
        if (this.input.getGeneratedKeyField() != null) {
            this.wReturnField.setText(this.input.getGeneratedKeyField());
        }
        this.wSpecifyFields.setSelection(this.input.specifyFields());
        for (int i = 0; i < this.input.getFieldDatabase().length; ++i) {
            TableItem item = this.wFields.table.getItem(i);
            if (this.input.getFieldDatabase()[i] != null) {
                item.setText(1, this.input.getFieldDatabase()[i]);
            }
            if (this.input.getFieldStream()[i] == null) continue;
            item.setText(2, this.input.getFieldStream()[i]);
        }
        this.setFlags();
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void getInfo(TableOutputMeta info) {
        info.setSchemaName(this.wSchema.getText());
        info.setTableName(this.wTable.getText());
        info.setDatabaseMeta(this.transMeta.findDatabase(this.wConnection.getText()));
        info.setCommitSize(this.wCommit.getText());
        info.setTruncateTable(this.wTruncate.getSelection());
        info.setIgnoreErrors(this.wIgnore.getSelection());
        info.setUseBatchUpdate(this.wBatch.getSelection());
        info.setPartitioningEnabled(this.wUsePart.getSelection());
        info.setPartitioningField(this.wPartField.getText());
        info.setPartitioningDaily(this.wPartDaily.getSelection());
        info.setPartitioningMonthly(this.wPartMonthly.getSelection());
        info.setTableNameInField(this.wNameInField.getSelection());
        info.setTableNameField(this.wNameField.getText());
        info.setTableNameInTable(this.wNameInTable.getSelection());
        info.setReturningGeneratedKeys(this.wReturnKeys.getSelection());
        info.setGeneratedKeyField(this.wReturnField.getText());
        info.setSpecifyFields(this.wSpecifyFields.getSelection());
        int nrRows = this.wFields.nrNonEmpty();
        info.allocate(nrRows);
        for (int i = 0; i < nrRows; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            info.getFieldDatabase()[i] = Const.NVL((String)item.getText(1), (String)"");
            info.getFieldStream()[i] = Const.NVL((String)item.getText(2), (String)"");
        }
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        this.getInfo(this.input);
        if (this.input.getDatabaseMeta() == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"TableOutputDialog.ConnectionError.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
            mb.open();
            return;
        }
        DatabaseMeta databaseMeta = this.input.getDatabaseMeta();
        boolean supportsBatchErrorHandling = databaseMeta != null && databaseMeta.supportsErrorHandlingOnBatchUpdates();
        boolean hasErrorHandling = this.stepMeta.isDoingErrorHandling();
        if (!supportsBatchErrorHandling && hasErrorHandling) {
            MessageBox mb = new MessageBox(this.shell, 40);
            mb.setMessage(BaseMessages.getString(PKG, (String)"TableOutput.Warning.ErrorHandlingIsNotFullySupportedWithBatchProcessing", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"TableOutput.Warning", (String[])new String[0]));
            mb.open();
        }
        this.dispose();
    }

    private void getTableName() {
        int connr = this.wConnection.getSelectionIndex();
        if (connr >= 0) {
            DatabaseMeta inf = this.transMeta.getDatabase(connr);
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"TableOutputDialog.Log.LookingAtConnection", (String[])new String[]{inf.toString()}));
            }
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, inf, this.transMeta.getDatabases());
            std.setSelectedSchemaAndTable(this.wSchema.getText(), this.wTable.getText());
            if (std.open()) {
                this.wSchema.setText(Const.NVL((String)std.getSchemaName(), (String)""));
                this.wTable.setText(Const.NVL((String)std.getTableName(), (String)""));
                this.setTableFieldCombo();
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"TableOutputDialog.ConnectionError2.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
            mb.open();
        }
    }

    private void get() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null && !r.isEmpty()) {
                BaseStepDialog.getFieldsFromPrevious(r, this.wFields, 1, new int[]{1, 2}, new int[0], -1, -1, null);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TableOutputDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableOutputDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void sql() {
        try {
            String text;
            int idx;
            TableOutputMeta info = new TableOutputMeta();
            this.getInfo(info);
            RowMetaInterface prev = this.transMeta.getPrevStepFields(this.stepname);
            if (info.isTableNameInField() && !info.isTableNameInTable() && info.getTableNameField().length() > 0 && (idx = prev.indexOfValue(info.getTableNameField())) >= 0) {
                prev.removeValueMeta(idx);
            }
            StepMeta stepMeta = this.transMeta.findStep(this.stepname);
            if (info.specifyFields()) {
                RowMeta prevNew = new RowMeta();
                for (int i = 0; i < info.getFieldDatabase().length; ++i) {
                    ValueMetaInterface insValue = prev.searchValueMeta(info.getFieldStream()[i]);
                    if (insValue == null) {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"TableOutputDialog.FailedToFindField.Message", (String[])new String[]{info.getFieldStream()[i]}));
                    }
                    ValueMetaInterface insertValue = insValue.clone();
                    insertValue.setName(info.getFieldDatabase()[i]);
                    prevNew.addValueMeta(insertValue);
                }
                prev = prevNew;
            }
            boolean autoInc = false;
            String pk = null;
            if (info.isReturningGeneratedKeys() && !Utils.isEmpty((CharSequence)info.getGeneratedKeyField())) {
                ValueMetaInteger valueMeta = new ValueMetaInteger(info.getGeneratedKeyField());
                valueMeta.setLength(15);
                prev.addValueMeta(0, (ValueMetaInterface)valueMeta);
                autoInc = true;
                pk = info.getGeneratedKeyField();
            }
            if (TableOutputDialog.isValidRowMeta(prev)) {
                SQLStatement sql = info.getSQLStatements(this.transMeta, stepMeta, prev, pk, autoInc, pk);
                if (!sql.hasError()) {
                    if (sql.hasSQL()) {
                        SQLEditor sqledit = new SQLEditor((VariableSpace)this.transMeta, this.shell, 0, info.getDatabaseMeta(), this.transMeta.getDbCache(), sql.getSQL());
                        sqledit.open();
                    } else {
                        String message = TableOutputDialog.getBaseMessage("TableOutputDialog.NoSQL.DialogMessage");
                        String text2 = TableOutputDialog.getBaseMessage("TableOutputDialog.NoSQL.DialogTitle");
                        this.showMessage(this.shell, 34, message, text2);
                    }
                } else {
                    text = TableOutputDialog.getBaseMessage("System.Dialog.Error.Title");
                    this.showMessage(this.shell, 33, sql.getError(), text);
                }
            } else {
                String message = TableOutputDialog.getBaseMessage("TableOutputDialog.NoSQL.EmptyCSVFields");
                text = TableOutputDialog.getBaseMessage("TableOutputDialog.NoSQL.DialogTitle");
                this.showMessage(this.shell, 33, message, text);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TableOutputDialog.BuildSQLError.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableOutputDialog.BuildSQLError.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void showMessage(Shell shell, int style, String message, String text) {
        MessageBox mb = new MessageBox(shell, style);
        mb.setMessage(message);
        mb.setText(text);
        mb.open();
    }

    private static boolean isValidRowMeta(RowMetaInterface rowMeta) {
        for (ValueMetaInterface value : rowMeta.getValueMetaList()) {
            String name = value.getName();
            if (name != null && !name.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static String getBaseMessage(String str) {
        return BaseMessages.getString(PKG, (String)str, (String[])new String[0]);
    }
}

