/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.datasets;

import java.util.ArrayList;
import java.util.Properties;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ConnectionProvider;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.DriverConnectionProvider;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.SQLReportDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.CubeFileProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.DataSourceProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.DriverDataSourceProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.LegacyBandedMDXDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.PmdDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.xpath.XPathDataFactory;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.datasets.QueryReadHandler;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.datasets.SelectedJNDIDataSourceReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.IgnoreAnyChildReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.PropertiesReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MultiDataSetReadHandler
extends PropertiesReadHandler {
    private ArrayList queries = new ArrayList();
    private SelectedJNDIDataSourceReadHandler selectedJNDIDataSourceReadHandler;
    private DataFactory dataFactory;

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("query".equals(tagName)) {
            QueryReadHandler readHandler = new QueryReadHandler();
            this.queries.add(readHandler);
            return readHandler;
        }
        if ("padding".equals(tagName)) {
            return new IgnoreAnyChildReadHandler();
        }
        if ("selectedJNDIDataSource".equals(tagName)) {
            this.selectedJNDIDataSourceReadHandler = new SelectedJNDIDataSourceReadHandler();
            return this.selectedJNDIDataSourceReadHandler;
        }
        if ("columnInfo".equals(tagName)) {
            return new IgnoreAnyChildReadHandler();
        }
        return super.getHandlerForChild(uri, tagName, atts);
    }

    protected void doneParsing() throws SAXException {
        super.doneParsing();
        Properties result = this.getResult();
        String connectionType = result.getProperty("connectionType");
        String xQueryDataFile = result.getProperty("xQueryDataFile");
        String xmiDefinitionFile = result.getProperty("xmiDefinitionFile");
        String mondrianCubeDefinition = result.getProperty("mondrianCubeDefinitionFile");
        boolean useMondrianCubeDefinition = "true".equals(result.getProperty("useMondrianCubeDefinition"));
        if ("MQL".equals(connectionType)) {
            if (xmiDefinitionFile == null) {
                throw new ParseException("Required property 'xmiDefinitionFile' is missing");
            }
            PmdDataFactory dataFactory = new PmdDataFactory();
            dataFactory.setXmiFile(xmiDefinitionFile);
            for (int i = 0; i < this.queries.size(); ++i) {
                QueryReadHandler handler = (QueryReadHandler)((Object)this.queries.get(i));
                dataFactory.setQuery(handler.getQueryName(), handler.getQuery(), null, null);
            }
            String queryNameProperty = result.getProperty("queryString");
            if (queryNameProperty != null) {
                dataFactory.setQuery("default", queryNameProperty, null, null);
            }
            this.dataFactory = dataFactory;
        } else if ("XQuery".equals(connectionType)) {
            if (xQueryDataFile == null) {
                throw new ParseException("Required property 'xQueryDataFile' is missing");
            }
            XPathDataFactory dataFactory = new XPathDataFactory();
            dataFactory.setXqueryDataFile(xQueryDataFile);
            for (int i = 0; i < this.queries.size(); ++i) {
                QueryReadHandler handler = (QueryReadHandler)((Object)this.queries.get(i));
                dataFactory.setQuery(handler.getQueryName(), handler.getQuery(), true);
            }
            String queryNameProperty = result.getProperty("queryString");
            if (queryNameProperty != null) {
                dataFactory.setQuery("default", queryNameProperty, true);
            }
            this.dataFactory = dataFactory;
        } else if ("JNDI".equals(connectionType)) {
            if (this.selectedJNDIDataSourceReadHandler == null) {
                throw new ParseException("Required element 'selectedJNDIDataSourceReadHandler' is missing");
            }
            if (useMondrianCubeDefinition) {
                if (mondrianCubeDefinition == null) {
                    throw new ParseException("Required property 'mondrianCubeDefinitionFile' is missing");
                }
                LegacyBandedMDXDataFactory dataFactory = new LegacyBandedMDXDataFactory();
                CubeFileProvider cubeFileProvider = (CubeFileProvider)ClassicEngineBoot.getInstance().getObjectFactory().get(CubeFileProvider.class);
                cubeFileProvider.setDesignTimeFile(mondrianCubeDefinition);
                dataFactory.setCubeFileProvider(cubeFileProvider);
                dataFactory.setJdbcUser(this.selectedJNDIDataSourceReadHandler.getUsername());
                dataFactory.setJdbcPassword(this.selectedJNDIDataSourceReadHandler.getPassword());
                dataFactory.setDesignTimeName(this.selectedJNDIDataSourceReadHandler.getJndiName());
                DriverDataSourceProvider driverDataSourceProvider = new DriverDataSourceProvider();
                driverDataSourceProvider.setDriver(this.selectedJNDIDataSourceReadHandler.getDriverClass());
                driverDataSourceProvider.setUrl(this.selectedJNDIDataSourceReadHandler.getConnectionString());
                dataFactory.setDataSourceProvider((DataSourceProvider)driverDataSourceProvider);
                for (int i = 0; i < this.queries.size(); ++i) {
                    QueryReadHandler handler = (QueryReadHandler)((Object)this.queries.get(i));
                    dataFactory.setQuery(handler.getQueryName(), handler.getQuery(), null, null);
                }
                String queryNameProperty = result.getProperty("queryString");
                if (queryNameProperty != null) {
                    dataFactory.setQuery("default", queryNameProperty, null, null);
                }
                this.dataFactory = dataFactory;
            } else {
                DriverConnectionProvider drc = new DriverConnectionProvider();
                drc.setUrl(this.selectedJNDIDataSourceReadHandler.getConnectionString());
                drc.setDriver(this.selectedJNDIDataSourceReadHandler.getDriverClass());
                drc.setProperty("user", this.selectedJNDIDataSourceReadHandler.getUsername());
                drc.setProperty("password", this.selectedJNDIDataSourceReadHandler.getPassword());
                drc.setProperty("::pentaho-reporting::name", this.selectedJNDIDataSourceReadHandler.getJndiName());
                SQLReportDataFactory dataFactory = new SQLReportDataFactory((ConnectionProvider)drc);
                for (int i = 0; i < this.queries.size(); ++i) {
                    QueryReadHandler handler = (QueryReadHandler)((Object)this.queries.get(i));
                    dataFactory.setQuery(handler.getQueryName(), handler.getQuery(), null, null);
                }
                String queryNameProperty = result.getProperty("queryString");
                if (queryNameProperty != null) {
                    dataFactory.setQuery("default", queryNameProperty, null, null);
                }
                this.dataFactory = dataFactory;
            }
        } else {
            throw new ParseException("Required Property 'connectionType' is missing", this.getLocator());
        }
    }

    public Object getObject() throws SAXException {
        return this.dataFactory;
    }
}

