/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.datasets;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanUtility;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.converter.ObjectConverterFactory;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.datasets.ReportFunctionPropertyArrayReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.StringReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ReportFunctionPropertyReadHandler
extends StringReadHandler {
    private String propertyName;
    private BeanUtility beanUtility;
    private boolean array;
    private ArrayList properties;

    public ReportFunctionPropertyReadHandler(BeanUtility beanUtility) {
        if (beanUtility == null) {
            throw new NullPointerException("No current beanUtility");
        }
        this.beanUtility = beanUtility;
        this.properties = new ArrayList();
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        super.startParsing(attrs);
        this.propertyName = attrs.getValue(this.getUri(), "name");
        if (this.propertyName == null) {
            throw new ParseException("Required attribute 'name' is null.", this.getLocator());
        }
        this.array = attrs.getValue(this.getUri(), "array") != null;
    }

    protected void doneParsing() throws SAXException {
        super.doneParsing();
        try {
            Class propertyType = this.beanUtility.getPropertyType(this.propertyName);
            if (!this.array) {
                String value = this.getResult();
                Object o = ObjectConverterFactory.convert(propertyType, value, this.getLocator());
                this.beanUtility.setProperty(this.propertyName, o);
            } else {
                Object[] value = (Object[])Array.newInstance(propertyType, this.properties.size());
                for (int i = 0; i < this.properties.size(); ++i) {
                    ReportFunctionPropertyArrayReadHandler handler = (ReportFunctionPropertyArrayReadHandler)((Object)this.properties.get(i));
                    value[i] = handler.getObject();
                }
                this.beanUtility.setProperty(this.propertyName, (Object)value);
            }
        }
        catch (BeanException e) {
            throw new ParseException("Failed to set property", this.getLocator());
        }
    }

    public Object getObject() {
        return null;
    }
}

