/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements;

import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements.BorderCornerReadHandler;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements.BorderEdgeReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ElementBorderReadHandler
extends AbstractXmlReadHandler {
    private BorderEdgeReadHandler borderTop;
    private BorderEdgeReadHandler borderLeft;
    private BorderEdgeReadHandler borderBottom;
    private BorderEdgeReadHandler borderRight;
    private BorderEdgeReadHandler borderBreak;
    private BorderCornerReadHandler borderTopLeft;
    private BorderCornerReadHandler borderTopRight;
    private BorderCornerReadHandler borderBottomLeft;
    private BorderCornerReadHandler borderBottomRight;
    private ElementStyleSheet elementStyleSheet;
    private boolean sameBorder;

    public ElementBorderReadHandler(ElementStyleSheet elementStyleSheet) {
        this.elementStyleSheet = elementStyleSheet;
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        super.startParsing(attrs);
        this.sameBorder = "true".equals(attrs.getValue(this.getUri(), "sameBorderForAllSides"));
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("borderTop".equals(tagName)) {
            this.borderTop = new BorderEdgeReadHandler();
            return this.borderTop;
        }
        if ("borderLeft".equals(tagName)) {
            this.borderLeft = new BorderEdgeReadHandler();
            return this.borderLeft;
        }
        if ("borderBottom".equals(tagName)) {
            this.borderBottom = new BorderEdgeReadHandler();
            return this.borderBottom;
        }
        if ("borderRight".equals(tagName)) {
            this.borderRight = new BorderEdgeReadHandler();
            return this.borderRight;
        }
        if ("borderBreak".equals(tagName)) {
            this.borderBreak = new BorderEdgeReadHandler();
            return this.borderBreak;
        }
        if ("topLeftEdge".equals(tagName)) {
            this.borderTopLeft = new BorderCornerReadHandler();
            return this.borderTopLeft;
        }
        if ("topRightEdge".equals(tagName)) {
            this.borderTopRight = new BorderCornerReadHandler();
            return this.borderTopRight;
        }
        if ("bottomLeftEdge".equals(tagName)) {
            this.borderBottomLeft = new BorderCornerReadHandler();
            return this.borderBottomLeft;
        }
        if ("bottomRightEdge".equals(tagName)) {
            this.borderBottomRight = new BorderCornerReadHandler();
            return this.borderBottomRight;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        this.apply(this.elementStyleSheet);
    }

    private void apply(ElementStyleSheet s) {
        if (this.sameBorder) {
            this.borderLeft = this.borderTop;
            this.borderRight = this.borderTop;
            this.borderBottom = this.borderTop;
            this.borderTopRight = this.borderTopLeft;
            this.borderBottomLeft = this.borderTopLeft;
            this.borderBottomRight = this.borderTopLeft;
        }
        if (this.borderTop != null) {
            s.setStyleProperty(ElementStyleKeys.BORDER_TOP_STYLE, (Object)this.borderTop.getBorderType());
            s.setStyleProperty(ElementStyleKeys.BORDER_TOP_WIDTH, (Object)new Float(this.borderTop.getWidth()));
            s.setStyleProperty(ElementStyleKeys.BORDER_TOP_COLOR, (Object)this.borderTop.getColor());
        }
        if (this.borderLeft != null) {
            s.setStyleProperty(ElementStyleKeys.BORDER_LEFT_STYLE, (Object)this.borderLeft.getBorderType());
            s.setStyleProperty(ElementStyleKeys.BORDER_LEFT_WIDTH, (Object)new Float(this.borderLeft.getWidth()));
            s.setStyleProperty(ElementStyleKeys.BORDER_LEFT_COLOR, (Object)this.borderLeft.getColor());
        }
        if (this.borderBottom != null) {
            s.setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_STYLE, (Object)this.borderBottom.getBorderType());
            s.setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_WIDTH, (Object)new Float(this.borderBottom.getWidth()));
            s.setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_COLOR, (Object)this.borderBottom.getColor());
        }
        if (this.borderRight != null) {
            s.setStyleProperty(ElementStyleKeys.BORDER_RIGHT_STYLE, (Object)this.borderRight.getBorderType());
            s.setStyleProperty(ElementStyleKeys.BORDER_RIGHT_WIDTH, (Object)new Float(this.borderRight.getWidth()));
            s.setStyleProperty(ElementStyleKeys.BORDER_RIGHT_COLOR, (Object)this.borderRight.getColor());
        }
        if (this.borderBreak != null) {
            s.setStyleProperty(ElementStyleKeys.BORDER_BREAK_STYLE, (Object)this.borderBreak.getBorderType());
            s.setStyleProperty(ElementStyleKeys.BORDER_BREAK_WIDTH, (Object)new Float(this.borderBreak.getWidth()));
            s.setStyleProperty(ElementStyleKeys.BORDER_BREAK_COLOR, (Object)this.borderBreak.getColor());
        }
        if (this.borderBottomLeft != null) {
            s.setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_LEFT_RADIUS_HEIGHT, (Object)this.borderBottomLeft.getHeight());
            s.setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_LEFT_RADIUS_WIDTH, (Object)this.borderBottomLeft.getWidth());
        }
        if (this.borderBottomRight != null) {
            s.setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS_HEIGHT, (Object)this.borderBottomRight.getHeight());
            s.setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS_WIDTH, (Object)this.borderBottomRight.getWidth());
        }
        if (this.borderTopLeft != null) {
            s.setStyleProperty(ElementStyleKeys.BORDER_TOP_LEFT_RADIUS_HEIGHT, (Object)this.borderTopLeft.getHeight());
            s.setStyleProperty(ElementStyleKeys.BORDER_TOP_LEFT_RADIUS_WIDTH, (Object)this.borderTopLeft.getWidth());
        }
        if (this.borderTopRight != null) {
            s.setStyleProperty(ElementStyleKeys.BORDER_TOP_RIGHT_RADIUS_HEIGHT, (Object)this.borderTopRight.getHeight());
            s.setStyleProperty(ElementStyleKeys.BORDER_TOP_RIGHT_RADIUS_WIDTH, (Object)this.borderTopRight.getWidth());
        }
    }

    public Object getObject() throws SAXException {
        return null;
    }
}

