/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements;

import java.util.Map;
import java.util.Properties;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportParserUtil;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements.SubReportParametersReadHandler;
import org.pentaho.reporting.libraries.resourceloader.FactoryParameterKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.xmlns.parser.IgnoreAnyChildReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.PropertiesReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SubreportElementReadHandler
extends PropertiesReadHandler {
    private SubReport subReport;
    private SubReportParametersReadHandler parametersReadHandler;

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (this.isSameNamespace(uri)) {
            if ("parameters".equals(tagName)) {
                this.parametersReadHandler = new SubReportParametersReadHandler();
                return this.parametersReadHandler;
            }
            if ("padding".equals(tagName)) {
                return new IgnoreAnyChildReadHandler();
            }
        }
        return super.getHandlerForChild(uri, tagName, atts);
    }

    public Object getObject() throws SAXException {
        return this.subReport;
    }

    protected void doneParsing() throws SAXException {
        super.doneParsing();
        Properties result1 = this.getResult();
        String filePath = result1.getProperty("filePath");
        if (filePath == null) {
            throw new ParseException("There was no subreport file specified.", this.getLocator());
        }
        Map parameters = this.deriveParseParameters();
        parameters.put(new FactoryParameterKey("::Report"), null);
        parameters.put(new FactoryParameterKey("::Include-parser"), ReportParserUtil.INCLUDE_PARSING_VALUE);
        try {
            this.subReport = (SubReport)this.performExternalParsing(filePath, SubReport.class, parameters);
        }
        catch (ResourceLoadingException e) {
            throw new ParseException("The specified subreport was not found or could not be loaded.", (Exception)((Object)e), this.getLocator());
        }
        String query = result1.getProperty("query");
        this.subReport.setQuery(query);
        if (this.parametersReadHandler != null) {
            ParameterMapping mapping;
            int i;
            this.subReport.clearExportParameters();
            this.subReport.clearInputParameters();
            if (this.parametersReadHandler.isGlobalImport()) {
                this.subReport.addInputParameter("*", "*");
            } else {
                ParameterMapping[] importMapping = this.parametersReadHandler.getImportParameterMappings();
                for (i = 0; i < importMapping.length; ++i) {
                    mapping = importMapping[i];
                    this.subReport.addInputParameter(mapping.getName(), mapping.getAlias());
                }
            }
            if (this.parametersReadHandler.isGlobalExport()) {
                this.subReport.addExportParameter("*", "*");
            } else {
                ParameterMapping[] exportMapping = this.parametersReadHandler.getImportParameterMappings();
                for (i = 0; i < exportMapping.length; ++i) {
                    mapping = exportMapping[i];
                    this.subReport.addExportParameter(mapping.getName(), mapping.getAlias());
                }
            }
        }
    }
}

