/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.report;

import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.converter.ObjectConverterFactory;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.PropertiesReadHandler;
import org.xml.sax.SAXException;

public class PropertyArrayReadHandler
extends PropertiesReadHandler {
    private Class componentType;
    private Object[] retval;

    public PropertyArrayReadHandler(Class componentType) {
        this.componentType = componentType;
    }

    protected void doneParsing() throws SAXException {
        super.doneParsing();
        Properties properties = this.getResult();
        ArrayList<Object> list = new ArrayList<Object>();
        for (Map.Entry<Object, Object> o : properties.entrySet()) {
            String key = (String)o.getKey();
            String value = (String)o.getValue();
            try {
                int index = Integer.parseInt(key);
                if (index < 0) {
                    throw new ParseException("Failed to parse array index", this.getLocator());
                }
                list.ensureCapacity(index);
                while (list.size() < index + 1) {
                    list.add(null);
                }
                list.set(index, ObjectConverterFactory.convert(this.componentType, value, this.getLocator()));
            }
            catch (NumberFormatException nfe) {
                throw new ParseException("Failed to parse array index", this.getLocator());
            }
        }
        this.retval = list.toArray();
    }

    public Object getObject() {
        return this.retval;
    }
}

