/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swing.tags;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang.StringUtils;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.components.XulDialogheader;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulRoot;
import org.pentaho.ui.xul.containers.XulWindow;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swing.AbstractSwingContainer;
import org.pentaho.ui.xul.swing.SwingRoot;
import org.pentaho.ui.xul.swing.tags.SwingButton;
import org.pentaho.ui.xul.util.Orient;

public class SwingDialog
extends AbstractSwingContainer
implements XulDialog,
SwingRoot {
    XulDomContainer domContainer = null;
    private JDialog dialog = null;
    private Boolean resizable = false;
    private Boolean modal = true;
    private String buttonlabelaccept;
    private String buttonlabelcancel;
    private String buttonlabelextra1;
    private String buttonlabelextra2;
    private LinkedHashMap<BUTTONS, XulButton> buttons = new LinkedHashMap();
    private String ondialogaccept;
    private String ondialogcancel;
    private String ondialogextra1;
    private String ondialogextra2;
    private String title = "Dialog";
    private String onload;
    private String onclose;
    private String onunload;
    private XulDialogheader header;
    private int height = 300;
    private int width = 450;
    private String btns;
    private BUTTON_ALIGN buttonAlignment;
    private boolean pack;
    private JFrame frame;
    private String ID;
    private XulComponent parent = null;
    private Box buttonPanel = Box.createHorizontalBox();
    private Map<String, ButtonGroup> anonymousButtonGroups = new HashMap<String, ButtonGroup>();
    private boolean buttonsProcessed = false;
    private Component centerComp;

    public SwingDialog(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        super("dialog");
        this.ID = self.getAttributeValue("ID");
        this.parent = parent;
        this.domContainer = domContainer;
        this.orientation = Orient.VERTICAL;
        this.container = new JPanel(new GridBagLayout());
        this.setManagedObject("empty");
        this.resetContainer();
    }

    @Override
    public ButtonGroup getButtonGroup(String group) {
        if (this.anonymousButtonGroups.containsKey(group)) {
            return this.anonymousButtonGroups.get(group);
        }
        ButtonGroup grp = new ButtonGroup();
        this.anonymousButtonGroups.put(group, grp);
        return grp;
    }

    @Override
    public void resetContainer() {
        this.container.removeAll();
        this.gc = new GridBagConstraints();
        this.gc.gridy = -1;
        this.gc.gridx = 0;
        this.gc.gridheight = 1;
        this.gc.gridwidth = 0;
        int pad = this.getPadding();
        this.gc.insets = new Insets(pad, pad, pad, pad);
        this.gc.fill = 2;
        this.gc.anchor = 18;
        this.gc.weightx = 1.0;
    }

    public JComponent getContainer() {
        return this.container;
    }

    public JDialog getDialog() {
        if (this.dialog == null) {
            this.createDialog();
        }
        return this.dialog;
    }

    public String getButtonlabelaccept() {
        return this.buttonlabelaccept;
    }

    public String getButtonlabelcancel() {
        return this.buttonlabelcancel;
    }

    public String getButtons() {
        return this.btns;
    }

    public String getOndialogaccept() {
        return this.ondialogaccept;
    }

    public String getOndialogcancel() {
        return this.ondialogcancel;
    }

    public String getTitle() {
        return this.title;
    }

    public void setButtonlabelaccept(String label) {
        this.buttonlabelaccept = label;
    }

    public void setButtonlabelcancel(String label) {
        this.buttonlabelcancel = label;
    }

    public void setButtons(String buttons) {
        this.btns = buttons;
        if (this.buttonsProcessed) {
            this.buttonsProcessed = false;
            this.layout();
            this.populateButtonPanel();
        }
    }

    public void setOndialogaccept(String command) {
        this.ondialogaccept = command;
    }

    public void setOndialogcancel(String command) {
        this.ondialogcancel = command;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void show() {
        if (this.dialog == null) {
            this.initialized = false;
            this.createDialog();
            this.dialog.pack();
            this.initialized = true;
        }
        this.dialog.setLocationRelativeTo(this.centerComp);
        this.dialog.setVisible(true);
    }

    public void hide() {
        this.dialog.setVisible(false);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.show();
        } else {
            this.hide();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void layout() {
        this.initialized = false;
        for (Map.Entry<BUTTONS, XulButton> entry : this.buttons.entrySet()) {
            this.removeChild((Element)entry.getValue());
        }
        super.layout();
        for (Element element : this.getChildNodes()) {
            if (!(element instanceof XulDialogheader)) continue;
            this.header = (XulDialogheader)element;
        }
        this.initialized = false;
        if (!this.buttonsProcessed) {
            this.buttons.clear();
            if (this.btns != null) {
                void var2_6;
                String[] tempButtons = this.btns.split(",");
                boolean bl = false;
                while (var2_6 < tempButtons.length) {
                    if (!StringUtils.isEmpty((String)tempButtons[var2_6].trim())) {
                        SwingButton btn = new SwingButton(null, (XulComponent)this, this.domContainer, "button");
                        this.addChild((Element)btn);
                        this.buttons.put(BUTTONS.valueOf(tempButtons[var2_6].trim().toUpperCase()), btn);
                        btn.setId(this.ID + "_" + BUTTONS.valueOf(tempButtons[var2_6].trim().toUpperCase()).toString().toLowerCase());
                    }
                    ++var2_6;
                }
            }
            this.buttonsProcessed = true;
        } else {
            for (Map.Entry<BUTTONS, Object> entry : this.buttons.entrySet()) {
                this.addChild((Element)entry.getValue());
            }
        }
        this.initialized = true;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int height) {
        this.height = height;
        if (this.dialog != null) {
            this.dialog.setSize(this.dialog.getSize().width, height);
        }
    }

    public void setWidth(int width) {
        this.width = width;
        if (this.dialog != null) {
            this.dialog.setSize(width, this.dialog.getSize().height);
        }
    }

    public void setModal(Boolean modal) {
        this.modal = modal;
    }

    public Boolean isModal() {
        return this.modal;
    }

    public String getButtonalign() {
        return this.buttonAlignment.toString().toLowerCase();
    }

    public void setButtonalign(String align) {
        this.buttonAlignment = BUTTON_ALIGN.valueOf(align.toUpperCase());
    }

    public String getOnload() {
        return this.onload;
    }

    public void setOnload(String onload) {
        if (this.parent == null && !(this.parent instanceof XulRoot)) {
            this.onload = onload;
        } else {
            XulRoot root = (XulRoot)this.parent;
            String prevOnload = root.getOnload();
            root.setOnload(prevOnload + "," + onload);
        }
        this.onload = onload;
    }

    private void populateButtonPanel() {
        this.buttonPanel.removeAll();
        if (this.buttonAlignment == BUTTON_ALIGN.RIGHT || this.buttonAlignment == BUTTON_ALIGN.END || this.buttonAlignment == BUTTON_ALIGN.MIDDLE || this.buttonAlignment == BUTTON_ALIGN.CENTER || this.buttonAlignment == null) {
            this.buttonPanel.add(Box.createHorizontalGlue());
        }
        ArrayList<BUTTONS> buttonKeyList = new ArrayList<BUTTONS>(this.buttons.keySet());
        for (int i = 0; i < buttonKeyList.size(); ++i) {
            this.buttonPanel.add(Box.createHorizontalStrut(5));
            this.buttonPanel.add((JButton)this.buttons.get((Object)buttonKeyList.get(i)).getManagedObject());
            this.addChild((Element)this.buttons.get((Object)buttonKeyList.get(i)));
        }
        this.buttonPanel.add(Box.createHorizontalStrut(5));
        if (this.buttonAlignment == BUTTON_ALIGN.START || this.buttonAlignment == BUTTON_ALIGN.LEFT || this.buttonAlignment == BUTTON_ALIGN.MIDDLE || this.buttonAlignment == BUTTON_ALIGN.CENTER) {
            this.buttonPanel.add(Box.createHorizontalGlue());
        }
        if (this.buttons.containsKey((Object)BUTTONS.ACCEPT)) {
            this.buttons.get((Object)BUTTONS.ACCEPT).setLabel(this.getButtonlabelaccept());
            this.buttons.get((Object)BUTTONS.ACCEPT).setOnclick(this.getOndialogaccept());
        }
        if (this.buttons.containsKey((Object)BUTTONS.CANCEL)) {
            this.buttons.get((Object)BUTTONS.CANCEL).setLabel(this.getButtonlabelcancel());
            this.buttons.get((Object)BUTTONS.CANCEL).setOnclick(this.getOndialogcancel());
        }
        if (this.buttons.containsKey((Object)BUTTONS.EXTRA1)) {
            this.buttons.get((Object)BUTTONS.EXTRA1).setLabel(this.getButtonlabelextra1());
            this.buttons.get((Object)BUTTONS.EXTRA1).setOnclick(this.getOndialogextra1());
        }
        if (this.buttons.containsKey((Object)BUTTONS.EXTRA2)) {
            this.buttons.get((Object)BUTTONS.EXTRA2).setLabel(this.getButtonlabelextra2());
            this.buttons.get((Object)BUTTONS.EXTRA2).setOnclick(this.getOndialogextra2());
        }
    }

    private void createDialog() {
        Object parentObj;
        if (this.getParent() instanceof XulDialog) {
            parentObj = ((SwingDialog)this.getParent()).getDialog();
            this.dialog = new JDialog((Dialog)parentObj);
            this.centerComp = (Component)parentObj;
        } else if (this.getParent() instanceof XulWindow) {
            parentObj = this.getParent().getManagedObject();
            this.dialog = new JDialog((Frame)parentObj);
            this.centerComp = (Component)parentObj;
        } else {
            Document doc = this.getDocument();
            XulComponent rootElement = doc.getRootElement();
            XulWindow window = null;
            if (rootElement != this) {
                window = (XulWindow)rootElement;
            }
            if (window != null) {
                this.frame = (JFrame)window.getManagedObject();
                this.dialog = new JDialog(this.frame);
                this.centerComp = this.frame;
            } else {
                Object context = this.domContainer.getOuterContext();
                if (context instanceof JFrame) {
                    this.frame = (JFrame)context;
                    this.centerComp = (Component)context;
                    this.dialog = new JDialog(this.frame);
                } else if (context instanceof JDialog) {
                    this.dialog = new JDialog((JDialog)context);
                    this.centerComp = (Component)context;
                } else if (context instanceof JComponent) {
                    this.dialog = new JDialog();
                    this.centerComp = (Component)context;
                } else {
                    this.dialog = new JDialog();
                }
            }
        }
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setResizable(this.getResizable());
        this.dialog.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setOpaque(true);
        int pad = this.getPadding() > -1 ? this.getPadding() : 3;
        mainPanel.setBorder(BorderFactory.createEmptyBorder(pad, pad, pad, pad));
        this.dialog.setTitle(this.title);
        this.dialog.setModal(this.isModal());
        this.dialog.add((Component)mainPanel, "Center");
        mainPanel.add((Component)this.container, "Center");
        this.container.setOpaque(false);
        if (this.header != null) {
            JPanel headerPanel = new JPanel(new BorderLayout());
            headerPanel.setBackground(Color.decode("#5F86C0"));
            headerPanel.setOpaque(true);
            JPanel headerPanelInner = new JPanel(new BorderLayout());
            headerPanelInner.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            headerPanelInner.setOpaque(false);
            headerPanel.setBorder(BorderFactory.createBevelBorder(1, Color.decode("#8FB1E5"), Color.decode("#446CA9")));
            JLabel title = new JLabel(this.header.getTitle());
            title.setForeground(Color.white);
            headerPanelInner.add((Component)title, "West");
            JLabel desc = new JLabel(this.header.getDescription());
            desc.setForeground(Color.white);
            headerPanelInner.add((Component)desc, "East");
            headerPanel.add((Component)headerPanelInner, "Center");
            mainPanel.add((Component)headerPanel, "North");
        }
        this.populateButtonPanel();
        mainPanel.add((Component)this.buttonPanel, "South");
        this.dialog.setSize(new Dimension(this.getWidth(), this.getHeight()));
        this.dialog.setPreferredSize(new Dimension(this.getWidth(), this.getHeight()));
        this.dialog.setMinimumSize(new Dimension(this.getWidth(), this.getHeight()));
        if (this.getBgcolor() != null) {
            mainPanel.setBackground(Color.decode(this.getBgcolor()));
        }
    }

    public boolean isHidden() {
        return this.dialog == null || !this.dialog.isVisible();
    }

    public String getButtonlabelextra1() {
        return this.buttonlabelextra1;
    }

    public void setButtonlabelextra1(String buttonlabelextra1) {
        this.buttonlabelextra1 = buttonlabelextra1;
    }

    public String getButtonlabelextra2() {
        return this.buttonlabelextra2;
    }

    public void setButtonlabelextra2(String buttonlabelextra2) {
        this.buttonlabelextra2 = buttonlabelextra2;
    }

    public String getOndialogextra1() {
        return this.ondialogextra1;
    }

    public void setOndialogextra1(String ondialogextra1) {
        this.ondialogextra1 = ondialogextra1;
    }

    public String getOndialogextra2() {
        return this.ondialogextra2;
    }

    public void setOndialogextra2(String ondialogextra2) {
        this.ondialogextra2 = ondialogextra2;
    }

    public XulDomContainer getXulDomContainer() {
        return this.domContainer;
    }

    public void setXulDomContainer(XulDomContainer xulDomContainer) {
        this.domContainer = xulDomContainer;
    }

    public Object getRootObject() {
        if (this.dialog == null) {
            this.createDialog();
        }
        return this.dialog;
    }

    public String getOnclose() {
        return this.onclose;
    }

    public String getOnunload() {
        return this.onunload;
    }

    public void setOnclose(String onclose) {
        this.onclose = onclose;
    }

    public void setOnunload(String onunload) {
        this.onunload = onunload;
    }

    public void invokeLater(Runnable runnable) {
        EventQueue.invokeLater(runnable);
    }

    public Boolean getResizable() {
        return this.resizable;
    }

    public void setResizable(Boolean resizable) {
        this.resizable = resizable;
    }

    public void setAppicon(String icon) {
    }

    public boolean isPack() {
        return this.pack;
    }

    public void setPack(boolean pack) {
        this.pack = pack;
    }

    private static enum BUTTON_ALIGN {
        START,
        CENTER,
        END,
        LEFT,
        RIGHT,
        MIDDLE;

    }

    private static enum BUTTONS {
        ACCEPT,
        CANCEL,
        HELP,
        EXTRA1,
        EXTRA2;

    }
}

