/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swing.tags;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.components.XulImage;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swing.SwingElement;

public class SwingImage
extends SwingElement
implements XulImage {
    private String src;
    private static final Log logger = LogFactory.getLog(SwingImage.class);
    private XulDomContainer container;
    private JPanel panel = new JPanel(new BorderLayout());
    private ImageIcon ico = null;
    private Image image;
    private JLabel lbl = null;

    public SwingImage(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        super("image");
        this.panel.setOpaque(false);
        this.container = domContainer;
        this.setManagedObject(this.panel);
    }

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String src) {
        URL url = SwingImage.class.getClassLoader().getResource(this.container.getXulLoader().getRootDir() + src);
        if (url == null) {
            try {
                File f = new File(src);
                if (f.exists()) {
                    url = f.toURL();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (url == null) {
            logger.error((Object)("Could not find resource: " + src));
            return;
        }
        this.ico = new ImageIcon(url);
        if (this.ico == null) {
            logger.error((Object)("Image could not be found: " + this.ico));
        }
        this.src = src;
        this.layout();
    }

    public void setSrc(Object img) {
        if (img instanceof String) {
            this.setSrc((String)img);
            return;
        }
        this.image = (Image)img;
        this.ico = new ImageIcon(this.image);
        if (this.lbl != null) {
            this.lbl.setIcon(this.ico);
        }
        logger.info((Object)"set new Image Src");
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.layout();
    }

    @Override
    public void layout() {
        this.panel.removeAll();
        if (this.ico == null || !this.visible) {
            return;
        }
        if (this.getHeight() > 0 && this.getWidth() > 0) {
            this.ico = new ImageIcon(this.ico.getImage().getScaledInstance(this.getWidth(), this.getHeight(), 16));
        }
        this.lbl = new JLabel(this.ico);
        this.lbl.setOpaque(false);
        this.panel.add((Component)this.lbl, "Center");
        if (this.getHeight() > 0 && this.getWidth() > 0) {
            this.panel.setMinimumSize(new Dimension(this.getWidth(), this.getHeight()));
        }
        this.panel.revalidate();
    }

    public void refresh() {
        this.panel.updateUI();
    }
}

