/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swing.tags;

import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swing.SwingElement;
import org.pentaho.ui.xul.util.TextType;

public class SwingTextbox
extends SwingElement
implements XulTextbox {
    private JTextField textField;
    private boolean multiline = false;
    private JTextArea textArea;
    boolean disabled = false;
    private String value = "";
    private JScrollPane scrollPane;
    private static final Log logger = LogFactory.getLog(SwingTextbox.class);
    private boolean readonly = false;
    private TextType type = TextType.NORMAL;
    private JTextComponent textComp = null;
    private String onInput;
    private int min = -1;
    private int max = -1;
    private int maxlength = -1;
    private String oldValue = null;

    public SwingTextbox(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        super("textbox");
        this.setManagedObject(null);
    }

    public String getValue() {
        if (this.textComp != null) {
            return this.textComp.getText();
        }
        logger.error((Object)"Attempt to get Textbox's value before it's instantiated");
        return null;
    }

    public void setValue(String text) {
        String oldVal = this.value;
        if (this.textComp != null && this.textComp.getText().equals(text)) {
            return;
        }
        if (this.textComp != null) {
            this.textComp.setText(text);
        }
        this.value = text;
        if (text != null || oldVal != null) {
            this.changeSupport.firePropertyChange("value", oldVal, text);
        }
    }

    @Override
    public void layout() {
    }

    public int getMaxlength() {
        return this.maxlength;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public void setDisabled(boolean dis) {
        boolean oldValue = this.disabled;
        this.disabled = dis;
        if (this.textComp != null) {
            this.textComp.setEnabled(!dis);
        }
        this.changeSupport.firePropertyChange("disabled", oldValue, dis);
    }

    public void setMaxlength(int length) {
        this.maxlength = length;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public void setMultiline(boolean multi) {
        this.multiline = multi;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readOnly) {
        this.readonly = readOnly;
    }

    public String getType() {
        if (this.type == null) {
            return null;
        }
        return this.type.toString();
    }

    public void setType(String type) {
        if (type == null) {
            return;
        }
        this.setType(TextType.valueOf((String)type.toUpperCase()));
    }

    public void setType(TextType type) {
        this.type = type;
    }

    public void selectAll() {
        this.textComp.selectAll();
    }

    public void setFocus() {
    }

    public Object getTextControl() {
        return this.getManagedObject();
    }

    public int getWidth() {
        if (this.width <= 0) {
            return 150;
        }
        return this.width;
    }

    public void setWidth(int width) {
        super.setWidth(width);
        if (this.textComp == null) {
            return;
        }
        Dimension box = new Dimension();
        box.height = this.textComp.getPreferredSize().height;
        box.width = width;
        this.textComp.setMaximumSize(box);
        this.textComp.setPreferredSize(box);
        this.textComp.setMinimumSize(box);
    }

    public Object getManagedObject() {
        if (super.getManagedObject() == null) {
            switch (this.type) {
                case PASSWORD: {
                    JPasswordField pass = new JPasswordField(this.value != null ? this.value : "");
                    pass.setPreferredSize(new Dimension(this.getWidth(), 20));
                    pass.setMinimumSize(new Dimension(pass.getPreferredSize().width, pass.getPreferredSize().height));
                    pass.setEditable(!this.readonly);
                    this.textComp = pass;
                    this.setManagedObject(pass);
                    break;
                }
                default: {
                    if (this.multiline) {
                        this.textArea = new JTextArea(this.value != null ? this.value : "");
                        this.scrollPane = new JScrollPane(this.textArea);
                        this.textComp = this.textArea;
                        this.setManagedObject(this.scrollPane);
                        this.textArea.setEditable(!this.readonly);
                        this.scrollPane.setMinimumSize(new Dimension(this.getWidth(), this.height));
                    } else {
                        this.textField = new JTextField(this.value != null ? this.value : "");
                        this.textField.setPreferredSize(new Dimension(this.getWidth(), this.textField.getPreferredSize().height));
                        this.textField.setMinimumSize(new Dimension(this.textField.getPreferredSize().width, this.textField.getPreferredSize().height));
                        this.textField.setEditable(!this.readonly);
                        this.setManagedObject(this.textField);
                        this.textComp = this.textField;
                    }
                    if (this.type == TextType.NUMERIC) {
                        this.textComp.setDocument(new NumericDocument(this.min, this.max));
                    }
                    this.textComp.setEnabled(!this.disabled);
                }
            }
            this.textComp.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                    SwingTextbox.this.oldValue = SwingTextbox.this.textComp.getText();
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    if (SwingTextbox.this.oldValue != null && !SwingTextbox.this.oldValue.equals(SwingTextbox.this.textComp.getText())) {
                        SwingTextbox.this.changeSupport.firePropertyChange("value", SwingTextbox.this.oldValue, SwingTextbox.this.getValue());
                        SwingTextbox.this.oldValue = SwingTextbox.this.textComp.getText();
                    } else if (SwingTextbox.this.oldValue == null) {
                        SwingTextbox.this.oldValue = SwingTextbox.this.textComp.getText();
                    } else {
                        logger.debug((Object)"Special key pressed, ignoring");
                    }
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }
            });
            this.textComp.setToolTipText(this.getTooltiptext());
        }
        return super.getManagedObject();
    }

    public void setOninput(final String method) {
        if (this.textComp != null) {
            this.textComp.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    SwingTextbox.this.invoke(method);
                }
            });
        } else {
            this.onInput = method;
        }
    }

    public String getMin() {
        return "" + this.min;
    }

    public void setMin(String min) {
        this.min = Integer.parseInt(min);
    }

    public String getMax() {
        return "" + this.max;
    }

    public void setMax(String max) {
        this.max = Integer.parseInt(max);
    }

    public void setCommand(String command) {
        throw new RuntimeException("command not implemented on textbox");
    }

    private class NumericDocument
    extends PlainDocument {
        private int min;
        private int max;

        public NumericDocument(int min, int max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (!this.validString(str)) {
                logger.error((Object)("Textbox input not a valid number: " + str));
                return;
            }
            if (str.charAt(str.length() - 1) != '.' && str.charAt(str.length() - 1) != '-' && this.max > -1) {
                StringBuilder stringBuilder = new StringBuilder();
                if (Double.parseDouble(stringBuilder.append(super.getText(0, super.getLength())).append(str).toString()) > (double)this.max) {
                    logger.error((Object)String.format("Textbox Greater [%f]less than max: %d", Float.valueOf(Float.parseFloat(super.getText(0, super.getLength()) + str)), this.max));
                    return;
                }
            }
            super.insertString(offs, str, a);
        }

        private boolean validString(String str) {
            return StringUtils.isNumeric((String)str.replace(".", "").replace("-", "")) || str.equals("-") || str.equals(".");
        }
    }
}

