/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.util.DetachableInputStream;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.HashMapUpdateLockable;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.SelfManagedDataManager;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.context.externalize.ActivateUtils;
import org.apache.axis2.context.externalize.MessageExternalizeUtils;
import org.apache.axis2.context.externalize.SafeObjectInputStream;
import org.apache.axis2.context.externalize.SafeObjectOutputStream;
import org.apache.axis2.context.externalize.SafeSerializable;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisBindingMessage;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.ModuleConfiguration;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisError;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.Phase;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.LoggingControl;
import org.apache.axis2.util.MetaDataEntry;
import org.apache.axis2.util.SelfManagedDataHolder;
import org.apache.axis2.wsdl.WSDLUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageContext
extends AbstractContext
implements Externalizable,
SafeSerializable {
    private static final Log log = LogFactory.getLog(MessageContext.class);
    private String logCorrelationID = null;
    private transient String logCorrelationIDString = null;
    private static final String myClassName = "MessageContext";
    private static final long serialVersionUID = -7753637088257391858L;
    private static final int REVISION_2 = 2;
    private static final int revisionID = 2;
    public static ThreadLocal<MessageContext> currentMessageContext = new ThreadLocal();
    protected Options options = new Options();
    public static final int IN_FLOW = 1;
    public static final int IN_FAULT_FLOW = 3;
    public static final int OUT_FLOW = 2;
    public static final int OUT_FAULT_FLOW = 4;
    public static final String REMOTE_ADDR = "REMOTE_ADDR";
    public static final String TRANSPORT_ADDR = "TRANSPORT_ADDR";
    public static final String TRANSPORT_HEADERS = "TRANSPORT_HEADERS";
    public transient Attachments attachments;
    public static final String TRANSPORT_OUT = "TRANSPORT_OUT";
    public static final String TRANSPORT_IN = "TRANSPORT_IN";
    public static final String CHARACTER_SET_ENCODING = "CHARACTER_SET_ENCODING";
    public static final String UTF_8 = "UTF-8";
    public static final String UTF_16 = "utf-16";
    public static final String TRANSPORT_SUCCEED = "TRANSPORT_SUCCEED";
    public static final String DEFAULT_CHAR_SET_ENCODING = "UTF-8";
    public int FLOW = 1;
    public static final String TRANSPORT_NON_BLOCKING = "transportNonBlocking";
    public static final String DISABLE_ASYNC_CALLBACK_ON_TRANSPORT_ERROR = "disableTransmissionErrorCallback";
    private boolean processingFault;
    private boolean paused;
    public boolean outputWritten;
    private boolean newThreadRequired;
    private boolean isSOAP11 = true;
    private ArrayList<Handler> executionChain;
    private LinkedList<Handler> executedPhases;
    private boolean doingREST;
    private boolean doingMTOM;
    private boolean doingSwA;
    private transient AxisMessage axisMessage;
    private transient AxisOperation axisOperation;
    private transient AxisService axisService;
    private transient AxisServiceGroup axisServiceGroup;
    private transient ConfigurationContext configurationContext;
    private int currentHandlerIndex;
    private int currentPhaseIndex;
    private Exception failureReason;
    private SOAPEnvelope envelope;
    private OperationContext operationContext;
    private boolean responseWritten;
    private boolean serverSide;
    private ServiceContext serviceContext;
    private String serviceContextID;
    private ServiceGroupContext serviceGroupContext;
    private String serviceGroupContextId;
    private SessionContext sessionContext;
    private transient TransportOutDescription transportOut;
    private transient TransportInDescription transportIn;
    private String incomingTransportName;
    private transient LinkedHashMap<String, Object> selfManagedDataMap = null;
    private transient boolean needsToBeReconciled = false;
    private transient int selfManagedDataHandlerCount = 0;
    private transient ArrayList<SelfManagedDataHolder> selfManagedDataListHolder = null;
    private transient ArrayList<MetaDataEntry> metaExecutionChain = null;
    private transient LinkedList<MetaDataEntry> metaExecuted = null;
    private transient int metaHandlerIndex = 0;
    private transient int metaPhaseIndex = 0;
    private transient MetaDataEntry metaAxisOperation = null;
    private transient MetaDataEntry metaAxisService = null;
    private transient MetaDataEntry metaAxisServiceGroup = null;
    private transient MetaDataEntry metaTransportOut = null;
    private transient MetaDataEntry metaTransportIn = null;
    private transient MetaDataEntry metaAxisMessage = null;
    private transient boolean reconcileAxisMessage = false;
    private transient boolean executedPhasesReset = false;
    private String selfManagedDataDelimiter = "*";

    public static MessageContext getCurrentMessageContext() {
        return currentMessageContext.get();
    }

    public static void setCurrentMessageContext(MessageContext ctx) {
        currentMessageContext.set(ctx);
    }

    public MessageContext() {
        super(null);
    }

    MessageContext(ConfigurationContext configContext) {
        this();
        this.setConfigurationContext(configContext);
    }

    public String toString() {
        return this.getLogIDString();
    }

    public String getLogCorrelationID() {
        if (this.logCorrelationID == null) {
            this.logCorrelationID = UUIDGenerator.getUUID();
        }
        return this.logCorrelationID;
    }

    public String getLogIDString() {
        if (this.logCorrelationIDString == null) {
            this.logCorrelationIDString = "[MessageContext: logID=" + this.getLogCorrelationID() + "]";
        }
        return this.logCorrelationIDString;
    }

    public void pause() {
        this.paused = true;
    }

    public AxisOperation getAxisOperation() {
        if (LoggingControl.debugLoggingAllowed) {
            this.checkActivateWarning("getAxisOperation");
        }
        return this.axisOperation;
    }

    public AxisService getAxisService() {
        if (LoggingControl.debugLoggingAllowed) {
            this.checkActivateWarning("getAxisService");
        }
        return this.axisService;
    }

    public AxisServiceGroup getAxisServiceGroup() {
        if (LoggingControl.debugLoggingAllowed) {
            this.checkActivateWarning("getAxisServiceGroup");
        }
        return this.axisServiceGroup;
    }

    public ConfigurationContext getConfigurationContext() {
        if (LoggingControl.debugLoggingAllowed) {
            this.checkActivateWarning("getConfigurationContext");
        }
        return this.configurationContext;
    }

    public int getCurrentHandlerIndex() {
        return this.currentHandlerIndex;
    }

    public int getCurrentPhaseIndex() {
        return this.currentPhaseIndex;
    }

    public SOAPEnvelope getEnvelope() {
        return this.envelope;
    }

    public ArrayList<Handler> getExecutionChain() {
        if (LoggingControl.debugLoggingAllowed) {
            this.checkActivateWarning("getExecutionChain");
        }
        return this.executionChain;
    }

    public void addExecutedPhase(Handler phase) {
        if (this.executedPhases == null) {
            this.executedPhases = new LinkedList();
        }
        this.executedPhases.addFirst(phase);
    }

    public void removeFirstExecutedPhase() {
        if (this.executedPhases != null) {
            this.executedPhases.removeFirst();
        }
    }

    public Iterator<Handler> getExecutedPhases() {
        if (LoggingControl.debugLoggingAllowed) {
            this.checkActivateWarning("getExecutedPhases");
        }
        if (this.executedPhases == null) {
            this.executedPhases = new LinkedList();
        }
        return this.executedPhases.iterator();
    }

    public void resetExecutedPhases() {
        this.executedPhasesReset = true;
        this.executedPhases = new LinkedList();
    }

    public EndpointReference getFaultTo() {
        return this.options.getFaultTo();
    }

    public EndpointReference getFrom() {
        return this.options.getFrom();
    }

    public String getMessageID() {
        return this.options.getMessageId();
    }

    public Parameter getModuleParameter(String key, String moduleName, HandlerDescription handler) {
        AxisModule module;
        AxisConfiguration baseConfig;
        AxisServiceGroup axisServiceDesc;
        AxisService axisService;
        Parameter param;
        ModuleConfiguration moduleConfig;
        AxisOperation opDesc = this.getAxisOperation();
        if (opDesc != null && (moduleConfig = opDesc.getModuleConfig(moduleName)) != null) {
            param = moduleConfig.getParameter(key);
            if (param != null) {
                return param;
            }
            param = opDesc.getParameter(key);
            if (param != null) {
                return param;
            }
        }
        if ((axisService = this.getAxisService()) != null && (moduleConfig = axisService.getModuleConfig(moduleName)) != null) {
            param = moduleConfig.getParameter(key);
            if (param != null) {
                return param;
            }
            param = axisService.getParameter(key);
            if (param != null) {
                return param;
            }
        }
        if ((axisServiceDesc = this.getAxisServiceGroup()) != null && (moduleConfig = axisServiceDesc.getModuleConfig(moduleName)) != null) {
            param = moduleConfig.getParameter(key);
            if (param != null) {
                return param;
            }
            param = axisServiceDesc.getParameter(key);
            if (param != null) {
                return param;
            }
        }
        if ((moduleConfig = (baseConfig = this.configurationContext.getAxisConfiguration()).getModuleConfig(moduleName)) != null) {
            param = moduleConfig.getParameter(key);
            if (param != null) {
                return param;
            }
            param = baseConfig.getParameter(key);
            if (param != null) {
                return param;
            }
        }
        if ((module = baseConfig.getModule(moduleName)) != null && (param = module.getParameter(key)) != null) {
            return param;
        }
        param = handler.getParameter(key);
        return param;
    }

    public OperationContext getOperationContext() {
        if (LoggingControl.debugLoggingAllowed) {
            this.checkActivateWarning("getOperationContext");
        }
        return this.operationContext;
    }

    public Parameter getParameter(String key) {
        if (this.axisMessage != null) {
            return this.axisMessage.getParameter(key);
        }
        if (this.axisOperation != null) {
            return this.axisOperation.getParameter(key);
        }
        if (this.axisService != null) {
            return this.axisService.getParameter(key);
        }
        if (this.axisServiceGroup != null) {
            return this.axisServiceGroup.getParameter(key);
        }
        if (this.configurationContext != null) {
            AxisConfiguration baseConfig = this.configurationContext.getAxisConfiguration();
            return baseConfig.getParameter(key);
        }
        return null;
    }

    @Override
    public Object getLocalProperty(String name) {
        return this.getLocalProperty(name, true);
    }

    public Object getLocalProperty(String name, boolean searchOptions) {
        Object obj;
        if (LoggingControl.debugLoggingAllowed) {
            this.checkActivateWarning("getProperty");
        }
        if ((obj = super.getLocalProperty(name)) != null) {
            return obj;
        }
        if (searchOptions && (obj = this.options.getProperty(name)) != null) {
            return obj;
        }
        return null;
    }

    @Override
    public Object getProperty(String name) {
        Object obj;
        if (LoggingControl.debugLoggingAllowed) {
            this.checkActivateWarning("getProperty");
        }
        if ((obj = super.getProperty(name)) != null) {
            return obj;
        }
        obj = this.options.getProperty(name);
        if (obj != null) {
            return obj;
        }
        if (this.operationContext != null) {
            if (!this.isAncestor(this.operationContext)) {
                obj = this.operationContext.getProperty(name);
            }
        } else if (this.serviceContext != null) {
            if (!this.isAncestor(this.serviceContext)) {
                obj = this.serviceContext.getProperty(name);
            }
        } else if (this.serviceGroupContext != null) {
            if (!this.isAncestor(this.serviceGroupContext)) {
                obj = this.serviceGroupContext.getProperty(name);
            }
        } else if (this.configurationContext != null && !this.isAncestor(this.configurationContext)) {
            obj = this.configurationContext.getProperty(name);
        }
        return obj;
    }

    public boolean isPropertyTrue(String name) {
        return this.isPropertyTrue(name, false);
    }

    public boolean isPropertyTrue(String name, boolean defaultVal) {
        return JavaUtils.isTrueExplicitly(this.getProperty(name), defaultVal);
    }

    @Override
    public Map<String, Object> getProperties() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (this.configurationContext != null) {
            resultMap.putAll(this.configurationContext.getProperties());
        }
        if (this.serviceGroupContext != null) {
            resultMap.putAll(this.serviceGroupContext.getProperties());
        }
        if (this.serviceContext != null) {
            resultMap.putAll(this.serviceContext.getProperties());
        }
        if (this.operationContext != null) {
            resultMap.putAll(this.operationContext.getProperties());
        }
        resultMap.putAll(this.options.getProperties());
        return Collections.unmodifiableMap(resultMap);
    }

    public RelatesTo[] getRelationships() {
        return this.options.getRelationships();
    }

    public RelatesTo getRelatesTo(String type) {
        return this.options.getRelatesTo(type);
    }

    public RelatesTo getRelatesTo() {
        return this.options.getRelatesTo();
    }

    public EndpointReference getReplyTo() {
        return this.options.getReplyTo();
    }

    public ServiceContext getServiceContext() {
        if (LoggingControl.debugLoggingAllowed) {
            this.checkActivateWarning("getServiceContext");
        }
        return this.serviceContext;
    }

    public String getServiceContextID() {
        return this.serviceContextID;
    }

    public ServiceGroupContext getServiceGroupContext() {
        if (LoggingControl.debugLoggingAllowed) {
            this.checkActivateWarning("getServiceGroupContext");
        }
        return this.serviceGroupContext;
    }

    public String getServiceGroupContextId() {
        return this.serviceGroupContextId;
    }

    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public String getSoapAction() {
        return this.options.getAction();
    }

    public EndpointReference getTo() {
        return this.options.getTo();
    }

    public TransportInDescription getTransportIn() {
        if (LoggingControl.debugLoggingAllowed) {
            this.checkActivateWarning("getTransportIn");
        }
        return this.transportIn;
    }

    public TransportOutDescription getTransportOut() {
        if (LoggingControl.debugLoggingAllowed) {
            this.checkActivateWarning("getTransportOut");
        }
        return this.transportOut;
    }

    public String getWSAAction() {
        return this.options.getAction();
    }

    public boolean isDoingMTOM() {
        return this.doingMTOM;
    }

    public boolean isDoingREST() {
        return this.doingREST;
    }

    public boolean isDoingSwA() {
        return this.doingSwA;
    }

    public boolean isNewThreadRequired() {
        return this.newThreadRequired;
    }

    public boolean isOutputWritten() {
        return this.outputWritten;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public boolean isProcessingFault() {
        return this.processingFault;
    }

    public boolean isResponseWritten() {
        return this.responseWritten;
    }

    public boolean isSOAP11() {
        return this.isSOAP11;
    }

    public long getInboundContentLength() throws IOException {
        DetachableInputStream dis;
        if (this.attachments != null) {
            // empty if block
        }
        if ((dis = (DetachableInputStream)this.getProperty("org.apache.axiom.om.util.DetachableInputStream")) != null) {
            return dis.length();
        }
        return 0L;
    }

    public boolean isServerSide() {
        return this.serverSide;
    }

    public AxisMessage getAxisMessage() {
        if (this.reconcileAxisMessage && LoggingControl.debugLoggingAllowed && log.isWarnEnabled()) {
            log.warn((Object)(this.getLogIDString() + ":getAxisMessage(): ****WARNING**** MessageContext.activate(configurationContext) needs to be invoked."));
        }
        return this.axisMessage;
    }

    public void setAxisMessage(AxisMessage axisMessage) {
        this.axisMessage = axisMessage;
    }

    public void setAxisOperation(AxisOperation axisOperation) {
        this.axisOperation = axisOperation;
    }

    public void setAxisService(AxisService axisService) {
        this.axisService = axisService;
        this.axisServiceGroup = this.axisService != null ? axisService.getAxisServiceGroup() : null;
    }

    public void setAxisServiceGroup(AxisServiceGroup axisServiceGroup) {
        this.axisServiceGroup = axisServiceGroup;
    }

    public void setConfigurationContext(ConfigurationContext context) {
        this.configurationContext = context;
    }

    public void setCurrentHandlerIndex(int currentHandlerIndex) {
        this.currentHandlerIndex = currentHandlerIndex;
    }

    public void setCurrentPhaseIndex(int currentPhaseIndex) {
        this.currentPhaseIndex = currentPhaseIndex;
    }

    public void setDoingMTOM(boolean b) {
        this.doingMTOM = b;
    }

    public void setDoingREST(boolean b) {
        this.doingREST = b;
    }

    public void setDoingSwA(boolean b) {
        this.doingSwA = b;
    }

    public void setEnvelope(SOAPEnvelope envelope) throws AxisFault {
        this.envelope = envelope;
        if (this.envelope != null) {
            String soapNamespaceURI = envelope.getNamespace().getNamespaceURI();
            if ("http://www.w3.org/2003/05/soap-envelope".equals(soapNamespaceURI)) {
                this.isSOAP11 = false;
            } else if ("http://schemas.xmlsoap.org/soap/envelope/".equals(soapNamespaceURI)) {
                this.isSOAP11 = true;
            } else {
                throw new AxisFault("Unknown SOAP Version. Current Axis handles only SOAP 1.1 and SOAP 1.2 messages");
            }
            if (this.getAxisService() != null) {
                this.getAxisService().attachEnvelopeEvent(this);
            }
        }
    }

    public void setExecutionChain(ArrayList<Handler> executionChain) {
        this.executionChain = executionChain;
        this.currentHandlerIndex = -1;
        this.currentPhaseIndex = 0;
    }

    public void setFaultTo(EndpointReference reference) {
        this.options.setFaultTo(reference);
    }

    public void setFrom(EndpointReference reference) {
        this.options.setFrom(reference);
    }

    public void setMessageID(String messageId) {
        this.options.setMessageId(messageId);
    }

    public void setNewThreadRequired(boolean b) {
        this.newThreadRequired = b;
    }

    public void setOperationContext(OperationContext context) {
        this.operationContext = context;
        this.setParent(this.operationContext);
        if (this.operationContext != null) {
            if (this.serviceContext == null) {
                this.setServiceContext(this.operationContext.getServiceContext());
            } else if (this.operationContext.getParent() != this.serviceContext) {
                throw new AxisError("ServiceContext in OperationContext does not match !");
            }
            this.setAxisOperation(this.operationContext.getAxisOperation());
        }
    }

    public void setOutputWritten(boolean b) {
        this.outputWritten = b;
    }

    public void setProcessingFault(boolean b) {
        this.processingFault = b;
    }

    public void addRelatesTo(RelatesTo reference) {
        this.options.addRelatesTo(reference);
    }

    public void setReplyTo(EndpointReference reference) {
        this.options.setReplyTo(reference);
    }

    public void setResponseWritten(boolean b) {
        this.responseWritten = b;
    }

    public void setServerSide(boolean b) {
        this.serverSide = b;
    }

    public void setServiceContext(ServiceContext context) {
        this.serviceContext = context;
        if (this.serviceContext != null) {
            if (this.operationContext != null && this.operationContext.getParent() != context) {
                throw new AxisError("ServiceContext and OperationContext.parent do not match!");
            }
            if (this.configurationContext == null) {
                this.configurationContext = context.getConfigurationContext();
            }
            if (this.serviceGroupContext == null) {
                this.serviceGroupContext = context.getServiceGroupContext();
            }
            AxisService axisService = context.getAxisService();
            this.setAxisService(axisService);
            if (axisService != null) {
                axisService.attachServiceContextEvent(this.serviceContext, this);
            }
        }
    }

    public void setServiceContextID(String serviceContextID) {
        this.serviceContextID = serviceContextID;
    }

    public void setServiceGroupContext(ServiceGroupContext serviceGroupContext) {
        this.serviceGroupContext = serviceGroupContext;
        if (this.serviceGroupContext != null) {
            this.axisServiceGroup = serviceGroupContext.getDescription();
        }
    }

    public void setServiceGroupContextId(String serviceGroupContextId) {
        this.serviceGroupContextId = serviceGroupContextId;
    }

    public void setSoapAction(String soapAction) {
        this.options.setAction(soapAction);
    }

    public void setTo(EndpointReference to) {
        this.options.setTo(to);
    }

    public void setTransportIn(TransportInDescription in) {
        this.transportIn = in;
    }

    public void setTransportOut(TransportOutDescription out) {
        this.transportOut = out;
    }

    public void setWSAAction(String actionURI) {
        this.options.setAction(actionURI);
    }

    public void setWSAMessageId(String messageID) {
        this.options.setMessageId(messageID);
    }

    public int getFLOW() {
        return this.FLOW;
    }

    public void setFLOW(int FLOW) {
        this.FLOW = FLOW;
    }

    public Options getOptions() {
        if (LoggingControl.debugLoggingAllowed) {
            this.checkActivateWarning("getOptions");
        }
        return this.options;
    }

    public void setOptions(Options options) {
        this.options.setParent(options);
    }

    public String getIncomingTransportName() {
        return this.incomingTransportName;
    }

    public void setIncomingTransportName(String incomingTransportName) {
        this.incomingTransportName = incomingTransportName;
    }

    public void setRelationships(RelatesTo[] list) {
        this.options.setRelationships(list);
    }

    public Policy getEffectivePolicy() {
        AxisBindingMessage bindingMessage;
        if (LoggingControl.debugLoggingAllowed) {
            this.checkActivateWarning("getEffectivePolicy");
        }
        if ((bindingMessage = (AxisBindingMessage)this.getProperty("AxisBindingMessage")) == null) {
            bindingMessage = this.findBindingMessage();
        }
        if (bindingMessage != null) {
            return bindingMessage.getEffectivePolicy();
        }
        if (this.axisMessage != null) {
            return this.axisMessage.getEffectivePolicy();
        }
        return null;
    }

    private AxisBindingMessage findBindingMessage() {
        AxisEndpoint axisEndpoint;
        if (this.axisService != null && this.axisOperation != null && this.axisService.getEndpointName() != null && (axisEndpoint = this.axisService.getEndpoint(this.axisService.getEndpointName())) != null) {
            AxisBinding axisBinding = axisEndpoint.getBinding();
            AxisBindingOperation axisBindingOperation = (AxisBindingOperation)axisBinding.getChild(this.axisOperation.getName());
            if (axisBindingOperation == null) {
                return null;
            }
            String direction = this.axisMessage.getDirection();
            AxisBindingMessage axisBindingMessage = null;
            if ("in".equals(direction) && WSDLUtil.isInputPresentForMEP(this.axisOperation.getMessageExchangePattern())) {
                axisBindingMessage = (AxisBindingMessage)axisBindingOperation.getChild("In");
                return axisBindingMessage;
            }
            if ("out".equals(direction) && WSDLUtil.isOutputPresentForMEP(this.axisOperation.getMessageExchangePattern())) {
                axisBindingMessage = (AxisBindingMessage)axisBindingOperation.getChild("Out");
                return axisBindingMessage;
            }
        }
        return null;
    }

    public boolean isEngaged(String moduleName) {
        if (LoggingControl.debugLoggingAllowed) {
            this.checkActivateWarning("isEngaged");
        }
        if (this.configurationContext != null) {
            AxisConfiguration axisConfig = this.configurationContext.getAxisConfiguration();
            AxisModule module = axisConfig.getModule(moduleName);
            if (module == null) {
                return false;
            }
            boolean enegage = axisConfig.isEngaged(module);
            if (enegage) {
                return true;
            }
            if (this.axisServiceGroup != null && (enegage = this.axisServiceGroup.isEngaged(module))) {
                return true;
            }
            if (this.axisService != null && (enegage = this.axisService.isEngaged(module))) {
                return true;
            }
            if (this.axisOperation != null && (enegage = this.axisOperation.isEngaged(module))) {
                return true;
            }
        }
        return false;
    }

    public boolean isHeaderPresent() {
        if (this.envelope == null) {
            return false;
        }
        return this.envelope.getHeader() != null;
    }

    public void setAttachmentMap(Attachments attachments) {
        this.attachments = attachments;
    }

    public Attachments getAttachmentMap() {
        if (this.attachments == null) {
            this.attachments = new Attachments();
        }
        return this.attachments;
    }

    public void addAttachment(String contentID, DataHandler dataHandler) {
        if (this.attachments == null) {
            this.attachments = new Attachments();
        }
        this.attachments.addDataHandler(contentID, dataHandler);
    }

    public String addAttachment(DataHandler dataHandler) {
        String contentID = UUIDGenerator.getUUID();
        this.addAttachment(contentID, dataHandler);
        return contentID;
    }

    public DataHandler getAttachment(String contentID) {
        if (this.attachments == null) {
            this.attachments = new Attachments();
        }
        return this.attachments.getDataHandler(contentID);
    }

    public void removeAttachment(String contentID) {
        if (this.attachments != null) {
            this.attachments.removeDataHandler(contentID);
        }
    }

    private String generateSelfManagedDataKey(Class clazz, Object key) {
        return clazz.getName() + this.selfManagedDataDelimiter + key.toString() + this.selfManagedDataDelimiter + Integer.toString(key.hashCode());
    }

    public void setSelfManagedData(Class clazz, Object key, Object value) {
        if (this.selfManagedDataMap == null) {
            this.selfManagedDataMap = new LinkedHashMap();
        }
        this.selfManagedDataMap.put(this.generateSelfManagedDataKey(clazz, key), value);
    }

    public Object getSelfManagedData(Class clazz, Object key) {
        if (this.selfManagedDataMap != null) {
            return this.selfManagedDataMap.get(this.generateSelfManagedDataKey(clazz, key));
        }
        return null;
    }

    public boolean containsSelfManagedDataKey(Class clazz, Object key) {
        if (this.selfManagedDataMap == null) {
            return false;
        }
        return this.selfManagedDataMap.containsKey(this.generateSelfManagedDataKey(clazz, key));
    }

    public void removeSelfManagedData(Class clazz, Object key) {
        if (this.selfManagedDataMap != null) {
            this.selfManagedDataMap.remove(this.generateSelfManagedDataKey(clazz, key));
        }
    }

    private ArrayList<Handler> flattenPhaseListToHandlers(ArrayList<Handler> list, LinkedHashMap<String, Handler> map) {
        if (map == null) {
            map = new LinkedHashMap();
        }
        for (Handler handler : list) {
            String key = null;
            if (handler != null) {
                key = handler.getClass().getName() + "@" + handler.hashCode();
            }
            if (handler instanceof Phase) {
                this.flattenHandlerList(((Phase)handler).getHandlers(), map);
                continue;
            }
            map.put(key, handler);
        }
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            for (String key : map.keySet()) {
                Handler value = map.get(key);
                String name = value.getName();
                log.trace((Object)(this.getLogIDString() + ":flattenPhaseListToHandlers():  key [" + key + "]    handler name [" + name + "]"));
            }
        }
        return new ArrayList<Handler>(map.values());
    }

    private ArrayList<Handler> flattenHandlerList(List<Handler> list, LinkedHashMap<String, Handler> map) {
        if (map == null) {
            map = new LinkedHashMap();
        }
        for (Handler handler : list) {
            String key = null;
            if (handler != null) {
                key = handler.getClass().getName() + "@" + handler.hashCode();
            }
            if (handler instanceof Phase) {
                map.put(key, handler);
                this.flattenHandlerList(((Phase)handler).getHandlers(), map);
                continue;
            }
            map.put(key, handler);
        }
        return new ArrayList<Handler>(map.values());
    }

    private void serializeSelfManagedData(ObjectOutput out) {
        block7: {
            this.selfManagedDataHandlerCount = 0;
            try {
                if (this.selfManagedDataMap == null || this.executionChain == null || this.selfManagedDataMap.size() == 0 || this.executionChain.size() == 0) {
                    out.writeBoolean(false);
                    if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                        log.trace((Object)(this.getLogIDString() + ":serializeSelfManagedData(): No data : END"));
                    }
                    return;
                }
                ArrayList<Handler> flatExecChain = this.flattenPhaseListToHandlers(this.executionChain, null);
                ArrayList<SelfManagedDataHolder> selfManagedDataHolderList = this.serializeSelfManagedDataHelper(flatExecChain);
                if (selfManagedDataHolderList.size() == 0) {
                    out.writeBoolean(false);
                    if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                        log.trace((Object)(this.getLogIDString() + ":serializeSelfManagedData(): No data : END"));
                    }
                    return;
                }
                out.writeBoolean(true);
                out.writeInt(selfManagedDataHolderList.size());
                for (int i = 0; i < selfManagedDataHolderList.size(); ++i) {
                    out.writeObject(selfManagedDataHolderList.get(i));
                }
            }
            catch (IOException e) {
                if (!LoggingControl.debugLoggingAllowed || !log.isTraceEnabled()) break block7;
                log.trace((Object)("MessageContext:serializeSelfManagedData(): Exception [" + e.getClass().getName() + "]  description [" + e.getMessage() + "]"), (Throwable)e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private ArrayList<SelfManagedDataHolder> serializeSelfManagedDataHelper(ArrayList<Handler> handlers) {
        ArrayList<SelfManagedDataHolder> selfManagedDataHolderList = new ArrayList<SelfManagedDataHolder>();
        Iterator<Handler> it = handlers.iterator();
        try {
            while (it.hasNext()) {
                ByteArrayOutputStream baos_fromHandler;
                Handler handler = it.next();
                if (!SelfManagedDataManager.class.isAssignableFrom(handler.getClass())) continue;
                if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                    log.trace((Object)("MessageContext:serializeSelfManagedDataHelper(): calling handler  [" + handler.getClass().getName() + "]  name [" + handler.getName() + "]   serializeSelfManagedData method"));
                }
                if ((baos_fromHandler = ((SelfManagedDataManager)((Object)handler)).serializeSelfManagedData(this)) == null) continue;
                baos_fromHandler.close();
                try {
                    SelfManagedDataHolder selfManagedDataHolder = new SelfManagedDataHolder(handler.getClass().getName(), handler.getName(), baos_fromHandler.toByteArray());
                    selfManagedDataHolderList.add(selfManagedDataHolder);
                    ++this.selfManagedDataHandlerCount;
                }
                catch (Exception exc) {
                    if (!LoggingControl.debugLoggingAllowed || !log.isTraceEnabled()) continue;
                    log.trace((Object)("MessageContext:serializeSelfManagedData(): exception [" + exc.getClass().getName() + "][" + exc.getMessage() + "]  in setting up SelfManagedDataHolder object for [" + handler.getClass().getName() + " / " + handler.getName() + "] "), (Throwable)exc);
                }
            }
            return selfManagedDataHolderList;
        }
        catch (Exception ex) {
            if (!LoggingControl.debugLoggingAllowed) return null;
            if (!log.isTraceEnabled()) return null;
            log.trace((Object)("MessageContext:serializeSelfManagedData(): exception [" + ex.getClass().getName() + "][" + ex.getMessage() + "]"), (Throwable)ex);
            return null;
        }
    }

    private SelfManagedDataManager deserialize_getHandlerFromExecutionChain(Iterator<Handler> it, String classname, String qNameAsString) {
        SelfManagedDataManager handler_toreturn = null;
        try {
            while (it.hasNext() && handler_toreturn == null) {
                Handler handler = it.next();
                if (handler instanceof Phase) {
                    handler_toreturn = this.deserialize_getHandlerFromExecutionChain(((Phase)handler).getHandlers().iterator(), classname, qNameAsString);
                    continue;
                }
                if (!handler.getClass().getName().equals(classname) || !handler.getName().equals(qNameAsString)) continue;
                handler_toreturn = (SelfManagedDataManager)((Object)handler);
            }
            return handler_toreturn;
        }
        catch (ClassCastException e) {
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)("MessageContext:deserialize_getHandlerFromExecutionChain(): ClassCastException thrown: " + e.getMessage()), (Throwable)e);
            }
            return null;
        }
    }

    private void deserializeSelfManagedData() throws IOException {
        try {
            for (int i = 0; this.selfManagedDataListHolder != null && i < this.selfManagedDataListHolder.size(); ++i) {
                SelfManagedDataHolder selfManagedDataHolder = this.selfManagedDataListHolder.get(i);
                String classname = selfManagedDataHolder.getClassname();
                String qNameAsString = selfManagedDataHolder.getId();
                SelfManagedDataManager handler = this.deserialize_getHandlerFromExecutionChain(this.executionChain.iterator(), classname, qNameAsString);
                if (handler == null) {
                    if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                        log.trace((Object)(this.getLogIDString() + ":deserializeSelfManagedData():  [" + classname + "]  was not found in the executionChain associated with the message context."));
                    }
                    throw new IOException("The class [" + classname + "] was not found in the executionChain associated with the message context.");
                }
                ByteArrayInputStream handlerData = new ByteArrayInputStream(selfManagedDataHolder.getData());
                if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                    log.trace((Object)(this.getLogIDString() + ":deserializeSelfManagedData(): calling handler [" + classname + "] [" + qNameAsString + "]  deserializeSelfManagedData method"));
                }
                handler.deserializeSelfManagedData(handlerData, this);
                handler.restoreTransientData(this);
            }
        }
        catch (IOException ioe) {
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(this.getLogIDString() + ":deserializeSelfManagedData(): IOException thrown: " + ioe.getMessage()), (Throwable)ioe);
            }
            throw ioe;
        }
    }

    @Override
    public void writeExternal(ObjectOutput o) throws IOException {
        MetaDataEntry lastEntry;
        String qnameAsString;
        MetaDataEntry mdEntry;
        String objClass;
        OperationContext opContext;
        String charSetEnc;
        SafeObjectOutputStream out = SafeObjectOutputStream.install(o);
        String logCorrelationIDString = this.getLogIDString();
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(logCorrelationIDString + ":writeExternal(): writing to output stream"));
        }
        out.writeLong(-7753637088257391858L);
        out.writeInt(2);
        out.writeInt(this.FLOW);
        out.writeBoolean(this.processingFault);
        out.writeBoolean(this.paused);
        out.writeBoolean(this.outputWritten);
        out.writeBoolean(this.newThreadRequired);
        out.writeBoolean(this.isSOAP11);
        out.writeBoolean(this.doingREST);
        out.writeBoolean(this.doingMTOM);
        out.writeBoolean(this.doingSwA);
        out.writeBoolean(this.responseWritten);
        out.writeBoolean(this.serverSide);
        out.writeLong(this.getLastTouchedTime());
        out.writeObject(this.getLogCorrelationID());
        OMOutputFormat outputFormat = new OMOutputFormat();
        outputFormat.setSOAP11(this.isSOAP11);
        boolean persistOptimized = this.getPersistOptimized();
        if (persistOptimized) {
            outputFormat.setDoOptimize(true);
        }
        if ((charSetEnc = (String)this.getProperty(CHARACTER_SET_ENCODING)) == null && (opContext = this.getOperationContext()) != null) {
            charSetEnc = (String)opContext.getProperty(CHARACTER_SET_ENCODING);
        }
        if (charSetEnc == null) {
            charSetEnc = "UTF-8";
        }
        outputFormat.setCharSetEncoding(charSetEnc);
        MessageExternalizeUtils.writeExternal(out, this, logCorrelationIDString, outputFormat);
        out.writeUTF("executionChain");
        if (this.executionChain != null && this.executionChain.size() > 0) {
            out.writeBoolean(true);
            out.writeInt(this.currentHandlerIndex);
            out.writeInt(this.currentPhaseIndex);
            out.writeInt(this.executionChain.size());
            int nextIndex = 0;
            for (Handler obj : this.executionChain) {
                objClass = obj.getClass().getName();
                mdEntry = new MetaDataEntry();
                mdEntry.setClassName(objClass);
                if (obj instanceof Phase) {
                    Phase phaseObj = (Phase)obj;
                    qnameAsString = phaseObj.getName();
                    this.setupPhaseList(phaseObj, mdEntry);
                } else if (obj instanceof Handler) {
                    Handler handlerObj = obj;
                    qnameAsString = handlerObj.getName();
                } else {
                    qnameAsString = "NULL";
                }
                mdEntry.setQName(qnameAsString);
                if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                    log.trace((Object)(logCorrelationIDString + ":writeExternal(): ***BEFORE OBJ WRITE*** executionChain entry class [" + objClass + "] qname [" + qnameAsString + "]"));
                }
                out.writeObject(mdEntry);
                ++nextIndex;
                if (!LoggingControl.debugLoggingAllowed || !log.isTraceEnabled()) continue;
                log.trace((Object)(logCorrelationIDString + ":writeExternal(): ***AFTER OBJ WRITE*** executionChain entry class [" + objClass + "] qname [" + qnameAsString + "]"));
            }
            lastEntry = new MetaDataEntry();
            lastEntry.setClassName(MetaDataEntry.END_OF_LIST);
            out.writeObject(lastEntry);
            out.writeInt(++nextIndex);
        } else {
            out.writeBoolean(false);
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(logCorrelationIDString + ":writeExternal(): executionChain is NULL"));
            }
        }
        out.writeUTF("executedPhases");
        if (this.executedPhases != null && this.executedPhases.size() > 0) {
            out.writeBoolean(true);
            out.writeInt(this.executedPhases.size());
            int execNextIndex = 0;
            for (Handler obj : this.executedPhases) {
                objClass = obj.getClass().getName();
                mdEntry = new MetaDataEntry();
                mdEntry.setClassName(objClass);
                if (obj instanceof Phase) {
                    Phase inPhaseObj = (Phase)obj;
                    qnameAsString = inPhaseObj.getName();
                    this.setupPhaseList(inPhaseObj, mdEntry);
                } else if (obj instanceof Handler) {
                    Handler inHandlerObj = obj;
                    qnameAsString = inHandlerObj.getName();
                } else {
                    qnameAsString = "NULL";
                }
                mdEntry.setQName(qnameAsString);
                if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                    log.trace((Object)(logCorrelationIDString + ":writeExternal(): ***BEFORE Executed List OBJ WRITE*** executedPhases entry class [" + objClass + "] qname [" + qnameAsString + "]"));
                }
                out.writeObject(mdEntry);
                ++execNextIndex;
                if (!LoggingControl.debugLoggingAllowed || !log.isTraceEnabled()) continue;
                log.trace((Object)(logCorrelationIDString + ":writeExternal(): " + "***AFTER Executed List OBJ WRITE*** " + "executedPhases entry class [" + objClass + "] " + "qname [" + qnameAsString + "]"));
            }
            lastEntry = new MetaDataEntry();
            lastEntry.setClassName(MetaDataEntry.END_OF_LIST);
            out.writeObject(lastEntry);
            out.writeInt(++execNextIndex);
        } else {
            out.writeBoolean(false);
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(logCorrelationIDString + ":writeExternal(): executedPhases is NULL"));
            }
        }
        String tmpID = this.getMessageID();
        if (tmpID == null) {
            tmpID = UUIDGenerator.getUUID();
            this.setMessageID(tmpID);
        }
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(logCorrelationIDString + ":writeExternal():   message ID [" + tmpID + "]"));
        }
        out.writeUTF("options");
        out.writeObject(this.options);
        out.writeUTF("axisOperation");
        this.metaAxisOperation = null;
        if (this.axisOperation != null) {
            QName aoTmpQName = this.axisOperation.getName();
            if (aoTmpQName == null) {
                aoTmpQName = new QName("EMPTY_OBJ");
                this.axisOperation.setName(aoTmpQName);
            }
            this.metaAxisOperation = new MetaDataEntry(this.axisOperation.getClass().getName(), this.axisOperation.getName().toString());
        }
        out.writeObject(this.metaAxisOperation);
        out.writeUTF("operationContext");
        if (this.operationContext != null) {
            this.operationContext.isolateMessageContext(this);
        }
        out.writeObject(this.operationContext);
        out.writeUTF("axisService");
        this.metaAxisService = null;
        if (this.axisService != null) {
            this.metaAxisService = new MetaDataEntry(this.axisService.getClass().getName(), this.axisService.getName());
        }
        out.writeObject(this.metaAxisService);
        out.writeObject(this.serviceContextID);
        boolean isParent = false;
        out.writeUTF("serviceContext");
        if (this.operationContext != null) {
            ServiceContext opctxParent = this.operationContext.getServiceContext();
            if (this.serviceContext != null && this.serviceContext.equals(opctxParent)) {
                isParent = true;
            }
        }
        if (this.serviceContext == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeBoolean(isParent);
            if (!isParent) {
                out.writeObject(this.serviceContext);
            }
        }
        out.writeUTF("axisServiceGroup");
        this.metaAxisServiceGroup = null;
        if (this.axisServiceGroup != null) {
            this.metaAxisServiceGroup = new MetaDataEntry(this.axisServiceGroup.getClass().getName(), this.axisServiceGroup.getServiceGroupName());
        }
        out.writeObject(this.metaAxisServiceGroup);
        out.writeObject(this.serviceGroupContextId);
        isParent = false;
        out.writeUTF("serviceGroupContext");
        if (this.serviceContext != null) {
            ServiceGroupContext srvgrpctxParent = (ServiceGroupContext)this.serviceContext.getParent();
            if (this.serviceGroupContext != null && this.serviceGroupContext.equals(srvgrpctxParent)) {
                isParent = true;
            }
        }
        if (this.serviceGroupContext == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeBoolean(isParent);
            if (!isParent) {
                out.writeObject(this.serviceGroupContext);
            }
        }
        out.writeUTF("axisMessage");
        this.metaAxisMessage = null;
        if (this.axisMessage != null) {
            String amTmpName = this.axisMessage.getName();
            if (amTmpName == null) {
                amTmpName = "EMPTY_OBJ";
                this.axisMessage.setName(amTmpName);
            }
            QName amTmpElementQName = this.axisMessage.getElementQName();
            String amTmpElemQNameString = null;
            if (amTmpElementQName != null) {
                amTmpElemQNameString = amTmpElementQName.toString();
            }
            this.metaAxisMessage = new MetaDataEntry(this.axisMessage.getClass().getName(), this.axisMessage.getName(), amTmpElemQNameString);
        }
        out.writeObject(this.metaAxisMessage);
        out.writeObject(this.sessionContext);
        out.writeObject(this.incomingTransportName);
        this.metaTransportIn = null;
        if (this.transportIn != null) {
            this.metaTransportIn = new MetaDataEntry(null, this.transportIn.getName());
        }
        out.writeObject(this.metaTransportIn);
        this.metaTransportOut = null;
        if (this.transportOut != null) {
            this.metaTransportOut = new MetaDataEntry(null, this.transportOut.getName());
        }
        out.writeObject(this.metaTransportOut);
        out.writeUTF("properties");
        out.writeMap(this.properties);
        out.writeUTF("selfManagedData");
        this.serializeSelfManagedData(out);
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(logCorrelationIDString + ":writeExternal(): completed writing to output stream for " + logCorrelationIDString));
        }
    }

    private boolean getPersistOptimized() {
        Object property;
        boolean persistOptimized = false;
        if (this.attachments != null && this.attachments.getContentIDList().size() > 1) {
            persistOptimized = true;
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(this.getLogIDString() + ":getPersistOptimized(): attachments present; persist optimized"));
            }
        }
        if (!persistOptimized && (property = this.getProperty("enableMTOM")) != null && JavaUtils.isTrueExplicitly(property)) {
            persistOptimized = true;
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(this.getLogIDString() + ":getPersistOptimized(): ENBABLE_MTOM is set; persist optimized"));
            }
        }
        if (!persistOptimized && (property = this.getProperty("enableSwA")) != null && JavaUtils.isTrueExplicitly(property)) {
            persistOptimized = true;
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(this.getLogIDString() + ":getPersistOptimized(): ENBABLE_SWA is set; persist optimized"));
            }
        }
        if (!persistOptimized && LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(this.getLogIDString() + ":getPersistOptimized(): No attachments or attachment settings; persist non-optimized"));
        }
        return persistOptimized;
    }

    @Override
    public void readExternal(ObjectInput inObject) throws IOException, ClassNotFoundException {
        boolean gotSelfManagedData;
        boolean isParentSGC;
        boolean servGrpCtxActive;
        boolean isParent;
        boolean servCtxActive;
        boolean gotChain;
        SafeObjectInputStream in = SafeObjectInputStream.install(inObject);
        this.needsToBeReconciled = true;
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)("MessageContext:readExternal():  BEGIN  bytes available in stream [" + in.available() + "]  "));
        }
        long suid = in.readLong();
        int revID = in.readInt();
        if (suid != -7753637088257391858L) {
            throw new ClassNotFoundException("Serialization version ID is not supported.");
        }
        if (revID != 2) {
            throw new ClassNotFoundException("Revision ID is not supported.");
        }
        this.FLOW = in.readInt();
        this.processingFault = in.readBoolean();
        this.paused = in.readBoolean();
        this.outputWritten = in.readBoolean();
        this.newThreadRequired = in.readBoolean();
        this.isSOAP11 = in.readBoolean();
        this.doingREST = in.readBoolean();
        this.doingMTOM = in.readBoolean();
        this.doingSwA = in.readBoolean();
        this.responseWritten = in.readBoolean();
        this.serverSide = in.readBoolean();
        long time = in.readLong();
        this.setLastTouchedTime(time);
        this.logCorrelationID = (String)in.readObject();
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            this.logCorrelationIDString = "[MessageContext: logID=" + this.getLogCorrelationID() + "]";
            log.trace((Object)("MessageContext:readExternal():  reading the input stream for  " + this.getLogIDString()));
        }
        this.envelope = MessageExternalizeUtils.readExternal(in, this, this.getLogIDString());
        this.executionChain = null;
        this.currentHandlerIndex = -1;
        this.currentPhaseIndex = 0;
        this.metaExecutionChain = null;
        String marker = in.readUTF();
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(this.getLogIDString() + ": readExternal(): About to read executionChain, marker is: " + marker));
        }
        if (gotChain = in.readBoolean()) {
            this.metaHandlerIndex = in.readInt();
            this.metaPhaseIndex = in.readInt();
            int expectedNumberEntries = in.readInt();
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(this.getLogIDString() + ":readExternal(): execution chain:  expected number of entries [" + expectedNumberEntries + "]"));
            }
            this.metaExecutionChain = new ArrayList();
            boolean keepGoing = true;
            int count = 0;
            while (keepGoing) {
                Object tmpObj = in.readObject();
                ++count;
                MetaDataEntry mdObj = (MetaDataEntry)tmpObj;
                if (mdObj != null) {
                    String tmpHasList;
                    String tmpClassNameStr = mdObj.getClassName();
                    if (tmpClassNameStr.equalsIgnoreCase(MetaDataEntry.END_OF_LIST)) {
                        keepGoing = false;
                        continue;
                    }
                    this.metaExecutionChain.add(mdObj);
                    String tmpQNameAsStr = mdObj.getQNameAsString();
                    if (!LoggingControl.debugLoggingAllowed || !log.isTraceEnabled()) continue;
                    String string = tmpHasList = mdObj.isListEmpty() ? "no children" : "has children";
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)(this.getLogIDString() + ":readExternal(): meta data class [" + tmpClassNameStr + "] qname [" + tmpQNameAsStr + "]  index [" + count + "]   [" + tmpHasList + "]"));
                    continue;
                }
                keepGoing = false;
            }
            int adjustedNumberEntries = in.readInt();
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(this.getLogIDString() + ":readExternal(): adjusted number of entries ExecutionChain [" + adjustedNumberEntries + "]    "));
            }
        }
        if ((this.metaExecutionChain == null || this.metaExecutionChain.isEmpty()) && LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(this.getLogIDString() + ":readExternal(): meta data for Execution Chain is NULL"));
        }
        this.executedPhases = null;
        this.metaExecuted = null;
        marker = in.readUTF();
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(this.getLogIDString() + ": readExternal(): About to read executedPhases, marker is: " + marker));
        }
        boolean gotInExecList = in.readBoolean();
        boolean oldStyleExecutedPhases = false;
        if (marker.equals("inboundExecutedPhases")) {
            oldStyleExecutedPhases = true;
        }
        if (oldStyleExecutedPhases && !gotInExecList) {
            marker = in.readUTF();
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(this.getLogIDString() + ": readExternal(): Skipping over oldStyle empty inboundExecutedPhases"));
                log.trace((Object)(this.getLogIDString() + ": readExternal(): About to read executedPhases, marker is: " + marker));
            }
            gotInExecList = in.readBoolean();
        }
        if (gotInExecList) {
            int expectedNumberInExecList = in.readInt();
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(this.getLogIDString() + ":readExternal(): executed phases:  expected number of entries [" + expectedNumberInExecList + "]"));
            }
            this.metaExecuted = new LinkedList();
            boolean keepGoing = true;
            int count = 0;
            while (keepGoing) {
                Object tmpObj = in.readObject();
                ++count;
                MetaDataEntry mdObj = (MetaDataEntry)tmpObj;
                String tmpHasList = "no list";
                if (mdObj != null) {
                    String tmpClassNameStr = mdObj.getClassName();
                    if (tmpClassNameStr.equalsIgnoreCase(MetaDataEntry.END_OF_LIST)) {
                        keepGoing = false;
                        continue;
                    }
                    this.metaExecuted.add(mdObj);
                    String tmpQNameAsStr = mdObj.getQNameAsString();
                    if (!mdObj.isListEmpty()) {
                        tmpHasList = "has list";
                    }
                    if (!LoggingControl.debugLoggingAllowed || !log.isTraceEnabled()) continue;
                    log.trace((Object)(this.getLogIDString() + ":readExternal(): meta data class [" + tmpClassNameStr + "] qname [" + tmpQNameAsStr + "]  index [" + count + "]   [" + tmpHasList + "]"));
                    continue;
                }
                keepGoing = false;
            }
            int adjustedNumberInExecList = in.readInt();
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(this.getLogIDString() + ":readExternal(): adjusted number of entries executedPhases [" + adjustedNumberInExecList + "]    "));
            }
        }
        if ((this.metaExecuted == null || this.metaExecuted.isEmpty()) && LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(this.getLogIDString() + ":readExternal(): meta data for executedPhases list is NULL"));
        }
        marker = in.readUTF();
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(this.getLogIDString() + ": readExternal(): After reading executedPhases, marker is: " + marker));
        }
        if (marker.equals("outboundExecutedPhases")) {
            Boolean gotOutExecList = in.readBoolean();
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(this.getLogIDString() + ": readExternal(): Skipping over outboundExecutedPhases, marker is: " + marker + ", is list an active object: " + gotOutExecList));
            }
            if (gotOutExecList.booleanValue()) {
                throw new IOException("Both inboundExecutedPhases and outboundExecutedPhases had active objects");
            }
            marker = in.readUTF();
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(this.getLogIDString() + ": readExternal(): After skipping ooutboundExecutePhases, marker is: " + marker));
            }
        }
        this.options = (Options)in.readObject();
        if (this.options != null && LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(this.getLogIDString() + ":readExternal(): restored Options [" + this.options.getLogCorrelationIDString() + "]"));
        }
        this.axisOperation = null;
        marker = in.readUTF();
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(this.getLogIDString() + ": readExternal(): About to read axisOperation, marker is: " + marker));
        }
        this.metaAxisOperation = (MetaDataEntry)in.readObject();
        marker = in.readUTF();
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(this.getLogIDString() + ": readExternal(): About to read operationContext, marker is: " + marker));
        }
        this.operationContext = (OperationContext)in.readObject();
        if (this.operationContext != null && LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(this.getLogIDString() + ":readExternal(): restored OperationContext [" + this.operationContext.getLogCorrelationIDString() + "]"));
        }
        this.axisService = null;
        marker = in.readUTF();
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(this.getLogIDString() + ": readExternal(): About to read axisService, marker is: " + marker));
        }
        this.metaAxisService = (MetaDataEntry)in.readObject();
        this.serviceContextID = (String)in.readObject();
        marker = in.readUTF();
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(this.getLogIDString() + ": readExternal(): About to read serviceContext, marker is: " + marker));
        }
        this.serviceContext = !(servCtxActive = in.readBoolean()) ? null : (!(isParent = in.readBoolean()) ? (ServiceContext)in.readObject() : null);
        this.axisServiceGroup = null;
        marker = in.readUTF();
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(this.getLogIDString() + ": readExternal(): About to read AxisServiceGroup, marker is: " + marker));
        }
        this.metaAxisServiceGroup = (MetaDataEntry)in.readObject();
        this.serviceGroupContextId = (String)in.readObject();
        marker = in.readUTF();
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(this.getLogIDString() + ": readExternal(): About to read ServiceGroupContext, marker is: " + marker));
        }
        this.serviceGroupContext = !(servGrpCtxActive = in.readBoolean()) ? null : (!(isParentSGC = in.readBoolean()) ? (ServiceGroupContext)in.readObject() : null);
        this.axisMessage = null;
        marker = in.readUTF();
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(this.getLogIDString() + ": readExternal(): About to read AxisMessage, marker is: " + marker));
        }
        this.metaAxisMessage = (MetaDataEntry)in.readObject();
        this.reconcileAxisMessage = this.metaAxisMessage != null;
        this.sessionContext = (SessionContext)in.readObject();
        this.incomingTransportName = (String)in.readObject();
        this.transportIn = null;
        this.metaTransportIn = (MetaDataEntry)in.readObject();
        this.transportOut = null;
        this.metaTransportOut = (MetaDataEntry)in.readObject();
        marker = in.readUTF();
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(this.getLogIDString() + ": readExternal(): About to read properties, marker is: " + marker));
        }
        this.properties = in.readMap(new HashMapUpdateLockable());
        marker = in.readUTF();
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(this.getLogIDString() + ": readExternal(): About to read SpecialData, marker is: " + marker));
        }
        if (gotSelfManagedData = in.readBoolean()) {
            this.selfManagedDataHandlerCount = in.readInt();
            if (this.selfManagedDataListHolder == null) {
                this.selfManagedDataListHolder = new ArrayList();
            } else {
                this.selfManagedDataListHolder.clear();
            }
            for (int i = 0; i < this.selfManagedDataHandlerCount; ++i) {
                this.selfManagedDataListHolder.add((SelfManagedDataHolder)in.readObject());
            }
        }
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(this.getLogIDString() + ":readExternal():  message context object created for  " + this.getLogIDString()));
        }
    }

    public void activate(ConfigurationContext cc) {
        String logCorrelationIDString;
        block32: {
            AxisOperation op;
            if (!this.needsToBeReconciled) {
                return;
            }
            this.setConfigurationContext(cc);
            AxisConfiguration axisConfig = this.configurationContext.getAxisConfiguration();
            if (this.metaAxisService != null) {
                this.setAxisService(ActivateUtils.findService(axisConfig, this.metaAxisService.getClassName(), this.metaAxisService.getQNameAsString()));
            }
            if (this.metaAxisServiceGroup != null) {
                this.setAxisServiceGroup(ActivateUtils.findServiceGroup(axisConfig, this.metaAxisServiceGroup.getClassName(), this.metaAxisServiceGroup.getQNameAsString()));
            }
            if (this.metaAxisOperation != null) {
                AxisService serv = this.axisService;
                if (serv != null) {
                    this.setAxisOperation(ActivateUtils.findOperation(serv, this.metaAxisOperation.getClassName(), this.metaAxisOperation.getQName()));
                } else {
                    this.setAxisOperation(ActivateUtils.findOperation(axisConfig, this.metaAxisOperation.getClassName(), this.metaAxisOperation.getQName()));
                }
            }
            if (this.metaAxisMessage != null && (op = this.axisOperation) != null) {
                this.setAxisMessage(ActivateUtils.findMessage(op, this.metaAxisMessage.getQNameAsString(), this.metaAxisMessage.getExtraName()));
            }
            if (this.operationContext != null) {
                this.operationContext.activate(cc);
            }
            if (this.serviceContext == null && this.operationContext != null) {
                this.serviceContext = this.operationContext.getServiceContext();
            }
            if (this.serviceContext != null) {
                this.serviceContext.activate(cc);
            }
            if (this.serviceGroupContext == null && this.serviceContext != null) {
                this.serviceGroupContext = (ServiceGroupContext)this.serviceContext.getParent();
            }
            if (this.serviceGroupContext != null) {
                this.serviceGroupContext.activate(cc);
            }
            this.setParent(this.operationContext);
            if (this.options != null) {
                this.options.activate(cc);
            }
            String tmpID = this.getMessageID();
            logCorrelationIDString = this.getLogIDString();
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(logCorrelationIDString + ":activate():   message ID [" + tmpID + "] for " + logCorrelationIDString));
            }
            if (this.metaTransportIn != null) {
                QName qin = this.metaTransportIn.getQName();
                TransportInDescription tmpIn = null;
                try {
                    tmpIn = axisConfig.getTransportIn(qin.getLocalPart());
                }
                catch (Exception exin) {
                    log.trace((Object)(logCorrelationIDString + "activate():  exception caught when getting the TransportInDescription [" + qin.toString() + "]  from the AxisConfiguration [" + exin.getClass().getName() + " : " + exin.getMessage() + "]"));
                }
                this.transportIn = tmpIn != null ? tmpIn : null;
            } else {
                this.transportIn = null;
            }
            if (this.metaTransportOut != null) {
                TransportOutDescription tmpOut;
                block31: {
                    QName qout = this.metaTransportOut.getQName();
                    tmpOut = null;
                    try {
                        tmpOut = axisConfig.getTransportOut(qout.getLocalPart());
                    }
                    catch (Exception exout) {
                        if (!LoggingControl.debugLoggingAllowed || !log.isTraceEnabled()) break block31;
                        log.trace((Object)(logCorrelationIDString + "activate():  exception caught when getting the TransportOutDescription [" + qout.toString() + "]  from the AxisConfiguration [" + exout.getClass().getName() + " : " + exout.getMessage() + "]"));
                    }
                }
                this.transportOut = tmpOut != null ? tmpOut : null;
            } else {
                this.transportOut = null;
            }
            if (this.metaExecutionChain != null) {
                if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                    log.trace((Object)(logCorrelationIDString + ":activate(): reconciling the execution chain..."));
                }
                this.currentHandlerIndex = this.metaHandlerIndex;
                this.currentPhaseIndex = this.metaPhaseIndex;
                this.executionChain = this.restoreHandlerList(this.metaExecutionChain);
                try {
                    this.deserializeSelfManagedData();
                }
                catch (Exception ex) {
                    if (!LoggingControl.debugLoggingAllowed || !log.isTraceEnabled()) break block32;
                    log.trace((Object)(logCorrelationIDString + ":activate(): *** WARNING *** deserializing the self managed data encountered Exception [" + ex.getClass().getName() + " : " + ex.getMessage() + "]"), (Throwable)ex);
                }
            }
        }
        if (this.metaExecuted != null) {
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(logCorrelationIDString + ":activate(): reconciling the executed chain..."));
            }
            if (!this.executedPhasesReset) {
                this.executedPhases = this.restoreExecutedList(this.executedPhases, this.metaExecuted);
            }
        }
        if (this.executedPhases == null) {
            this.executedPhases = new LinkedList();
        }
        if (this.operationContext != null) {
            this.operationContext.restoreMessageContext(this);
        }
        this.needsToBeReconciled = false;
    }

    public void activateWithOperationContext(OperationContext operationCtx) {
        String logCorrelationIDString;
        block30: {
            if (!this.needsToBeReconciled) {
                return;
            }
            logCorrelationIDString = this.getLogIDString();
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(logCorrelationIDString + ":activateWithOperationContext():  BEGIN"));
            }
            if (operationCtx == null) {
                if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                    log.trace((Object)(logCorrelationIDString + ":activateWithOperationContext():  *** WARNING ***  No active OperationContext object is available."));
                }
                return;
            }
            ConfigurationContext configCtx = operationCtx.getConfigurationContext();
            if (configCtx == null) {
                if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                    log.trace((Object)(logCorrelationIDString + ":activateWithOperationContext():  *** WARNING ***  No active ConfigurationContext object is available."));
                }
                return;
            }
            AxisConfiguration axisCfg = configCtx.getAxisConfiguration();
            AxisOperation axisOp = operationCtx.getAxisOperation();
            ServiceContext serviceCtx = operationCtx.getServiceContext();
            ServiceGroupContext serviceGroupCtx = null;
            AxisService axisSrv = null;
            AxisServiceGroup axisSG = null;
            if (serviceCtx != null) {
                serviceGroupCtx = serviceCtx.getServiceGroupContext();
                axisSrv = serviceCtx.getAxisService();
            }
            if (serviceGroupCtx != null) {
                axisSG = serviceGroupCtx.getDescription();
            }
            this.setConfigurationContext(configCtx);
            this.setAxisOperation(axisOp);
            this.setAxisService(axisSrv);
            this.setAxisServiceGroup(axisSG);
            this.setServiceGroupContext(serviceGroupCtx);
            this.setServiceContext(serviceCtx);
            this.setOperationContext(operationCtx);
            if (this.metaAxisMessage != null && axisOp != null) {
                this.setAxisMessage(ActivateUtils.findMessage(axisOp, this.metaAxisMessage.getQNameAsString(), this.metaAxisMessage.getExtraName()));
            }
            if (this.options != null) {
                this.options.activate(configCtx);
            }
            String tmpID = this.getMessageID();
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(logCorrelationIDString + ":activateWithOperationContext():   message ID [" + tmpID + "]"));
            }
            if (this.metaTransportIn != null) {
                TransportInDescription tmpIn;
                block28: {
                    QName qin = this.metaTransportIn.getQName();
                    tmpIn = null;
                    try {
                        tmpIn = axisCfg.getTransportIn(qin.getLocalPart());
                    }
                    catch (Exception exin) {
                        if (!LoggingControl.debugLoggingAllowed || !log.isTraceEnabled()) break block28;
                        log.trace((Object)(logCorrelationIDString + "activateWithOperationContext():  exception caught when getting the TransportInDescription [" + qin.toString() + "]  from the AxisConfiguration [" + exin.getClass().getName() + " : " + exin.getMessage() + "]"));
                    }
                }
                this.transportIn = tmpIn != null ? tmpIn : null;
            } else {
                this.transportIn = null;
            }
            if (this.metaTransportOut != null) {
                TransportOutDescription tmpOut;
                block29: {
                    QName qout = this.metaTransportOut.getQName();
                    tmpOut = null;
                    try {
                        tmpOut = axisCfg.getTransportOut(qout.getLocalPart());
                    }
                    catch (Exception exout) {
                        if (!LoggingControl.debugLoggingAllowed || !log.isTraceEnabled()) break block29;
                        log.trace((Object)(logCorrelationIDString + "activateWithOperationContext():  exception caught when getting the TransportOutDescription [" + qout.toString() + "]  from the AxisConfiguration [" + exout.getClass().getName() + " : " + exout.getMessage() + "]"));
                    }
                }
                this.transportOut = tmpOut != null ? tmpOut : null;
            } else {
                this.transportOut = null;
            }
            if (this.metaExecutionChain != null) {
                if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                    log.trace((Object)(logCorrelationIDString + ":activateWithOperationContext(): reconciling the execution chain..."));
                }
                this.currentHandlerIndex = this.metaHandlerIndex;
                this.currentPhaseIndex = this.metaPhaseIndex;
                this.executionChain = this.restoreHandlerList(this.metaExecutionChain);
                try {
                    this.deserializeSelfManagedData();
                }
                catch (Exception ex) {
                    if (!LoggingControl.debugLoggingAllowed || !log.isTraceEnabled()) break block30;
                    log.trace((Object)(logCorrelationIDString + ":activateWithOperationContext(): *** WARNING *** deserializing the self managed data encountered Exception [" + ex.getClass().getName() + " : " + ex.getMessage() + "]"), (Throwable)ex);
                }
            }
        }
        if (this.metaExecuted != null) {
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(logCorrelationIDString + ":activateWithOperationContext(): reconciling the executed chain..."));
            }
            if (!this.executedPhasesReset) {
                this.executedPhases = this.restoreExecutedList(this.executedPhases, this.metaExecuted);
            }
        }
        if (this.executedPhases == null) {
            this.executedPhases = new LinkedList();
        }
        this.needsToBeReconciled = false;
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(logCorrelationIDString + ":activateWithOperationContext():  END"));
        }
    }

    private ArrayList<Handler> restoreHandlerList(ArrayList<MetaDataEntry> metaDataEntries) {
        AxisConfiguration axisConfig = this.configurationContext.getAxisConfiguration();
        ArrayList<Handler> existingHandlers = new ArrayList<Handler>();
        switch (this.FLOW) {
            case 1: {
                existingHandlers.addAll(axisConfig.getInFlowPhases());
                break;
            }
            case 2: {
                existingHandlers.addAll(axisConfig.getOutFlowPhases());
                break;
            }
            case 3: {
                existingHandlers.addAll(axisConfig.getInFaultFlowPhases());
                break;
            }
            case 4: {
                existingHandlers.addAll(axisConfig.getOutFaultFlowPhases());
            }
        }
        existingHandlers = this.flattenHandlerList(existingHandlers, null);
        ArrayList<Handler> handlerListToReturn = new ArrayList<Handler>();
        for (int i = 0; i < metaDataEntries.size(); ++i) {
            Handler handler = (Handler)ActivateUtils.findHandler(existingHandlers, metaDataEntries.get(i));
            if (handler == null) continue;
            handlerListToReturn.add(handler);
        }
        return handlerListToReturn;
    }

    private LinkedList<Handler> restoreExecutedList(LinkedList<Handler> base, LinkedList<MetaDataEntry> metaDataEntries) {
        if (metaDataEntries == null) {
            return base;
        }
        ArrayList<MetaDataEntry> tmpMetaDataList = new ArrayList<MetaDataEntry>(metaDataEntries);
        ArrayList<Handler> existingList = this.restoreHandlerList(tmpMetaDataList);
        if (existingList == null || existingList.isEmpty()) {
            return base;
        }
        LinkedList<Handler> returnedList = new LinkedList<Handler>();
        if (base != null) {
            returnedList.addAll(base);
        }
        returnedList.addAll(existingList);
        return returnedList;
    }

    private void setupPhaseList(Phase phase, MetaDataEntry mdPhase) {
        List<Handler> handlers = phase.getHandlers();
        if (handlers.isEmpty()) {
            mdPhase.removeList();
            return;
        }
        int listSize = handlers.size();
        if (listSize > 0) {
            for (Handler obj : handlers) {
                String qnameAsString;
                String objClass = obj.getClass().getName();
                MetaDataEntry mdEntry = new MetaDataEntry();
                mdEntry.setClassName(objClass);
                if (obj instanceof Phase) {
                    Phase phaseObj = (Phase)obj;
                    qnameAsString = phaseObj.getName();
                    this.setupPhaseList(phaseObj, mdEntry);
                } else if (obj instanceof Handler) {
                    Handler handlerObj = obj;
                    qnameAsString = handlerObj.getName();
                } else {
                    qnameAsString = "NULL";
                }
                mdEntry.setQName(qnameAsString);
                mdPhase.addToList(mdEntry);
                if (!LoggingControl.debugLoggingAllowed || !log.isTraceEnabled()) continue;
                log.trace((Object)(this.getLogIDString() + ":setupPhaseList(): list entry class [" + objClass + "] qname [" + qnameAsString + "]"));
            }
        } else {
            mdPhase.removeList();
        }
    }

    public MessageContext extractCopyMessageContext() {
        MessageContext copy;
        block3: {
            copy = new MessageContext();
            String logCorrelationIDString = this.getLogIDString();
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(logCorrelationIDString + ":extractCopyMessageContext():  based on " + logCorrelationIDString + "   into copy " + copy.getLogIDString()));
            }
            copy.setFLOW(this.FLOW);
            copy.setProcessingFault(this.processingFault);
            copy.setPaused(this.paused);
            copy.setOutputWritten(this.outputWritten);
            copy.setNewThreadRequired(this.newThreadRequired);
            copy.setDoingREST(this.doingREST);
            copy.setDoingMTOM(this.doingMTOM);
            copy.setDoingSwA(this.doingSwA);
            copy.setResponseWritten(this.responseWritten);
            copy.setServerSide(this.serverSide);
            copy.setLastTouchedTime(this.getLastTouchedTime());
            try {
                copy.setEnvelope(this.envelope);
            }
            catch (Exception ex) {
                if (!LoggingControl.debugLoggingAllowed || !log.isTraceEnabled()) break block3;
                log.trace((Object)(logCorrelationIDString + ":extractCopyMessageContext():  Exception caught when setting the copy with the envelope"), (Throwable)ex);
            }
        }
        copy.setAttachmentMap(this.attachments);
        copy.setIsSOAP11Explicit(this.isSOAP11);
        copy.setExecutionChain(this.executionChain);
        copy.setCurrentHandlerIndex(this.currentHandlerIndex);
        copy.setCurrentPhaseIndex(this.currentPhaseIndex);
        copy.setExecutedPhasesExplicit(this.executedPhases);
        copy.setOptionsExplicit(this.options);
        copy.setAxisOperation(null);
        copy.setOperationContext(null);
        copy.setAxisService(null);
        copy.setServiceContextID(this.serviceContextID);
        copy.setServiceContext(null);
        copy.setServiceGroupContext(null);
        copy.setServiceGroupContextId(this.serviceGroupContextId);
        copy.setAxisMessage(this.axisMessage);
        copy.setConfigurationContext(this.configurationContext);
        copy.setSessionContext(this.sessionContext);
        copy.setIncomingTransportName(this.incomingTransportName);
        copy.setTransportIn(this.transportIn);
        copy.setTransportOut(this.transportOut);
        copy.setProperties(this.properties);
        copy.setSelfManagedDataMapExplicit(this.selfManagedDataMap);
        return copy;
    }

    public void setIsSOAP11Explicit(boolean t) {
        this.isSOAP11 = t;
    }

    public void setExecutedPhasesExplicit(LinkedList<Handler> inb) {
        this.executedPhases = inb;
    }

    public void setSelfManagedDataMapExplicit(LinkedHashMap<String, Object> map) {
        this.selfManagedDataMap = map;
    }

    public void setOptionsExplicit(Options op) {
        this.options = op;
    }

    private void checkActivateWarning(String methodname) {
        if (this.needsToBeReconciled && LoggingControl.debugLoggingAllowed && log.isWarnEnabled()) {
            log.warn((Object)(this.getLogIDString() + ":" + methodname + "(): ****WARNING**** " + myClassName + ".activate(configurationContext) needs to be invoked."));
        }
    }

    @Override
    public ConfigurationContext getRootContext() {
        return this.configurationContext;
    }

    public boolean isFault() {
        try {
            return this.getEnvelope().hasFault();
        }
        catch (Exception e) {
            return false;
        }
    }

    public Exception getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(Exception failureReason) {
        this.failureReason = failureReason;
    }
}

