/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.aries.blueprint.ComponentDefinitionRegistry;
import org.apache.aries.transaction.BundleWideTxData;
import org.apache.aries.transaction.BundleWideTxDataUtil;
import org.apache.aries.transaction.Constants;
import org.apache.aries.transaction.TxComponentMetaDataHelper;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxComponentMetaDataHelperImpl
implements TxComponentMetaDataHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TxComponentMetaDataHelperImpl.class);
    private static final Map<ComponentMetadata, TranData> data = new ConcurrentHashMap<ComponentMetadata, TranData>();
    private static final ConcurrentHashMap<ComponentDefinitionRegistry, List<BundleWideTxData>> bundleTransactionMap = new ConcurrentHashMap();
    private static final ConcurrentMap<ComponentDefinitionRegistry, Collection<ComponentMetadata>> dataForCDR = new ConcurrentHashMap<ComponentDefinitionRegistry, Collection<ComponentMetadata>>();

    public void unregister(ComponentDefinitionRegistry registry) {
        Collection components = (Collection)dataForCDR.remove(registry);
        bundleTransactionMap.remove(registry);
        if (components != null) {
            for (ComponentMetadata meta : components) {
                data.remove(meta);
            }
        }
    }

    public synchronized void setComponentTransactionData(ComponentDefinitionRegistry registry, ComponentMetadata component, String value, String method) {
        TranData td = data.get(component);
        if (td == null) {
            td = new TranData();
            data.put(component, td);
            dataForCDR.putIfAbsent(registry, new HashSet());
            ((Collection)dataForCDR.get(registry)).add(component);
        }
        if (method == null || method.length() == 0) {
            method = "*";
        }
        if (value == null || value.length() == 0) {
            value = "Required";
        }
        String[] names = method.split("[, \t]");
        for (int i = 0; i < names.length; ++i) {
            Pattern pattern = Pattern.compile(names[i].replaceAll("\\*", ".*"));
            td.add(pattern, value);
        }
    }

    public String getComponentMethodTxAttribute(ComponentMetadata component, String methodName) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Getting the txAttribute for the component {0} and method {1}", (Object)component.getId(), (Object)methodName);
        }
        TranData td = data.get(component);
        String result = null;
        if (td != null) {
            result = td.getAttribute(methodName);
        }
        if (result != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Return the txAttribute {0} for the component and method", (Object)result);
            }
            return result;
        }
        ComponentDefinitionRegistry cdr = this.getComponentDefinitionRegistry(component);
        if (cdr == null) {
            result = null;
        } else {
            List<BundleWideTxData> bundleData = bundleTransactionMap.get(cdr);
            result = BundleWideTxDataUtil.getAttribute(component.getId(), methodName, bundleData);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Return the txAttribute {0} for the component and method", (Object)result);
        }
        return result;
    }

    public void populateBundleWideTransactionData(ComponentDefinitionRegistry cdr, String value, String method, String bean) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Start populating bundle wide transaction data value {0} method {1} bean {2} per component definition registry", new Object[]{value, method, bean});
        }
        BundleWideTxData bundleWideTxData = new BundleWideTxData(value, method, bean);
        List<BundleWideTxData> bundleData = bundleTransactionMap.get(cdr);
        if (bundleData == null) {
            bundleData = new ArrayList<BundleWideTxData>();
            bundleData.add(bundleWideTxData);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Adding component definition registry and bundleData to the bundleTransactionMap", new Object[]{cdr, bundleData});
            }
            bundleTransactionMap.put(cdr, bundleData);
        } else {
            bundleData.add(bundleWideTxData);
        }
    }

    private ComponentDefinitionRegistry getComponentDefinitionRegistry(ComponentMetadata metadata) {
        Enumeration<ComponentDefinitionRegistry> keys = bundleTransactionMap.keys();
        while (keys.hasMoreElements()) {
            ComponentDefinitionRegistry cdr = keys.nextElement();
            if (!cdr.containsComponentDefinition(metadata.getId()) || !metadata.equals(cdr.getComponentDefinition(metadata.getId()))) continue;
            return cdr;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TranData {
        private final Map<Pattern, String> map = new ConcurrentHashMap<Pattern, String>();
        private final Map<String, String> cache = new ConcurrentHashMap<String, String>();

        public void add(Pattern pattern, String txAttribute) {
            this.map.put(pattern, txAttribute);
        }

        public String getAttribute(String name) {
            String txAttribute = this.cache.get(name);
            if (txAttribute == null) {
                List<Pattern> matches = this.findMatches(name);
                int size = matches.size();
                if (size == 0) {
                    txAttribute = null;
                } else if (size == 1) {
                    txAttribute = this.map.get(matches.get(0));
                } else {
                    size = (matches = this.selectPatternsWithFewestWildcards(matches)).size();
                    if (size == 1) {
                        txAttribute = this.map.get(matches.get(0));
                    } else {
                        size = (matches = this.selectLongestPatterns(matches)).size();
                        if (size == 1) {
                            txAttribute = this.map.get(matches.get(0));
                        } else {
                            throw new IllegalStateException(Constants.MESSAGES.getMessage("unable.to.apply.patterns", new Object[]{matches}));
                        }
                    }
                }
                if (txAttribute != null) {
                    this.cache.put(name, txAttribute);
                }
            }
            return txAttribute;
        }

        private List<Pattern> findMatches(String name) {
            ArrayList<Pattern> matches = new ArrayList<Pattern>();
            for (Pattern p : this.map.keySet()) {
                if (!p.matcher(name).matches()) continue;
                matches.add(p);
            }
            return matches;
        }

        private List<Pattern> selectPatternsWithFewestWildcards(List<Pattern> matches) {
            ArrayList<Pattern> remainingMatches = new ArrayList<Pattern>();
            int minWildcards = Integer.MAX_VALUE;
            for (Pattern p : matches) {
                String pattern = p.pattern();
                Matcher m = Constants.WILDCARD.matcher(pattern);
                int count = 0;
                while (m.find()) {
                    ++count;
                }
                if (count < minWildcards) {
                    remainingMatches.clear();
                    remainingMatches.add(p);
                    minWildcards = count;
                    continue;
                }
                if (count != minWildcards) continue;
                remainingMatches.add(p);
            }
            return remainingMatches;
        }

        private List<Pattern> selectLongestPatterns(List<Pattern> matches) {
            ArrayList<Pattern> remainingMatches = new ArrayList<Pattern>();
            int longestLength = 0;
            for (Pattern p : matches) {
                String pattern = p.pattern();
                int length = pattern.length();
                if (length > longestLength) {
                    remainingMatches.clear();
                    remainingMatches.add(p);
                    longestLength = length;
                    continue;
                }
                if (length != longestLength) continue;
                remainingMatches.add(p);
            }
            return remainingMatches;
        }
    }
}

