/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.hadoop;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.pentaho.di.core.namedcluster.model.NamedCluster;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.namedcluster.HadoopClusterDelegate;
import org.pentaho.di.ui.core.namedcluster.NamedClusterUIHelper;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.metastore.api.IMetaStore;

public class PopupMenuFactory {
    private static final int RESULT_YES = 0;
    private Spoon spoon = Spoon.getInstance();
    private static Class<?> PKG = PopupMenuFactory.class;
    private HadoopClusterDelegate ncDelegate = NamedClusterUIHelper.getNamedClusterUIFactory().createHadoopClusterDelegate(this.spoon);
    public static PopupMenuFactory popupMenuFactory = null;
    private Menu newMenu = null;
    private Menu maintMenu = null;
    private NamedCluster selectedNamedCluster = null;

    public Menu createNewPopupMenu(Tree selectionTree) {
        if (this.newMenu == null) {
            this.newMenu = new Menu((Control)selectionTree);
            this.createPopupMenu(this.newMenu, BaseMessages.getString(PKG, (String)"PopupMenuFactory.NAMEDCLUSTERS.New", (String[])new String[0]), new NewNamedClusterCommand());
        }
        return this.newMenu;
    }

    public Menu createMaintPopupMenu(Tree selectionTree, NamedCluster selectedNamedCluster) {
        this.selectedNamedCluster = selectedNamedCluster;
        if (this.maintMenu == null) {
            this.maintMenu = new Menu((Control)selectionTree);
            this.createPopupMenu(this.maintMenu, BaseMessages.getString(PKG, (String)"PopupMenuFactory.NAMEDCLUSTERS.New", (String[])new String[0]), new NewNamedClusterCommand());
            this.createPopupMenu(this.maintMenu, BaseMessages.getString(PKG, (String)"PopupMenuFactory.NAMEDCLUSTERS.Edit", (String[])new String[0]), new EditNamedClusterCommand());
            this.createPopupMenu(this.maintMenu, BaseMessages.getString(PKG, (String)"PopupMenuFactory.NAMEDCLUSTERS.Duplicate", (String[])new String[0]), new DuplicateNamedClusterCommand());
            this.createPopupMenu(this.maintMenu, BaseMessages.getString(PKG, (String)"PopupMenuFactory.NAMEDCLUSTERS.Delete", (String[])new String[0]), new DeleteNamedClusterCommand());
        }
        return this.maintMenu;
    }

    private void createPopupMenu(Menu parentMenu, String label, final NamedClusterCommand command) {
        MenuItem deleteMenuItem = new MenuItem(parentMenu, 0);
        deleteMenuItem.setText(label);
        deleteMenuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                command.execute();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
    }

    public static PopupMenuFactory newInstance() {
        if (popupMenuFactory == null) {
            popupMenuFactory = new PopupMenuFactory();
        }
        return popupMenuFactory;
    }

    class DeleteNamedClusterCommand
    implements NamedClusterCommand {
        DeleteNamedClusterCommand() {
        }

        @Override
        public void execute() {
            String title = BaseMessages.getString((Class)PKG, (String)"PopupMenuFactory.NAMEDCLUSTERS.DeleteNamedClusterAsk.Title", (String[])new String[0]);
            String message = BaseMessages.getString((Class)PKG, (String)"PopupMenuFactory.NAMEDCLUSTERS.DeleteNamedClusterAsk.Message", (String[])new String[]{PopupMenuFactory.this.selectedNamedCluster.getName()});
            String deleteButton = BaseMessages.getString((Class)PKG, (String)"PopupMenuFactory.NAMEDCLUSTERS.DeleteNamedClusterAsk.Delete", (String[])new String[0]);
            String doNotDeleteButton = BaseMessages.getString((Class)PKG, (String)"PopupMenuFactory.NAMEDCLUSTERS.DeleteNamedClusterAsk.DoNotDelete", (String[])new String[0]);
            MessageDialog dialog = new MessageDialog(PopupMenuFactory.this.spoon.getShell(), title, null, message, 4, new String[]{deleteButton, doNotDeleteButton}, 0);
            int response = dialog.open();
            if (response != 0) {
                return;
            }
            PopupMenuFactory.this.ncDelegate.delNamedCluster((IMetaStore)((PopupMenuFactory)PopupMenuFactory.this).spoon.metaStore, PopupMenuFactory.this.selectedNamedCluster);
        }
    }

    class DuplicateNamedClusterCommand
    implements NamedClusterCommand {
        DuplicateNamedClusterCommand() {
        }

        @Override
        public void execute() {
            PopupMenuFactory.this.ncDelegate.dupeNamedCluster((IMetaStore)((PopupMenuFactory)PopupMenuFactory.this).spoon.metaStore, PopupMenuFactory.this.selectedNamedCluster, PopupMenuFactory.this.spoon.getShell());
        }
    }

    class EditNamedClusterCommand
    implements NamedClusterCommand {
        EditNamedClusterCommand() {
        }

        @Override
        public void execute() {
            PopupMenuFactory.this.ncDelegate.editNamedCluster((IMetaStore)((PopupMenuFactory)PopupMenuFactory.this).spoon.metaStore, PopupMenuFactory.this.selectedNamedCluster, PopupMenuFactory.this.spoon.getShell());
        }
    }

    class NewNamedClusterCommand
    implements NamedClusterCommand {
        NewNamedClusterCommand() {
        }

        @Override
        public void execute() {
            Object vs = null;
            vs = PopupMenuFactory.this.spoon.getActiveMeta() instanceof TransMeta ? PopupMenuFactory.this.spoon.getActiveTransformation() : PopupMenuFactory.this.spoon.getActiveJob();
            PopupMenuFactory.this.ncDelegate.newNamedCluster((VariableSpace)vs, (IMetaStore)((PopupMenuFactory)PopupMenuFactory.this).spoon.metaStore, PopupMenuFactory.this.spoon.getShell());
        }
    }

    static interface NamedClusterCommand {
        public void execute();
    }
}

