/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.runtime.test.module.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.pentaho.runtime.test.RuntimeTest;
import org.pentaho.runtime.test.module.RuntimeTestModuleResults;
import org.pentaho.runtime.test.result.RuntimeTestEntrySeverity;
import org.pentaho.runtime.test.result.RuntimeTestResult;

public class RuntimeTestModuleResultsImpl
implements RuntimeTestModuleResults {
    private final String name;
    private final List<RuntimeTestResult> runtimeTestResults;
    private final Set<RuntimeTest> runningTests;
    private final Set<RuntimeTest> outstandingTests;
    private final RuntimeTestEntrySeverity maxSeverity;

    public RuntimeTestModuleResultsImpl(String name, List<RuntimeTestResult> runtimeTestResults, Set<RuntimeTest> runningTests, Set<RuntimeTest> outstandingTests) {
        this.name = name;
        this.runningTests = Collections.unmodifiableSet(new HashSet<RuntimeTest>(runningTests));
        this.outstandingTests = Collections.unmodifiableSet(new HashSet<RuntimeTest>(outstandingTests));
        this.runtimeTestResults = Collections.unmodifiableList(new ArrayList<RuntimeTestResult>(runtimeTestResults));
        this.maxSeverity = RuntimeTestEntrySeverity.maxSeverityResult(runtimeTestResults);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<RuntimeTestResult> getRuntimeTestResults() {
        return this.runtimeTestResults;
    }

    @Override
    public RuntimeTestEntrySeverity getMaxSeverity() {
        return this.maxSeverity;
    }

    @Override
    public Set<RuntimeTest> getRunningTests() {
        return this.runningTests;
    }

    @Override
    public Set<RuntimeTest> getOutstandingTests() {
        return this.outstandingTests;
    }

    public String toString() {
        return "RuntimeTestModuleResultsImpl{getName='" + this.name + '\'' + ", runtimeTestResults=" + this.runtimeTestResults + ", runningTests=" + this.runningTests + ", outstandingTests=" + this.outstandingTests + ", maxSeverity=" + (Object)((Object)this.maxSeverity) + '}';
    }
}

