/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.runtime.test.network.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.runtime.test.i18n.MessageGetter;
import org.pentaho.runtime.test.i18n.MessageGetterFactory;
import org.pentaho.runtime.test.network.ConnectivityTest;
import org.pentaho.runtime.test.result.RuntimeTestEntrySeverity;
import org.pentaho.runtime.test.result.RuntimeTestResultEntry;
import org.pentaho.runtime.test.test.impl.RuntimeTestResultEntryImpl;

public class ConnectivityTestImpl
implements ConnectivityTest {
    public static final String CONNECT_TEST_HOST_BLANK_DESC = "ConnectTest.HostBlank.Desc";
    public static final String CONNECT_TEST_HOST_BLANK_MESSAGE = "ConnectTest.HostBlank.Message";
    public static final String CONNECT_TEST_HA_DESC = "ConnectTest.HA.Desc";
    public static final String CONNECT_TEST_HA_MESSAGE = "ConnectTest.HA.Message";
    public static final String CONNECT_TEST_PORT_BLANK_DESC = "ConnectTest.PortBlank.Desc";
    public static final String CONNECT_TEST_PORT_BLANK_MESSAGE = "ConnectTest.PortBlank.Message";
    public static final String CONNECT_TEST_CONNECT_SUCCESS_DESC = "ConnectTest.ConnectSuccess.Desc";
    public static final String CONNECT_TEST_CONNECT_SUCCESS_MESSAGE = "ConnectTest.ConnectSuccess.Message";
    public static final String CONNECT_TEST_CONNECT_FAIL_DESC = "ConnectTest.ConnectFail.Desc";
    public static final String CONNECT_TEST_CONNECT_FAIL_MESSAGE = "ConnectTest.ConnectFail.Message";
    public static final String CONNECT_TEST_UNKNOWN_HOSTNAME_DESC = "ConnectTest.UnknownHostname.Desc";
    public static final String CONNECT_TEST_UNKNOWN_HOSTNAME_MESSAGE = "ConnectTest.UnknownHostname.Message";
    public static final String CONNECT_TEST_NETWORK_ERROR_DESC = "ConnectTest.NetworkError.Desc";
    public static final String CONNECT_TEST_NETWORK_ERROR_MESSAGE = "ConnectTest.NetworkError.Message";
    public static final String CONNECT_TEST_PORT_NUMBER_FORMAT_DESC = "ConnectTest.PortNumberFormat.Desc";
    public static final String CONNECT_TEST_PORT_NUMBER_FORMAT_MESSAGE = "ConnectTest.PortNumberFormat.Message";
    public static final String CONNECT_TEST_UNREACHABLE_DESC = "ConnectTest.Unreachable.Desc";
    public static final String CONNECT_TEST_UNREACHABLE_MESSAGE = "ConnectTest.Unreachable.Message";
    private static final Class<?> PKG = ConnectivityTestImpl.class;
    private final MessageGetter messageGetter;
    private final String hostname;
    private final String port;
    private final boolean haPossible;
    private final RuntimeTestEntrySeverity severityOfFalures;
    private final SocketFactory socketFactory;
    private final InetAddressFactory inetAddressFactory;

    public ConnectivityTestImpl(MessageGetterFactory messageGetterFactory, String hostname, String port, boolean haPossible) {
        this(messageGetterFactory, hostname, port, haPossible, RuntimeTestEntrySeverity.FATAL);
    }

    public ConnectivityTestImpl(MessageGetterFactory messageGetterFactory, String hostname, String port, boolean haPossible, RuntimeTestEntrySeverity severityOfFailures) {
        this(messageGetterFactory, hostname, port, haPossible, severityOfFailures, new SocketFactory(), new InetAddressFactory());
    }

    public ConnectivityTestImpl(MessageGetterFactory messageGetterFactory, String hostname, String port, boolean haPossible, RuntimeTestEntrySeverity severityOfFailures, SocketFactory socketFactory, InetAddressFactory inetAddressFactory) {
        this.messageGetter = messageGetterFactory.create(PKG);
        Variables variables = new Variables();
        variables.initializeVariablesFrom(null);
        this.hostname = variables.environmentSubstitute(hostname);
        this.port = variables.environmentSubstitute(port);
        this.haPossible = haPossible;
        this.severityOfFalures = severityOfFailures;
        this.socketFactory = socketFactory;
        this.inetAddressFactory = inetAddressFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RuntimeTestResultEntry runTest() {
        ArrayList runtimeTestResultEntries = new ArrayList();
        if (Const.isEmpty((String)this.hostname)) {
            return new RuntimeTestResultEntryImpl(this.severityOfFalures, this.messageGetter.getMessage(CONNECT_TEST_HOST_BLANK_DESC, new String[0]), this.messageGetter.getMessage(CONNECT_TEST_HOST_BLANK_MESSAGE, new String[0]));
        }
        if (Const.isEmpty((String)this.port)) {
            if (!this.haPossible) return new RuntimeTestResultEntryImpl(this.severityOfFalures, this.messageGetter.getMessage(CONNECT_TEST_PORT_BLANK_DESC, new String[0]), this.messageGetter.getMessage(CONNECT_TEST_PORT_BLANK_MESSAGE, new String[0]));
            return new RuntimeTestResultEntryImpl(RuntimeTestEntrySeverity.INFO, this.messageGetter.getMessage(CONNECT_TEST_HA_DESC, new String[0]), this.messageGetter.getMessage(CONNECT_TEST_HA_MESSAGE, this.hostname));
        }
        Socket socket = null;
        try {
            if (!this.inetAddressFactory.create(this.hostname).isReachable(10000)) {
                return new RuntimeTestResultEntryImpl(this.severityOfFalures, this.messageGetter.getMessage(CONNECT_TEST_UNREACHABLE_DESC, this.hostname), this.messageGetter.getMessage(CONNECT_TEST_UNREACHABLE_MESSAGE, this.hostname));
            }
            try {
                socket = this.socketFactory.create(this.hostname, Integer.valueOf(this.port));
                RuntimeTestResultEntryImpl runtimeTestResultEntryImpl = new RuntimeTestResultEntryImpl(RuntimeTestEntrySeverity.INFO, this.messageGetter.getMessage(CONNECT_TEST_CONNECT_SUCCESS_DESC, new String[0]), this.messageGetter.getMessage(CONNECT_TEST_CONNECT_SUCCESS_MESSAGE, this.hostname, this.port));
                return runtimeTestResultEntryImpl;
            }
            catch (IOException e) {
                RuntimeTestResultEntryImpl runtimeTestResultEntryImpl2 = new RuntimeTestResultEntryImpl(this.severityOfFalures, this.messageGetter.getMessage(CONNECT_TEST_CONNECT_FAIL_DESC, new String[0]), this.messageGetter.getMessage(CONNECT_TEST_CONNECT_FAIL_MESSAGE, this.hostname, this.port), e);
                return runtimeTestResultEntryImpl2;
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (UnknownHostException e2) {
            return new RuntimeTestResultEntryImpl(this.severityOfFalures, this.messageGetter.getMessage(CONNECT_TEST_UNKNOWN_HOSTNAME_DESC, new String[0]), this.messageGetter.getMessage(CONNECT_TEST_UNKNOWN_HOSTNAME_MESSAGE, this.hostname), e2);
        }
        catch (IOException e3) {
            return new RuntimeTestResultEntryImpl(this.severityOfFalures, this.messageGetter.getMessage(CONNECT_TEST_NETWORK_ERROR_DESC, new String[0]), this.messageGetter.getMessage(CONNECT_TEST_NETWORK_ERROR_MESSAGE, this.hostname, this.port), e3);
        }
        catch (NumberFormatException e4) {
            return new RuntimeTestResultEntryImpl(RuntimeTestEntrySeverity.FATAL, this.messageGetter.getMessage(CONNECT_TEST_PORT_NUMBER_FORMAT_DESC, new String[0]), this.messageGetter.getMessage(CONNECT_TEST_PORT_NUMBER_FORMAT_MESSAGE, this.port), e4);
        }
    }

    public static class InetAddressFactory {
        public InetAddress create(String hostname) throws UnknownHostException {
            return InetAddress.getByName(hostname);
        }
    }

    public static class SocketFactory {
        public Socket create(String hostname, int port) throws IOException {
            return new Socket(hostname, port);
        }
    }
}

