/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.service.CompositeService;
import org.apache.hive.service.ServiceException;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.FetchType;
import org.apache.hive.service.cli.GetInfoType;
import org.apache.hive.service.cli.GetInfoValue;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.ICLIService;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.OperationStatus;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.Operation;
import org.apache.hive.service.cli.session.SessionManager;
import org.apache.hive.service.cli.thrift.TProtocolVersion;
import org.apache.hive.service.server.HiveServer2;

public class CLIService
extends CompositeService
implements ICLIService {
    public static final TProtocolVersion SERVER_VERSION;
    private final Log LOG = LogFactory.getLog((String)CLIService.class.getName());
    private HiveConf hiveConf;
    private SessionManager sessionManager;
    private UserGroupInformation serviceUGI;
    private UserGroupInformation httpUGI;
    private final HiveServer2 hiveServer2;

    public CLIService(HiveServer2 hiveServer2) {
        super(CLIService.class.getSimpleName());
        this.hiveServer2 = hiveServer2;
    }

    @Override
    public synchronized void init(HiveConf hiveConf) {
        this.hiveConf = hiveConf;
        this.sessionManager = new SessionManager(this.hiveServer2);
        this.addService(this.sessionManager);
        if (UserGroupInformation.isSecurityEnabled()) {
            try {
                HiveAuthFactory.loginFromKeytab(hiveConf);
                this.serviceUGI = Utils.getUGI();
            }
            catch (IOException e) {
                throw new ServiceException("Unable to login to kerberos with given principal/keytab", e);
            }
            catch (LoginException e) {
                throw new ServiceException("Unable to login to kerberos with given principal/keytab", e);
            }
            String principal = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SPNEGO_PRINCIPAL);
            String keyTabFile = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SPNEGO_KEYTAB);
            if (principal.isEmpty() || keyTabFile.isEmpty()) {
                this.LOG.info((Object)("SPNego httpUGI not created, spNegoPrincipal: " + principal + ", ketabFile: " + keyTabFile));
            } else {
                try {
                    this.httpUGI = HiveAuthFactory.loginFromSpnegoKeytabAndReturnUGI(hiveConf);
                    this.LOG.info((Object)"SPNego httpUGI successfully created.");
                }
                catch (IOException e) {
                    this.LOG.warn((Object)"SPNego httpUGI creation failed: ", (Throwable)e);
                }
            }
        }
        try {
            this.applyAuthorizationConfigPolicy(hiveConf);
        }
        catch (Exception e) {
            throw new RuntimeException("Error applying authorization policy on hive configuration: " + e.getMessage(), e);
        }
        this.setupBlockedUdfs();
        super.init(hiveConf);
    }

    private void applyAuthorizationConfigPolicy(HiveConf newHiveConf) throws HiveException, MetaException {
        SessionState ss = new SessionState(newHiveConf);
        ss.setIsHiveServerQuery(true);
        SessionState.start((SessionState)ss);
        ss.applyAuthorizationPolicy();
    }

    private void setupBlockedUdfs() {
        FunctionRegistry.setupPermissionsForBuiltinUDFs((String)this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_BUILTIN_UDF_WHITELIST), (String)this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_BUILTIN_UDF_BLACKLIST));
    }

    public UserGroupInformation getServiceUGI() {
        return this.serviceUGI;
    }

    public UserGroupInformation getHttpUGI() {
        return this.httpUGI;
    }

    @Override
    public synchronized void start() {
        super.start();
        try (HiveMetaStoreClient metastoreClient = null;){
            metastoreClient = new HiveMetaStoreClient(this.hiveConf);
            metastoreClient.getDatabases("default");
        }
    }

    @Override
    public synchronized void stop() {
        super.stop();
        Hive.closeCurrent();
    }

    @Deprecated
    public SessionHandle openSession(TProtocolVersion protocol, String username, String password, Map<String, String> configuration) throws HiveSQLException {
        SessionHandle sessionHandle = this.sessionManager.openSession(protocol, username, password, null, configuration, false, null);
        this.LOG.debug((Object)(sessionHandle + ": openSession()"));
        return sessionHandle;
    }

    @Deprecated
    public SessionHandle openSessionWithImpersonation(TProtocolVersion protocol, String username, String password, Map<String, String> configuration, String delegationToken) throws HiveSQLException {
        SessionHandle sessionHandle = this.sessionManager.openSession(protocol, username, password, null, configuration, true, delegationToken);
        this.LOG.debug((Object)(sessionHandle + ": openSessionWithImpersonation()"));
        return sessionHandle;
    }

    public SessionHandle openSession(TProtocolVersion protocol, String username, String password, String ipAddress, Map<String, String> configuration) throws HiveSQLException {
        SessionHandle sessionHandle = this.sessionManager.openSession(protocol, username, password, ipAddress, configuration, false, null);
        this.LOG.debug((Object)(sessionHandle + ": openSession()"));
        return sessionHandle;
    }

    public SessionHandle openSessionWithImpersonation(TProtocolVersion protocol, String username, String password, String ipAddress, Map<String, String> configuration, String delegationToken) throws HiveSQLException {
        SessionHandle sessionHandle = this.sessionManager.openSession(protocol, username, password, ipAddress, configuration, true, delegationToken);
        this.LOG.debug((Object)(sessionHandle + ": openSession()"));
        return sessionHandle;
    }

    @Override
    public SessionHandle openSession(String username, String password, Map<String, String> configuration) throws HiveSQLException {
        SessionHandle sessionHandle = this.sessionManager.openSession(SERVER_VERSION, username, password, null, configuration, false, null);
        this.LOG.debug((Object)(sessionHandle + ": openSession()"));
        return sessionHandle;
    }

    @Override
    public SessionHandle openSessionWithImpersonation(String username, String password, Map<String, String> configuration, String delegationToken) throws HiveSQLException {
        SessionHandle sessionHandle = this.sessionManager.openSession(SERVER_VERSION, username, password, null, configuration, true, delegationToken);
        this.LOG.debug((Object)(sessionHandle + ": openSession()"));
        return sessionHandle;
    }

    @Override
    public void closeSession(SessionHandle sessionHandle) throws HiveSQLException {
        this.sessionManager.closeSession(sessionHandle);
        this.LOG.debug((Object)(sessionHandle + ": closeSession()"));
    }

    @Override
    public GetInfoValue getInfo(SessionHandle sessionHandle, GetInfoType getInfoType) throws HiveSQLException {
        GetInfoValue infoValue = this.sessionManager.getSession(sessionHandle).getInfo(getInfoType);
        this.LOG.debug((Object)(sessionHandle + ": getInfo()"));
        return infoValue;
    }

    @Override
    public OperationHandle executeStatement(SessionHandle sessionHandle, String statement, Map<String, String> confOverlay) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).executeStatement(statement, confOverlay);
        this.LOG.debug((Object)(sessionHandle + ": executeStatement()"));
        return opHandle;
    }

    @Override
    public OperationHandle executeStatement(SessionHandle sessionHandle, String statement, Map<String, String> confOverlay, long queryTimeout) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).executeStatement(statement, confOverlay, queryTimeout);
        this.LOG.debug((Object)(sessionHandle + ": executeStatement()"));
        return opHandle;
    }

    @Override
    public OperationHandle executeStatementAsync(SessionHandle sessionHandle, String statement, Map<String, String> confOverlay) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).executeStatementAsync(statement, confOverlay);
        this.LOG.debug((Object)(sessionHandle + ": executeStatementAsync()"));
        return opHandle;
    }

    @Override
    public OperationHandle executeStatementAsync(SessionHandle sessionHandle, String statement, Map<String, String> confOverlay, long queryTimeout) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).executeStatementAsync(statement, confOverlay, queryTimeout);
        this.LOG.debug((Object)(sessionHandle + ": executeStatementAsync()"));
        return opHandle;
    }

    @Override
    public OperationHandle getTypeInfo(SessionHandle sessionHandle) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getTypeInfo();
        this.LOG.debug((Object)(sessionHandle + ": getTypeInfo()"));
        return opHandle;
    }

    @Override
    public OperationHandle getCatalogs(SessionHandle sessionHandle) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getCatalogs();
        this.LOG.debug((Object)(sessionHandle + ": getCatalogs()"));
        return opHandle;
    }

    @Override
    public OperationHandle getSchemas(SessionHandle sessionHandle, String catalogName, String schemaName) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getSchemas(catalogName, schemaName);
        this.LOG.debug((Object)(sessionHandle + ": getSchemas()"));
        return opHandle;
    }

    @Override
    public OperationHandle getTables(SessionHandle sessionHandle, String catalogName, String schemaName, String tableName, List<String> tableTypes) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getTables(catalogName, schemaName, tableName, tableTypes);
        this.LOG.debug((Object)(sessionHandle + ": getTables()"));
        return opHandle;
    }

    @Override
    public OperationHandle getTableTypes(SessionHandle sessionHandle) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getTableTypes();
        this.LOG.debug((Object)(sessionHandle + ": getTableTypes()"));
        return opHandle;
    }

    @Override
    public OperationHandle getColumns(SessionHandle sessionHandle, String catalogName, String schemaName, String tableName, String columnName) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getColumns(catalogName, schemaName, tableName, columnName);
        this.LOG.debug((Object)(sessionHandle + ": getColumns()"));
        return opHandle;
    }

    @Override
    public OperationHandle getFunctions(SessionHandle sessionHandle, String catalogName, String schemaName, String functionName) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getFunctions(catalogName, schemaName, functionName);
        this.LOG.debug((Object)(sessionHandle + ": getFunctions()"));
        return opHandle;
    }

    @Override
    public OperationStatus getOperationStatus(OperationHandle opHandle) throws HiveSQLException {
        Operation operation = this.sessionManager.getOperationManager().getOperation(opHandle);
        if (operation.shouldRunAsync()) {
            HiveConf conf = operation.getParentSession().getHiveConf();
            long timeout = HiveConf.getTimeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_LONG_POLLING_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS);
            try {
                operation.getBackgroundHandle().get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                this.LOG.trace((Object)(opHandle + ": Long polling timed out"));
            }
            catch (CancellationException e) {
                this.LOG.trace((Object)(opHandle + ": The background operation was cancelled"), (Throwable)e);
            }
            catch (ExecutionException e) {
                this.LOG.warn((Object)(opHandle + ": The background operation was aborted"), (Throwable)e);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        OperationStatus opStatus = operation.getStatus();
        this.LOG.debug((Object)(opHandle + ": getOperationStatus()"));
        return opStatus;
    }

    @Override
    public void cancelOperation(OperationHandle opHandle) throws HiveSQLException {
        this.sessionManager.getOperationManager().getOperation(opHandle).getParentSession().cancelOperation(opHandle);
        this.LOG.debug((Object)(opHandle + ": cancelOperation()"));
    }

    @Override
    public void closeOperation(OperationHandle opHandle) throws HiveSQLException {
        this.sessionManager.getOperationManager().getOperation(opHandle).getParentSession().closeOperation(opHandle);
        this.LOG.debug((Object)(opHandle + ": closeOperation"));
    }

    @Override
    public TableSchema getResultSetMetadata(OperationHandle opHandle) throws HiveSQLException {
        TableSchema tableSchema = this.sessionManager.getOperationManager().getOperation(opHandle).getParentSession().getResultSetMetadata(opHandle);
        this.LOG.debug((Object)(opHandle + ": getResultSetMetadata()"));
        return tableSchema;
    }

    @Override
    public RowSet fetchResults(OperationHandle opHandle) throws HiveSQLException {
        return this.fetchResults(opHandle, Operation.DEFAULT_FETCH_ORIENTATION, 100L, FetchType.QUERY_OUTPUT);
    }

    @Override
    public RowSet fetchResults(OperationHandle opHandle, FetchOrientation orientation, long maxRows, FetchType fetchType) throws HiveSQLException {
        RowSet rowSet = this.sessionManager.getOperationManager().getOperation(opHandle).getParentSession().fetchResults(opHandle, orientation, maxRows, fetchType);
        this.LOG.debug((Object)(opHandle + ": fetchResults()"));
        return rowSet;
    }

    public synchronized String getDelegationTokenFromMetaStore(String owner) throws HiveSQLException, UnsupportedOperationException, LoginException, IOException {
        if (!this.hiveConf.getBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL) || !this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS)) {
            throw new UnsupportedOperationException("delegation token is can only be obtained for a secure remote metastore");
        }
        try {
            Hive.closeCurrent();
            return Hive.get((HiveConf)this.hiveConf).getDelegationToken(owner, owner);
        }
        catch (HiveException e) {
            if (e.getCause() instanceof UnsupportedOperationException) {
                throw (UnsupportedOperationException)e.getCause();
            }
            throw new HiveSQLException("Error connect metastore to setup impersonation", e);
        }
    }

    @Override
    public String getDelegationToken(SessionHandle sessionHandle, HiveAuthFactory authFactory, String owner, String renewer) throws HiveSQLException {
        String delegationToken = this.sessionManager.getSession(sessionHandle).getDelegationToken(authFactory, owner, renewer);
        this.LOG.info((Object)(sessionHandle + ": getDelegationToken()" + " owner: " + owner + ", renewer: " + renewer));
        return delegationToken;
    }

    @Override
    public void cancelDelegationToken(SessionHandle sessionHandle, HiveAuthFactory authFactory, String tokenStr) throws HiveSQLException {
        this.sessionManager.getSession(sessionHandle).cancelDelegationToken(authFactory, tokenStr);
        this.LOG.info((Object)(sessionHandle + ": cancelDelegationToken()"));
    }

    @Override
    public void renewDelegationToken(SessionHandle sessionHandle, HiveAuthFactory authFactory, String tokenStr) throws HiveSQLException {
        this.sessionManager.getSession(sessionHandle).renewDelegationToken(authFactory, tokenStr);
        this.LOG.info((Object)(sessionHandle + ": renewDelegationToken()"));
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    static {
        TProtocolVersion[] protocols = TProtocolVersion.values();
        SERVER_VERSION = protocols[protocols.length - 1];
    }
}

