/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.CommandNeedRetryException;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.exec.ExplainTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.VariableSubstitution;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.OperationLog;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.RowSetFactory;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.ExecuteStatementOperation;
import org.apache.hive.service.cli.operation.Operation;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.server.ThreadWithGarbageCleanup;

public class SQLOperation
extends ExecuteStatementOperation {
    private Driver driver = null;
    private CommandProcessorResponse response;
    private TableSchema resultSchema = null;
    private Schema mResultSchema = null;
    private SerDe serde = null;
    private boolean fetchStarted = false;
    private long queryTimeout;
    private ScheduledExecutorService timeoutExecutor;
    private final boolean runAsync;
    private final transient List<Object> convey = new ArrayList<Object>();

    public SQLOperation(HiveSession parentSession, String statement, Map<String, String> confOverlay, boolean runInBackground, long queryTimeout) {
        super(parentSession, statement, confOverlay, runInBackground);
        this.runAsync = runInBackground;
        this.queryTimeout = queryTimeout;
    }

    @Override
    public boolean shouldRunAsync() {
        return this.runAsync;
    }

    public void prepare(HiveConf sqlOperationConf) throws HiveSQLException {
        this.setState(OperationState.RUNNING);
        try {
            this.driver = new Driver(sqlOperationConf, this.getParentSession().getUserName());
            if (this.queryTimeout > 0L) {
                this.timeoutExecutor = new ScheduledThreadPoolExecutor(1);
                Runnable timeoutTask = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Operation.LOG.info((Object)("Query timed out after: " + SQLOperation.this.queryTimeout + " seconds. Cancelling the execution now."));
                            SQLOperation.this.cancel(OperationState.TIMEDOUT);
                        }
                        catch (HiveSQLException e) {
                            Operation.LOG.error((Object)("Error cancelling the query after timeout: " + SQLOperation.this.queryTimeout + " seconds"), (Throwable)e);
                        }
                        finally {
                            SQLOperation.this.timeoutExecutor.shutdown();
                        }
                    }
                };
                this.timeoutExecutor.schedule(timeoutTask, this.queryTimeout, TimeUnit.SECONDS);
            }
            String guid64 = Base64.encodeBase64URLSafeString((byte[])this.getHandle().getHandleIdentifier().toTHandleIdentifier().getGuid()).trim();
            this.driver.setOperationId(guid64);
            this.driver.setTryCount(Integer.MAX_VALUE);
            String subStatement = new VariableSubstitution().substitute(sqlOperationConf, this.statement);
            this.response = this.driver.compileAndRespond(subStatement);
            if (0 != this.response.getResponseCode()) {
                throw this.toSQLException("Error while compiling statement", this.response);
            }
            this.mResultSchema = this.driver.getSchema();
            if (this.driver.getPlan().getFetchTask() != null) {
                if (this.mResultSchema == null || !this.mResultSchema.isSetFieldSchemas()) {
                    throw new HiveSQLException("Error compiling query: Schema and FieldSchema should be set when query plan has a FetchTask");
                }
                this.resultSchema = new TableSchema(this.mResultSchema);
                this.setHasResultSet(true);
            } else {
                this.setHasResultSet(false);
            }
            for (Task task : this.driver.getPlan().getRootTasks()) {
                if (task.getClass() != ExplainTask.class) continue;
                this.resultSchema = new TableSchema(this.mResultSchema);
                this.setHasResultSet(true);
                break;
            }
        }
        catch (HiveSQLException e) {
            this.setState(OperationState.ERROR);
            throw e;
        }
        catch (Exception e) {
            this.setState(OperationState.ERROR);
            throw new HiveSQLException("Error running query: " + e.toString(), e);
        }
    }

    private void runQuery(HiveConf sqlOperationConf) throws HiveSQLException {
        try {
            OperationState opState = this.getStatus().getState();
            if (opState.isTerminal()) {
                LOG.info((Object)("Not running the query. Operation is already in terminal state: " + (Object)((Object)opState) + ", perhaps cancelled due to query timeout or by another thread."));
                return;
            }
            this.driver.setTryCount(Integer.MAX_VALUE);
            this.response = this.driver.run();
            if (0 != this.response.getResponseCode()) {
                throw this.toSQLException("Error while processing statement", this.response);
            }
        }
        catch (HiveSQLException e) {
            if (this.getStatus().getState() == OperationState.CANCELED || this.getStatus().getState() == OperationState.TIMEDOUT || this.getStatus().getState() == OperationState.CLOSED) {
                return;
            }
            this.setState(OperationState.ERROR);
            throw e;
        }
        catch (Exception e) {
            this.setState(OperationState.ERROR);
            throw new HiveSQLException("Error running query: " + e.toString(), e);
        }
        this.setState(OperationState.FINISHED);
    }

    @Override
    public void runInternal() throws HiveSQLException {
        this.setState(OperationState.PENDING);
        final HiveConf opConfig = this.getConfigForOperation();
        this.prepare(opConfig);
        if (!this.shouldRunAsync()) {
            this.runQuery(opConfig);
        } else {
            final SessionState parentSessionState = SessionState.get();
            final Hive parentHive = this.getSessionHive();
            final PerfLogger parentPerfLogger = SessionState.getPerfLogger();
            final UserGroupInformation currentUGI = this.getCurrentUGI(opConfig);
            Runnable backgroundOperation = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    PrivilegedExceptionAction<Object> doAsAction = new PrivilegedExceptionAction<Object>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Object run() throws HiveSQLException {
                            Hive.set((Hive)parentHive);
                            SessionState.setCurrentSessionState((SessionState)parentSessionState);
                            PerfLogger.setPerfLogger((PerfLogger)parentPerfLogger);
                            SQLOperation.this.registerCurrentOperationLog();
                            try {
                                SQLOperation.this.runQuery(opConfig);
                            }
                            catch (HiveSQLException e) {
                                SQLOperation.this.setOperationException(e);
                                Operation.LOG.error((Object)"Error running hive query: ", (Throwable)e);
                            }
                            finally {
                                SQLOperation.this.unregisterOperationLog();
                            }
                            return null;
                        }
                    };
                    try {
                        currentUGI.doAs((PrivilegedExceptionAction)doAsAction);
                    }
                    catch (Exception e) {
                        SQLOperation.this.setOperationException(new HiveSQLException(e));
                        Operation.LOG.error((Object)("Error running hive query as user : " + currentUGI.getShortUserName()), (Throwable)e);
                    }
                    finally {
                        if (ThreadWithGarbageCleanup.currentThread() instanceof ThreadWithGarbageCleanup) {
                            ThreadWithGarbageCleanup currentThread = (ThreadWithGarbageCleanup)ThreadWithGarbageCleanup.currentThread();
                            currentThread.cacheThreadLocalRawStore();
                        }
                    }
                }
            };
            try {
                Future<?> backgroundHandle = this.getParentSession().submitBackgroundOperation(backgroundOperation);
                this.setBackgroundHandle(backgroundHandle);
            }
            catch (RejectedExecutionException rejected) {
                this.setState(OperationState.ERROR);
                throw new HiveSQLException("The background threadpool cannot accept new task for execution, please retry the operation", rejected);
            }
        }
    }

    private UserGroupInformation getCurrentUGI(HiveConf opConfig) throws HiveSQLException {
        try {
            return Utils.getUGI();
        }
        catch (Exception e) {
            throw new HiveSQLException("Unable to get current user", e);
        }
    }

    private Hive getSessionHive() throws HiveSQLException {
        try {
            return Hive.get();
        }
        catch (HiveException e) {
            throw new HiveSQLException("Failed to get ThreadLocal Hive object", e);
        }
    }

    private void registerCurrentOperationLog() {
        if (this.isOperationLogEnabled) {
            if (this.operationLog == null) {
                LOG.warn((Object)("Failed to get current OperationLog object of Operation: " + this.getHandle().getHandleIdentifier()));
                this.isOperationLogEnabled = false;
                return;
            }
            OperationLog.setCurrentOperationLog((OperationLog)this.operationLog);
        }
    }

    private synchronized void cleanup(OperationState state) throws HiveSQLException {
        Future<?> backgroundHandle;
        this.setState(state);
        if (this.driver != null) {
            this.driver.close();
            this.driver.destroy();
        }
        this.driver = null;
        SessionState ss = SessionState.get();
        if (ss == null) {
            LOG.warn((Object)"Operation seems to be in invalid state, SessionState is null");
        } else if (ss.getTmpOutputFile() != null) {
            ss.getTmpOutputFile().delete();
        }
        if (this.shouldRunAsync() && (backgroundHandle = this.getBackgroundHandle()) != null) {
            backgroundHandle.cancel(true);
        }
        if (this.timeoutExecutor != null && state != OperationState.TIMEDOUT && state.isTerminal()) {
            this.timeoutExecutor.shutdownNow();
        }
    }

    @Override
    public void cancel(OperationState stateAfterCancel) throws HiveSQLException {
        this.cleanup(stateAfterCancel);
        this.cleanupOperationLog();
    }

    @Override
    public void close() throws HiveSQLException {
        this.cleanup(OperationState.CLOSED);
        this.cleanupOperationLog();
    }

    @Override
    public TableSchema getResultSetSchema() throws HiveSQLException {
        this.assertState(new ArrayList<OperationState>(Arrays.asList(OperationState.RUNNING, OperationState.FINISHED)));
        if (this.resultSchema == null) {
            this.resultSchema = new TableSchema(this.driver.getSchema());
        }
        return this.resultSchema;
    }

    @Override
    public RowSet getNextRowSet(FetchOrientation orientation, long maxRows) throws HiveSQLException {
        this.validateDefaultFetchOrientation(orientation);
        this.assertState(new ArrayList<OperationState>(Arrays.asList(OperationState.FINISHED)));
        RowSet rowSet = RowSetFactory.create(this.resultSchema, this.getProtocolVersion());
        try {
            if (orientation.equals((Object)FetchOrientation.FETCH_FIRST) && this.fetchStarted) {
                this.driver.resetFetch();
            }
            this.fetchStarted = true;
            this.driver.setMaxRows((int)maxRows);
            if (this.driver.getResults(this.convey)) {
                RowSet rowSet2 = this.decode(this.convey, rowSet);
                return rowSet2;
            }
            RowSet rowSet3 = rowSet;
            return rowSet3;
        }
        catch (IOException e) {
            throw new HiveSQLException(e);
        }
        catch (CommandNeedRetryException e) {
            throw new HiveSQLException(e);
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
        finally {
            this.convey.clear();
        }
    }

    private RowSet decode(List<Object> rows, RowSet rowSet) throws Exception {
        if (this.driver.isFetchingTable()) {
            return this.prepareFromRow(rows, rowSet);
        }
        return this.decodeFromString(rows, rowSet);
    }

    private RowSet prepareFromRow(List<Object> rows, RowSet rowSet) throws Exception {
        for (Object row : rows) {
            rowSet.addRow((Object[])row);
        }
        return rowSet;
    }

    private RowSet decodeFromString(List<Object> rows, RowSet rowSet) throws SQLException, SerDeException {
        this.getSerDe();
        StructObjectInspector soi = (StructObjectInspector)this.serde.getObjectInspector();
        List fieldRefs = soi.getAllStructFieldRefs();
        Object[] deserializedFields = new Object[fieldRefs.size()];
        int protocol = this.getProtocolVersion().getValue();
        for (Object rowString : rows) {
            Object rowObj;
            try {
                rowObj = this.serde.deserialize((Writable)new BytesWritable(((String)rowString).getBytes("UTF-8")));
            }
            catch (UnsupportedEncodingException e) {
                throw new SerDeException((Throwable)e);
            }
            for (int i = 0; i < fieldRefs.size(); ++i) {
                StructField fieldRef = (StructField)fieldRefs.get(i);
                ObjectInspector fieldOI = fieldRef.getFieldObjectInspector();
                Object fieldData = soi.getStructFieldData(rowObj, fieldRef);
                deserializedFields[i] = SerDeUtils.toThriftPayload((Object)fieldData, (ObjectInspector)fieldOI, (int)protocol);
            }
            rowSet.addRow(deserializedFields);
        }
        return rowSet;
    }

    private SerDe getSerDe() throws SQLException {
        if (this.serde != null) {
            return this.serde;
        }
        try {
            List fieldSchemas = this.mResultSchema.getFieldSchemas();
            StringBuilder namesSb = new StringBuilder();
            StringBuilder typesSb = new StringBuilder();
            if (fieldSchemas != null && !fieldSchemas.isEmpty()) {
                for (int pos = 0; pos < fieldSchemas.size(); ++pos) {
                    if (pos != 0) {
                        namesSb.append(",");
                        typesSb.append(",");
                    }
                    namesSb.append(((FieldSchema)fieldSchemas.get(pos)).getName());
                    typesSb.append(((FieldSchema)fieldSchemas.get(pos)).getType());
                }
            }
            String names = namesSb.toString();
            String types = typesSb.toString();
            this.serde = new LazySimpleSerDe();
            Properties props = new Properties();
            if (names.length() > 0) {
                LOG.debug((Object)("Column names: " + names));
                props.setProperty("columns", names);
            }
            if (types.length() > 0) {
                LOG.debug((Object)("Column types: " + types));
                props.setProperty("columns.types", types);
            }
            SerDeUtils.initializeSerDe((Deserializer)this.serde, (Configuration)new HiveConf(), (Properties)props, null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SQLException("Could not create ResultSet: " + ex.getMessage(), ex);
        }
        return this.serde;
    }

    private HiveConf getConfigForOperation() throws HiveSQLException {
        HiveConf sqlOperationConf = this.getParentSession().getHiveConf();
        if (!this.getConfOverlay().isEmpty() || this.shouldRunAsync()) {
            sqlOperationConf = new HiveConf(sqlOperationConf);
            for (Map.Entry<String, String> confEntry : this.getConfOverlay().entrySet()) {
                try {
                    sqlOperationConf.verifyAndSet(confEntry.getKey(), confEntry.getValue());
                }
                catch (IllegalArgumentException e) {
                    throw new HiveSQLException("Error applying statement specific settings", e);
                }
            }
        }
        return sqlOperationConf;
    }
}

