/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.toc;

import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.event.PageEventListener;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.FormulaExpression;
import org.pentaho.reporting.engine.classic.core.function.Function;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.function.PageFunction;
import org.pentaho.reporting.engine.classic.core.function.WrapperExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.util.IntegerCache;
import org.pentaho.reporting.engine.classic.core.util.TypedTableModel;
import org.pentaho.reporting.engine.classic.extensions.toc.IndexUtility;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class IndexDataGeneratorFunction
extends AbstractFunction
implements PageEventListener {
    private PageFunction pageFunction = new PageFunction();
    private TypedTableModel model = new TypedTableModel();
    private String dataField;
    private FormulaExpression dataFormula = new FormulaExpression();
    private String indexSeparator = ".";
    private boolean condensedStyle;
    private transient boolean initialized;
    private TreeMap<String, IndexDataHolder> dataStorage = new TreeMap();

    public boolean isCondensedStyle() {
        return this.condensedStyle;
    }

    public void setCondensedStyle(boolean condensedStyle) {
        this.condensedStyle = condensedStyle;
    }

    public String getIndexSeparator() {
        return this.indexSeparator;
    }

    public void setIndexSeparator(String indexSeparator) {
        this.indexSeparator = indexSeparator;
    }

    public String getDataFormula() {
        return this.dataFormula.getFormula();
    }

    public void setDataFormula(String titleFormula) {
        this.dataFormula.setFormula(titleFormula);
    }

    public String getDataField() {
        return this.dataField;
    }

    public void setDataField(String dataField) {
        this.dataField = dataField;
    }

    public void reportInitialized(ReportEvent event) {
        if (event.isDeepTraversing()) {
            return;
        }
        if (!this.initialized) {
            this.initialized = true;
            this.model.addColumn("item-data", Object.class);
            this.model.addColumn("item-pages", String.class);
            this.model.addColumn("item-pages-array", Integer[].class);
            this.model.addColumn("item-key", String.class);
        }
        this.pageFunction.reportInitialized(event);
    }

    public void reportStarted(ReportEvent event) {
        if (event.isDeepTraversing()) {
            return;
        }
        this.pageFunction.reportStarted(event);
    }

    public void itemsAdvanced(ReportEvent event) {
        if (event.isDeepTraversing() && "index".equals(event.getOriginatingState().getReport().getMetaData().getName())) {
            return;
        }
        Object o = this.computeDataValue(event);
        if (o == null) {
            return;
        }
        if (FunctionUtilities.isDefinedPrepareRunLevel((Function)this, (ReportEvent)event)) {
            this.dataStorage.put(String.valueOf(o), new IndexDataHolder(o));
        } else if (FunctionUtilities.isLayoutLevel((ReportEvent)event)) {
            IndexDataHolder o1 = this.dataStorage.get(String.valueOf(o));
            if (o1 == null) {
                throw new IllegalStateException("Unable to compute index: Function values changed between prepare and layout run");
            }
            o1.addPage(this.pageFunction.getPage());
        }
    }

    private DataRow extractDataRow(ReportEvent event) {
        if (!event.isDeepTraversing()) {
            return this.getDataRow();
        }
        return event.getOriginatingState().getDataRow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object computeDataValue(ReportEvent event) {
        DataRow dataRow = this.extractDataRow(event);
        if (!StringUtils.isEmpty((String)this.dataField)) {
            return dataRow.get(this.dataField);
        }
        try {
            this.dataFormula.setRuntime((ExpressionRuntime)new WrapperExpressionRuntime(dataRow, this.getRuntime()));
            Object object = this.dataFormula.getValue();
            return object;
        }
        finally {
            this.dataFormula.setRuntime(null);
        }
    }

    public void pageStarted(ReportEvent event) {
        this.pageFunction.pageStarted(event);
    }

    public void pageFinished(ReportEvent event) {
        this.pageFunction.pageFinished(event);
    }

    public void reportDone(ReportEvent event) {
        block4: {
            block3: {
                if (event.isDeepTraversing()) {
                    return;
                }
                if (!FunctionUtilities.isDefinedPrepareRunLevel((Function)this, (ReportEvent)event)) break block3;
                for (Map.Entry<String, IndexDataHolder> entry : this.dataStorage.entrySet()) {
                    String key = entry.getKey();
                    IndexDataHolder data = entry.getValue();
                    this.model.addRow(new Object[]{data.getData(), data.getPagesText(this.indexSeparator, this.condensedStyle), data.getPages(), key});
                }
                break block4;
            }
            if (!FunctionUtilities.isLayoutLevel((ReportEvent)event)) break block4;
            int rowCount = this.model.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                String key = (String)this.model.getValueAt(i, 3);
                IndexDataHolder dataHolder = this.dataStorage.get(key);
                this.model.setValueAt((Object)dataHolder.getPagesText(this.indexSeparator, this.condensedStyle), i, 1);
                this.model.setValueAt((Object)dataHolder.getPages(), i, 2);
            }
        }
    }

    public Object getValue() {
        return this.model;
    }

    public boolean isDeepTraversing() {
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        IndexDataGeneratorFunction o = (IndexDataGeneratorFunction)((Object)super.clone());
        o.dataFormula = (FormulaExpression)this.dataFormula.clone();
        o.pageFunction = (PageFunction)this.pageFunction.clone();
        return o;
    }

    public Expression getInstance() {
        IndexDataGeneratorFunction instance = (IndexDataGeneratorFunction)super.getInstance();
        instance.model = new TypedTableModel();
        instance.pageFunction = (PageFunction)this.pageFunction.getInstance();
        instance.dataFormula = (FormulaExpression)this.dataFormula.getInstance();
        instance.dataStorage = new TreeMap();
        instance.initialized = false;
        return instance;
    }

    public TypedTableModel getModel() {
        return this.model;
    }

    private static class IndexDataHolder
    implements Serializable {
        private Object data;
        private TreeSet<Integer> pages;

        private IndexDataHolder(Object data) {
            this.data = data;
            this.pages = new TreeSet();
        }

        public void addPage(int page) {
            this.pages.add(IntegerCache.getInteger((int)page));
        }

        public Object getData() {
            return this.data;
        }

        public String getPagesText(String indexSeparator, boolean condensedStyle) {
            Integer[] groupCount = this.pages.toArray(new Integer[this.pages.size()]);
            if (condensedStyle) {
                return IndexUtility.getCondensedIndexText(groupCount, indexSeparator);
            }
            return IndexUtility.getIndexText(groupCount, indexSeparator);
        }

        public Integer[] getPages() {
            return this.pages.toArray(new Integer[this.pages.size()]);
        }
    }
}

