/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.toc;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.util.IntegerCache;

public class IndexNumberGeneratorFunction
extends AbstractFunction {
    private int depth;
    private ArrayList groupCount;
    private boolean collectDetails;
    private transient int groupIndex = -1;
    private transient boolean initialized;

    public boolean isCollectDetails() {
        return this.collectDetails;
    }

    public void setCollectDetails(boolean collectDetails) {
        this.collectDetails = collectDetails;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void reportInitialized(ReportEvent event) {
        if (event.isDeepTraversing()) {
            return;
        }
        if (!this.initialized) {
            this.initialized = true;
            this.groupCount = new ArrayList(this.depth);
        }
        this.groupCount.clear();
        this.groupIndex = -1;
    }

    public void reportStarted(ReportEvent event) {
        if (event.isDeepTraversing()) {
            return;
        }
        this.groupIndex = -1;
    }

    public void groupStarted(ReportEvent event) {
        if (event.isDeepTraversing() && "toc".equals(event.getOriginatingState().getReport().getMetaData().getName())) {
            return;
        }
        ++this.groupIndex;
        if (this.groupCount.size() == this.groupIndex) {
            this.groupCount.add(IntegerCache.getInteger((int)1));
        } else {
            int lastIndex = this.groupCount.size() - 1;
            if (lastIndex == this.groupIndex) {
                Integer o = (Integer)this.groupCount.get(lastIndex);
                if (o == null) {
                    throw new IllegalStateException();
                }
                this.groupCount.set(lastIndex, IntegerCache.getInteger((int)(o + 1)));
            } else {
                throw new IllegalStateException("Out of index error: " + this.groupIndex + " " + this.groupCount.size());
            }
        }
    }

    public void itemsStarted(ReportEvent event) {
        if (event.isDeepTraversing() && "toc".equals(event.getOriginatingState().getReport().getMetaData().getName())) {
            return;
        }
        if (this.collectDetails) {
            ++this.groupIndex;
        }
    }

    public void itemsAdvanced(ReportEvent event) {
        if (event.isDeepTraversing() && "toc".equals(event.getOriginatingState().getReport().getMetaData().getName())) {
            return;
        }
        if (this.collectDetails && (this.groupIndex < this.depth || this.depth == 0)) {
            if (this.groupCount.size() == this.groupIndex) {
                this.groupCount.add(IntegerCache.getInteger((int)1));
            } else {
                int lastIndex = this.groupCount.size() - 1;
                if (lastIndex == this.groupIndex) {
                    Integer o = (Integer)this.groupCount.get(lastIndex);
                    if (o == null) {
                        throw new IllegalStateException();
                    }
                    this.groupCount.set(lastIndex, IntegerCache.getInteger((int)(o + 1)));
                } else {
                    throw new IllegalStateException("Out of index error: " + this.groupIndex + " " + this.groupCount.size());
                }
            }
        }
    }

    public void itemsFinished(ReportEvent event) {
        if (event.isDeepTraversing() && "toc".equals(event.getOriginatingState().getReport().getMetaData().getName())) {
            return;
        }
        if (this.collectDetails) {
            if (this.groupIndex + 2 == this.groupCount.size()) {
                this.groupCount.remove(this.groupCount.size() - 1);
            }
            --this.groupIndex;
        }
    }

    public void groupFinished(ReportEvent event) {
        super.groupFinished(event);
        if (event.isDeepTraversing() && "toc".equals(event.getOriginatingState().getReport().getMetaData().getName())) {
            return;
        }
        Group group = FunctionUtilities.getCurrentDeepTraverseGroup((ReportEvent)event);
        if (!(group instanceof RelationalGroup)) {
            return;
        }
        if (this.groupIndex + 2 == this.groupCount.size()) {
            this.groupCount.remove(this.groupCount.size() - 1);
        }
        --this.groupIndex;
    }

    public Object getValue() {
        Integer[] indexValues = new Integer[this.groupCount.size()];
        for (int i = 0; i < indexValues.length; ++i) {
            indexValues[i] = (Integer)this.groupCount.get(i);
        }
        return indexValues;
    }

    public Object clone() throws CloneNotSupportedException {
        IndexNumberGeneratorFunction o = (IndexNumberGeneratorFunction)((Object)super.clone());
        if (this.groupCount != null) {
            o.groupCount = (ArrayList)this.groupCount.clone();
        }
        return o;
    }

    public boolean isDeepTraversing() {
        return true;
    }

    public Expression getInstance() {
        IndexNumberGeneratorFunction instance = (IndexNumberGeneratorFunction)super.getInstance();
        instance.groupCount = null;
        return instance;
    }
}

