/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

abstract class DataStream {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    protected static ConverterImplRemote converter_;
    protected AS400ImplRemote system_;
    protected byte[] data_;
    protected int headerLength_;

    static ConverterImplRemote getDefaultConverter() {
        return converter_;
    }

    static void setDefaultConverter(ConverterImplRemote converterImplRemote) {
        converter_ = converterImplRemote;
    }

    static final int readFromStream(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        boolean bl = false;
        int n3 = 0;
        while (n3 < n2 && !bl) {
            int n4 = inputStream.read(byArray, n + n3, n2 - n3);
            if (n4 == -1) {
                bl = true;
                continue;
            }
            n3 += n4;
        }
        if (Trace.traceOn_) {
            Trace.log(0, "Data stream data received...", byArray, n, n3);
        }
        return n3;
    }

    DataStream(int n) {
        this.headerLength_ = n;
        this.data_ = new byte[this.headerLength_];
        this.setLength(this.headerLength_);
    }

    DataStream(int n, byte[] byArray) {
        this.headerLength_ = n;
        this.data_ = byArray;
    }

    public boolean equals(Object object) {
        if (object instanceof DataStream) {
            return this.hashCode() == ((DataStream)object).hashCode();
        }
        return false;
    }

    abstract int getCorrelation();

    abstract int getLength();

    Object getNewDataStream() {
        return null;
    }

    AS400ImplRemote getSystem() {
        return this.system_;
    }

    protected final int get16bit(int n) {
        return ((this.data_[n] & 0xFF) << 8) + (this.data_[n + 1] & 0xFF);
    }

    protected final int get32bit(int n) {
        return ((this.data_[n] & 0xFF) << 24) + ((this.data_[n + 1] & 0xFF) << 16) + ((this.data_[n + 2] & 0xFF) << 8) + (this.data_[n + 3] & 0xFF);
    }

    protected final long get64bit(int n) {
        return BinaryConverter.byteArrayToLong(this.data_, n);
    }

    public int hashCode() {
        return super.hashCode();
    }

    int readAfterHeader(InputStream inputStream) throws IOException {
        int n = DataStream.readFromStream(inputStream, this.data_, this.headerLength_, this.data_.length - this.headerLength_);
        if (n < this.data_.length - this.headerLength_) {
            if (Trace.traceOn_) {
                Trace.log(2, "Failed to read all of the data stream.");
            }
            throw new ConnectionDroppedException(2);
        }
        return n;
    }

    abstract void setCorrelation(int var1);

    abstract void setLength(int var1);

    void setSystem(AS400ImplRemote aS400ImplRemote) {
        this.system_ = aS400ImplRemote;
    }

    protected final void set16bit(int n, int n2) {
        this.data_[n2] = (byte)(n >>> 8);
        this.data_[n2 + 1] = (byte)n;
    }

    protected final void set32bit(int n, int n2) {
        this.data_[n2] = (byte)(n >>> 24);
        this.data_[n2 + 1] = (byte)(n >>> 16);
        this.data_[n2 + 2] = (byte)(n >>> 8);
        this.data_[n2 + 3] = (byte)n;
    }

    protected final void set64bit(long l, int n) {
        BinaryConverter.longToByteArray(l, this.data_, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(OutputStream outputStream) throws IOException {
        OutputStream outputStream2 = outputStream;
        synchronized (outputStream2) {
            outputStream.write(this.data_);
            outputStream.flush();
        }
        if (Trace.traceOn_) {
            Trace.log(0, "Data stream sent...", this.data_);
        }
    }
}

