/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Float4;
import com.ibm.as400.access.AS400Float8;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.FieldDescription;
import java.io.Serializable;
import java.util.Vector;

public class FloatFieldDescription
extends FieldDescription
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private int decimalPositions_;
    private String floatPrecision_ = "";

    public FloatFieldDescription() {
    }

    public FloatFieldDescription(AS400Float8 aS400Float8, String string) {
        super(aS400Float8, string);
        this.length_ = 9;
    }

    public FloatFieldDescription(AS400Float8 aS400Float8, String string, String string2, int n) {
        super(aS400Float8, string, string2);
        if (n < 1) {
            throw new ExtendedIllegalArgumentException("length", 2);
        }
        this.length_ = n;
    }

    public FloatFieldDescription(AS400Float8 aS400Float8, String string, String string2, int n, int n2) {
        super(aS400Float8, string, string2);
        if (n < 1) {
            throw new ExtendedIllegalArgumentException("length", 2);
        }
        if (n2 < 0) {
            throw new ExtendedIllegalArgumentException("decimalPositions", 2);
        }
        this.length_ = n;
        this.decimalPositions_ = n2;
    }

    public FloatFieldDescription(AS400Float4 aS400Float4, String string) {
        super(aS400Float4, string);
        this.length_ = 9;
    }

    public FloatFieldDescription(AS400Float4 aS400Float4, String string, String string2, int n) {
        super(aS400Float4, string, string2);
        if (n < 1) {
            throw new ExtendedIllegalArgumentException("length", 2);
        }
        this.length_ = n;
    }

    public FloatFieldDescription(AS400Float4 aS400Float4, String string, String string2, int n, int n2) {
        super(aS400Float4, string, string2);
        if (n < 1) {
            throw new ExtendedIllegalArgumentException("length", 2);
        }
        if (n2 < 0) {
            throw new ExtendedIllegalArgumentException("decimalPositions", 2);
        }
        this.length_ = n;
        this.decimalPositions_ = n2;
    }

    String[] getDDSDescription() {
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer(this.ddsName_);
        while (stringBuffer.length() < 10) {
            stringBuffer.append(" ");
        }
        if (!this.refFld_.equals("")) {
            stringBuffer.append("R");
        } else {
            stringBuffer.append(" ");
        }
        String string = String.valueOf(this.length_);
        int n = 5 - string.length();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(string.toString());
        stringBuffer.append("F");
        StringBuffer stringBuffer2 = new StringBuffer(new Integer(this.decimalPositions_).toString());
        if (stringBuffer2.length() == 1) {
            stringBuffer2.insert(0, " ");
        }
        stringBuffer.append(stringBuffer2.toString());
        stringBuffer.append("       ");
        vector.addElement(stringBuffer.toString());
        String[] stringArray = super.getFieldFunctions();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                vector.addElement(stringArray[i]);
            }
        }
        if (!this.floatPrecision_.equals("")) {
            vector.addElement("FLTPCN(" + this.floatPrecision_ + ") ");
        }
        if (this.defaultValue_ != null) {
            vector.addElement("DFT(" + this.defaultValue_.toString() + ") ");
        } else if (this.isDFTNull_) {
            vector.addElement("DFT(*NULL) ");
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public int getDecimalPositions() {
        return this.decimalPositions_;
    }

    public String getFLTPCN() {
        return this.floatPrecision_;
    }

    public void setDataType(AS400Float4 aS400Float4) {
        if (aS400Float4 == null) {
            throw new NullPointerException("dataType");
        }
        this.dataType_ = aS400Float4;
        this.length_ = 9;
    }

    public void setDataType(AS400Float8 aS400Float8) {
        if (aS400Float8 == null) {
            throw new NullPointerException("dataType");
        }
        this.dataType_ = aS400Float8;
        this.length_ = 17;
    }

    public void setDecimalPositions(int n) {
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("decimalPositions (" + String.valueOf(n) + ")", 2);
        }
        this.decimalPositions_ = n;
    }

    public void setFLTPCN(String string) {
        if (string == null) {
            throw new NullPointerException("floatPrecision");
        }
        if (!string.equalsIgnoreCase("*SINGLE") && !string.equalsIgnoreCase("*DOUBLE")) {
            throw new ExtendedIllegalArgumentException("floatPrecision (" + string + ")", 2);
        }
        this.floatPrecision_ = string;
    }

    public void setDFT(Double d) {
        if (d == null) {
            throw new NullPointerException("defaultValue");
        }
        this.defaultValue_ = d;
        this.isDFTNull_ = false;
        this.isDFTCurrent_ = false;
        this.DFTCurrentValue_ = null;
    }

    public void setDFT(Float f) {
        if (f == null) {
            throw new NullPointerException("defaultValue");
        }
        this.defaultValue_ = f;
        this.isDFTNull_ = false;
        this.isDFTCurrent_ = false;
        this.DFTCurrentValue_ = null;
    }

    public void setDFTNull() {
        this.isDFTNull_ = true;
        this.defaultValue_ = null;
        this.isDFTCurrent_ = false;
        this.DFTCurrentValue_ = null;
    }

    public void setLength(int n) {
        if (n < 1) {
            throw new ExtendedIllegalArgumentException("length (" + String.valueOf(n) + ")", 2);
        }
        this.length_ = n;
    }
}

