/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.SSLOptions;
import com.ibm.as400.access.SocketContainer;
import com.ibm.as400.access.Trace;
import com.ibm.sslight.SSLContext;
import com.ibm.sslight.SSLSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Date;

class SocketContainerSSL
extends SocketContainer {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private SSLSocket sslSocket_;

    SocketContainerSSL() {
    }

    void setProperties(Socket socket, String string, String string2, int n, SSLOptions sSLOptions) throws IOException {
        String[] stringArray;
        if (Trace.isTraceOn()) {
            Trace.log(1, "SocketContainerSSL: create SSLContext");
        }
        SSLContext sSLContext = new SSLContext();
        if (Trace.isTraceOn()) {
            sSLContext.debug = true;
        }
        if (sSLOptions.keyRingData_ == null) {
            try {
                stringArray = (String[])Class.forName(sSLOptions.keyRingName_).newInstance();
                sSLOptions.keyRingData_ = stringArray.getKeyRingData();
            }
            catch (Exception exception) {
                Trace.log(2, "Error loading key ring:", (Throwable)exception);
                throw new InternalErrorException(10);
            }
        }
        sSLContext.importKeyRings(sSLOptions.keyRingData_, sSLOptions.keyRingPassword_);
        if (Trace.isTraceOn()) {
            stringArray = sSLContext.getEnabledCipherSuites();
            Trace.log(1, "Enabled cipher suites:");
            for (int i = 0; i < stringArray.length; ++i) {
                Trace.log(1, "   " + stringArray[i]);
            }
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "SocketContainerSSL: create SSLSocket");
        }
        this.sslSocket_ = new SSLSocket(socket, false, sSLContext, false, null);
        if (Trace.isTraceOn()) {
            Trace.log(1, "SSL connection established");
            Trace.log(1, "   cipher suite:       " + this.sslSocket_.getCipherSuite());
            Trace.log(1, "   compression method: " + this.sslSocket_.getCompressionMethod());
            stringArray = this.sslSocket_.getPeerCertificateChain();
            if (stringArray != null) {
                Trace.log(1, "Peer Certificate:");
                Trace.log(1, stringArray[0].getKeyInfo() + " bits");
                int[] nArray = new int[]{3, 11, 10, 6, 7};
                for (int i = 0; i < nArray.length; ++i) {
                    String string3 = stringArray[0].getNameComponent(1, nArray[i]);
                    if (string3 != null) {
                        Trace.log(1, string3);
                        continue;
                    }
                    Trace.log(1, "");
                }
                Date[] dateArray = stringArray[0].getValidity();
                if (dateArray != null) {
                    Trace.log(1, "Valid From: " + dateArray[0]);
                    Trace.log(1, "        To: " + dateArray[1]);
                }
            }
        }
    }

    void close() throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "SocketContainerSSL: close");
        }
        this.sslSocket_.close();
    }

    InputStream getInputStream() throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "SocketContainerSSL: getInputStream");
        }
        return this.sslSocket_.getInputStream();
    }

    OutputStream getOutputStream() throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "SocketContainerSSL: getOutputStream");
        }
        return this.sslSocket_.getOutputStream();
    }
}

