/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.i18n.resource;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import org.pentaho.osgi.i18n.resource.OSGIResourceBundle;
import org.pentaho.osgi.i18n.resource.OSGIResourceBundleFactory;
import org.pentaho.osgi.i18n.settings.OSGIResourceNameComparator;
import org.pentaho.osgi.i18n.settings.OSGIResourceNamingConvention;

public class OSGIResourceBundleCacheCallable
implements Callable<Map<String, OSGIResourceBundle>> {
    private final Map<Long, Map<String, OSGIResourceBundleFactory>> configMap;

    public OSGIResourceBundleCacheCallable(Map<Long, Map<String, OSGIResourceBundleFactory>> configMap) {
        this.configMap = configMap;
    }

    @Override
    public Map<String, OSGIResourceBundle> call() throws Exception {
        TreeMap<String, OSGIResourceBundleFactory> factoryMap = new TreeMap<String, OSGIResourceBundleFactory>(new OSGIResourceNameComparator());
        for (Map<String, OSGIResourceBundleFactory> bundleMap : this.configMap.values()) {
            for (Map.Entry<String, OSGIResourceBundleFactory> entry : bundleMap.entrySet()) {
                OSGIResourceBundleFactory pathToFactoryMap = entry.getValue();
                String key = entry.getValue().getPropertyFilePath();
                factoryMap.put(key, pathToFactoryMap);
            }
        }
        HashMap<String, OSGIResourceBundle> result = new HashMap<String, OSGIResourceBundle>();
        Set keys = factoryMap.keySet();
        TreeMap<String, OSGIResourceBundleFactory> factoryMapCopy = new TreeMap<String, OSGIResourceBundleFactory>(new OSGIResourceNameComparator());
        factoryMapCopy.putAll(factoryMap);
        for (String key : keys) {
            OSGIResourceBundleFactory nameToFactoryEntry = (OSGIResourceBundleFactory)factoryMap.get(key);
            String name = nameToFactoryEntry.getPropertyFilePath();
            Matcher defaultMatcher = OSGIResourceNamingConvention.getResourceNameMatcher(name);
            String defaultName = defaultMatcher.group(1);
            String locale = defaultMatcher.group(2);
            if (locale.length() > 1) {
                locale = locale.substring(1).replace('_', '-');
            }
            OSGIResourceBundleFactory defaultFactory = null;
            List<String> candidates = OSGIResourceNamingConvention.getCandidateNames(defaultName, Locale.forLanguageTag(locale));
            for (int i = 0; i < candidates.size(); ++i) {
                Optional<String> firstKeyInHierarhy = this.getFirstKeyInHierarhy(factoryMapCopy, candidates.get(i) + ".properties");
                if (!firstKeyInHierarhy.isPresent() || factoryMapCopy.get(firstKeyInHierarhy.get()) == nameToFactoryEntry) continue;
                if (i != candidates.size() - 1) {
                    defaultFactory = (OSGIResourceBundleFactory)factoryMapCopy.remove(firstKeyInHierarhy.get());
                    break;
                }
                defaultFactory = (OSGIResourceBundleFactory)factoryMapCopy.get(firstKeyInHierarhy.get());
                break;
            }
            OSGIResourceBundle parentBundle = null;
            if (defaultFactory != null) {
                parentBundle = (OSGIResourceBundle)result.get(defaultFactory.getBundle(null).getDefaultName());
            }
            OSGIResourceBundle resultKeyBundles = nameToFactoryEntry.getBundle(parentBundle);
            result.put(resultKeyBundles.getDefaultName(), resultKeyBundles);
        }
        return result;
    }

    private Optional<String> getFirstKeyInHierarhy(SortedMap<String, OSGIResourceBundleFactory> factoryMapWithoutCurrent, final String name) {
        return factoryMapWithoutCurrent.keySet().stream().filter(new Predicate<String>(){

            @Override
            public boolean test(String s) {
                return s.startsWith(name);
            }
        }).findFirst();
    }
}

