/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.action.hadoop.JavaActionExecutor;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.util.XLog;
import org.jdom.Element;
import org.jdom.JDOMException;

public class DistcpActionExecutor
extends JavaActionExecutor {
    public static final String CONF_OOZIE_DISTCP_ACTION_MAIN_CLASS = "org.apache.oozie.action.hadoop.DistcpMain";
    private static final String DISTCP_MAIN_CLASS_NAME = "org.apache.hadoop.tools.DistCp";
    public static final String CLASS_NAMES = "oozie.actions.main.classnames";
    private static final XLog LOG = XLog.getLog(DistcpActionExecutor.class);
    public static final String DISTCP_TYPE = "distcp";

    public DistcpActionExecutor() {
        super(DISTCP_TYPE);
    }

    @Override
    Configuration setupActionConf(Configuration actionConf, ActionExecutor.Context context, Element actionXml, Path appPath) throws ActionExecutorException {
        actionConf = super.setupActionConf(actionConf, context, actionXml, appPath);
        String classNameDistcp = CONF_OOZIE_DISTCP_ACTION_MAIN_CLASS;
        String name = DistcpActionExecutor.getClassNamebyType(DISTCP_TYPE);
        if (name != null) {
            classNameDistcp = name;
        }
        actionConf.set("oozie.action.java.main", DISTCP_MAIN_CLASS_NAME);
        return actionConf;
    }

    @Override
    public List<Class> getLauncherClasses() {
        ArrayList<Class> classes = new ArrayList<Class>();
        try {
            classes.add(Class.forName(CONF_OOZIE_DISTCP_ACTION_MAIN_CLASS));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found", e);
        }
        return classes;
    }

    public static String getClassNamebyType(String type) {
        String classname = null;
        for (String function : ConfigurationService.getStrings(CLASS_NAMES)) {
            function = DistcpActionExecutor.Trim(function);
            LOG.debug("class for Distcp Action: " + function);
            String[] str = function.split("=");
            if (str.length <= 0 || !type.equalsIgnoreCase(str[0])) continue;
            classname = new String(str[1]);
        }
        return classname;
    }

    public static String Trim(String str) {
        if (str != null) {
            str = str.replaceAll("\\n", "");
            str = str.replaceAll("\\t", "");
            str = str.trim();
        }
        return str;
    }

    @Override
    protected String getDefaultShareLibName(Element actionXml) {
        return DISTCP_TYPE;
    }

    @Override
    protected String getLauncherMain(Configuration launcherConf, Element actionXml) {
        return launcherConf.get("oozie.launcher.action.main.class", CONF_OOZIE_DISTCP_ACTION_MAIN_CLASS);
    }

    @Override
    protected void getActionData(FileSystem actionFs, RunningJob runningJob, WorkflowAction action, ActionExecutor.Context context) throws HadoopAccessorException, JDOMException, IOException, URISyntaxException {
        super.getActionData(actionFs, runningJob, action, context);
        this.readExternalChildIDs(action, context);
    }

    @Override
    protected boolean getCaptureOutput(WorkflowAction action) throws JDOMException {
        return true;
    }
}

