/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.XCommand;
import org.apache.oozie.command.coord.CoordinatorXCommand;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.util.ParamChecker;

public abstract class TransitionXCommand<T>
extends XCommand<T> {
    protected Job job;
    protected List<BatchQueryExecutor.UpdateEntry> updateList = new ArrayList<BatchQueryExecutor.UpdateEntry>();
    protected List<JsonBean> insertList = new ArrayList<JsonBean>();

    public TransitionXCommand(String name, String type, int priority) {
        super(name, type, priority);
    }

    public TransitionXCommand(String name, String type, int priority, boolean dryrun) {
        super(name, type, priority, dryrun);
    }

    public abstract void transitToNext() throws CommandException;

    public abstract void updateJob() throws CommandException;

    public abstract void notifyParent() throws CommandException;

    public void generateEvents(CoordinatorJobBean coordJob, Date startTime) throws CommandException {
        for (BatchQueryExecutor.UpdateEntry entry : this.updateList) {
            JsonBean actionBean = entry.getBean();
            if (!(actionBean instanceof CoordinatorActionBean)) continue;
            CoordinatorActionBean caBean = (CoordinatorActionBean)actionBean;
            caBean.setJobId(coordJob.getId());
            CoordinatorXCommand.generateEvent(caBean, coordJob.getUser(), coordJob.getAppName(), startTime);
        }
    }

    public abstract void performWrites() throws CommandException;

    @Override
    protected T execute() throws CommandException {
        this.transitToNext();
        this.updateJob();
        this.notifyParent();
        return null;
    }

    public Job getJob() {
        return this.job;
    }

    public void setJob(Job job) {
        this.job = ParamChecker.notNull(job, "job");
    }
}

