/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.io.IOException;
import java.io.StringReader;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.NotificationXCommand;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XConfiguration;

public class CoordActionNotificationXCommand
extends NotificationXCommand {
    private final CoordinatorActionBean actionBean;
    private static final String STATUS_PATTERN = "\\$status";
    private static final String ACTION_ID_PATTERN = "\\$actionId";
    int retries = 0;

    public CoordActionNotificationXCommand(CoordinatorActionBean actionBean) {
        super("coord_action_notification", "coord_action_notification", 0);
        ParamChecker.notNull(actionBean, "Action Bean");
        this.actionBean = actionBean;
        this.jobId = actionBean.getId();
    }

    @Override
    protected void loadState() throws CommandException {
        XConfiguration conf;
        try {
            conf = new XConfiguration(new StringReader(this.actionBean.getRunConf()));
        }
        catch (IOException e1) {
            this.LOG.warn("Configuration parse error. read from DB :" + this.actionBean.getRunConf());
            throw new CommandException(ErrorCode.E1005, e1.getMessage(), e1);
        }
        this.url = conf.get("oozie.coord.action.notification.url");
        if (this.url != null) {
            this.url = this.url.replaceAll(ACTION_ID_PATTERN, this.actionBean.getId());
            this.url = this.url.replaceAll(STATUS_PATTERN, this.actionBean.getStatus().toString());
            this.proxyConf = conf.get("oozie.coord.action.notification.proxy", Services.get().getConf().get("oozie.notification.proxy"));
            this.LOG.debug("Proxy :" + this.proxyConf);
        }
        this.LOG.debug("Notification URL :" + this.url);
        LogUtils.setLogInfo(this.actionBean);
    }
}

