/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.XException;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.action.control.ControlNodeActionExecutor;
import org.apache.oozie.client.SLAEvent;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.wf.ActionXCommand;
import org.apache.oozie.command.wf.WorkflowNotificationXCommand;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowActionQueryExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.service.ActionService;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.db.SLADbXOperations;

public class ActionKillXCommand
extends ActionXCommand<Void> {
    private String actionId;
    private String jobId;
    private WorkflowJobBean wfJob;
    private WorkflowActionBean wfAction;
    private JPAService jpaService = null;
    private List<BatchQueryExecutor.UpdateEntry> updateList = new ArrayList<BatchQueryExecutor.UpdateEntry>();
    private List<JsonBean> insertList = new ArrayList<JsonBean>();

    public ActionKillXCommand(String actionId, String type) {
        super("action.kill", type, 0);
        this.actionId = actionId;
        this.jobId = Services.get().get(UUIDService.class).getId(actionId);
    }

    public ActionKillXCommand(String actionId) {
        this(actionId, "action.kill");
    }

    @Override
    protected void setLogInfo() {
        LogUtils.setLogInfo(this.actionId);
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    public String getEntityKey() {
        return this.jobId;
    }

    @Override
    public String getKey() {
        return this.getName() + "_" + this.actionId;
    }

    @Override
    protected void loadState() throws CommandException {
        try {
            this.jpaService = Services.get().get(JPAService.class);
            if (this.jpaService == null) {
                throw new CommandException(ErrorCode.E0610, new Object[0]);
            }
            this.wfJob = WorkflowJobQueryExecutor.getInstance().get(WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW_ACTION_OP, this.jobId);
            this.wfAction = WorkflowActionQueryExecutor.getInstance().get(WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTION, this.actionId);
            LogUtils.setLogInfo(this.wfJob);
            LogUtils.setLogInfo(this.wfAction);
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        if (this.wfAction.getStatus() != WorkflowAction.Status.KILLED) {
            throw new PreconditionException(ErrorCode.E0726, this.wfAction.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected Void execute() throws CommandException {
        this.LOG.debug("STARTED WorkflowActionKillXCommand for action " + this.actionId);
        if (this.wfAction.isPending() && (executor = Services.get().get(ActionService.class).getExecutor(this.wfAction.getType())) != null) {
            context = null;
            isRetry = false;
            isUserRetry = false;
            context = new ActionXCommand.ActionExecutorContext(this.wfJob, this.wfAction, isRetry, isUserRetry);
            this.incrActionCounter(this.wfAction.getType(), 1);
            cron = new Instrumentation.Cron();
            cron.start();
            executor.kill(context, this.wfAction);
            cron.stop();
            this.addActionCron(this.wfAction.getType(), cron);
            this.wfAction.resetPending();
            this.wfAction.setStatus(WorkflowAction.Status.KILLED);
            this.wfAction.setEndTime(new Date());
            this.updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowActionQueryExecutor.WorkflowActionQuery>(WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION_END, this.wfAction));
            this.wfJob.setLastModifiedTime(new Date());
            this.updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowJobQueryExecutor.WorkflowJobQuery>(WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_MODTIME, this.wfJob));
            slaEvent = SLADbXOperations.createStatusEvent(this.wfAction.getSlaXml(), this.wfAction.getId(), SLAEvent.Status.KILLED, SLAEvent.SlaAppType.WORKFLOW_ACTION);
            if (slaEvent != null) {
                this.insertList.add(slaEvent);
            }
            this.queue(new WorkflowNotificationXCommand(this.wfJob, this.wfAction));
            try {
                this.cleanupActionDir(context);
                BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(this.insertList, this.updateList, null);
                if (executor instanceof ControlNodeActionExecutor || !EventHandlerService.isEnabled()) ** GOTO lbl70
                this.generateEvent(this.wfAction, this.wfJob.getUser());
            }
            catch (JPAExecutorException e) {
                throw new CommandException(e);
            }
            catch (ActionExecutorException ex) {
                try {
                    this.wfAction.resetPending();
                    this.wfAction.setStatus(WorkflowAction.Status.FAILED);
                    this.wfAction.setErrorInfo(ex.getErrorCode().toString(), "KILL COMMAND FAILED - exception while executing job kill");
                    this.wfAction.setEndTime(new Date());
                    this.wfJob.setStatus(WorkflowJob.Status.KILLED);
                    this.updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowActionQueryExecutor.WorkflowActionQuery>(WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION_END, this.wfAction));
                    this.wfJob.setLastModifiedTime(new Date());
                    this.updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowJobQueryExecutor.WorkflowJobQuery>(WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_MODTIME, this.wfJob));
                    slaEvent = SLADbXOperations.createStatusEvent(this.wfAction.getSlaXml(), this.wfAction.getId(), SLAEvent.Status.FAILED, SLAEvent.SlaAppType.WORKFLOW_ACTION);
                    if (slaEvent != null) {
                        this.insertList.add(slaEvent);
                    }
                    this.LOG.warn("Exception while executing kill(). Error Code [{0}], Message[{1}]", new Object[]{ex.getErrorCode(), ex.getMessage(), ex});
                }
                catch (Throwable var7_11) {
                    try {
                        this.cleanupActionDir(context);
                        BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(this.insertList, this.updateList, null);
                        if (!(executor instanceof ControlNodeActionExecutor) && EventHandlerService.isEnabled()) {
                            this.generateEvent(this.wfAction, this.wfJob.getUser());
                        }
                    }
                    catch (JPAExecutorException e) {
                        throw new CommandException(e);
                    }
                    throw var7_11;
                }
                try {
                    this.cleanupActionDir(context);
                    BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(this.insertList, this.updateList, null);
                    if (!(executor instanceof ControlNodeActionExecutor) && EventHandlerService.isEnabled()) {
                        this.generateEvent(this.wfAction, this.wfJob.getUser());
                    }
                }
                catch (JPAExecutorException e) {
                    throw new CommandException(e);
                }
            }
        }
lbl70:
        // 5 sources

        this.LOG.debug("ENDED WorkflowActionKillXCommand for action " + this.actionId);
        return null;
    }

    private void cleanupActionDir(ActionExecutor.Context context) {
        try {
            FileStatus[] statuses;
            FileSystem actionFs = context.getAppFileSystem();
            Path actionDir = context.getActionDir();
            Path jobDir = actionDir.getParent();
            if (!context.getProtoActionConf().getBoolean("oozie.action.keep.action.dir", false) && actionFs.exists(actionDir)) {
                actionFs.delete(actionDir, true);
            }
            if (actionFs.exists(jobDir) && actionFs.getFileStatus(jobDir).isDir() && ((statuses = actionFs.listStatus(jobDir)) == null || statuses.length == 0)) {
                actionFs.delete(jobDir, true);
            }
        }
        catch (Exception e) {
            this.LOG.warn("Exception while cleaning up action dir. Message[{1}]", e.getMessage(), e);
        }
    }
}

