/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.util.Properties;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.wf.ActionCheckXCommand;
import org.apache.oozie.command.wf.WorkflowXCommand;
import org.apache.oozie.executor.jpa.WorkflowActionQueryExecutor;
import org.apache.oozie.service.ActionService;
import org.apache.oozie.service.CallbackService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;

public class CompletedActionXCommand
extends WorkflowXCommand<Void> {
    private final String actionId;
    private final String externalStatus;
    private WorkflowActionBean wfactionBean;
    private int earlyRequeueCount;

    public CompletedActionXCommand(String actionId, String externalStatus, Properties actionData, int priority, int earlyRequeueCount) {
        super("callback", "callback", priority);
        this.actionId = ParamChecker.notEmpty(actionId, "actionId");
        this.externalStatus = ParamChecker.notEmpty(externalStatus, "externalStatus");
        this.earlyRequeueCount = earlyRequeueCount;
    }

    public CompletedActionXCommand(String actionId, String externalStatus, Properties actionData, int priority) {
        this(actionId, externalStatus, actionData, 1, 0);
    }

    public CompletedActionXCommand(String actionId, String externalStatus, Properties actionData) {
        this(actionId, externalStatus, actionData, 1);
    }

    @Override
    protected void setLogInfo() {
        LogUtils.setLogInfo(this.actionId);
    }

    @Override
    protected void eagerLoadState() throws CommandException {
        try {
            this.wfactionBean = WorkflowActionQueryExecutor.getInstance().get(WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTION_COMPLETED, this.actionId);
        }
        catch (Exception ex) {
            throw new CommandException(ErrorCode.E0603, ex.getMessage(), ex);
        }
        LogUtils.setLogInfo(this.wfactionBean);
    }

    @Override
    protected void eagerVerifyPrecondition() throws CommandException, PreconditionException {
        if (this.wfactionBean.getStatus() != WorkflowAction.Status.RUNNING && this.wfactionBean.getStatus() != WorkflowAction.Status.PREP) {
            throw new CommandException(ErrorCode.E0800, this.actionId, this.wfactionBean.getStatus());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Void execute() throws CommandException {
        if (this.wfactionBean.getStatus() == WorkflowAction.Status.PREP) {
            int maxEarlyRequeueCount = Services.get().get(CallbackService.class).getEarlyRequeueMaxRetries();
            if (this.earlyRequeueCount >= maxEarlyRequeueCount) throw new CommandException(ErrorCode.E0822, this.actionId);
            long delay = this.getRequeueDelay();
            this.LOG.warn("Received early callback for action still in PREP state; will wait [{0}]ms and requeue up to [{1}] more times", delay, maxEarlyRequeueCount - this.earlyRequeueCount);
            this.queue(new CompletedActionXCommand(this.actionId, this.externalStatus, null, this.getPriority(), this.earlyRequeueCount + 1), delay);
            return null;
        } else {
            ActionExecutor executor = Services.get().get(ActionService.class).getExecutor(this.wfactionBean.getType());
            if (!executor.isCompleted(this.externalStatus)) return null;
            this.queue(new ActionCheckXCommand(this.wfactionBean.getId(), this.getPriority(), -1));
        }
        return null;
    }

    @Override
    public String getEntityKey() {
        return null;
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }

    @Override
    protected void loadState() throws CommandException {
        this.eagerLoadState();
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        this.eagerVerifyPrecondition();
    }
}

