/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.SLAEventBean;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.XException;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.control.ForkActionExecutor;
import org.apache.oozie.action.control.StartActionExecutor;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.SLAEvent;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.wf.ActionKillXCommand;
import org.apache.oozie.command.wf.ActionStartXCommand;
import org.apache.oozie.command.wf.ActionXCommand;
import org.apache.oozie.command.wf.ForkedActionStartXCommand;
import org.apache.oozie.command.wf.SubmitXCommand;
import org.apache.oozie.command.wf.SuspendXCommand;
import org.apache.oozie.command.wf.WfEndXCommand;
import org.apache.oozie.command.wf.WorkflowNotificationXCommand;
import org.apache.oozie.command.wf.WorkflowXCommand;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowActionQueryExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.service.ActionService;
import org.apache.oozie.service.CallableQueueService;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.ELService;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.service.WorkflowStoreService;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.InstrumentUtils;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.apache.oozie.util.db.SLADbXOperations;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.lite.KillNodeDef;
import org.apache.oozie.workflow.lite.NodeDef;
import org.jdom.Element;

public class SignalXCommand
extends WorkflowXCommand<Void> {
    private JPAService jpaService = null;
    private String jobId;
    private String actionId;
    private WorkflowJobBean wfJob;
    private WorkflowActionBean wfAction;
    private List<BatchQueryExecutor.UpdateEntry> updateList = new ArrayList<BatchQueryExecutor.UpdateEntry>();
    private List<JsonBean> insertList = new ArrayList<JsonBean>();
    private boolean generateEvent = false;
    private String wfJobErrorCode;
    private String wfJobErrorMsg;
    public static final String FORK_PARALLEL_JOBSUBMISSION = "oozie.workflow.parallel.fork.action.start";

    public SignalXCommand(String name, int priority, String jobId) {
        super(name, name, priority);
        this.jobId = ParamChecker.notEmpty(jobId, "jobId");
    }

    public SignalXCommand(String jobId, String actionId) {
        this("signal", 1, jobId);
        this.actionId = ParamChecker.notEmpty(actionId, "actionId");
    }

    @Override
    protected void setLogInfo() {
        if (this.jobId != null) {
            LogUtils.setLogInfo(this.jobId);
        } else if (this.actionId != null) {
            LogUtils.setLogInfo(this.actionId);
        }
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    public String getEntityKey() {
        return this.jobId;
    }

    @Override
    public String getKey() {
        return this.getName() + "_" + this.jobId + "_" + this.actionId;
    }

    @Override
    protected void loadState() throws CommandException {
        block4: {
            try {
                this.jpaService = Services.get().get(JPAService.class);
                if (this.jpaService != null) {
                    this.wfJob = WorkflowJobQueryExecutor.getInstance().get(WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW, this.jobId);
                    LogUtils.setLogInfo(this.wfJob);
                    if (this.actionId != null) {
                        this.wfAction = WorkflowActionQueryExecutor.getInstance().get(WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTION_SIGNAL, this.actionId);
                        LogUtils.setLogInfo(this.wfAction);
                    }
                    break block4;
                }
                throw new CommandException(ErrorCode.E0610, new Object[0]);
            }
            catch (XException ex) {
                throw new CommandException(ex);
            }
        }
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        if (this.wfAction == null || this.wfAction.isComplete() && this.wfAction.isPending()) {
            if (this.wfJob.getStatus() != WorkflowJob.Status.RUNNING && this.wfJob.getStatus() != WorkflowJob.Status.PREP) {
                throw new PreconditionException(ErrorCode.E0813, this.wfJob.getStatusStr());
            }
        } else {
            throw new PreconditionException(ErrorCode.E0814, this.actionId, this.wfAction.getStatusStr(), this.wfAction.isPending());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Void execute() throws CommandException {
        this.LOG.debug("STARTED SignalCommand for jobid=" + this.jobId + ", actionId=" + this.actionId);
        WorkflowInstance workflowInstance = this.wfJob.getWorkflowInstance();
        workflowInstance.setTransientVar("oozie.workflow.workflow.bean", this.wfJob);
        WorkflowJob.Status prevStatus = this.wfJob.getStatus();
        boolean completed = false;
        boolean skipAction = false;
        WorkflowActionBean syncAction = null;
        ArrayList<WorkflowActionBean> workflowActionBeanListForForked = new ArrayList<WorkflowActionBean>();
        if (this.wfAction == null) {
            if (this.wfJob.getStatus() != WorkflowJob.Status.PREP) throw new CommandException(ErrorCode.E0801, this.wfJob.getId());
            try {
                completed = workflowInstance.start();
            }
            catch (WorkflowException e) {
                throw new CommandException(e);
            }
            this.wfJob.setStatus(WorkflowJob.Status.RUNNING);
            this.wfJob.setStartTime(new Date());
            this.wfJob.setWorkflowInstance(workflowInstance);
            this.generateEvent = true;
            SLAEventBean slaEvent = SLADbXOperations.createStatusEvent(this.wfJob.getSlaXml(), this.jobId, SLAEvent.Status.STARTED, SLAEvent.SlaAppType.WORKFLOW_JOB);
            if (slaEvent != null) {
                this.insertList.add(slaEvent);
            }
            this.createSLARegistrationForAllActions(workflowInstance.getApp().getDefinition(), this.wfJob.getUser(), this.wfJob.getGroup(), this.wfJob.getConf());
            this.queue(new WorkflowNotificationXCommand(this.wfJob));
        } else {
            WorkflowInstance.Status initialStatus = workflowInstance.getStatus();
            String skipVar = workflowInstance.getVar(this.wfAction.getName() + "#" + "TO_SKIP");
            if (skipVar != null) {
                skipAction = skipVar.equals("true");
            }
            try {
                completed = workflowInstance.signal(this.wfAction.getExecutionPath(), this.wfAction.getSignalValue());
            }
            catch (WorkflowException e) {
                this.LOG.error((Object)("Workflow action failed : " + e.getMessage()), e);
                this.wfJob.setStatus(WorkflowJob.Status.valueOf((String)workflowInstance.getStatus().toString()));
                completed = true;
            }
            this.wfJob.setWorkflowInstance(workflowInstance);
            this.wfAction.resetPending();
            if (!skipAction) {
                this.wfAction.setTransition(workflowInstance.getTransition(this.wfAction.getName()));
                this.queue(new WorkflowNotificationXCommand(this.wfJob, this.wfAction));
            }
            this.updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowActionQueryExecutor.WorkflowActionQuery>(WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION_PENDING_TRANS, this.wfAction));
            WorkflowInstance.Status endStatus = workflowInstance.getStatus();
            if (endStatus != initialStatus) {
                this.generateEvent = true;
            }
        }
        if (completed) {
            NodeDef nodeDef;
            try {
                for (String actionToKillId : WorkflowStoreService.getActionsToKill(workflowInstance)) {
                    WorkflowActionBean actionToKill = WorkflowActionQueryExecutor.getInstance().get(WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTION_ID_TYPE_LASTCHECK, actionToKillId);
                    actionToKill.setPending();
                    actionToKill.setStatus(WorkflowAction.Status.KILLED);
                    this.updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowActionQueryExecutor.WorkflowActionQuery>(WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION_STATUS_PENDING, actionToKill));
                    this.queue(new ActionKillXCommand(actionToKill.getId(), actionToKill.getType()));
                }
                for (String actionToFailId : WorkflowStoreService.getActionsToFail(workflowInstance)) {
                    WorkflowActionBean actionToFail = WorkflowActionQueryExecutor.getInstance().get(WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTION_FAIL, actionToFailId);
                    actionToFail.resetPending();
                    actionToFail.setStatus(WorkflowAction.Status.FAILED);
                    if (this.wfJobErrorCode != null) {
                        this.wfJobErrorCode = actionToFail.getErrorCode();
                        this.wfJobErrorMsg = actionToFail.getErrorMessage();
                    }
                    this.queue(new WorkflowNotificationXCommand(this.wfJob, actionToFail));
                    SLAEventBean slaEvent = SLADbXOperations.createStatusEvent(this.wfAction.getSlaXml(), this.wfAction.getId(), SLAEvent.Status.FAILED, SLAEvent.SlaAppType.WORKFLOW_ACTION);
                    if (slaEvent != null) {
                        this.insertList.add(slaEvent);
                    }
                    this.updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowActionQueryExecutor.WorkflowActionQuery>(WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION_STATUS_PENDING, actionToFail));
                }
            }
            catch (JPAExecutorException je) {
                throw new CommandException(je);
            }
            this.wfJob.setStatus(WorkflowJob.Status.valueOf((String)workflowInstance.getStatus().toString()));
            this.wfJob.setEndTime(new Date());
            this.wfJob.setWorkflowInstance(workflowInstance);
            SLAEvent.Status slaStatus = SLAEvent.Status.SUCCEEDED;
            switch (this.wfJob.getStatus()) {
                case SUCCEEDED: {
                    slaStatus = SLAEvent.Status.SUCCEEDED;
                    break;
                }
                case KILLED: {
                    slaStatus = SLAEvent.Status.KILLED;
                    break;
                }
                case FAILED: {
                    slaStatus = SLAEvent.Status.FAILED;
                    break;
                }
            }
            SLAEventBean slaEvent = SLADbXOperations.createStatusEvent(this.wfJob.getSlaXml(), this.jobId, slaStatus, SLAEvent.SlaAppType.WORKFLOW_JOB);
            if (slaEvent != null) {
                this.insertList.add(slaEvent);
            }
            this.queue(new WorkflowNotificationXCommand(this.wfJob));
            if (this.wfJob.getStatus() == WorkflowJob.Status.SUCCEEDED) {
                InstrumentUtils.incrJobCounter("succeeded", 1, this.getInstrumentation());
            }
            if (this.wfAction != null && (nodeDef = workflowInstance.getNodeDef(this.wfAction.getExecutionPath())) != null && nodeDef instanceof KillNodeDef) {
                boolean isRetry = false;
                boolean isUserRetry = false;
                ActionXCommand.ActionExecutorContext context = new ActionXCommand.ActionExecutorContext(this.wfJob, this.wfAction, isRetry, isUserRetry);
                InstrumentUtils.incrJobCounter("killed", 1, this.getInstrumentation());
                try {
                    String tmpNodeConf = nodeDef.getConf();
                    String message = context.getELEvaluator().evaluate(tmpNodeConf, String.class);
                    this.LOG.debug("Try to resolve KillNode message for jobid [{0}], actionId [{1}], before resolve [{2}], after resolve [{3}]", this.jobId, this.actionId, tmpNodeConf, message);
                    if (this.wfAction.getErrorCode() != null) {
                        this.wfAction.setErrorInfo(this.wfAction.getErrorCode(), message);
                    } else {
                        this.wfAction.setErrorInfo(ErrorCode.E0729.toString(), message);
                    }
                }
                catch (Exception ex) {
                    this.LOG.warn("Exception in SignalXCommand when processing Kill node message: {0}", ex.getMessage(), ex);
                    this.wfAction.setErrorInfo(ErrorCode.E0756.toString(), ErrorCode.E0756.format(ex.getMessage()));
                    this.wfAction.setStatus(WorkflowAction.Status.ERROR);
                }
                this.updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowActionQueryExecutor.WorkflowActionQuery>(WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION_PENDING_TRANS_ERROR, this.wfAction));
            }
        } else {
            for (WorkflowActionBean newAction : WorkflowStoreService.getActionsToStart(workflowInstance)) {
                boolean isOldWFAction;
                block55: {
                    isOldWFAction = false;
                    if ("sub-workflow".equals(newAction.getType())) {
                        try {
                            WorkflowActionBean oldAction = WorkflowActionQueryExecutor.getInstance().get(WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTION_CHECK, newAction.getId());
                            newAction.setExternalId(oldAction.getExternalId());
                            newAction.setCreatedTime(oldAction.getCreatedTime());
                            isOldWFAction = true;
                        }
                        catch (JPAExecutorException e) {
                            if (e.getErrorCode() == ErrorCode.E0605) break block55;
                            throw new CommandException(e);
                        }
                    }
                }
                String skipVar = workflowInstance.getVar(newAction.getName() + "#" + "TO_SKIP");
                boolean skipNewAction = false;
                boolean suspendNewAction = false;
                if (skipVar != null) {
                    skipNewAction = skipVar.equals("true");
                }
                if (skipNewAction) {
                    WorkflowActionBean oldAction = new WorkflowActionBean();
                    oldAction.setId(newAction.getId());
                    oldAction.setPending();
                    oldAction.setExecutionPath(newAction.getExecutionPath());
                    this.updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowActionQueryExecutor.WorkflowActionQuery>(WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION_PENDING, oldAction));
                    this.queue(new SignalXCommand(this.jobId, oldAction.getId()));
                    continue;
                }
                if (!skipAction) {
                    try {
                        WorkflowActionQueryExecutor.getInstance().get(WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTION_ID_TYPE_LASTCHECK, newAction.getId());
                        continue;
                    }
                    catch (JPAExecutorException jee) {
                        // empty catch block
                    }
                }
                suspendNewAction = this.checkForSuspendNode(newAction);
                newAction.setPending();
                String actionSlaXml = this.getActionSLAXml(newAction.getName(), workflowInstance.getApp().getDefinition(), this.wfJob.getConf());
                newAction.setSlaXml(actionSlaXml);
                if (!isOldWFAction) {
                    newAction.setCreatedTime(new Date());
                    this.insertList.add(newAction);
                } else {
                    this.updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowActionQueryExecutor.WorkflowActionQuery>(WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION_START, newAction));
                }
                this.LOG.debug("SignalXCommand: Name: " + newAction.getName() + ", Id: " + newAction.getId() + ", Authcode:" + newAction.getCred());
                if (this.wfAction != null) {
                    ActionService as = Services.get().get(ActionService.class);
                    ActionExecutor current = as.getExecutor(this.wfAction.getType());
                    this.LOG.trace("Current Action Type:" + current.getClass());
                    if (!suspendNewAction) {
                        if (current instanceof StartActionExecutor) {
                            this.queue(new ActionStartXCommand(newAction.getId(), newAction.getType()));
                            continue;
                        }
                        if (current instanceof ForkActionExecutor) {
                            if (ConfigurationService.getBoolean(FORK_PARALLEL_JOBSUBMISSION)) {
                                workflowActionBeanListForForked.add(newAction);
                                continue;
                            }
                            this.queue(new ActionStartXCommand(newAction.getId(), newAction.getType()));
                            continue;
                        }
                        syncAction = newAction;
                        continue;
                    }
                    if (!ConfigurationService.getBoolean(FORK_PARALLEL_JOBSUBMISSION)) continue;
                    workflowActionBeanListForForked.add(newAction);
                    continue;
                }
                syncAction = newAction;
            }
        }
        try {
            this.wfJob.setLastModifiedTime(new Date());
            this.updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowJobQueryExecutor.WorkflowJobQuery>(WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MOD_START_END, this.wfJob));
            BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(this.insertList, this.updateList, null);
            if (prevStatus != this.wfJob.getStatus()) {
                this.LOG.debug("Updated the workflow status to " + this.wfJob.getId() + "  status =" + this.wfJob.getStatusStr());
            }
            if (this.generateEvent && EventHandlerService.isEnabled()) {
                SignalXCommand.generateEvent(this.wfJob, this.wfJobErrorCode, this.wfJobErrorMsg);
            }
        }
        catch (JPAExecutorException je) {
            throw new CommandException(je);
        }
        if (this.wfJob.getStatus() != WorkflowJob.Status.RUNNING && this.wfJob.getStatus() != WorkflowJob.Status.SUSPENDED) {
            this.updateParentIfNecessary(this.wfJob);
            new WfEndXCommand(this.wfJob).call();
        } else if (syncAction != null) {
            new ActionStartXCommand(this.wfJob, syncAction.getId(), syncAction.getType()).call();
        } else if (!workflowActionBeanListForForked.isEmpty() && !this.checkForSuspendNode(workflowActionBeanListForForked)) {
            this.startForkedActions(workflowActionBeanListForForked);
        }
        this.LOG.debug("ENDED SignalCommand for jobid=" + this.jobId + ", actionId=" + this.actionId);
        return null;
    }

    public void startForkedActions(List<WorkflowActionBean> workflowActionBeanListForForked) throws CommandException {
        ArrayList tasks = new ArrayList();
        ArrayList<BatchQueryExecutor.UpdateEntry> updateList = new ArrayList<BatchQueryExecutor.UpdateEntry>();
        ArrayList<JsonBean> insertList = new ArrayList<JsonBean>();
        boolean endWorkflow = false;
        boolean submitJobByQueuing = false;
        for (WorkflowActionBean workflowActionBean : workflowActionBeanListForForked) {
            this.LOG.debug("Starting forked actions parallely : " + workflowActionBean.getId());
            CallableQueueService callableQueueService = Services.get().get(CallableQueueService.class);
            callableQueueService.getClass();
            tasks.add(callableQueueService.new CallableQueueService.CallableWrapper<ActionXCommand.ActionExecutorContext>(new ForkedActionStartXCommand(this.wfJob, workflowActionBean.getId(), workflowActionBean.getType()), 0L));
        }
        try {
            List futures = Services.get().get(CallableQueueService.class).invokeAll(tasks);
            for (Future result : futures) {
                if (result == null) {
                    submitJobByQueuing = true;
                    continue;
                }
                ActionXCommand.ActionExecutorContext context = (ActionXCommand.ActionExecutorContext)result.get();
                Map<String, String> contextVariableMap = ((ActionXCommand.ForkedActionExecutorContext)context).getContextMap();
                this.LOG.debug("contextVariableMap size of action " + context.getAction().getId() + " is " + contextVariableMap.size());
                for (String key : contextVariableMap.keySet()) {
                    context.setVarToWorkflow(key, contextVariableMap.get(key));
                }
                if (context.getJobStatus() != null && context.getJobStatus().equals((Object)Job.Status.FAILED)) {
                    this.LOG.warn("Action has failed, failing job" + context.getAction().getId());
                    new ActionStartXCommand(context.getAction().getId(), null).failJob(context);
                    updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowActionQueryExecutor.WorkflowActionQuery>(WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION_START, (WorkflowActionBean)context.getAction()));
                    if (context.isShouldEndWF()) {
                        endWorkflow = true;
                    }
                }
                if (context.getJobStatus() == null || !context.getJobStatus().equals((Object)Job.Status.SUSPENDED)) continue;
                this.LOG.warn("Action has failed, failing job" + context.getAction().getId());
                new ActionStartXCommand(context.getAction().getId(), null).handleNonTransient(context, null, WorkflowAction.Status.START_MANUAL);
                updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowActionQueryExecutor.WorkflowActionQuery>(WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION_START, (WorkflowActionBean)context.getAction()));
                if (!context.isShouldEndWF()) continue;
                endWorkflow = true;
            }
            if (endWorkflow) {
                this.endWF(insertList);
            }
        }
        catch (Exception e) {
            this.LOG.error((Object)"Error running forked jobs parallely", e);
            this.startForkedActionsByQueuing(workflowActionBeanListForForked);
            submitJobByQueuing = false;
        }
        if (submitJobByQueuing && !endWorkflow) {
            this.LOG.error("There is error in running forked jobs parallely");
            this.startForkedActionsByQueuing(workflowActionBeanListForForked);
        }
        this.wfJob.setLastModifiedTime(new Date());
        updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowJobQueryExecutor.WorkflowJobQuery>(WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MODIFIED, this.wfJob));
        try {
            BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(insertList, updateList, null);
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
        this.LOG.debug("forked actions submitted parallely");
    }

    public void startForkedActionsByQueuing(List<WorkflowActionBean> workflowActionBeanListForForked) throws CommandException {
        for (WorkflowActionBean workflowActionBean : workflowActionBeanListForForked) {
            this.LOG.debug("Queuing fork action " + workflowActionBean.getId());
            this.queue(new ActionStartXCommand(workflowActionBean.getId(), workflowActionBean.getType()));
        }
    }

    private void endWF(List<JsonBean> insertList) throws CommandException {
        this.updateParentIfNecessary(this.wfJob, 3);
        new WfEndXCommand(this.wfJob).call();
        SLAEventBean slaEvent2 = SLADbXOperations.createStatusEvent(this.wfJob.getSlaXml(), this.wfJob.getId(), SLAEvent.Status.FAILED, SLAEvent.SlaAppType.WORKFLOW_JOB);
        if (slaEvent2 != null) {
            insertList.add(slaEvent2);
        }
    }

    public static ELEvaluator createELEvaluatorForGroup(Configuration conf, String group) {
        ELEvaluator eval = Services.get().get(ELService.class).createEvaluator(group);
        for (Map.Entry entry : conf) {
            eval.setVariable((String)entry.getKey(), entry.getValue());
        }
        return eval;
    }

    private String getActionSLAXml(String actionName, String wfXml, String wfConf) throws CommandException {
        String slaXml = null;
        try {
            Element eWfJob = XmlUtils.parseXml(wfXml);
            for (Element action : eWfJob.getChildren("action", eWfJob.getNamespace())) {
                Element eSla;
                if (!action.getAttributeValue("name").equals(actionName) || (eSla = XmlUtils.getSLAElement(action)) == null) continue;
                slaXml = XmlUtils.prettyPrint(eSla).toString();
                break;
            }
        }
        catch (Exception e) {
            throw new CommandException(ErrorCode.E1004, e.getMessage(), e);
        }
        return slaXml;
    }

    private String resolveSla(Element eSla, Configuration conf) throws CommandException {
        String slaXml = null;
        try {
            ELEvaluator evalSla = SubmitXCommand.createELEvaluatorForGroup(conf, "wf-sla-submit");
            slaXml = SubmitXCommand.resolveSla(eSla, evalSla);
        }
        catch (Exception e) {
            throw new CommandException(ErrorCode.E1004, e.getMessage(), e);
        }
        return slaXml;
    }

    private void createSLARegistrationForAllActions(String wfXml, String user, String group, String strConf) throws CommandException {
        try {
            Element eWfJob = XmlUtils.parseXml(wfXml);
            XConfiguration conf = new XConfiguration(new StringReader(strConf));
            for (Element action : eWfJob.getChildren("action", eWfJob.getNamespace())) {
                String actionId;
                String slaXml;
                SLAEventBean slaEvent;
                Element eSla = XmlUtils.getSLAElement(action);
                if (eSla == null || (slaEvent = SLADbXOperations.createSlaRegistrationEvent(eSla = XmlUtils.parseXml(slaXml = this.resolveSla(eSla, conf)), actionId = Services.get().get(UUIDService.class).generateChildId(this.jobId, action.getAttributeValue("name") + ""), SLAEvent.SlaAppType.WORKFLOW_ACTION, user, group)) == null) continue;
                this.insertList.add(slaEvent);
            }
        }
        catch (Exception e) {
            throw new CommandException(ErrorCode.E1007, "workflow:Actions " + this.jobId, e.getMessage(), e);
        }
    }

    private boolean checkForSuspendNode(WorkflowActionBean newAction) {
        boolean suspendNewAction;
        block4: {
            suspendNewAction = false;
            try {
                XConfiguration wfjobConf = new XConfiguration(new StringReader(this.wfJob.getConf()));
                String[] values = wfjobConf.getTrimmedStrings("oozie.suspend.on.nodes");
                if (values == null) break block4;
                if (values.length == 1 && values[0].equals("*")) {
                    this.LOG.info("Reached suspend node at [{0}], suspending workflow [{1}]", newAction.getName(), this.wfJob.getId());
                    this.queue(new SuspendXCommand(this.jobId));
                    suspendNewAction = true;
                    break block4;
                }
                for (String suspendPoint : values) {
                    if (!suspendPoint.equals(newAction.getName())) continue;
                    this.LOG.info("Reached suspend node at [{0}], suspending workflow [{1}]", newAction.getName(), this.wfJob.getId());
                    this.queue(new SuspendXCommand(this.jobId));
                    suspendNewAction = true;
                    break;
                }
            }
            catch (IOException ex) {
                this.LOG.warn("Error reading oozie.suspend.on.nodes, ignoring [{0}]", ex.getMessage());
            }
        }
        return suspendNewAction;
    }

    private boolean checkForSuspendNode(List<WorkflowActionBean> workflowActionBeanListForForked) {
        for (WorkflowActionBean bean : workflowActionBeanListForForked) {
            if (!this.checkForSuspendNode(bean)) continue;
            return true;
        }
        return false;
    }
}

