/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.coord.input.logic;

import java.util.Date;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.NamespaceResolver;
import org.apache.commons.lang.StringUtils;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.coord.CoordUtils;
import org.apache.oozie.coord.SyncCoordAction;
import org.apache.oozie.coord.input.dependency.CoordPullInputDependency;
import org.apache.oozie.coord.input.dependency.CoordPushInputDependency;
import org.apache.oozie.coord.input.logic.CoordInputLogicBuilder;
import org.apache.oozie.coord.input.logic.CoordInputLogicEvaluatorPhaseOne;
import org.apache.oozie.coord.input.logic.CoordInputLogicEvaluatorPhaseThree;
import org.apache.oozie.coord.input.logic.CoordInputLogicEvaluatorPhaseTwo;
import org.apache.oozie.coord.input.logic.CoordInputLogicEvaluatorPhaseValidate;
import org.apache.oozie.coord.input.logic.CoordInputLogicEvaluatorResult;
import org.apache.oozie.coord.input.logic.InputLogicParser;
import org.apache.oozie.coord.input.logic.OozieJexlEngine;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;
import org.jdom.JDOMException;

public class CoordInputLogicEvaluatorUtil {
    private CoordinatorActionBean coordAction = null;
    private XLog log = XLog.getLog(this.getClass());

    public CoordInputLogicEvaluatorUtil(CoordinatorActionBean coordAction) {
        this.coordAction = coordAction;
        LogUtils.setLogInfo(coordAction);
    }

    public CoordInputLogicEvaluatorUtil() {
    }

    public boolean checkPullMissingDependencies() throws JDOMException {
        OozieJexlEngine jexl = new OozieJexlEngine();
        String expression = CoordUtils.getInputLogic(this.coordAction.getActionXml().toString());
        if (StringUtils.isEmpty((String)expression)) {
            return true;
        }
        Expression e = jexl.createExpression(expression);
        OozieJexlParser jc = new OozieJexlParser(jexl, new CoordInputLogicBuilder(new CoordInputLogicEvaluatorPhaseOne(this.coordAction, this.coordAction.getPullInputDependencies())));
        CoordInputLogicEvaluatorResult result = (CoordInputLogicEvaluatorResult)e.evaluate((JexlContext)jc);
        this.log.debug("Input logic expression for [{0}] and evaluate result is [{1}]", new Object[]{expression, result.getStatus()});
        if (result.isWaiting()) {
            return false;
        }
        return result.isTrue();
    }

    public void validateInputLogic() throws JDOMException, CommandException {
        OozieJexlEngine jexl = new OozieJexlEngine();
        String expression = CoordUtils.getInputLogic(this.coordAction.getActionXml().toString());
        if (StringUtils.isEmpty((String)expression)) {
            return;
        }
        Expression e = jexl.createExpression(expression);
        OozieJexlParser jc = new OozieJexlParser(jexl, new CoordInputLogicBuilder(new CoordInputLogicEvaluatorPhaseValidate(this.coordAction)));
        try {
            Object result = e.evaluate((JexlContext)jc);
            this.log.debug("Input logic expression is [{0}] and evaluate result is [{1}]", expression, result);
        }
        catch (RuntimeException re) {
            throw new CommandException(ErrorCode.E1028, re.getCause().getMessage());
        }
    }

    public String getInputDependencies(String name, SyncCoordAction syncCoordAction) throws JDOMException {
        OozieJexlEngine jexl = new OozieJexlEngine();
        CoordinatorActionBean coordAction = new CoordinatorActionBean();
        ELEvaluator eval = ELEvaluator.getCurrent();
        coordAction.setId(syncCoordAction.getActionId());
        Element eJob = XmlUtils.parseXml(eval.getVariable(".actionInputLogic").toString());
        String expression = new InputLogicParser().parseWithName(eJob, name);
        Expression e = jexl.createExpression(expression);
        CoordPullInputDependency pull = (CoordPullInputDependency)syncCoordAction.getPullDependencies();
        CoordPushInputDependency push = (CoordPushInputDependency)syncCoordAction.getPushDependencies();
        coordAction.setPushInputDependencies(push);
        coordAction.setPullInputDependencies(pull);
        OozieJexlParser jc = new OozieJexlParser(jexl, new CoordInputLogicBuilder(new CoordInputLogicEvaluatorPhaseThree(coordAction, eval)));
        CoordInputLogicEvaluatorResult result = (CoordInputLogicEvaluatorResult)e.evaluate((JexlContext)jc);
        if (result == null || !result.isTrue()) {
            this.log.debug("Input logic expression for [{0}] is [{1}] and it is not resolved", name, expression);
            return "${coord:dataIn('" + name + "')}";
        }
        this.log.debug("Input logic expression for [{0}] is [{1}] and evaluate result is [{2}]", new Object[]{name, expression, result.getStatus()});
        return result.getDataSets();
    }

    public boolean checkPushDependencies() throws JDOMException {
        OozieJexlEngine jexl = new OozieJexlEngine();
        String expression = CoordUtils.getInputLogic(this.coordAction.getActionXml().toString());
        if (StringUtils.isEmpty((String)expression)) {
            return true;
        }
        Expression e = jexl.createExpression(expression);
        OozieJexlParser jc = new OozieJexlParser(jexl, new CoordInputLogicBuilder(new CoordInputLogicEvaluatorPhaseOne(this.coordAction, this.coordAction.getPushInputDependencies())));
        CoordInputLogicEvaluatorResult result = (CoordInputLogicEvaluatorResult)e.evaluate((JexlContext)jc);
        this.log.debug("Input logic expression for [{0}] and evaluate result is [{1}]", new Object[]{expression, result.getStatus()});
        if (result.isWaiting()) {
            return false;
        }
        return result.isTrue();
    }

    public boolean checkUnResolved(Date actualTime) throws JDOMException {
        OozieJexlEngine jexl = new OozieJexlEngine();
        String expression = CoordUtils.getInputLogic(this.coordAction.getActionXml().toString());
        if (StringUtils.isEmpty((String)expression)) {
            return true;
        }
        Expression e = jexl.createExpression(expression);
        OozieJexlParser jc = new OozieJexlParser(jexl, new CoordInputLogicBuilder(new CoordInputLogicEvaluatorPhaseTwo(this.coordAction, actualTime)));
        CoordInputLogicEvaluatorResult result = (CoordInputLogicEvaluatorResult)e.evaluate((JexlContext)jc);
        this.log.debug("Input logic expression for [{0}] and evaluate result is [{1}]", new Object[]{expression, result.getStatus()});
        if (result.isWaiting()) {
            return false;
        }
        return result.isTrue();
    }

    public class OozieJexlParser
    implements JexlContext,
    NamespaceResolver {
        private final JexlEngine jexl;
        private final CoordInputLogicBuilder object;

        public Object resolveNamespace(String name) {
            return this.object;
        }

        public OozieJexlParser(JexlEngine engine, CoordInputLogicBuilder wrapped) {
            this.jexl = engine;
            this.object = wrapped;
        }

        public Object get(String name) {
            return this.jexl.getProperty((Object)this.object, name);
        }

        public void set(String name, Object value) {
            this.jexl.setProperty((Object)this.object, name, value);
        }

        public boolean has(String name) {
            return this.jexl.getUberspect().getPropertyGet((Object)this.object, (Object)name, null) != null;
        }
    }
}

