/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.dependency;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.action.hadoop.FSLauncherURIHandler;
import org.apache.oozie.action.hadoop.LauncherURIHandler;
import org.apache.oozie.dependency.URIHandler;
import org.apache.oozie.dependency.URIHandlerException;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;

public class FSURIHandler
implements URIHandler {
    private HadoopAccessorService service;
    private Set<String> supportedSchemes;
    private List<Class<?>> classesToShip;

    @Override
    public void init(Configuration conf) {
        this.service = Services.get().get(HadoopAccessorService.class);
        this.supportedSchemes = this.service.getSupportedSchemes();
        this.classesToShip = new FSLauncherURIHandler().getClassesForLauncher();
    }

    @Override
    public Set<String> getSupportedSchemes() {
        return this.supportedSchemes;
    }

    @Override
    public Class<? extends LauncherURIHandler> getLauncherURIHandlerClass() {
        return FSLauncherURIHandler.class;
    }

    @Override
    public List<Class<?>> getClassesForLauncher() {
        return this.classesToShip;
    }

    @Override
    public URIHandler.DependencyType getDependencyType(URI uri) throws URIHandlerException {
        return URIHandler.DependencyType.PULL;
    }

    @Override
    public void registerForNotification(URI uri, Configuration conf, String user, String actionID) throws URIHandlerException {
        throw new UnsupportedOperationException("Notifications are not supported for " + uri.getScheme());
    }

    @Override
    public boolean unregisterFromNotification(URI uri, String actionID) {
        throw new UnsupportedOperationException("Notifications are not supported for " + uri.getScheme());
    }

    @Override
    public URIHandler.Context getContext(URI uri, Configuration conf, String user, boolean readOnly) throws URIHandlerException {
        FileSystem fs = this.getFileSystem(uri, conf, user);
        return new FSContext(conf, user, fs);
    }

    @Override
    public boolean exists(URI uri, URIHandler.Context context) throws URIHandlerException {
        try {
            FileSystem fs = ((FSContext)context).getFileSystem();
            return fs.exists(this.getNormalizedPath(uri));
        }
        catch (IOException e) {
            throw new HadoopAccessorException(ErrorCode.E0902, e);
        }
    }

    @Override
    public boolean exists(URI uri, Configuration conf, String user) throws URIHandlerException {
        try {
            FileSystem fs = this.getFileSystem(uri, conf, user);
            return fs.exists(this.getNormalizedPath(uri));
        }
        catch (HadoopAccessorException e) {
            if (ErrorCode.E0902.equals((Object)e.getErrorCode()) && e.getMessage() != null && e.getMessage().indexOf("Invalid path for the Har Filesystem. No index file") != -1) {
                return false;
            }
            throw e;
        }
        catch (IOException e) {
            throw new HadoopAccessorException(ErrorCode.E0902, e);
        }
    }

    @Override
    public String getURIWithDoneFlag(String uri, String doneFlag) throws URIHandlerException {
        if (doneFlag.length() > 0) {
            uri = uri + "/" + doneFlag;
        }
        return uri;
    }

    @Override
    public String getURIWithoutDoneFlag(String uri, String doneFlag) throws URIHandlerException {
        if (doneFlag.length() > 0 && uri.endsWith(doneFlag)) {
            return uri.substring(0, uri.lastIndexOf("/" + doneFlag));
        }
        return uri;
    }

    @Override
    public void validate(String uri) throws URIHandlerException {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void delete(URI uri, URIHandler.Context context) throws URIHandlerException {
        FileSystem fs = ((FSContext)context).getFileSystem();
        Path path = new Path(uri);
        try {
            if (fs.exists(path) && !fs.delete(path, true)) {
                throw new URIHandlerException(ErrorCode.E0907, path.toString());
            }
        }
        catch (IOException e) {
            throw new URIHandlerException(ErrorCode.E0907, path.toString());
        }
    }

    @Override
    public void delete(URI uri, Configuration conf, String user) throws URIHandlerException {
        Path path = new Path(uri);
        FileSystem fs = this.getFileSystem(uri, conf, user);
        try {
            if (fs.exists(path) && !fs.delete(path, true)) {
                throw new URIHandlerException(ErrorCode.E0907, path.toString());
            }
        }
        catch (IOException e) {
            throw new URIHandlerException(ErrorCode.E0907, path.toString());
        }
    }

    private Path getNormalizedPath(URI uri) {
        return new Path(uri.getScheme(), uri.getAuthority(), uri.getPath());
    }

    private FileSystem getFileSystem(URI uri, Configuration conf, String user) throws HadoopAccessorException {
        if (user == null) {
            throw new HadoopAccessorException(ErrorCode.E0902, "user has to be specified to access FileSystem");
        }
        JobConf fsConf = this.service.createJobConf(uri.getAuthority());
        return this.service.createFileSystem(user, uri, (Configuration)fsConf);
    }

    static class FSContext
    extends URIHandler.Context {
        private FileSystem fs;

        public FSContext(Configuration conf, String user, FileSystem fs) {
            super(conf, user);
            this.fs = fs;
        }

        public FileSystem getFileSystem() {
            return this.fs;
        }
    }
}

