/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.XLog;

public abstract class QueryExecutor<T, E extends Enum<E>> {
    private static XLog LOG;

    protected QueryExecutor() {
    }

    public abstract int executeUpdate(E var1, T var2) throws JPAExecutorException;

    public void insert(JsonBean bean) throws JPAExecutorException {
        if (bean != null) {
            JPAService jpaService = Services.get().get(JPAService.class);
            EntityManager em = jpaService.getEntityManager();
            try {
                em.getTransaction().begin();
                em.persist((Object)bean);
                em.getTransaction().commit();
            }
            catch (PersistenceException e) {
                throw new JPAExecutorException(ErrorCode.E0603, new Object[]{e});
            }
            finally {
                if (em.getTransaction().isActive()) {
                    LOG.warn("insert ended with an active transaction, rolling back");
                    em.getTransaction().rollback();
                }
                if (em.isOpen()) {
                    em.close();
                }
            }
        }
    }

    public abstract T get(E var1, Object ... var2) throws JPAExecutorException;

    public abstract List<T> getList(E var1, Object ... var2) throws JPAExecutorException;

    public abstract Query getUpdateQuery(E var1, T var2, EntityManager var3) throws JPAExecutorException;

    public abstract Query getSelectQuery(E var1, EntityManager var2, Object ... var3) throws JPAExecutorException;

    public abstract Object getSingleValue(E var1, Object ... var2) throws JPAExecutorException;

    public abstract T getIfExist(E var1, Object ... var2) throws JPAExecutorException;
}

