/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class WorkflowJobGetJPAExecutor
implements JPAExecutor<WorkflowJobBean> {
    private String wfJobId = null;

    public WorkflowJobGetJPAExecutor(String wfJobId) {
        ParamChecker.notNull(wfJobId, "wfJobId");
        this.wfJobId = wfJobId;
    }

    @Override
    public String getName() {
        return "WorkflowJobGetJPAExecutor";
    }

    @Override
    public WorkflowJobBean execute(EntityManager em) throws JPAExecutorException {
        List wjBeans;
        try {
            Query q = em.createNamedQuery("GET_WORKFLOW");
            q.setParameter("id", (Object)this.wfJobId);
            wjBeans = q.getResultList();
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
        WorkflowJobBean bean = null;
        if (wjBeans != null && wjBeans.size() > 0) {
            bean = (WorkflowJobBean)wjBeans.get(0);
            bean.setStatus(bean.getStatus());
            return bean;
        }
        throw new JPAExecutorException(ErrorCode.E0604, this.wfJobId);
    }
}

