/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.sla.listener;

import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.client.event.JobEvent;
import org.apache.oozie.event.BundleJobEvent;
import org.apache.oozie.event.CoordinatorActionEvent;
import org.apache.oozie.event.CoordinatorJobEvent;
import org.apache.oozie.event.WorkflowActionEvent;
import org.apache.oozie.event.WorkflowJobEvent;
import org.apache.oozie.event.listener.JobEventListener;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.service.SLAService;
import org.apache.oozie.util.XLog;

public class SLAJobEventListener
extends JobEventListener {
    @Override
    public void init(Configuration conf) {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void onWorkflowJobEvent(WorkflowJobEvent event) {
        this.sendEventToSLAService(event, event.getStatus().toString());
    }

    @Override
    public void onWorkflowActionEvent(WorkflowActionEvent event) {
        this.sendEventToSLAService(event, event.getStatus().toString());
    }

    @Override
    public void onCoordinatorJobEvent(CoordinatorJobEvent event) {
        this.sendEventToSLAService(event, event.getStatus().toString());
    }

    @Override
    public void onCoordinatorActionEvent(CoordinatorActionEvent event) {
        this.sendEventToSLAService(event, event.getStatus().toString());
    }

    @Override
    public void onBundleJobEvent(BundleJobEvent wje) {
    }

    private void sendEventToSLAService(JobEvent event, String status) {
        Date startTime = event.getStartTime();
        Date endTime = event.getEndTime();
        try {
            Services.get().get(SLAService.class).addStatusEvent(event.getId(), status, event.getEventStatus(), startTime, endTime);
        }
        catch (ServiceException se) {
            XLog.getLog(SLAService.class).error((Object)"Exception happened while sending Job-Status event for SLA", se);
        }
    }
}

