/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.versionchecker;

import com.ccg.net.ethernet.EthernetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.versionchecker.VersionCheckResourceBundle;
import org.safehaus.uuid.UUID;
import org.safehaus.uuid.UUIDGenerator;

public class UUIDUtil {
    private static Log log;
    static boolean nativeInitialized;
    static UUIDGenerator ug;
    static org.safehaus.uuid.EthernetAddress eAddr;

    public static String getUUIDAsString() {
        return UUIDUtil.getUUID().toString();
    }

    public static UUID getUUID() {
        UUID uuId = ug.generateTimeBasedUUID(eAddr);
        return uuId;
    }

    static {
        UUID olduuId;
        String macAddr;
        log = LogFactory.getLog(UUIDUtil.class);
        nativeInitialized = false;
        ug = UUIDGenerator.getInstance();
        if (nativeInitialized) {
            try {
                EthernetAddress ea = EthernetAddress.getPrimaryAdapter();
                eAddr = new org.safehaus.uuid.EthernetAddress(ea.getBytes());
            }
            catch (Exception ex) {
                log.error((Object)VersionCheckResourceBundle.getString("UUIDUtil.ERROR_0002_GET_MAC_ADDR"), (Throwable)ex);
            }
            catch (UnsatisfiedLinkError ule) {
                log.error((Object)VersionCheckResourceBundle.getString("UUIDUtil.ERROR_0002_GET_MAC_ADDR"), (Throwable)ule);
                nativeInitialized = false;
            }
        }
        if (eAddr == null && (macAddr = System.getProperty("MAC_ADDRESS")) != null) {
            macAddr = macAddr.replace('-', ':');
            eAddr = new org.safehaus.uuid.EthernetAddress(macAddr);
        }
        if (eAddr == null) {
            eAddr = ug.getDummyAddress();
        }
        if ((olduuId = ug.generateTimeBasedUUID(eAddr)) == null) {
            log.error((Object)VersionCheckResourceBundle.getString("UUIDUtil.ERROR_0003_GENERATEFAILED"));
        }
    }
}

