/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.mt;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.pentaho.platform.api.engine.security.userroledao.IPentahoRole;
import org.pentaho.platform.api.engine.security.userroledao.IPentahoUser;
import org.pentaho.platform.api.engine.security.userroledao.IUserRoleDao;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.api.mt.ITenantManager;
import org.pentaho.platform.api.mt.ITenantedPrincipleNameResolver;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.api.repository2.unified.RepositoryFileSid;
import org.pentaho.platform.core.mt.Tenant;
import org.pentaho.platform.repository2.unified.IRepositoryFileAclDao;
import org.pentaho.platform.repository2.unified.IRepositoryFileDao;
import org.pentaho.platform.repository2.unified.ServerRepositoryPaths;
import org.pentaho.platform.repository2.unified.jcr.DefaultPathConversionHelper;
import org.pentaho.platform.repository2.unified.jcr.IPathConversionHelper;
import org.pentaho.platform.repository2.unified.jcr.JcrRepositoryFileUtils;
import org.pentaho.platform.repository2.unified.jcr.JcrTenantUtils;
import org.pentaho.platform.repository2.unified.jcr.PentahoJcrConstants;
import org.pentaho.platform.security.policy.rolebased.IRoleAuthorizationPolicyRoleBindingDao;
import org.springframework.util.Assert;

public abstract class AbstractRepositoryTenantManager
implements ITenantManager {
    public static final String FOLDER_NAME_AUTHZ = ".authz";
    public static final String FOLDER_NAME_ROLEBASED = "roleBased";
    public static final String FOLDER_NAME_RUNTIMEROLES = "runtimeRoles";
    protected IRepositoryFileAclDao repositoryFileAclDao;
    protected IRoleAuthorizationPolicyRoleBindingDao roleBindingDao;
    protected IUserRoleDao userRoleDao;
    protected IRepositoryFileDao repositoryFileDao;
    protected ITenantedPrincipleNameResolver tenantedRoleNameResolver;
    protected ITenantedPrincipleNameResolver tenantedUserNameResolver;
    protected String repositoryAdminUsername;
    protected String tenantAdminRoleName;
    protected String tenantAuthenticatedRoleName;
    protected List<String> singleTenantAuthenticatedAuthorityRoleBindingList;
    protected IPathConversionHelper pathConversionHelper = new DefaultPathConversionHelper();

    protected AbstractRepositoryTenantManager(IRepositoryFileDao contentDao, IUserRoleDao userRoleDao, IRepositoryFileAclDao repositoryFileAclDao, IRoleAuthorizationPolicyRoleBindingDao roleBindingDao, String repositoryAdminUsername, String tenantAuthenticatedAuthorityNamePattern, ITenantedPrincipleNameResolver tenantedUserNameResolver, ITenantedPrincipleNameResolver tenantedRoleNameResolver, String tenantAdminRoleName, List<String> singleTenantAuthenticatedAuthorityRoleBindingList) {
        Assert.notNull((Object)contentDao);
        Assert.notNull((Object)repositoryFileAclDao);
        Assert.notNull((Object)roleBindingDao);
        Assert.hasText((String)repositoryAdminUsername);
        Assert.hasText((String)tenantAuthenticatedAuthorityNamePattern);
        this.repositoryFileDao = contentDao;
        this.repositoryFileAclDao = repositoryFileAclDao;
        this.userRoleDao = userRoleDao;
        this.roleBindingDao = roleBindingDao;
        this.repositoryAdminUsername = repositoryAdminUsername;
        this.tenantAdminRoleName = tenantAdminRoleName;
        this.tenantAuthenticatedRoleName = tenantAuthenticatedAuthorityNamePattern;
        this.tenantedRoleNameResolver = tenantedRoleNameResolver;
        this.tenantedUserNameResolver = tenantedUserNameResolver;
        this.singleTenantAuthenticatedAuthorityRoleBindingList = singleTenantAuthenticatedAuthorityRoleBindingList;
    }

    public void deleteTenants(Session session, List<ITenant> tenants) throws RepositoryException {
        for (ITenant tenant : tenants) {
            this.deleteTenant(session, tenant);
        }
    }

    private void deleteUserRole(Session session, ITenant parentTenant, List<ITenant> tenants) throws RepositoryException {
        for (ITenant tenant : tenants) {
            this.deleteUserRole(session, tenant, this.getChildTenants(session, tenant));
        }
        for (IPentahoRole role : this.userRoleDao.getRoles(parentTenant)) {
            this.userRoleDao.deleteRole(role);
        }
        for (IPentahoUser user : this.userRoleDao.getUsers(parentTenant)) {
            this.userRoleDao.deleteUser(user);
        }
    }

    public void deleteTenant(Session jcrSession, ITenant tenant) throws RepositoryException {
        this.deleteUserRole(jcrSession, tenant, this.getChildTenants(jcrSession, tenant));
        this.repositoryFileDao.permanentlyDeleteFile(this.getTenantRootFolder(jcrSession, tenant).getId(), "tenant delete");
    }

    public void enableTenant(Session session, ITenant tenant, boolean enable) throws ItemNotFoundException, RepositoryException {
        Map<String, Serializable> fileMeta = JcrRepositoryFileUtils.getFileMetadata(session, this.getTenantRootFolder(session, tenant).getId());
        fileMeta.put("isTenantEnabled", Boolean.valueOf(enable));
        JcrRepositoryFileUtils.setFileMetadata(session, this.getTenantRootFolder(session, tenant).getId(), fileMeta);
    }

    public RepositoryFile getTenantRootFolder(ITenant tenant) {
        Map<String, Serializable> metadata;
        RepositoryFile rootFolder = this.repositoryFileDao.getFileByAbsolutePath(tenant.getRootFolderAbsolutePath());
        if (!(rootFolder == null || (metadata = this.repositoryFileDao.getFileMetadata(rootFolder.getId())).containsKey("isTenantRoot") && ((Boolean)metadata.get("isTenantRoot")).booleanValue())) {
            rootFolder = null;
        }
        return rootFolder;
    }

    private RepositoryFile getTenantRootFolder(Session session, ITenant tenant) throws RepositoryException {
        Map<String, Serializable> metadata;
        RepositoryFile rootFolder = JcrRepositoryFileUtils.getFileByAbsolutePath(session, tenant.getRootFolderAbsolutePath(), this.pathConversionHelper, null, false, null);
        if (!(rootFolder == null || (metadata = JcrRepositoryFileUtils.getFileMetadata(session, rootFolder.getId())).containsKey("isTenantRoot") && ((Boolean)metadata.get("isTenantRoot")).booleanValue())) {
            rootFolder = null;
        }
        return rootFolder;
    }

    public void enableTenants(Session session, List<ITenant> tenants, boolean enable) throws ItemNotFoundException, RepositoryException {
        for (ITenant tenant : tenants) {
            this.enableTenant(session, tenant, enable);
        }
    }

    public List<ITenant> getChildTenants(Session session, ITenant parentTenant, boolean includeDisabledTenants) throws RepositoryException {
        ArrayList<ITenant> children = new ArrayList<ITenant>();
        List<RepositoryFile> allChildren = JcrRepositoryFileUtils.getChildren(session, new PentahoJcrConstants(session), this.pathConversionHelper, null, this.getTenantRootFolder(session, parentTenant).getId(), null);
        for (RepositoryFile repoFile : allChildren) {
            Map<String, Serializable> metadata = JcrRepositoryFileUtils.getFileMetadata(session, repoFile.getId());
            if (!metadata.containsKey("isTenantRoot") || !((Boolean)metadata.get("isTenantRoot")).booleanValue()) continue;
            Tenant tenant = new Tenant(repoFile.getPath(), Boolean.valueOf(this.isTenantEnabled(session, repoFile.getId())));
            if (!includeDisabledTenants && !tenant.isEnabled()) continue;
            children.add((ITenant)new Tenant(this.pathConversionHelper.relToAbs(repoFile.getPath()), Boolean.valueOf(this.isTenantEnabled(session, repoFile.getId()))));
        }
        return children;
    }

    public List<ITenant> getChildTenants(Session session, ITenant parentTenant) throws RepositoryException {
        return this.getChildTenants(session, parentTenant, false);
    }

    public void updateTentant(Session jcrSession, String arg0, Map<String, Serializable> arg1) {
    }

    protected void createInitialTenantFolders(Session session, RepositoryFile tenantRootFolder, RepositoryFileSid fileOwnerSid, RepositoryFileSid authenticatedRoleSid) throws RepositoryException {
        this.repositoryFileDao.createFolder(tenantRootFolder.getId(), new RepositoryFile.Builder(ServerRepositoryPaths.getTenantPublicFolderName()).folder(true).build(), new RepositoryFileAcl.Builder(fileOwnerSid).build(), null);
        this.repositoryFileDao.createFolder(tenantRootFolder.getId(), new RepositoryFile.Builder(ServerRepositoryPaths.getTenantEtcFolderName()).folder(true).build(), new RepositoryFileAcl.Builder(fileOwnerSid).build(), null);
    }

    protected void setAsSystemFolder(Serializable fileId) {
        Map<String, Serializable> fileMeta = this.repositoryFileDao.getFileMetadata(fileId);
        fileMeta.put("system_folder", Boolean.valueOf(true));
        this.repositoryFileDao.setFileMetadata(fileId, fileMeta);
    }

    private boolean isTenantEnabled(Session session, Serializable tenantFolderId) throws ItemNotFoundException, RepositoryException {
        Map<String, Serializable> metadata = JcrRepositoryFileUtils.getFileMetadata(session, tenantFolderId);
        return metadata.containsKey("isTenantEnabled") && (Boolean)metadata.get("isTenantEnabled") != false;
    }

    public boolean isSubTenant(Session jcrSession, ITenant parentTenant, ITenant descendantTenant) {
        return this.internalIsSubTenant(parentTenant, descendantTenant);
    }

    private boolean internalIsSubTenant(ITenant descendantTenant, List<ITenant> childTenants) {
        for (ITenant tenant : childTenants) {
            if (tenant == null || !tenant.equals(childTenants)) continue;
            return true;
        }
        return false;
    }

    private boolean internalIsSubTenant(ITenant parentTenant, ITenant descendantTenant) {
        if (parentTenant.equals(descendantTenant)) {
            return true;
        }
        List childTenants = this.getChildTenants(parentTenant);
        if (childTenants != null && childTenants.size() > 0) {
            if (this.internalIsSubTenant(descendantTenant, childTenants)) {
                return true;
            }
            for (ITenant childTenant : childTenants) {
                boolean done = this.internalIsSubTenant(childTenant, descendantTenant);
                if (!done) continue;
                return done;
            }
        } else {
            return false;
        }
        return false;
    }

    public ITenant getTenant(Session session, String tenantId) throws RepositoryException {
        Tenant tenant = null;
        RepositoryFile tenantRootFolder = JcrRepositoryFileUtils.getFileByAbsolutePath(session, tenantId, this.pathConversionHelper, null, false, null);
        if (tenantRootFolder != null && this.isTenantRoot(session, tenantRootFolder.getId())) {
            tenant = new Tenant(tenantId, Boolean.valueOf(this.isTenantEnabled(session, tenantRootFolder.getId())));
        }
        return tenant;
    }

    private boolean isTenantRoot(Session session, Serializable tenantFolderId) throws ItemNotFoundException, RepositoryException {
        Map<String, Serializable> metadata = JcrRepositoryFileUtils.getFileMetadata(session, tenantFolderId);
        return metadata.containsKey("isTenantRoot") && (Boolean)metadata.get("isTenantRoot") != false;
    }

    public RepositoryFile createUserHomeFolder(ITenant theTenant, String username) {
        RepositoryFileAcl.Builder aclsForUserHomeFolder = null;
        RepositoryFileAcl.Builder aclsForTenantHomeFolder = null;
        RepositoryFile userHomeFolder = null;
        RepositoryFile tenantHomeFolder = null;
        RepositoryFile tenantRootFolder = null;
        String userId = this.tenantedUserNameResolver.getPrincipleId(theTenant, username);
        RepositoryFileSid userSid = new RepositoryFileSid(userId);
        username = JcrTenantUtils.getPrincipalName(username, true);
        if (theTenant == null) {
            theTenant = JcrTenantUtils.getTenant(username, true);
        }
        if ((tenantRootFolder = this.repositoryFileDao.getFileByAbsolutePath(ServerRepositoryPaths.getTenantRootFolderPath(theTenant))) != null) {
            tenantHomeFolder = this.repositoryFileDao.getFileByAbsolutePath(ServerRepositoryPaths.getTenantHomeFolderPath(theTenant));
            if (tenantHomeFolder == null) {
                String ownerId = this.tenantedUserNameResolver.getPrincipleId(theTenant, username);
                RepositoryFileSid ownerSid = new RepositoryFileSid(ownerId, RepositoryFileSid.Type.USER);
                String tenantAuthenticatedRoleId = this.tenantedRoleNameResolver.getPrincipleId(theTenant, this.tenantAuthenticatedRoleName);
                RepositoryFileSid tenantAuthenticatedRoleSid = new RepositoryFileSid(tenantAuthenticatedRoleId, RepositoryFileSid.Type.ROLE);
                aclsForTenantHomeFolder = new RepositoryFileAcl.Builder(userSid).ace(tenantAuthenticatedRoleSid, EnumSet.of(RepositoryFilePermission.READ));
                aclsForUserHomeFolder = new RepositoryFileAcl.Builder(userSid).ace(ownerSid, EnumSet.of(RepositoryFilePermission.ALL));
                tenantHomeFolder = this.repositoryFileDao.createFolder(tenantRootFolder.getId(), new RepositoryFile.Builder(ServerRepositoryPaths.getTenantHomeFolderName()).folder(true).build(), aclsForTenantHomeFolder.build(), "tenant home folder");
            } else {
                String ownerId = this.tenantedUserNameResolver.getPrincipleId(theTenant, username);
                RepositoryFileSid ownerSid = new RepositoryFileSid(ownerId, RepositoryFileSid.Type.USER);
                aclsForUserHomeFolder = new RepositoryFileAcl.Builder(userSid).ace(ownerSid, EnumSet.of(RepositoryFilePermission.ALL));
            }
            userHomeFolder = this.repositoryFileDao.getFileByAbsolutePath(ServerRepositoryPaths.getUserHomeFolderPath(theTenant, username));
            if (userHomeFolder == null) {
                userHomeFolder = this.repositoryFileDao.createFolder(tenantHomeFolder.getId(), new RepositoryFile.Builder(username).folder(true).build(), aclsForUserHomeFolder.build(), "user home folder");
            }
        }
        return userHomeFolder;
    }

    public RepositoryFile getUserHomeFolder(ITenant theTenant, String username) {
        return this.repositoryFileDao.getFileByAbsolutePath(ServerRepositoryPaths.getUserHomeFolderPath(theTenant, username));
    }
}

