/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.fileio;

import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.pentaho.platform.api.engine.IContentOutputHandler;
import org.pentaho.platform.api.engine.IMimeTypeListener;
import org.pentaho.platform.api.engine.IOutputHandler;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository2.unified.fileio.RepositoryFileContentItem;
import org.pentaho.platform.repository2.unified.fileio.RepositoryFileOutputStream;
import org.pentaho.platform.util.web.MimeHelper;

public class RepositoryFileOutputHandler
implements IOutputHandler {
    private RepositoryFileOutputStream outputStream;
    private boolean contentGenerated;
    private boolean responseExpected;
    private IMimeTypeListener mimeTypeListener;
    private int outputType = 3;
    private IPentahoSession session;

    public RepositoryFileOutputHandler(RepositoryFileOutputStream outputStream) {
        this.outputStream = outputStream;
        this.contentGenerated = false;
    }

    public boolean allowFeedback() {
        return false;
    }

    public boolean contentDone() {
        return this.contentGenerated;
    }

    public IContentItem getFeedbackContentItem() {
        return null;
    }

    public IMimeTypeListener getMimeTypeListener() {
        return this.mimeTypeListener;
    }

    public IContentItem getOutputContentItem(String outputName, String contentName, String instanceId, String localMimeType) {
        RepositoryFileContentItem outputContentItem = null;
        if (outputName.equals("response") && contentName.equals("content")) {
            String requestedFileExtension = MimeHelper.getExtension((String)localMimeType);
            String currentExtension = FilenameUtils.getExtension((String)this.outputStream.getFilePath());
            if (requestedFileExtension == null) {
                if (currentExtension != null) {
                    String tempFilePath = FilenameUtils.getFullPathNoEndSeparator((String)this.outputStream.getFilePath()) + "/" + FilenameUtils.getBaseName((String)this.outputStream.getFilePath());
                    this.outputStream.setFilePath(tempFilePath);
                    outputContentItem = new RepositoryFileContentItem(this.outputStream);
                } else {
                    outputContentItem = new RepositoryFileContentItem(this.outputStream);
                }
            } else if (!requestedFileExtension.substring(1).equals(currentExtension.toLowerCase())) {
                String tempFilePath = FilenameUtils.getFullPathNoEndSeparator((String)this.outputStream.getFilePath()) + "/" + FilenameUtils.getBaseName((String)this.outputStream.getFilePath()) + requestedFileExtension;
                this.outputStream.setFilePath(tempFilePath);
                outputContentItem = new RepositoryFileContentItem(this.outputStream);
            } else {
                outputContentItem = new RepositoryFileContentItem(this.outputStream);
            }
            this.responseExpected = true;
        } else {
            IContentOutputHandler output = PentahoSystem.getOutputDestinationFromContentRef((String)contentName, (IPentahoSession)this.session);
            if (output == null) {
                output = PentahoSystem.getOutputDestinationFromContentRef((String)(outputName + ":" + contentName), (IPentahoSession)this.session);
            }
            if (output != null) {
                output.setSession(PentahoSessionHolder.getSession());
                output.setInstanceId(instanceId);
                String filePath = "~/workspace/" + contentName;
                if (contentName.startsWith("/")) {
                    filePath = contentName;
                }
                output.setSolutionPath(filePath);
                output.setMimeType(localMimeType);
                outputContentItem = output.getFileOutputContentItem();
            }
        }
        return outputContentItem;
    }

    public int getOutputPreference() {
        return this.outputType;
    }

    public IPentahoSession getSession() {
        return this.session;
    }

    public boolean isResponseExpected() {
        return this.responseExpected;
    }

    public void setMimeTypeListener(IMimeTypeListener mimeTypeListener) {
        this.mimeTypeListener = mimeTypeListener;
    }

    public void setOutput(String name, Object value) throws IOException {
        IContentItem response;
        if (value == null) {
            return;
        }
        if ("content".equalsIgnoreCase(name) && (response = this.getOutputContentItem("response", "content", null, null)) != null && !(value instanceof IContentItem)) {
            if (response.getMimeType() == null) {
                response.setMimeType("text/html");
            }
            response.getOutputStream(null).write(value.toString().getBytes());
            this.contentGenerated = true;
        }
    }

    public void setOutputPreference(int outputType) {
        this.outputType = outputType;
    }

    public void setSession(IPentahoSession session) {
        this.session = session;
    }
}

