/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.api.repository2.unified.RepositoryFileSid;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.repository2.unified.jcr.InheritDefaultAclHandler;
import org.pentaho.platform.repository2.unified.jcr.JcrTenantUtils;

public class SharedObjectsDefaultAclHandler
extends InheritDefaultAclHandler {
    String authenticatedRoleName = "Authenticated";
    List<String> sharedObjectPaths;

    public SharedObjectsDefaultAclHandler() {
        this.sharedObjectPaths = new ArrayList<String>();
        this.sharedObjectPaths.add("{0}/etc/pdi/databases");
    }

    public SharedObjectsDefaultAclHandler(String authenticatedRoleName, List<String> sharedObjectPaths) {
        this.authenticatedRoleName = authenticatedRoleName;
        this.sharedObjectPaths = sharedObjectPaths;
    }

    protected boolean applyAuthRule(RepositoryFile file) {
        ITenant tenant = JcrTenantUtils.getTenant();
        for (String path : this.sharedObjectPaths) {
            String substitutedPath = MessageFormat.format(path, tenant.getRootFolderAbsolutePath());
            if (file.getPath() == null || !file.getPath().startsWith(substitutedPath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public RepositoryFileAcl createDefaultAcl(RepositoryFile repositoryFile) {
        if (this.applyAuthRule(repositoryFile)) {
            if (this.authenticatedRoleName == null || this.authenticatedRoleName.trim().length() == 0) {
                return new RepositoryFileAcl.Builder(PentahoSessionHolder.getSession().getName()).entriesInheriting(false).build();
            }
            RepositoryFileSid tenantAuthenticatedRoleSid = new RepositoryFileSid(this.authenticatedRoleName, RepositoryFileSid.Type.ROLE);
            return new RepositoryFileAcl.Builder(PentahoSessionHolder.getSession().getName()).entriesInheriting(false).ace(tenantAuthenticatedRoleSid, EnumSet.of(RepositoryFilePermission.ALL)).build();
        }
        return super.createDefaultAcl(repositoryFile);
    }
}

