/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr.jackrabbit.security;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.core.security.AnonymousPrincipal;
import org.apache.jackrabbit.core.security.UserPrincipal;
import org.apache.jackrabbit.core.security.principal.AdminPrincipal;
import org.apache.jackrabbit.core.security.principal.EveryonePrincipal;
import org.apache.jackrabbit.core.security.principal.PrincipalIteratorAdapter;
import org.apache.jackrabbit.core.security.principal.PrincipalProvider;
import org.pentaho.platform.api.engine.security.userroledao.IPentahoRole;
import org.pentaho.platform.api.engine.security.userroledao.IUserRoleDao;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.api.mt.ITenantedPrincipleNameResolver;
import org.pentaho.platform.repository2.unified.jcr.JcrAclMetadataStrategy;
import org.pentaho.platform.repository2.unified.jcr.jackrabbit.security.SpringSecurityRolePrincipal;
import org.pentaho.platform.repository2.unified.jcr.sejcr.ConstantCredentialsStrategy;
import org.pentaho.platform.repository2.unified.jcr.sejcr.CredentialsStrategy;
import org.pentaho.platform.security.userroledao.DefaultTenantedPrincipleNameResolver;

public class TestPrincipalProvider
implements PrincipalProvider {
    private Map<String, Principal> principals = new HashMap<String, Principal>();
    private Map<String, List<SpringSecurityRolePrincipal>> roleAssignments = new HashMap<String, List<SpringSecurityRolePrincipal>>();
    private String adminId;
    private AdminPrincipal adminPrincipal;
    private String anonymousId;
    private AnonymousPrincipal anonymousPrincipal = new AnonymousPrincipal();
    private String adminRole;
    private SpringSecurityRolePrincipal adminRolePrincipal;
    private static final String KEY_ADMIN_ID = "adminId";
    private static final String KEY_ANONYMOUS_ID = "anonymousId";
    private static final String KEY_ADMIN_ROLE = "adminRole";
    private ITenantedPrincipleNameResolver tenantedUserNameUtils = new DefaultTenantedPrincipleNameResolver();
    private ITenantedPrincipleNameResolver tenantedRoleNameUtils = new DefaultTenantedPrincipleNameResolver("_");
    private boolean primeWithSampleUsers;
    public static IUserRoleDao userRoleDao;
    public static CredentialsStrategy adminCredentialsStrategy;
    public static Repository repository;
    Session session;

    public TestPrincipalProvider() {
        this(true);
    }

    public TestPrincipalProvider(boolean primeWithSampleUsers) {
        this.primeWithSampleUsers = primeWithSampleUsers;
    }

    public void init(Properties options) {
        this.adminId = options.getProperty(KEY_ADMIN_ID, "admin");
        this.adminPrincipal = new AdminPrincipal(this.adminId);
        this.adminRole = options.getProperty(KEY_ADMIN_ROLE, "administrators");
        this.adminRolePrincipal = new SpringSecurityRolePrincipal(this.adminRole);
        this.anonymousId = options.getProperty(KEY_ANONYMOUS_ID, "anonymous");
        this.principals.put(this.adminId, (Principal)this.adminPrincipal);
        this.principals.put(this.adminRole, (Principal)((Object)this.adminRolePrincipal));
        ArrayList<SpringSecurityRolePrincipal> assignedAdminRoles = new ArrayList<SpringSecurityRolePrincipal>();
        assignedAdminRoles.add(this.adminRolePrincipal);
        this.roleAssignments.put(this.adminId, assignedAdminRoles);
        this.principals.put(this.anonymousId, (Principal)this.anonymousPrincipal);
        EveryonePrincipal everyone = EveryonePrincipal.getInstance();
        this.principals.put(everyone.getName(), (Principal)everyone);
    }

    Session getAdminSession() {
        try {
            if (this.session == null) {
                this.session = repository.login(adminCredentialsStrategy.getCredentials(), null);
            }
        }
        catch (LoginException e) {
            e.printStackTrace();
        }
        catch (NoSuchWorkspaceException e) {
            e.printStackTrace();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        return this.session;
    }

    public void close() {
    }

    public boolean canReadPrincipal(Session session, Principal principal) {
        return true;
    }

    public Principal getPrincipal(String principalName) {
        if (JcrAclMetadataStrategy.AclMetadataPrincipal.isAclMetadataPrincipal(principalName)) {
            return new JcrAclMetadataStrategy.AclMetadataPrincipal(principalName);
        }
        if (this.principals.containsKey(principalName)) {
            return this.principals.get(principalName);
        }
        if (userRoleDao != null) {
            try {
                if (userRoleDao.getUser(null, principalName) != null) {
                    return new UserPrincipal(principalName);
                }
                if (userRoleDao.getRole(null, principalName) != null) {
                    return new SpringSecurityRolePrincipal(principalName);
                }
                if (principalName.startsWith("super")) {
                    return new SpringSecurityRolePrincipal(principalName);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public PrincipalIterator getGroupMembership(Principal principal) {
        if (principal instanceof EveryonePrincipal) {
            return PrincipalIteratorAdapter.EMPTY;
        }
        if (principal instanceof JcrAclMetadataStrategy.AclMetadataPrincipal) {
            return PrincipalIteratorAdapter.EMPTY;
        }
        HashSet<Object> principals = new HashSet<Object>(this.roleAssignments.containsKey(principal.getName()) ? (Collection)this.roleAssignments.get(principal.getName()) : new HashSet());
        principals.add(EveryonePrincipal.getInstance());
        if (principal instanceof AdminPrincipal) {
            principals.add(this.adminRolePrincipal);
        } else if (principal instanceof UserPrincipal) {
            if (userRoleDao != null) {
                try {
                    List roles = userRoleDao.getUserRoles(null, principal.getName());
                    for (IPentahoRole role : roles) {
                        principals.add(new SpringSecurityRolePrincipal(this.tenantedRoleNameUtils.getPrincipleId(role.getTenant(), role.getName())));
                    }
                }
                catch (Exception e) {
                    List roles = userRoleDao.getUserRoles(null, principal.getName());
                    for (IPentahoRole role : roles) {
                        principals.add(new SpringSecurityRolePrincipal(this.tenantedRoleNameUtils.getPrincipleId(role.getTenant(), role.getName())));
                    }
                }
            } else {
                ITenant tenant;
                if (principal.getName() != null && (principal.getName().startsWith("admin") || principal.getName().startsWith("suzy") || principal.getName().startsWith("tiffany"))) {
                    tenant = this.tenantedUserNameUtils.getTenant(principal.getName());
                    principals.add(new SpringSecurityRolePrincipal(this.tenantedRoleNameUtils.getPrincipleId(tenant, "Authenticated")));
                }
                if (principal.getName() != null && principal.getName().startsWith("admin")) {
                    tenant = this.tenantedUserNameUtils.getTenant(principal.getName());
                    principals.add(new SpringSecurityRolePrincipal(this.tenantedRoleNameUtils.getPrincipleId(tenant, "TenantAdmin")));
                }
                if (principal.getName() != null && principal.getName().startsWith("super")) {
                    tenant = this.tenantedUserNameUtils.getTenant(principal.getName());
                    principals.add(new SpringSecurityRolePrincipal(this.tenantedRoleNameUtils.getPrincipleId(tenant, "SysAdmin")));
                }
            }
        }
        return new PrincipalIteratorAdapter(principals);
    }

    public PrincipalIterator findPrincipals(String simpleFilter) {
        throw new UnsupportedOperationException("not implemented");
    }

    public PrincipalIterator findPrincipals(String simpleFilter, int searchType) {
        throw new UnsupportedOperationException("not implemented");
    }

    public PrincipalIterator getPrincipals(int searchType) {
        throw new UnsupportedOperationException("not implemented");
    }

    static {
        adminCredentialsStrategy = new ConstantCredentialsStrategy();
    }
}

