/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr.sejcr;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.pentaho.platform.api.engine.ISystemConfig;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository2.unified.jcr.sejcr.CredentialsStrategySessionFactory;
import org.pentaho.platform.repository2.unified.jcr.sejcr.NoCachePentahoJcrSessionFactory;
import org.pentaho.platform.repository2.unified.jcr.sejcr.PentahoJcrSessionFactory;
import org.pentaho.platform.repository2.unified.jcr.sejcr.PentahoTransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.extensions.jcr.SessionFactory;
import org.springframework.extensions.jcr.SessionFactoryUtils;

class GuavaCachePoolPentahoJcrSessionFactory
extends NoCachePentahoJcrSessionFactory
implements PentahoJcrSessionFactory {
    private CredentialsStrategySessionFactory credentialsStrategySessionFactory;
    private int cacheDuration = 300;
    private int cacheSize = 100;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private PentahoTransactionManager transactionManager;
    private LoadingCache<CacheKey, Session> sessionCache = CacheBuilder.newBuilder().expireAfterAccess((long)this.cacheDuration, TimeUnit.SECONDS).maximumSize((long)this.cacheSize).removalListener((RemovalListener)new RemovalListener<CacheKey, Session>(){

        public void onRemoval(RemovalNotification<CacheKey, Session> objectObjectRemovalNotification) {
        }
    }).recordStats().build((CacheLoader)new CacheLoader<CacheKey, Session>(){

        public Session load(CacheKey credKey) throws Exception {
            return GuavaCachePoolPentahoJcrSessionFactory.super.getSession((Credentials)credKey.creds);
        }
    });

    public GuavaCachePoolPentahoJcrSessionFactory(Repository repository, String workspace) {
        this(repository, workspace, null);
    }

    public GuavaCachePoolPentahoJcrSessionFactory(Repository repository, String workspace, PentahoTransactionManager transactionManager) {
        super(repository, workspace);
        this.transactionManager = transactionManager;
        ISystemConfig systemConfig = (ISystemConfig)PentahoSystem.get(ISystemConfig.class);
        if (systemConfig != null && systemConfig.getConfiguration("repository") != null) {
            try {
                this.cacheDuration = Integer.parseInt(systemConfig.getConfiguration("repository").getProperties().getProperty("cache-ttl", "300"));
                this.cacheSize = Integer.parseInt(systemConfig.getConfiguration("repository").getProperties().getProperty("cache-size", "100"));
            }
            catch (IOException e) {
                this.logger.info("Could not find repository.cache-duration");
            }
        }
    }

    @Override
    public Session getSession(Credentials creds) throws RepositoryException {
        Session session;
        if (this.transactionManager == null || !this.transactionManager.isCreatingTransaction()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Thread is not transacted, checking cache for session: " + creds);
            }
            try {
                CacheKey key = new CacheKey(creds);
                session = (Session)this.sessionCache.get((Object)key);
                if (!session.isLive()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Cached session is not longer alive. disposing: " + creds);
                    }
                    this.sessionCache.invalidate((Object)key);
                    session = (Session)this.sessionCache.get((Object)key);
                }
                if (SessionFactoryUtils.isSessionThreadBound((Session)session, (SessionFactory)this.credentialsStrategySessionFactory)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Session is bound to a transaction. This should never happen, ignoring this session and creating a new session: " + creds);
                    }
                    this.sessionCache.invalidate((Object)key);
                    session = (Session)this.sessionCache.get((Object)key);
                }
                session.refresh(false);
            }
            catch (Exception e) {
                this.logger.error("Error obtaining session from cache. Creating one directly instead: " + creds, (Throwable)e);
                session = super.getSession(creds);
            }
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Thread is transacted, obtaining session directly, not cached: " + creds);
            }
            session = super.getSession(creds);
        }
        return session;
    }

    private class CacheKey {
        SimpleCredentials creds;
        Long threadId;

        private CacheKey(Credentials creds) {
            this.creds = (SimpleCredentials)creds;
            this.threadId = Thread.currentThread().getId();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.creds != null ? !this.creds.getUserID().equals(cacheKey.creds.getUserID()) : cacheKey.creds != null) {
                return false;
            }
            return !(this.threadId != null ? !this.threadId.equals(cacheKey.threadId) : cacheKey.threadId != null);
        }

        public int hashCode() {
            int result = this.creds != null ? this.creds.getUserID().hashCode() : 0;
            result = 31 * result + (this.threadId != null ? this.threadId.hashCode() : 0);
            return result;
        }
    }
}

