/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr.sejcr;

import org.springframework.extensions.jcr.jackrabbit.LocalTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;

public class PentahoTransactionManager
extends LocalTransactionManager {
    private ThreadLocal<TransactionDefinition> activeTransactionDefinition = new ThreadLocal();

    protected void doBegin(Object transaction, TransactionDefinition transactionDefinition) throws TransactionException {
        this.activeTransactionDefinition.set(transactionDefinition);
        try {
            super.doBegin(transaction, transactionDefinition);
        }
        finally {
            this.activeTransactionDefinition.remove();
        }
    }

    public TransactionDefinition getTransactionDefinition() {
        return this.activeTransactionDefinition.get();
    }

    public boolean isCreatingTransaction() {
        if (this.activeTransactionDefinition.get() == null) {
            return false;
        }
        switch (this.activeTransactionDefinition.get().getPropagationBehavior()) {
            case 0: 
            case 3: 
            case 6: {
                return true;
            }
        }
        return false;
    }
}

