/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr.transform;

import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.pentaho.platform.api.repository2.unified.IRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.data.simple.SimpleRepositoryFileData;
import org.pentaho.platform.repository2.unified.jcr.ITransformer;
import org.pentaho.platform.repository2.unified.jcr.PentahoJcrConstants;
import org.springframework.util.StringUtils;

public class SimpleRepositoryFileDataTransformer
implements ITransformer<SimpleRepositoryFileData> {
    @Override
    public boolean canRead(String contentType, Class<? extends IRepositoryFileData> clazz) {
        return "simple".equals(contentType) && clazz.isAssignableFrom(SimpleRepositoryFileData.class);
    }

    @Override
    public boolean canWrite(Class<? extends IRepositoryFileData> clazz) {
        return SimpleRepositoryFileData.class.equals(clazz);
    }

    @Override
    public String getContentType() {
        return "simple";
    }

    @Override
    public void createContentNode(Session session, PentahoJcrConstants pentahoJcrConstants, SimpleRepositoryFileData data, Node fileNode) throws RepositoryException {
        Node resourceNode = fileNode.addNode(pentahoJcrConstants.getJCR_CONTENT(), pentahoJcrConstants.getNT_RESOURCE());
        resourceNode.setProperty(pentahoJcrConstants.getJCR_LASTMODIFIED(), fileNode.getProperty(pentahoJcrConstants.getJCR_CREATED()).getDate());
        if (StringUtils.hasText((String)data.getEncoding())) {
            resourceNode.setProperty(pentahoJcrConstants.getJCR_ENCODING(), data.getEncoding());
        }
        resourceNode.setProperty(pentahoJcrConstants.getJCR_DATA(), session.getValueFactory().createBinary(data.getStream()));
        resourceNode.setProperty(pentahoJcrConstants.getJCR_MIMETYPE(), data.getMimeType());
    }

    @Override
    public SimpleRepositoryFileData fromContentNode(Session session, PentahoJcrConstants pentahoJcrConstants, Node fileNode) throws RepositoryException {
        String encoding = null;
        Node resourceNode = fileNode.getNode(pentahoJcrConstants.getJCR_CONTENT());
        if (resourceNode.hasProperty(pentahoJcrConstants.getJCR_ENCODING())) {
            encoding = resourceNode.getProperty(pentahoJcrConstants.getJCR_ENCODING()).getString();
        }
        InputStream data = resourceNode.getProperty(pentahoJcrConstants.getJCR_DATA()).getBinary().getStream();
        String mimeType = resourceNode.getProperty(pentahoJcrConstants.getJCR_MIMETYPE()).getString();
        return new SimpleRepositoryFileData(data, encoding, mimeType);
    }

    @Override
    public void updateContentNode(Session session, PentahoJcrConstants pentahoJcrConstants, SimpleRepositoryFileData data, Node fileNode) throws RepositoryException {
        Node resourceNode = fileNode.getNode(pentahoJcrConstants.getJCR_CONTENT());
        resourceNode.setProperty(pentahoJcrConstants.getJCR_LASTMODIFIED(), Calendar.getInstance());
        if (StringUtils.hasText((String)data.getEncoding())) {
            resourceNode.setProperty(pentahoJcrConstants.getJCR_ENCODING(), data.getEncoding());
        }
        resourceNode.setProperty(pentahoJcrConstants.getJCR_DATA(), session.getValueFactory().createBinary(data.getStream()));
        resourceNode.setProperty(pentahoJcrConstants.getJCR_MIMETYPE(), data.getMimeType());
    }
}

