/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.webservices;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.pentaho.platform.api.repository2.unified.data.node.DataNode;
import org.pentaho.platform.api.repository2.unified.data.node.DataNodeRef;
import org.pentaho.platform.api.repository2.unified.data.node.DataProperty;
import org.pentaho.platform.api.repository2.unified.data.node.NodeRepositoryFileData;
import org.pentaho.platform.repository2.unified.webservices.DataNodeDto;
import org.pentaho.platform.repository2.unified.webservices.DataPropertyDto;
import org.pentaho.platform.repository2.unified.webservices.NodeRepositoryFileDataDto;

public class NodeRepositoryFileDataAdapter
extends XmlAdapter<NodeRepositoryFileDataDto, NodeRepositoryFileData> {
    public NodeRepositoryFileDataDto marshal(NodeRepositoryFileData v) {
        DataNodeDto node;
        NodeRepositoryFileDataDto d = new NodeRepositoryFileDataDto();
        d.node = node = new DataNodeDto();
        this.toDataNodeDto(node, v.getNode());
        return d;
    }

    protected void toDataNodeDto(DataNodeDto nodeDto, DataNode node) {
        nodeDto.name = node.getName();
        if (node.getId() != null) {
            nodeDto.id = node.getId().toString();
        }
        ArrayList<DataPropertyDto> dtoProps = new ArrayList<DataPropertyDto>();
        for (DataProperty prop : node.getProperties()) {
            DataPropertyDto dtoProp = new DataPropertyDto();
            dtoProp.name = prop.getName();
            if (prop.getType() == DataNode.DataPropertyType.BOOLEAN || prop.getType() == DataNode.DataPropertyType.DOUBLE || prop.getType() == DataNode.DataPropertyType.LONG || prop.getType() == DataNode.DataPropertyType.STRING || prop.getType() == DataNode.DataPropertyType.REF) {
                dtoProp.value = prop.getString();
            } else if (prop.getType() == DataNode.DataPropertyType.DATE) {
                Date dateProp = prop.getDate();
                dtoProp.value = dateProp != null ? String.valueOf(dateProp.getTime()) : null;
            } else {
                throw new IllegalArgumentException();
            }
            dtoProp.type = prop.getType() != null ? prop.getType().ordinal() : -1;
            dtoProps.add(dtoProp);
        }
        nodeDto.childProperties = dtoProps;
        ArrayList<DataNodeDto> nodeDtos = new ArrayList<DataNodeDto>();
        for (DataNode childNode : node.getNodes()) {
            DataNodeDto child = new DataNodeDto();
            nodeDtos.add(child);
            this.toDataNodeDto(child, childNode);
        }
        nodeDto.childNodes = nodeDtos;
    }

    public NodeRepositoryFileData unmarshal(NodeRepositoryFileDataDto v) {
        DataNode node = this.toDataNode(v.node);
        NodeRepositoryFileData data = new NodeRepositoryFileData(node);
        return data;
    }

    protected DataNode toDataNode(DataNodeDto nodeDto) {
        DataNode node = new DataNode(nodeDto.name);
        node.setId((Serializable)((Object)nodeDto.id));
        for (DataPropertyDto dtoProp : nodeDto.childProperties) {
            if (dtoProp.type == DataNode.DataPropertyType.BOOLEAN.ordinal()) {
                node.setProperty(dtoProp.name, Boolean.parseBoolean(dtoProp.value));
                continue;
            }
            if (dtoProp.type == DataNode.DataPropertyType.DATE.ordinal()) {
                node.setProperty(dtoProp.name, new Date(Long.parseLong(dtoProp.value)));
                continue;
            }
            if (dtoProp.type == DataNode.DataPropertyType.DOUBLE.ordinal()) {
                node.setProperty(dtoProp.name, Double.parseDouble(dtoProp.value));
                continue;
            }
            if (dtoProp.type == DataNode.DataPropertyType.LONG.ordinal()) {
                node.setProperty(dtoProp.name, Long.parseLong(dtoProp.value));
                continue;
            }
            if (dtoProp.type == DataNode.DataPropertyType.STRING.ordinal()) {
                node.setProperty(dtoProp.name, dtoProp.value);
                continue;
            }
            if (dtoProp.type == DataNode.DataPropertyType.REF.ordinal()) {
                node.setProperty(dtoProp.name, new DataNodeRef((Serializable)((Object)dtoProp.value)));
                continue;
            }
            throw new IllegalArgumentException();
        }
        for (DataNodeDto childNodeDto : nodeDto.childNodes) {
            node.addNode(this.toDataNode(childNodeDto));
        }
        return node;
    }
}

