/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.security.policy.rolebased;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.pentaho.platform.api.engine.IAuthorizationAction;
import org.pentaho.platform.api.engine.security.userroledao.NotFoundException;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.api.mt.ITenantedPrincipleNameResolver;
import org.pentaho.platform.engine.core.system.TenantUtils;
import org.pentaho.platform.repository2.unified.jcr.JcrTenantUtils;
import org.pentaho.platform.security.policy.rolebased.AbstractJcrBackedRoleBindingDao;
import org.pentaho.platform.security.policy.rolebased.RoleBindingStruct;
import org.springframework.extensions.jcr.JcrCallback;
import org.springframework.extensions.jcr.JcrTemplate;
import org.springframework.util.Assert;

public class JcrRoleAuthorizationPolicyRoleBindingDao
extends AbstractJcrBackedRoleBindingDao {
    private JcrTemplate jcrTemplate;

    public JcrRoleAuthorizationPolicyRoleBindingDao(JcrTemplate jcrTemplate, Map<String, List<IAuthorizationAction>> immutableRoleBindings, Map<String, List<String>> bootstrapRoleBindings, String superAdminRoleName, ITenantedPrincipleNameResolver tenantedRoleNameUtils, List<IAuthorizationAction> authorizationActions) {
        super(immutableRoleBindings, bootstrapRoleBindings, superAdminRoleName, tenantedRoleNameUtils, authorizationActions);
        Assert.notNull((Object)jcrTemplate);
        this.jcrTemplate = jcrTemplate;
    }

    @Override
    public RoleBindingStruct getRoleBindingStruct(final String locale) {
        return (RoleBindingStruct)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                return JcrRoleAuthorizationPolicyRoleBindingDao.this.getRoleBindingStruct(session, null, locale);
            }
        });
    }

    @Override
    public RoleBindingStruct getRoleBindingStruct(final ITenant tenant, final String locale) {
        if (tenant != null && !TenantUtils.isAccessibleTenant((ITenant)tenant)) {
            return new RoleBindingStruct(new HashMap<String, String>(), new HashMap<String, List<String>>(), new HashSet<String>());
        }
        return (RoleBindingStruct)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                return JcrRoleAuthorizationPolicyRoleBindingDao.this.getRoleBindingStruct(session, tenant, locale);
            }
        });
    }

    @Override
    public void setRoleBindings(String runtimeRoleName, List<String> logicalRoleNames) {
        this.setRoleBindings(null, runtimeRoleName, logicalRoleNames);
    }

    @Override
    public void setRoleBindings(final ITenant tenant, final String runtimeRoleName, final List<String> logicalRoleNames) {
        ITenant tempTenant = tenant;
        if (tenant == null) {
            tempTenant = JcrTenantUtils.getTenant(runtimeRoleName, false);
        }
        if (!TenantUtils.isAccessibleTenant((ITenant)tempTenant)) {
            throw new NotFoundException("Tenant " + tenant.getId() + " not found");
        }
        Assert.notNull(logicalRoleNames);
        this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                JcrRoleAuthorizationPolicyRoleBindingDao.this.setRoleBindings(session, tenant, runtimeRoleName, logicalRoleNames);
                return null;
            }
        });
    }

    @Override
    public List<String> getBoundLogicalRoleNames(final List<String> runtimeRoleNames) {
        return (List)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                return JcrRoleAuthorizationPolicyRoleBindingDao.this.getBoundLogicalRoleNames(session, (List<String>)runtimeRoleNames);
            }
        });
    }

    @Override
    public List<String> getBoundLogicalRoleNames(final ITenant tenant, final List<String> runtimeRoleNames) {
        if (tenant != null && !TenantUtils.isAccessibleTenant((ITenant)tenant)) {
            return new ArrayList<String>();
        }
        return (List)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                return JcrRoleAuthorizationPolicyRoleBindingDao.this.getBoundLogicalRoleNames(session, tenant, runtimeRoleNames);
            }
        });
    }
}

