/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.security.policy.rolebased.springsecurity;

import java.util.Collection;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;

public class AuthorizationPolicyVoter
implements AccessDecisionVoter {
    private String prefix;
    private IAuthorizationPolicy policy;

    public AuthorizationPolicyVoter(IAuthorizationPolicy policy, String prefix) {
        Assert.notNull((Object)policy);
        Assert.notNull((Object)prefix);
        this.policy = policy;
        this.prefix = prefix;
    }

    public boolean supports(ConfigAttribute attribute) {
        return attribute.getAttribute() != null && attribute.getAttribute().startsWith(this.prefix);
    }

    public boolean supports(Class clazz) {
        return true;
    }

    public int vote(Authentication authentication, Object object, Collection configAttributes) {
        int result = 0;
        for (ConfigAttribute attribute : configAttributes) {
            if (!this.supports(attribute)) continue;
            String actionName = attribute.getAttribute().substring(this.prefix.length());
            if (this.policy.isAllowed(actionName)) {
                return 1;
            }
            return -1;
        }
        return result;
    }
}

