/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.security.userroledao;

import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.api.mt.ITenantedPrincipleNameResolver;
import org.pentaho.platform.core.mt.Tenant;
import org.pentaho.platform.repository2.unified.ServerRepositoryPaths;

public class DefaultTenantedPrincipleNameResolver
implements ITenantedPrincipleNameResolver {
    public static final String DEFAULT_DELIMETER = "-";
    public static final String ALTERNATE_DELIMETER = "_";
    public boolean userNameNaturallyContainsEmbeddedTenantName = false;
    private String delimeter = "-";
    private boolean principalNameFollowsTenantName = false;

    public DefaultTenantedPrincipleNameResolver() {
    }

    public DefaultTenantedPrincipleNameResolver(String delimiter) {
        this.setDelimeter(delimiter);
    }

    public ITenant getTenant(String principalId) {
        String tenantName = null;
        int delimiterIndex = principalId.lastIndexOf(this.getDelimeter() + "/");
        if (delimiterIndex >= 0) {
            String string = tenantName = this.getUserNameFollowsTenantName() ? principalId.substring(0, delimiterIndex - 1) : principalId.substring(delimiterIndex + 1);
            if (!this.isTenantValid(tenantName)) {
                tenantName = null;
            }
        }
        return new Tenant(tenantName, Boolean.valueOf(true));
    }

    public String getPrincipleName(String principalId) {
        String userName = principalId;
        int delimiterIndex = principalId.lastIndexOf(this.getDelimeter() + "/");
        if (delimiterIndex >= 0) {
            if (this.getUserNameNaturallyContainsEmbeddedTenantName()) {
                userName = principalId;
            } else {
                String string = userName = this.getUserNameFollowsTenantName() ? principalId.substring(delimiterIndex + 1) : principalId.substring(0, delimiterIndex);
                if (this.getTenant(principalId).getId() == null) {
                    userName = principalId;
                }
            }
        }
        return userName;
    }

    public String getPrincipleId(ITenant tenant, String principleName) {
        String id = this.getDelimeter();
        id = tenant == null || tenant.getId() == null ? principleName : (this.principalNameFollowsTenantName ? tenant.getId() + this.getDelimeter() + principleName : principleName + this.getDelimeter() + tenant.getId());
        return id;
    }

    public boolean getUserNameNaturallyContainsEmbeddedTenantName() {
        return this.userNameNaturallyContainsEmbeddedTenantName;
    }

    public void setUserNameNaturallyContainsEmbeddedTenantName(boolean userNameNaturallyContainsEmbeddedTenantName) {
        this.userNameNaturallyContainsEmbeddedTenantName = userNameNaturallyContainsEmbeddedTenantName;
    }

    public String getDelimeter() {
        return this.delimeter;
    }

    public void setDelimeter(String delimeter) {
        this.delimeter = delimeter;
    }

    public boolean getUserNameFollowsTenantName() {
        return this.principalNameFollowsTenantName;
    }

    public void setUserNameFollowsTenantName(boolean userNameFollowsTenantName) {
        this.principalNameFollowsTenantName = userNameFollowsTenantName;
    }

    public boolean isValid(String principleId) {
        if (principleId.contains(this.getDelimeter())) {
            int pentahoRootFolderNameIndex = principleId.lastIndexOf(ServerRepositoryPaths.getPentahoRootFolderName());
            if (pentahoRootFolderNameIndex <= 1) {
                return false;
            }
            String delim = principleId.substring(pentahoRootFolderNameIndex - 2, pentahoRootFolderNameIndex - 1);
            if (delim.equals(this.getDelimeter())) {
                return true;
            }
        }
        return false;
    }

    private boolean isTenantValid(String tenantName) {
        return tenantName != null && tenantName.contains(ServerRepositoryPaths.getPentahoRootFolderName());
    }
}

