/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.security.userroledao.ws;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.jws.WebService;
import org.apache.commons.lang.StringUtils;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.security.userroledao.IPentahoRole;
import org.pentaho.platform.api.engine.security.userroledao.IPentahoUser;
import org.pentaho.platform.api.engine.security.userroledao.IUserRoleDao;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.security.userroledao.messages.Messages;
import org.pentaho.platform.security.userroledao.ws.IUserRoleWebService;
import org.pentaho.platform.security.userroledao.ws.ProxyPentahoRole;
import org.pentaho.platform.security.userroledao.ws.ProxyPentahoUser;
import org.pentaho.platform.security.userroledao.ws.ProxyPentahoUserRoleHelper;
import org.pentaho.platform.security.userroledao.ws.UserRoleException;
import org.pentaho.platform.security.userroledao.ws.UserRoleSecurityInfo;
import org.pentaho.platform.security.userroledao.ws.UserToRoleAssignment;

@WebService(endpointInterface="org.pentaho.platform.security.userroledao.ws.IUserRoleWebService", serviceName="userRoleService", portName="userRoleServicePort", targetNamespace="http://www.pentaho.org/ws/1.0")
public class UserRoleWebService
implements IUserRoleWebService {
    protected boolean isAdmin() {
        return this.canAdminister();
    }

    protected IUserRoleDao getDao() throws UserRoleException {
        if (!this.isAdmin()) {
            throw new UserRoleException(Messages.getInstance().getErrorString("UserRoleWebService.ERROR_0001_NOT_ADMIN"));
        }
        IUserRoleDao dao = (IUserRoleDao)PentahoSystem.get(IUserRoleDao.class, (String)"userRoleDaoTxn", (IPentahoSession)PentahoSessionHolder.getSession());
        if (dao == null) {
            throw new UserRoleException(Messages.getInstance().getErrorString("UserRoleWebService.ERROR_0002_IUSERROLEDAO_NOT_AVAILABLE"));
        }
        return dao;
    }

    @Override
    public UserRoleSecurityInfo getUserRoleSecurityInfo() throws UserRoleException {
        UserRoleSecurityInfo userRoleSecurityInfo = new UserRoleSecurityInfo();
        IUserRoleDao dao = this.getDao();
        List users = dao.getUsers();
        if (users != null) {
            for (IPentahoUser user : users) {
                userRoleSecurityInfo.getUsers().add(ProxyPentahoUserRoleHelper.toProxyUser(user));
                List roles = dao.getUserRoles(user.getTenant(), user.getUsername());
                if (roles == null) continue;
                for (IPentahoRole role : roles) {
                    userRoleSecurityInfo.getAssignments().add(new UserToRoleAssignment(user.getUsername(), role.getName()));
                }
            }
        }
        userRoleSecurityInfo.getRoles().addAll(Arrays.asList(this.getRoles()));
        return userRoleSecurityInfo;
    }

    @Override
    public boolean createUser(ProxyPentahoUser proxyUser) throws UserRoleException {
        this.getDao().createUser((ITenant)proxyUser.getTenant(), proxyUser.getName(), proxyUser.getPassword(), proxyUser.getDescription(), null);
        return true;
    }

    @Override
    public boolean deleteUsers(ProxyPentahoUser[] users) throws UserRoleException {
        int i;
        IPentahoUser[] persistedUsers = new IPentahoUser[users.length];
        for (i = 0; i < users.length; ++i) {
            persistedUsers[i] = this.getDao().getUser((ITenant)users[i].getTenant(), users[i].getName());
            if (persistedUsers[i] != null) continue;
            throw new UserRoleException(Messages.getInstance().getErrorString("UserRoleWebService.ERROR_0003_USER_DELETION_FAILED_NO_USER", new Object[]{users[i].getName()}));
        }
        for (i = 0; i < persistedUsers.length; ++i) {
            this.getDao().deleteUser(persistedUsers[i]);
        }
        return true;
    }

    @Override
    public ProxyPentahoUser getUser(String pUserName) throws UserRoleException {
        ProxyPentahoUser proxyPentahoUser = null;
        IPentahoUser user = this.getDao().getUser(null, pUserName);
        if (user != null) {
            proxyPentahoUser = ProxyPentahoUserRoleHelper.toProxyUser(user);
        }
        return proxyPentahoUser;
    }

    @Override
    public ProxyPentahoUser[] getUsers() throws UserRoleException {
        List users = this.getDao().getUsers();
        if (users != null) {
            ProxyPentahoUser[] proxyUsers = new ProxyPentahoUser[users.size()];
            int i = 0;
            for (IPentahoUser user : users) {
                proxyUsers[i++] = ProxyPentahoUserRoleHelper.toProxyUser(user);
            }
            return proxyUsers;
        }
        return null;
    }

    @Override
    public ProxyPentahoUser[] getUsersForRole(ProxyPentahoRole proxyRole) throws UserRoleException {
        ArrayList<ProxyPentahoUser> users = new ArrayList<ProxyPentahoUser>();
        IPentahoRole role = this.getDao().getRole((ITenant)proxyRole.getTenant(), proxyRole.getName());
        if (role != null) {
            for (IPentahoUser user : this.getDao().getRoleMembers((ITenant)proxyRole.getTenant(), proxyRole.getName())) {
                users.add(ProxyPentahoUserRoleHelper.toProxyUser(user));
            }
        } else {
            throw new UserRoleException(Messages.getInstance().getErrorString("UserRoleWebService.ERROR_0005_FAILED_TO_FIND_ROLE", new Object[]{proxyRole.getName()}));
        }
        return users.toArray(new ProxyPentahoUser[0]);
    }

    @Override
    public boolean updateUser(ProxyPentahoUser proxyUser) throws UserRoleException {
        IPentahoUser user = this.getDao().getUser((ITenant)proxyUser.getTenant(), proxyUser.getName());
        if (user == null) {
            throw new UserRoleException(Messages.getInstance().getErrorString("UserRoleWebService.ERROR_0004_FAILED_TO_FIND_USER", new Object[]{proxyUser.getName()}));
        }
        if (!StringUtils.isBlank((String)proxyUser.getPassword())) {
            this.getDao().setPassword((ITenant)proxyUser.getTenant(), proxyUser.getName(), proxyUser.getPassword());
        }
        this.getDao().setUserDescription((ITenant)proxyUser.getTenant(), proxyUser.getName(), proxyUser.getDescription());
        return true;
    }

    @Override
    public void setRoles(ProxyPentahoUser proxyUser, ProxyPentahoRole[] assignedRoles) throws UserRoleException {
        IPentahoUser user = this.getDao().getUser((ITenant)proxyUser.getTenant(), proxyUser.getName());
        if (user == null) {
            throw new UserRoleException(Messages.getInstance().getErrorString("UserRoleWebService.ERROR_0004_FAILED_TO_FIND_USER", new Object[]{proxyUser.getName()}));
        }
        ArrayList<String> roles = new ArrayList<String>();
        for (ProxyPentahoRole assignedRole : assignedRoles) {
            roles.add(assignedRole.getName());
        }
        this.getDao().setUserRoles((ITenant)proxyUser.getTenant(), proxyUser.getName(), roles.toArray(new String[0]));
    }

    @Override
    public void setUsers(ProxyPentahoRole proxyRole, ProxyPentahoUser[] assignedUsers) throws UserRoleException {
        IPentahoRole role = this.getDao().getRole((ITenant)proxyRole.getTenant(), proxyRole.getName());
        if (role == null) {
            throw new UserRoleException(Messages.getInstance().getErrorString("UserRoleWebService.ERROR_0005_FAILED_TO_FIND_ROLE", new Object[]{proxyRole.getName()}));
        }
        ArrayList<String> userNames = new ArrayList<String>();
        for (ProxyPentahoUser proxyUser : assignedUsers) {
            userNames.add(proxyUser.getName());
        }
        this.getDao().setRoleMembers((ITenant)proxyRole.getTenant(), proxyRole.getName(), userNames.toArray(new String[0]));
    }

    @Override
    public void updateRole(String roleName, String description, List<String> usernames) throws UserRoleException {
        IPentahoRole role = this.getDao().getRole(null, roleName);
        if (role == null) {
            throw new UserRoleException(Messages.getInstance().getErrorString("UserRoleWebService.ERROR_0006_ROLE_UPDATE_FAILED", new Object[]{roleName}));
        }
        HashSet<String> users = new HashSet<String>();
        for (String username : usernames) {
            IPentahoUser user = this.getDao().getUser(null, username);
            if (user == null) {
                throw new UserRoleException(Messages.getInstance().getErrorString("UserRoleWebService.ERROR_0006_ROLE_UPDATE_FAILED", new Object[]{roleName}));
            }
            users.add(user.getUsername());
        }
        this.getDao().setRoleDescription(null, roleName, description);
        this.getDao().setRoleMembers(null, roleName, users.toArray(new String[0]));
    }

    @Override
    public boolean createRole(ProxyPentahoRole proxyRole) throws UserRoleException {
        this.getDao().createRole((ITenant)proxyRole.getTenant(), proxyRole.getName(), proxyRole.getDescription(), new String[0]);
        return false;
    }

    @Override
    public boolean deleteRoles(ProxyPentahoRole[] roles) throws UserRoleException {
        int i;
        IPentahoRole[] persistedRoles = new IPentahoRole[roles.length];
        for (i = 0; i < roles.length; ++i) {
            persistedRoles[i] = this.getDao().getRole((ITenant)roles[i].getTenant(), roles[i].getName());
            if (persistedRoles[i] != null) continue;
            throw new UserRoleException(Messages.getInstance().getErrorString("UserRoleWebService.ERROR_0007_ROLE_DELETION_FAILED_NO_ROLE", new Object[]{roles[i].getName()}));
        }
        for (i = 0; i < persistedRoles.length; ++i) {
            this.getDao().deleteRole(persistedRoles[i]);
        }
        return true;
    }

    @Override
    public ProxyPentahoRole[] getRolesForUser(ProxyPentahoUser proxyUser) throws UserRoleException {
        ArrayList<ProxyPentahoRole> proxyRoles = new ArrayList<ProxyPentahoRole>();
        IPentahoUser user = this.getDao().getUser((ITenant)proxyUser.getTenant(), proxyUser.getName());
        if (user != null) {
            for (IPentahoRole role : this.getDao().getUserRoles((ITenant)proxyUser.getTenant(), proxyUser.getName())) {
                proxyRoles.add(ProxyPentahoUserRoleHelper.toProxyRole(role));
            }
        } else {
            throw new UserRoleException(Messages.getInstance().getErrorString("UserRoleWebService.ERROR_0004_FAILED_TO_FIND_USER", new Object[]{proxyUser.getName()}));
        }
        return proxyRoles.toArray(new ProxyPentahoRole[0]);
    }

    @Override
    public ProxyPentahoRole[] getRoles() throws UserRoleException {
        ArrayList<ProxyPentahoRole> proxyRoles = new ArrayList<ProxyPentahoRole>();
        List roles = this.getDao().getRoles();
        if (roles != null) {
            for (IPentahoRole role : roles) {
                proxyRoles.add(ProxyPentahoUserRoleHelper.toProxyRole(role));
            }
        }
        return proxyRoles.toArray(new ProxyPentahoRole[0]);
    }

    @Override
    public boolean updateRoleObject(ProxyPentahoRole proxyPentahoRole) throws UserRoleException {
        IPentahoRole role = this.getDao().getRole((ITenant)proxyPentahoRole.getTenant(), proxyPentahoRole.getName());
        if (role == null) {
            throw new UserRoleException(Messages.getInstance().getErrorString("UserRoleWebService.ERROR_0006_ROLE_UPDATE_FAILED", new Object[]{proxyPentahoRole.getName()}));
        }
        this.getDao().setRoleDescription((ITenant)proxyPentahoRole.getTenant(), proxyPentahoRole.getName(), proxyPentahoRole.getDescription());
        return true;
    }

    private boolean canAdminister() {
        IAuthorizationPolicy policy = (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);
        return policy.isAllowed("org.pentaho.repository.read") && policy.isAllowed("org.pentaho.repository.create") && policy.isAllowed("org.pentaho.security.administerSecurity");
    }
}

