/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy.fast;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.CharacterCodingException;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.serde2.fast.DeserializeRead;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalYearMonthWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.lazy.LazyBinary;
import org.apache.hadoop.hive.serde2.lazy.LazyByte;
import org.apache.hadoop.hive.serde2.lazy.LazyInteger;
import org.apache.hadoop.hive.serde2.lazy.LazyLong;
import org.apache.hadoop.hive.serde2.lazy.LazySerDeParameters;
import org.apache.hadoop.hive.serde2.lazy.LazyShort;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.HiveDecimalUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.Text;
import org.apache.hive.common.util.TimestampParser;

public final class LazySimpleDeserializeRead
implements DeserializeRead {
    public static final Log LOG = LogFactory.getLog((String)LazySimpleDeserializeRead.class.getName());
    private TypeInfo[] typeInfos;
    private byte separator;
    private boolean isEscaped;
    private byte escapeChar;
    private byte[] nullSequenceBytes;
    private boolean isExtendedBooleanLiteral;
    private byte[] bytes;
    private int start;
    private int offset;
    private int end;
    private int fieldCount;
    private int fieldIndex;
    private int fieldStart;
    private int fieldLength;
    private boolean saveBool;
    private byte saveByte;
    private short saveShort;
    private int saveInt;
    private long saveLong;
    private float saveFloat;
    private double saveDouble;
    private byte[] saveBytes;
    private int saveBytesStart;
    private int saveBytesLength;
    private Date saveDate;
    private Timestamp saveTimestamp;
    private HiveIntervalYearMonth saveIntervalYearMonth;
    private HiveIntervalDayTime saveIntervalDayTime;
    private HiveDecimal saveDecimal;
    private DecimalTypeInfo saveDecimalTypeInfo;
    private Text tempText;
    private TimestampParser timestampParser;
    private boolean readBeyondConfiguredFieldsWarned;
    private boolean readBeyondBufferRangeWarned;
    private boolean bufferRangeHasExtraDataWarned;
    private static byte[] maxLongBytes = Long.valueOf(Long.MAX_VALUE).toString().getBytes();
    private static int maxLongDigitsCount = maxLongBytes.length;
    private static byte[] minLongNoSignBytes = Long.valueOf(Long.MIN_VALUE).toString().substring(1).getBytes();

    public LazySimpleDeserializeRead(TypeInfo[] typeInfos, byte separator, LazySerDeParameters lazyParams) {
        this.typeInfos = typeInfos;
        this.separator = separator;
        this.isEscaped = lazyParams.isEscaped();
        this.escapeChar = lazyParams.getEscapeChar();
        this.nullSequenceBytes = lazyParams.getNullSequence().getBytes();
        this.isExtendedBooleanLiteral = lazyParams.isExtendedBooleanLiteral();
        this.fieldCount = typeInfos.length;
        this.tempText = new Text();
        this.readBeyondConfiguredFieldsWarned = false;
        this.readBeyondBufferRangeWarned = false;
        this.bufferRangeHasExtraDataWarned = false;
    }

    private LazySimpleDeserializeRead() {
    }

    @Override
    public TypeInfo[] typeInfos() {
        return this.typeInfos;
    }

    @Override
    public void set(byte[] bytes, int offset, int length) {
        this.bytes = bytes;
        this.offset = offset;
        this.start = offset;
        this.end = offset + length;
        this.fieldIndex = -1;
    }

    @Override
    public boolean readCheckNull() {
        int i;
        if (++this.fieldIndex >= this.fieldCount) {
            if (!this.readBeyondConfiguredFieldsWarned) {
                LOG.info((Object)("Reading beyond configured fields! Configured " + this.fieldCount + " fields but " + " reading more (NULLs returned).  Ignoring similar problems."));
                this.readBeyondConfiguredFieldsWarned = true;
            }
            return true;
        }
        if (this.offset > this.end) {
            if (!this.readBeyondBufferRangeWarned) {
                int length = this.end - this.start;
                LOG.info((Object)("Reading beyond buffer range! Buffer range " + this.start + " for length " + length + " but reading more (NULLs returned)." + "  Ignoring similar problems."));
                this.readBeyondBufferRangeWarned = true;
            }
            return true;
        }
        this.fieldStart = this.offset;
        while (true) {
            if (this.offset >= this.end) {
                this.fieldLength = this.offset - this.fieldStart;
                break;
            }
            if (this.bytes[this.offset] == this.separator) {
                this.fieldLength = this.offset++ - this.fieldStart;
                break;
            }
            if (this.isEscaped && this.bytes[this.offset] == this.escapeChar && this.offset + 1 < this.end) {
                this.offset += 2;
                continue;
            }
            ++this.offset;
        }
        char[] charField = new char[this.fieldLength];
        for (int c = 0; c < charField.length; ++c) {
            charField[c] = (char)(this.bytes[this.fieldStart + c] & 0xFF);
        }
        if (this.nullSequenceBytes != null && this.fieldLength == this.nullSequenceBytes.length) {
            i = 0;
            while (this.bytes[this.fieldStart + i] == this.nullSequenceBytes[i]) {
                if (++i < this.fieldLength) continue;
                return true;
            }
        }
        switch (((PrimitiveTypeInfo)this.typeInfos[this.fieldIndex]).getPrimitiveCategory()) {
            case BOOLEAN: {
                i = this.fieldStart;
                if (this.fieldLength == 4) {
                    if (!(this.bytes[i] != 84 && this.bytes[i] != 116 || this.bytes[i + 1] != 82 && this.bytes[i + 1] != 114 || this.bytes[i + 2] != 85 && this.bytes[i + 1] != 117 || this.bytes[i + 3] != 69 && this.bytes[i + 3] != 101)) {
                        this.saveBool = true;
                        break;
                    }
                    return true;
                }
                if (this.fieldLength == 5) {
                    if (!(this.bytes[i] != 70 && this.bytes[i] != 102 || this.bytes[i + 1] != 65 && this.bytes[i + 1] != 97 || this.bytes[i + 2] != 76 && this.bytes[i + 2] != 108 || this.bytes[i + 3] != 83 && this.bytes[i + 3] != 115 || this.bytes[i + 4] != 69 && this.bytes[i + 4] != 101)) {
                        this.saveBool = false;
                        break;
                    }
                    return true;
                }
                if (this.isExtendedBooleanLiteral && this.fieldLength == 1) {
                    byte b = this.bytes[this.fieldStart];
                    if (b == 49 || b == 116 || b == 84) {
                        this.saveBool = true;
                        break;
                    }
                    if (b == 48 || b == 102 || b == 70) {
                        this.saveBool = false;
                        break;
                    }
                    return true;
                }
                return true;
            }
            case BYTE: {
                try {
                    this.saveByte = LazyByte.parseByte(this.bytes, this.fieldStart, this.fieldLength, 10);
                    break;
                }
                catch (NumberFormatException e) {
                    this.logExceptionMessage(this.bytes, this.fieldStart, this.fieldLength, "TINYINT");
                    return true;
                }
            }
            case SHORT: {
                try {
                    this.saveShort = LazyShort.parseShort(this.bytes, this.fieldStart, this.fieldLength, 10);
                    break;
                }
                catch (NumberFormatException e) {
                    this.logExceptionMessage(this.bytes, this.fieldStart, this.fieldLength, "SMALLINT");
                    return true;
                }
            }
            case INT: {
                try {
                    this.saveInt = LazyInteger.parseInt(this.bytes, this.fieldStart, this.fieldLength, 10);
                    break;
                }
                catch (NumberFormatException e) {
                    this.logExceptionMessage(this.bytes, this.fieldStart, this.fieldLength, "INT");
                    return true;
                }
            }
            case LONG: {
                try {
                    this.saveLong = LazyLong.parseLong(this.bytes, this.fieldStart, this.fieldLength, 10);
                    break;
                }
                catch (NumberFormatException e) {
                    this.logExceptionMessage(this.bytes, this.fieldStart, this.fieldLength, "BIGINT");
                    return true;
                }
            }
            case FLOAT: {
                String byteData = null;
                try {
                    byteData = Text.decode((byte[])this.bytes, (int)this.fieldStart, (int)this.fieldLength);
                    this.saveFloat = Float.parseFloat(byteData);
                    break;
                }
                catch (NumberFormatException e) {
                    LOG.debug((Object)("Data not in the Float data type range so converted to null. Given data is :" + byteData), (Throwable)e);
                    return true;
                }
                catch (CharacterCodingException e) {
                    LOG.debug((Object)"Data not in the Float data type range so converted to null.", (Throwable)e);
                    return true;
                }
            }
            case DOUBLE: {
                String byteData = null;
                try {
                    byteData = Text.decode((byte[])this.bytes, (int)this.fieldStart, (int)this.fieldLength);
                    this.saveDouble = Double.parseDouble(byteData);
                    break;
                }
                catch (NumberFormatException e) {
                    LOG.debug((Object)("Data not in the Double data type range so converted to null. Given data is :" + byteData), (Throwable)e);
                    return true;
                }
                catch (CharacterCodingException e) {
                    LOG.debug((Object)"Data not in the Double data type range so converted to null.", (Throwable)e);
                    return true;
                }
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                if (this.isEscaped) {
                    LazyUtils.copyAndEscapeStringDataToText(this.bytes, this.fieldStart, this.fieldLength, this.escapeChar, this.tempText);
                    this.saveBytes = this.tempText.getBytes();
                    this.saveBytesStart = 0;
                    this.saveBytesLength = this.tempText.getLength();
                    break;
                }
                this.saveBytes = this.bytes;
                this.saveBytesStart = this.fieldStart;
                this.saveBytesLength = this.fieldLength;
                break;
            }
            case BINARY: {
                byte[] recv = new byte[this.fieldLength];
                System.arraycopy(this.bytes, this.fieldStart, recv, 0, this.fieldLength);
                byte[] decoded = LazyBinary.decodeIfNeeded(recv);
                decoded = decoded.length > 0 ? decoded : recv;
                this.saveBytes = decoded;
                this.saveBytesStart = 0;
                this.saveBytesLength = decoded.length;
                break;
            }
            case DATE: {
                String s = null;
                try {
                    s = Text.decode((byte[])this.bytes, (int)this.fieldStart, (int)this.fieldLength);
                    this.saveDate = Date.valueOf(s);
                    break;
                }
                catch (Exception e) {
                    this.logExceptionMessage(this.bytes, this.fieldStart, this.fieldLength, "DATE");
                    return true;
                }
            }
            case TIMESTAMP: {
                String s = null;
                try {
                    s = new String(this.bytes, this.fieldStart, this.fieldLength, "US-ASCII");
                }
                catch (UnsupportedEncodingException e) {
                    LOG.error((Object)"Unsupported encoding found ", (Throwable)e);
                    s = "";
                }
                if (s.compareTo("NULL") == 0) {
                    this.logExceptionMessage(this.bytes, this.fieldStart, this.fieldLength, "TIMESTAMP");
                    return true;
                }
                try {
                    if (this.timestampParser == null) {
                        this.timestampParser = new TimestampParser();
                    }
                    this.saveTimestamp = this.timestampParser.parseTimestamp(s);
                    break;
                }
                catch (IllegalArgumentException e) {
                    this.logExceptionMessage(this.bytes, this.fieldStart, this.fieldLength, "TIMESTAMP");
                    return true;
                }
            }
            case INTERVAL_YEAR_MONTH: {
                String s = null;
                try {
                    s = Text.decode((byte[])this.bytes, (int)this.fieldStart, (int)this.fieldLength);
                    this.saveIntervalYearMonth = HiveIntervalYearMonth.valueOf((String)s);
                    break;
                }
                catch (Exception e) {
                    this.logExceptionMessage(this.bytes, this.fieldStart, this.fieldLength, "INTERVAL_YEAR_MONTH");
                    return true;
                }
            }
            case INTERVAL_DAY_TIME: {
                String s = null;
                try {
                    s = Text.decode((byte[])this.bytes, (int)this.fieldStart, (int)this.fieldLength);
                    this.saveIntervalDayTime = HiveIntervalDayTime.valueOf((String)s);
                    break;
                }
                catch (Exception e) {
                    this.logExceptionMessage(this.bytes, this.fieldStart, this.fieldLength, "INTERVAL_DAY_TIME");
                    return true;
                }
            }
            case DECIMAL: {
                String byteData = null;
                try {
                    byteData = Text.decode((byte[])this.bytes, (int)this.fieldStart, (int)this.fieldLength);
                }
                catch (CharacterCodingException e) {
                    LOG.debug((Object)"Data not in the HiveDecimal data type range so converted to null.", (Throwable)e);
                    return true;
                }
                this.saveDecimal = HiveDecimal.create((String)byteData);
                this.saveDecimalTypeInfo = (DecimalTypeInfo)this.typeInfos[this.fieldIndex];
                int precision = this.saveDecimalTypeInfo.getPrecision();
                int scale = this.saveDecimalTypeInfo.getScale();
                this.saveDecimal = HiveDecimalUtils.enforcePrecisionScale(this.saveDecimal, precision, scale);
                if (this.saveDecimal != null) break;
                LOG.debug((Object)("Data not in the HiveDecimal data type range so converted to null. Given data is :" + byteData));
                return true;
            }
            default: {
                throw new Error("Unexpected primitive category " + (Object)((Object)((PrimitiveTypeInfo)this.typeInfos[this.fieldIndex]).getPrimitiveCategory()));
            }
        }
        return false;
    }

    public void logExceptionMessage(byte[] bytes, int bytesStart, int bytesLength, String dataType) {
        try {
            if (LOG.isDebugEnabled()) {
                String byteData = Text.decode((byte[])bytes, (int)bytesStart, (int)bytesLength);
                LOG.debug((Object)("Data not in the " + dataType + " data type range so converted to null. Given data is :" + byteData), (Throwable)new Exception("For debugging purposes"));
            }
        }
        catch (CharacterCodingException e1) {
            LOG.debug((Object)("Data not in the " + dataType + " data type range so converted to null."), (Throwable)e1);
        }
    }

    @Override
    public void extraFieldsCheck() {
        if (this.offset < this.end && !this.bufferRangeHasExtraDataWarned) {
            int length = this.end - this.start;
            LOG.info((Object)("Not all fields were read in the buffer range! Buffer range " + this.start + " for length " + length + " but reading more (NULLs returned)." + "  Ignoring similar problems."));
            this.bufferRangeHasExtraDataWarned = true;
        }
    }

    @Override
    public boolean readBeyondConfiguredFieldsWarned() {
        return this.readBeyondConfiguredFieldsWarned;
    }

    @Override
    public boolean readBeyondBufferRangeWarned() {
        return this.readBeyondBufferRangeWarned;
    }

    @Override
    public boolean bufferRangeHasExtraDataWarned() {
        return this.bufferRangeHasExtraDataWarned;
    }

    @Override
    public boolean readBoolean() {
        return this.saveBool;
    }

    @Override
    public byte readByte() {
        return this.saveByte;
    }

    @Override
    public short readShort() {
        return this.saveShort;
    }

    @Override
    public int readInt() {
        return this.saveInt;
    }

    @Override
    public long readLong() {
        return this.saveLong;
    }

    @Override
    public float readFloat() {
        return this.saveFloat;
    }

    @Override
    public double readDouble() {
        return this.saveDouble;
    }

    @Override
    public DeserializeRead.ReadStringResults createReadStringResults() {
        return new LazySimpleReadStringResults();
    }

    @Override
    public void readString(DeserializeRead.ReadStringResults readStringResults) {
        readStringResults.bytes = this.saveBytes;
        readStringResults.start = this.saveBytesStart;
        readStringResults.length = this.saveBytesLength;
    }

    @Override
    public DeserializeRead.ReadHiveCharResults createReadHiveCharResults() {
        return new LazySimpleReadHiveCharResults();
    }

    @Override
    public void readHiveChar(DeserializeRead.ReadHiveCharResults readHiveCharResults) throws IOException {
        LazySimpleReadHiveCharResults LazySimpleReadHiveCharResults2 = (LazySimpleReadHiveCharResults)readHiveCharResults;
        if (!LazySimpleReadHiveCharResults2.isInit()) {
            LazySimpleReadHiveCharResults2.init((CharTypeInfo)this.typeInfos[this.fieldIndex]);
        }
        if (LazySimpleReadHiveCharResults2.readStringResults == null) {
            LazySimpleReadHiveCharResults2.readStringResults = new LazySimpleReadStringResults();
        }
        LazySimpleReadStringResults readStringResults = LazySimpleReadHiveCharResults2.readStringResults;
        this.readString(readStringResults);
        HiveCharWritable hiveCharWritable = LazySimpleReadHiveCharResults2.getHiveCharWritable();
        hiveCharWritable.getTextValue().set(readStringResults.bytes, readStringResults.start, readStringResults.length);
        hiveCharWritable.enforceMaxLength(LazySimpleReadHiveCharResults2.getMaxLength());
        readHiveCharResults.bytes = hiveCharWritable.getTextValue().getBytes();
        readHiveCharResults.start = 0;
        readHiveCharResults.length = hiveCharWritable.getTextValue().getLength();
    }

    @Override
    public DeserializeRead.ReadHiveVarcharResults createReadHiveVarcharResults() {
        return new LazySimpleReadHiveVarcharResults();
    }

    @Override
    public void readHiveVarchar(DeserializeRead.ReadHiveVarcharResults readHiveVarcharResults) throws IOException {
        LazySimpleReadHiveVarcharResults lazySimpleReadHiveVarvarcharResults = (LazySimpleReadHiveVarcharResults)readHiveVarcharResults;
        if (!lazySimpleReadHiveVarvarcharResults.isInit()) {
            lazySimpleReadHiveVarvarcharResults.init((VarcharTypeInfo)this.typeInfos[this.fieldIndex]);
        }
        if (lazySimpleReadHiveVarvarcharResults.readStringResults == null) {
            lazySimpleReadHiveVarvarcharResults.readStringResults = new LazySimpleReadStringResults();
        }
        LazySimpleReadStringResults readStringResults = lazySimpleReadHiveVarvarcharResults.readStringResults;
        this.readString(readStringResults);
        HiveVarcharWritable hiveVarcharWritable = lazySimpleReadHiveVarvarcharResults.getHiveVarcharWritable();
        hiveVarcharWritable.getTextValue().set(readStringResults.bytes, readStringResults.start, readStringResults.length);
        hiveVarcharWritable.enforceMaxLength(lazySimpleReadHiveVarvarcharResults.getMaxLength());
        readHiveVarcharResults.bytes = hiveVarcharWritable.getTextValue().getBytes();
        readHiveVarcharResults.start = 0;
        readHiveVarcharResults.length = hiveVarcharWritable.getTextValue().getLength();
    }

    @Override
    public DeserializeRead.ReadBinaryResults createReadBinaryResults() {
        return new LazySimpleReadBinaryResults();
    }

    @Override
    public void readBinary(DeserializeRead.ReadBinaryResults readBinaryResults) {
        readBinaryResults.bytes = this.saveBytes;
        readBinaryResults.start = this.saveBytesStart;
        readBinaryResults.length = this.saveBytesLength;
    }

    @Override
    public DeserializeRead.ReadDateResults createReadDateResults() {
        return new LazySimpleReadDateResults();
    }

    @Override
    public void readDate(DeserializeRead.ReadDateResults readDateResults) {
        LazySimpleReadDateResults lazySimpleReadDateResults = (LazySimpleReadDateResults)readDateResults;
        DateWritable dateWritable = lazySimpleReadDateResults.getDateWritable();
        dateWritable.set(this.saveDate);
        this.saveDate = null;
    }

    @Override
    public DeserializeRead.ReadIntervalYearMonthResults createReadIntervalYearMonthResults() {
        return new LazySimpleReadIntervalYearMonthResults();
    }

    @Override
    public void readIntervalYearMonth(DeserializeRead.ReadIntervalYearMonthResults readIntervalYearMonthResults) throws IOException {
        LazySimpleReadIntervalYearMonthResults lazySimpleReadIntervalYearMonthResults = (LazySimpleReadIntervalYearMonthResults)readIntervalYearMonthResults;
        HiveIntervalYearMonthWritable hiveIntervalYearMonthWritable = lazySimpleReadIntervalYearMonthResults.getHiveIntervalYearMonthWritable();
        hiveIntervalYearMonthWritable.set(this.saveIntervalYearMonth);
        this.saveIntervalYearMonth = null;
    }

    @Override
    public DeserializeRead.ReadIntervalDayTimeResults createReadIntervalDayTimeResults() {
        return new LazySimpleReadIntervalDayTimeResults();
    }

    @Override
    public void readIntervalDayTime(DeserializeRead.ReadIntervalDayTimeResults readIntervalDayTimeResults) throws IOException {
        LazySimpleReadIntervalDayTimeResults lazySimpleReadIntervalDayTimeResults = (LazySimpleReadIntervalDayTimeResults)readIntervalDayTimeResults;
        HiveIntervalDayTimeWritable hiveIntervalDayTimeWritable = lazySimpleReadIntervalDayTimeResults.getHiveIntervalDayTimeWritable();
        hiveIntervalDayTimeWritable.set(this.saveIntervalDayTime);
        this.saveIntervalDayTime = null;
    }

    @Override
    public DeserializeRead.ReadTimestampResults createReadTimestampResults() {
        return new LazySimpleReadTimestampResults();
    }

    @Override
    public void readTimestamp(DeserializeRead.ReadTimestampResults readTimestampResults) {
        LazySimpleReadTimestampResults lazySimpleReadTimestampResults = (LazySimpleReadTimestampResults)readTimestampResults;
        TimestampWritable timestampWritable = lazySimpleReadTimestampResults.getTimestampWritable();
        timestampWritable.set(this.saveTimestamp);
        this.saveTimestamp = null;
    }

    @Override
    public DeserializeRead.ReadDecimalResults createReadDecimalResults() {
        return new LazySimpleReadDecimalResults();
    }

    @Override
    public void readHiveDecimal(DeserializeRead.ReadDecimalResults readDecimalResults) {
        LazySimpleReadDecimalResults lazySimpleReadDecimalResults = (LazySimpleReadDecimalResults)readDecimalResults;
        if (!lazySimpleReadDecimalResults.isInit()) {
            lazySimpleReadDecimalResults.init(this.saveDecimalTypeInfo);
        }
        lazySimpleReadDecimalResults.hiveDecimal = this.saveDecimal;
        this.saveDecimal = null;
        this.saveDecimalTypeInfo = null;
    }

    public static int byteArrayCompareRanges(byte[] arg1, int start1, byte[] arg2, int start2, int len) {
        for (int i = 0; i < len; ++i) {
            int b1 = arg1[i + start1] & 0xFF;
            int b2 = arg2[i + start2] & 0xFF;
            if (b1 == b2) continue;
            return b1 - b2;
        }
        return 0;
    }

    private static class LazySimpleReadDecimalResults
    extends DeserializeRead.ReadDecimalResults {
        HiveDecimal hiveDecimal;

        @Override
        public HiveDecimal getHiveDecimal() {
            return this.hiveDecimal;
        }
    }

    private static class LazySimpleReadTimestampResults
    extends DeserializeRead.ReadTimestampResults {
        public TimestampWritable getTimestampWritable() {
            return this.timestampWritable;
        }
    }

    private static class LazySimpleReadIntervalDayTimeResults
    extends DeserializeRead.ReadIntervalDayTimeResults {
        public HiveIntervalDayTimeWritable getHiveIntervalDayTimeWritable() {
            return this.hiveIntervalDayTimeWritable;
        }
    }

    private static class LazySimpleReadIntervalYearMonthResults
    extends DeserializeRead.ReadIntervalYearMonthResults {
        public HiveIntervalYearMonthWritable getHiveIntervalYearMonthWritable() {
            return this.hiveIntervalYearMonthWritable;
        }
    }

    private static class LazySimpleReadDateResults
    extends DeserializeRead.ReadDateResults {
        public DateWritable getDateWritable() {
            return this.dateWritable;
        }
    }

    private class LazySimpleReadBinaryResults
    extends DeserializeRead.ReadBinaryResults {
    }

    private static class LazySimpleReadHiveVarcharResults
    extends DeserializeRead.ReadHiveVarcharResults {
        public LazySimpleReadStringResults readStringResults;

        public HiveVarcharWritable getHiveVarcharWritable() {
            return this.hiveVarcharWritable;
        }
    }

    private static class LazySimpleReadHiveCharResults
    extends DeserializeRead.ReadHiveCharResults {
        public LazySimpleReadStringResults readStringResults;

        public HiveCharWritable getHiveCharWritable() {
            return this.hiveCharWritable;
        }
    }

    private class LazySimpleReadStringResults
    extends DeserializeRead.ReadStringResults {
    }
}

