/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.instance.command;

import org.apache.karaf.instance.command.InstanceCommandSupport;
import org.apache.karaf.instance.core.Instance;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.apache.karaf.shell.table.ShellTable;

@Command(scope="instance", name="list", description="Lists all existing container instances.")
public class ListCommand
extends InstanceCommandSupport {
    @Option(name="-l", aliases={"--location"}, description="Displays the location of the container instances", required=false, multiValued=false)
    boolean location;
    @Option(name="-o", aliases={"--java-opts"}, description="Displays the Java options used to launch the JVM", required=false, multiValued=false)
    boolean javaOpts;
    @Option(name="--no-color", description="Disable table rendered output", required=false, multiValued=false)
    boolean noFormat;

    protected Object doExecute() throws Exception {
        this.getInstanceService().refreshInstance();
        Instance[] instances = this.getInstanceService().getInstances();
        ShellTable table = new ShellTable();
        table.column("SSH Port").alignRight();
        table.column("RMI Registry").alignRight();
        table.column("RMI Server").alignRight();
        table.column("State");
        table.column("PID");
        table.column(this.getRightColumnHeader());
        for (Instance instance : instances) {
            table.addRow().addContent(new Object[]{instance.getSshPort(), instance.getRmiRegistryPort(), instance.getRmiServerPort(), instance.getState(), instance.getPid(), this.getRightColumnValue(instance)});
        }
        table.print(System.out, !this.noFormat);
        return null;
    }

    private String getRightColumnHeader() {
        if (this.javaOpts) {
            return "JavaOpts";
        }
        if (this.location) {
            return "Location";
        }
        return "Name";
    }

    private String getRightColumnValue(Instance instance) {
        if (this.javaOpts) {
            return instance.getJavaOpts();
        }
        if (this.location) {
            return instance.getLocation();
        }
        return instance.getName();
    }
}

