/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.util.ArrayList;
import java.util.Collection;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.BandType;
import org.pentaho.reporting.engine.classic.core.style.BandDefaultStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class Band
extends Section {
    private static final Element[] EMPTY_ARRAY = new Element[0];
    private ArrayList<Element> allElements;
    private transient Element[] allElementsCached;
    public static final String ANONYMOUS_BAND_PREFIX = "anonymousBand@";

    public Band() {
        this.setElementType(new BandType());
    }

    public Band(InstanceID id) {
        super(id);
        this.setElementType(new BandType());
    }

    public Band(boolean pagebreakBefore, boolean pagebreakAfter) {
        this();
        if (pagebreakBefore) {
            this.setPagebreakBeforePrint(pagebreakBefore);
        }
        if (pagebreakAfter) {
            this.setPagebreakAfterPrint(pagebreakAfter);
        }
    }

    @Override
    public ElementStyleSheet getDefaultStyleSheet() {
        return BandDefaultStyleSheet.getBandDefaultStyle();
    }

    public void addElement(Element element) {
        this.addElement(this.getElementCount(), element);
    }

    public void addElement(int position, Element element) {
        if (position < 0) {
            throw new IllegalArgumentException("Position < 0");
        }
        if (position > this.getElementCount()) {
            throw new IllegalArgumentException("Position < 0");
        }
        if (element == null) {
            throw new NullPointerException("Band.addElement(...): element is null.");
        }
        this.validateLooping(element);
        if (this.unregisterParent(element)) {
            return;
        }
        if (this.allElements == null) {
            this.allElements = new ArrayList();
        }
        this.allElements.add(position, element);
        this.allElementsCached = null;
        this.registerAsChild(element);
        this.notifyNodeChildAdded(element);
    }

    public void addElements(Collection elements) {
        if (elements == null) {
            throw new NullPointerException("Band.addElements(...): collection is null.");
        }
        for (Element element : elements) {
            this.addElement(element);
        }
    }

    public Element getElement(String name) {
        if (name == null) {
            throw new NullPointerException("Band.getElement(...): name is null.");
        }
        for (Element e : this.internalGetElementArray()) {
            String elementName = e.getName();
            if (elementName == null || !elementName.equals(name)) continue;
            return e;
        }
        return null;
    }

    @Override
    public void removeElement(Element e) {
        if (e == null) {
            throw new NullPointerException();
        }
        if (e.getParentSection() != this) {
            return;
        }
        if (this.allElements == null) {
            return;
        }
        e.setParent(null);
        this.allElements.remove(e);
        this.allElementsCached = null;
        this.notifyNodeChildRemoved(e);
    }

    public void removeElement(int index) {
        this.removeElement(this.getElement(index));
    }

    @Override
    public void setElementAt(int position, Element element) {
        if (position < 0) {
            throw new IllegalArgumentException("Position < 0");
        }
        if (position >= this.getElementCount()) {
            throw new IllegalArgumentException("Position >= size");
        }
        if (element == null) {
            throw new NullPointerException("Band.addElement(...): element is null.");
        }
        this.validateLooping(element);
        if (this.unregisterParent(element)) {
            return;
        }
        if (this.allElements == null) {
            throw new IllegalStateException("The throws above should have caught that state");
        }
        Element o = this.allElements.set(position, element);
        o.setParent(null);
        this.allElementsCached = null;
        this.registerAsChild(element);
        this.notifyNodeChildRemoved(o);
        this.notifyNodeChildAdded(element);
    }

    public void clear() {
        Element[] elements = this.internalGetElementArray();
        for (int i = 0; i < elements.length; ++i) {
            Element element = elements[i];
            this.removeElement(element);
        }
    }

    @Override
    public int getElementCount() {
        if (this.allElements == null) {
            return 0;
        }
        return this.allElements.size();
    }

    public Element[] getElementArray() {
        return (Element[])this.internalGetElementArray().clone();
    }

    private Element[] internalGetElementArray() {
        if (this.allElementsCached == null) {
            if (this.allElements == null || this.allElements.isEmpty()) {
                this.allElementsCached = EMPTY_ARRAY;
            } else {
                Element[] elements = new Element[this.allElements.size()];
                elements = this.allElements.toArray(elements);
                this.allElementsCached = elements;
            }
        }
        return this.allElementsCached;
    }

    public final Element[] unsafeGetElementArray() {
        return this.internalGetElementArray();
    }

    @Override
    public Element getElement(int index) {
        if (this.allElements == null) {
            throw new IndexOutOfBoundsException("This index is invalid.");
        }
        return this.allElements.get(index);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder(100);
        b.append(this.getClass().getName());
        b.append("={name=\"");
        b.append(this.getName());
        b.append("\", size=\"");
        b.append(this.getElementCount());
        b.append("\", layout=\"");
        b.append(this.getStyle().getStyleProperty(BandStyleKeys.LAYOUT));
        b.append("\"}");
        return b.toString();
    }

    @Override
    public Band clone() {
        Band b;
        block4: {
            b = (Band)super.clone();
            if (this.allElements == null) break block4;
            int elementSize = this.allElements.size();
            b.allElements = (ArrayList)this.allElements.clone();
            b.allElements.clear();
            b.allElementsCached = new Element[elementSize];
            if (this.allElementsCached != null) {
                for (int i = 0; i < elementSize; ++i) {
                    Element eC = this.allElementsCached[i].clone();
                    b.allElements.add(eC);
                    b.allElementsCached[i] = eC;
                    eC.setParent(b);
                }
            } else {
                for (int i = 0; i < elementSize; ++i) {
                    Element e = this.allElements.get(i);
                    Element eC = e.clone();
                    b.allElements.add(eC);
                    b.allElementsCached[i] = eC;
                    eC.setParent(b);
                }
            }
        }
        return b;
    }

    @Override
    public Band derive(boolean preserveElementInstanceIds) {
        Band b;
        block4: {
            b = (Band)super.derive(preserveElementInstanceIds);
            if (this.allElements == null) break block4;
            int elementSize = this.allElements.size();
            b.allElements = (ArrayList)this.allElements.clone();
            b.allElements.clear();
            b.allElementsCached = new Element[elementSize];
            if (this.allElementsCached != null) {
                for (int i = 0; i < elementSize; ++i) {
                    Element eC = this.allElementsCached[i].derive(preserveElementInstanceIds);
                    b.allElements.add(eC);
                    b.allElementsCached[i] = eC;
                    eC.setParent(b);
                }
            } else {
                for (int i = 0; i < elementSize; ++i) {
                    Element e = this.allElements.get(i);
                    Element eC = e.derive(preserveElementInstanceIds);
                    b.allElements.add(eC);
                    b.allElementsCached[i] = eC;
                    eC.setParent(b);
                }
            }
        }
        return b;
    }

    public boolean isPagebreakBeforePrint() {
        return this.getStyle().getBooleanStyleProperty(BandStyleKeys.PAGEBREAK_BEFORE);
    }

    public void setPagebreakBeforePrint(boolean pagebreakBeforePrint) {
        this.getStyle().setBooleanStyleProperty(BandStyleKeys.PAGEBREAK_BEFORE, pagebreakBeforePrint);
        this.notifyNodePropertiesChanged();
    }

    public boolean isPagebreakAfterPrint() {
        return this.getStyle().getBooleanStyleProperty(BandStyleKeys.PAGEBREAK_AFTER);
    }

    public void setPagebreakAfterPrint(boolean pagebreakAfterPrint) {
        this.getStyle().setBooleanStyleProperty(BandStyleKeys.PAGEBREAK_AFTER, pagebreakAfterPrint);
        this.notifyNodePropertiesChanged();
    }

    public void setLayout(String layout) {
        this.getStyle().setStyleProperty(BandStyleKeys.LAYOUT, layout);
        this.notifyNodePropertiesChanged();
    }

    public String getLayout() {
        return (String)this.getStyle().getStyleProperty(BandStyleKeys.LAYOUT);
    }
}

