/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.designtime.AttributeChange;
import org.pentaho.reporting.engine.classic.core.designtime.AttributeExpressionChange;
import org.pentaho.reporting.engine.classic.core.designtime.StyleChange;
import org.pentaho.reporting.engine.classic.core.designtime.StyleExpressionChange;
import org.pentaho.reporting.engine.classic.core.dom.ReportStructureMatcher;
import org.pentaho.reporting.engine.classic.core.filter.DataSource;
import org.pentaho.reporting.engine.classic.core.filter.DataTarget;
import org.pentaho.reporting.engine.classic.core.filter.EmptyDataSource;
import org.pentaho.reporting.engine.classic.core.filter.types.LegacyType;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.layout.style.SimpleStyleSheet;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.style.ElementDefaultStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.base.util.NullOutputStream;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyUtils;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.serializer.SerializerHelper;

public class Element
implements DataTarget,
ReportElement {
    private static final String[] EMPTY_NAMES = new String[0];
    private static final Log logger = LogFactory.getLog(Element.class);
    public static final String ANONYMOUS_ELEMENT_PREFIX = "anonymousElement@";
    private static final DataSource NULL_DATASOURCE = new EmptyDataSource();
    private DataSource datasource;
    private InternalElementStyleSheet style;
    private Section parent;
    private InstanceID treeLock = new InstanceID();
    private HashMap<StyleKey, Expression> styleExpressions;
    private transient ReportAttributeMap<Object> attributes;
    private transient boolean copyOnWrite;
    private ReportAttributeMap<Expression> attributeExpressions;
    private transient ReportAttributeMap<Object> cachedAttributes;
    private transient long changeTracker;
    private transient Object elementContext;
    private transient ElementType elementType;

    public Element() {
        this.datasource = NULL_DATASOURCE;
        this.style = new InternalElementStyleSheet(this);
        this.attributes = new ReportAttributeMap();
        this.setElementType(LegacyType.INSTANCE);
    }

    protected Element(InstanceID id) {
        this();
        this.treeLock = id;
    }

    @Override
    public SimpleStyleSheet getComputedStyle() {
        SimpleStyleSheet computedStyle = (SimpleStyleSheet)this.attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "computed-style");
        if (computedStyle == null) {
            int hc = System.identityHashCode(this);
            throw new InvalidReportStateException("No computed style for (" + hc + ") - " + this);
        }
        return computedStyle;
    }

    @Override
    public void setComputedStyle(SimpleStyleSheet computedStyle) {
        if (computedStyle == null) {
            throw new IllegalArgumentException();
        }
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "computed-style", computedStyle, false);
    }

    @Override
    public void setAttributeExpression(String namespace, String name, Expression value) {
        if (this.attributeExpressions == null) {
            this.attributeExpressions = new ReportAttributeMap();
        }
        Expression oldExpression = this.attributeExpressions.setAttribute(namespace, name, value);
        this.notifyNodePropertiesChanged(new AttributeExpressionChange(namespace, name, oldExpression, value));
    }

    @Override
    public Expression getAttributeExpression(String namespace, String name) {
        if (this.attributeExpressions == null) {
            return null;
        }
        return (Expression)this.attributeExpressions.getAttribute(namespace, name);
    }

    @Override
    public String[] getAttributeExpressionNamespaces() {
        if (this.attributeExpressions == null) {
            return EMPTY_NAMES;
        }
        return this.attributeExpressions.getNameSpaces();
    }

    @Override
    public String[] getAttributeExpressionNames(String name) {
        if (this.attributeExpressions == null) {
            return EMPTY_NAMES;
        }
        return this.attributeExpressions.getNames(name);
    }

    public ReportAttributeMap<Expression> getAttributeExpressions() {
        if (this.attributeExpressions == null) {
            this.attributeExpressions = new ReportAttributeMap();
        }
        return this.attributeExpressions;
    }

    @Override
    public void setAttribute(String namespace, String name, Object value) {
        this.setAttribute(namespace, name, value, true);
    }

    @Override
    public void setAttribute(String namespace, String name, Object value, boolean notifyChange) {
        if (this.copyOnWrite) {
            this.attributes = this.attributes.clone();
            this.copyOnWrite = false;
        }
        Object oldValue = this.attributes.setAttribute(namespace, name, value);
        if (this.cachedAttributes != null && this.cachedAttributes.getChangeTracker() != this.attributes.getChangeTracker()) {
            this.cachedAttributes = null;
        }
        if ("http://reporting.pentaho.org/namespaces/engine/attributes/core".equals(namespace) && "element-type".equals(name)) {
            this.elementType = value instanceof ElementType ? (ElementType)value : LegacyType.INSTANCE;
        }
        if (notifyChange) {
            this.notifyNodePropertiesChanged(new AttributeChange(namespace, name, oldValue, value));
        }
    }

    @Override
    public Object getAttribute(String namespace, String name) {
        return this.attributes.getAttribute(namespace, name);
    }

    @Override
    public Object getFirstAttribute(String localName) {
        return this.attributes.getFirstAttribute(localName);
    }

    @Override
    public String[] getAttributeNamespaces() {
        return this.attributes.getNameSpaces();
    }

    @Override
    public String[] getAttributeNames(String namespace) {
        return this.attributes.getNames(namespace);
    }

    @Override
    public ReportAttributeMap<Object> getAttributes() {
        if (this.cachedAttributes != null && this.cachedAttributes.getChangeTracker() == this.attributes.getChangeTracker()) {
            return this.cachedAttributes;
        }
        this.cachedAttributes = this.attributes.createUnmodifiableMap();
        return this.cachedAttributes;
    }

    @Override
    public <TS> TS getAttributeTyped(String namespace, String attribute, Class<TS> filter) {
        return this.attributes.getAttributeTyped(namespace, attribute, filter);
    }

    public void setElementType(ElementType elementType) {
        if (elementType == null) {
            throw new NullPointerException("Element.setElementType(..): ElementType cannot be null");
        }
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "element-type", elementType, true);
    }

    @Override
    public ElementType getElementType() {
        if (this.elementType == null) {
            Object maybeElementType = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "element-type");
            this.elementType = maybeElementType instanceof ElementType ? (ElementType)maybeElementType : LegacyType.INSTANCE;
        }
        return this.elementType;
    }

    public String getElementTypeName() {
        return this.getElementType().getMetaData().getName();
    }

    @Override
    public final ElementMetaData getMetaData() {
        return this.getElementType().getMetaData();
    }

    public final Band getParent() {
        if (this.parent instanceof Band) {
            return (Band)this.parent;
        }
        return null;
    }

    @Override
    public final Section getParentSection() {
        return this.parent;
    }

    protected final void setParent(Section parent) {
        this.parent = parent;
        this.notifyElement();
    }

    protected void notifyElement() {
    }

    public void setName(String name) {
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "name", name);
    }

    @Override
    public String getName() {
        Object o = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "name");
        if (o != null) {
            return String.valueOf(o);
        }
        return "";
    }

    @Override
    public final DataSource getDataSource() {
        return this.datasource;
    }

    @Override
    public void setDataSource(DataSource ds) {
        if (ds == null) {
            throw new NullPointerException("Element.setDataSource(...) : null data source.");
        }
        this.datasource = ds;
        this.notifyNodePropertiesChanged();
    }

    public boolean isVisible() {
        return this.getStyle().getBooleanStyleProperty(ElementStyleKeys.VISIBLE, true);
    }

    public void setVisible(boolean b) {
        if (b) {
            this.getStyle().setStyleProperty(ElementStyleKeys.VISIBLE, Boolean.TRUE);
        } else {
            this.getStyle().setStyleProperty(ElementStyleKeys.VISIBLE, Boolean.FALSE);
        }
    }

    @Override
    public Element clone() {
        try {
            Element e = (Element)super.clone();
            e.style = (InternalElementStyleSheet)this.style.clone();
            e.datasource = this.datasource.clone();
            e.parent = null;
            e.style.updateElementReference(e);
            e.elementContext = null;
            if (this.attributeExpressions != null) {
                e.attributes = this.attributes.clone();
                e.attributeExpressions = this.attributeExpressions.clone();
                String[] namespaces = e.attributeExpressions.getNameSpaces();
                for (int i = 0; i < namespaces.length; ++i) {
                    String namespace = namespaces[i];
                    Map attrsNs = this.attributeExpressions.getAttributes(namespace);
                    for (Map.Entry entry : attrsNs.entrySet()) {
                        Expression exp = (Expression)entry.getValue();
                        e.attributeExpressions.setAttribute(namespace, (String)entry.getKey(), exp == null ? null : (Expression)exp.clone());
                    }
                }
            } else if (e.cachedAttributes != null) {
                e.attributes = this.attributes;
                e.copyOnWrite = true;
                this.copyOnWrite = true;
            } else {
                e.copyOnWrite = false;
                e.attributes = this.attributes.clone();
            }
            if (this.styleExpressions != null) {
                e.styleExpressions = (HashMap)this.styleExpressions.clone();
                for (Map.Entry<StyleKey, Expression> entry : e.styleExpressions.entrySet()) {
                    Expression exp = entry.getValue();
                    entry.setValue((Expression)exp.clone());
                }
            }
            return e;
        }
        catch (CloneNotSupportedException cne) {
            throw new IllegalStateException(cne);
        }
    }

    public final Element derive() {
        return this.derive(false);
    }

    public Element derive(boolean preserveElementInstanceIds) {
        try {
            Element e = (Element)super.clone();
            e.elementContext = null;
            if (!preserveElementInstanceIds) {
                e.treeLock = new InstanceID();
            }
            e.style = (InternalElementStyleSheet)this.style.derive(preserveElementInstanceIds);
            e.datasource = this.datasource.clone();
            e.parent = null;
            e.style.updateElementReference(e);
            e.attributes = this.attributes.clone();
            e.copyOnWrite = false;
            ElementMetaData metaData = e.getMetaData();
            String[] namespaces = e.attributes.getNameSpaces();
            for (int i = 0; i < namespaces.length; ++i) {
                String namespace = namespaces[i];
                Map attrsNs = this.attributes.getAttributes(namespace);
                for (Map.Entry entry : attrsNs.entrySet()) {
                    Object value = entry.getValue();
                    String name = (String)entry.getKey();
                    AttributeMetaData data = metaData.getAttributeDescription(namespace, name);
                    if (data == null && logger.isDebugEnabled()) {
                        logger.debug((Object)(this.getElementTypeName() + ": Attribute " + namespace + "|" + name + " is not listed in the metadata."));
                    }
                    if (value instanceof Cloneable) {
                        e.attributes.setAttribute(namespace, name, ObjectUtilities.clone(value));
                        continue;
                    }
                    if (data == null || !data.isComputed() || data.isDesignTimeValue()) {
                        e.attributes.setAttribute(namespace, name, value);
                        continue;
                    }
                    e.attributes.setAttribute(namespace, name, null);
                }
            }
            if (e.cachedAttributes != null && e.attributes.getChangeTracker() != e.cachedAttributes.getChangeTracker()) {
                e.cachedAttributes = null;
            }
            if (this.attributeExpressions != null) {
                e.attributeExpressions = this.attributeExpressions.clone();
                String[] attrExprNamespaces = e.attributeExpressions.getNameSpaces();
                for (int i = 0; i < attrExprNamespaces.length; ++i) {
                    String namespace = attrExprNamespaces[i];
                    Map attrsNs = this.attributeExpressions.getAttributes(namespace);
                    for (Map.Entry entry : attrsNs.entrySet()) {
                        Expression exp = (Expression)entry.getValue();
                        e.attributeExpressions.setAttribute(namespace, (String)entry.getKey(), exp == null ? null : exp.getInstance());
                    }
                }
            }
            if (this.styleExpressions != null) {
                e.styleExpressions = (HashMap)this.styleExpressions.clone();
                for (Map.Entry<StyleKey, Expression> entry : e.styleExpressions.entrySet()) {
                    Expression exp = entry.getValue();
                    entry.setValue(exp.getInstance());
                }
            }
            return e;
        }
        catch (CloneNotSupportedException cne) {
            throw new IllegalStateException(cne);
        }
    }

    @Override
    public ElementStyleSheet getStyle() {
        return this.style;
    }

    @Override
    public final Object getTreeLock() {
        Section parent = this.getParentSection();
        if (parent != null) {
            return parent.getTreeLock();
        }
        return this.treeLock;
    }

    @Override
    public String getId() {
        return (String)this.getAttribute("http://www.w3.org/XML/1998/namespace", "id");
    }

    public void setId(String id) {
        this.setAttribute("http://www.w3.org/XML/1998/namespace", "id", id);
    }

    @Override
    public final InstanceID getObjectID() {
        return this.treeLock;
    }

    public boolean isDynamicContent() {
        return this.getStyle().getBooleanStyleProperty(ElementStyleKeys.DYNAMIC_HEIGHT);
    }

    public void setDynamicContent(boolean dynamicContent) {
        this.getStyle().setBooleanStyleProperty(ElementStyleKeys.DYNAMIC_HEIGHT, dynamicContent);
    }

    @Override
    public ReportDefinition getReportDefinition() {
        if (this.parent != null) {
            return this.parent.getReportDefinition();
        }
        return null;
    }

    public ReportDefinition getMasterReport() {
        if (this.parent != null) {
            return this.parent.getMasterReport();
        }
        return null;
    }

    public void setHRefTarget(String target) {
        this.getStyle().setStyleProperty(ElementStyleKeys.HREF_TARGET, target);
    }

    public String getHRefTarget() {
        return (String)this.getStyle().getStyleProperty(ElementStyleKeys.HREF_TARGET);
    }

    @Override
    public ElementStyleSheet getDefaultStyleSheet() {
        return ElementDefaultStyleSheet.getDefaultStyle();
    }

    @Override
    public void setStyleExpression(StyleKey property, Expression function) {
        if (this.styleExpressions == null) {
            if (function == null) {
                return;
            }
            this.styleExpressions = new HashMap();
        }
        Expression oldValue = function == null ? this.styleExpressions.remove(property) : this.styleExpressions.put(property, function);
        this.notifyNodePropertiesChanged(new StyleExpressionChange(property, oldValue, function));
    }

    @Override
    public Expression getStyleExpression(StyleKey property) {
        if (this.styleExpressions == null) {
            return null;
        }
        return this.styleExpressions.get(property);
    }

    @Override
    public Map<StyleKey, Expression> getStyleExpressions() {
        if (this.styleExpressions != null) {
            return Collections.unmodifiableMap(this.styleExpressions);
        }
        return Collections.emptyMap();
    }

    public ResourceKey getDefinitionSource() {
        Object o = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "source");
        if (o instanceof ResourceKey) {
            return (ResourceKey)o;
        }
        if (this.parent != null) {
            return this.parent.getDefinitionSource();
        }
        return null;
    }

    public ResourceKey getContentBase() {
        Object o = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "content-base");
        if (o instanceof ResourceKey) {
            return (ResourceKey)o;
        }
        if (this.parent != null) {
            return this.parent.getContentBase();
        }
        return null;
    }

    @Override
    public long getChangeTracker() {
        return this.changeTracker;
    }

    public void notifyNodePropertiesChanged() {
        this.updateChangedFlagInternal(this, 0, null);
    }

    public void notifyNodePropertiesChanged(Object parameter) {
        this.updateChangedFlagInternal(this, 0, parameter);
    }

    public void notifyNodeChildAdded(Object o) {
        this.updateChangedFlagInternal(this, 1, o);
    }

    public void notifyNodeChildRemoved(Object o) {
        this.updateChangedFlagInternal(this, 2, o);
    }

    public void notifyNodeStructureChanged() {
        this.updateChangedFlagInternal(this, 3, null);
    }

    protected void updateChangedFlagInternal(ReportElement element, int type, Object parameter) {
        ++this.changeTracker;
        if (this.parent != null) {
            this.parent.updateChangedFlagInternal(element, type, parameter);
        }
    }

    protected final void updateInternalChangeFlag() {
        ++this.changeTracker;
    }

    protected final void setChangeTracker(long changeTracker) {
        this.changeTracker = changeTracker;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        ReportAttributeMap<Object> attributes = this.attributes;
        stream.writeLong(attributes.getChangeTracker());
        String[] nameSpaces = attributes.getNameSpaces();
        stream.writeObject(nameSpaces);
        for (int i = 0; i < nameSpaces.length; ++i) {
            String nameSpace = nameSpaces[i];
            String[] names = attributes.getNames(nameSpace);
            stream.writeObject(names);
            for (int j = 0; j < names.length; ++j) {
                String name = names[j];
                Object attribute = attributes.getAttribute(nameSpace, name);
                AttributeMetaData data = this.getMetaData().getAttributeDescription(nameSpace, name);
                if (data != null) {
                    if (data.isTransient()) {
                        stream.writeByte(1);
                        continue;
                    }
                    if (attribute instanceof ResourceKey) {
                        ResourceKey key = (ResourceKey)attribute;
                        ResourceKey parent = key.getParent();
                        if ("http://reporting.pentaho.org/namespaces/engine/attributes/core".equals(nameSpace) && ("content-base".equals(name) || "source".equals(name))) {
                            if (parent != null) {
                                if (this.isKeySerializable(parent)) {
                                    stream.writeByte(0);
                                    SerializerHelper.getInstance().writeObject((Object)parent, stream);
                                    continue;
                                }
                                stream.writeByte(1);
                                continue;
                            }
                            if (this.isKeySerializable(key)) {
                                stream.writeByte(0);
                                SerializerHelper.getInstance().writeObject((Object)key, stream);
                                continue;
                            }
                            stream.writeByte(1);
                            continue;
                        }
                        if ("Resource".equals(data.getValueRole()) || parent != null) {
                            stream.writeByte(0);
                            try {
                                ResourceKey resourceKey = ResourceKeyUtils.embedResourceInKey((ResourceManager)this.locateResourceManager(), (ResourceKey)key, (Map)key.getFactoryParameters());
                                SerializerHelper.getInstance().writeObject((Object)resourceKey, stream);
                                continue;
                            }
                            catch (ResourceException e) {
                                throw new IOException("Failed to convert resource-key into byte-array key: " + (Object)((Object)e));
                            }
                        }
                        stream.writeByte(0);
                        SerializerHelper.getInstance().writeObject(attribute, stream);
                        continue;
                    }
                    if (SerializerHelper.getInstance().isSerializable(attribute)) {
                        stream.writeByte(0);
                        SerializerHelper.getInstance().writeObject(attribute, stream);
                        continue;
                    }
                    stream.writeByte(1);
                    continue;
                }
                if (attribute instanceof String) {
                    stream.writeByte(0);
                    SerializerHelper.getInstance().writeObject(attribute, stream);
                    continue;
                }
                stream.writeByte(1);
            }
        }
    }

    private boolean isKeySerializable(ResourceKey key) {
        try {
            ObjectOutputStream oout = new ObjectOutputStream((OutputStream)new NullOutputStream());
            oout.writeObject(key);
            oout.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private ResourceManager locateResourceManager() {
        ReportDefinition report = this.getMasterReport();
        if (report instanceof MasterReport) {
            MasterReport mr = (MasterReport)report;
            return mr.getResourceManager();
        }
        return new ResourceManager();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.attributes = new ReportAttributeMap(stream.readLong());
        String[] nameSpaces = (String[])stream.readObject();
        for (int i = 0; i < nameSpaces.length; ++i) {
            String nameSpace = nameSpaces[i];
            String[] names = (String[])stream.readObject();
            for (int j = 0; j < names.length; ++j) {
                String name = names[j];
                byte nullHandler = stream.readByte();
                if (nullHandler != 0) continue;
                Object attribute = SerializerHelper.getInstance().readObject(stream);
                this.attributes.setAttribute(nameSpace, name, attribute);
            }
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder(100);
        b.append(this.getClass().getName());
        b.append("={name=\"");
        b.append(this.getName());
        b.append("\", type=\"");
        b.append(this.getElementTypeName());
        b.append("\"}");
        return b.toString();
    }

    @Override
    public ReportElement[] getChildElementsByType(ElementType type) {
        return ReportStructureMatcher.findElementsByType(this, type);
    }

    @Override
    public ReportElement getChildElementByType(ElementType type) {
        return ReportStructureMatcher.findElementByType(this, type);
    }

    @Override
    public ReportElement[] getChildElementsByName(String name) {
        return ReportStructureMatcher.findElementsByName(this, name);
    }

    public void copyInto(Element target) {
        ElementMetaData metaData = this.getMetaData();
        String[] attributeNamespaces = this.getAttributeNamespaces();
        for (int i = 0; i < attributeNamespaces.length; ++i) {
            String namespace = attributeNamespaces[i];
            String[] attributeNames = this.getAttributeNames(namespace);
            for (int j = 0; j < attributeNames.length; ++j) {
                String name = attributeNames[j];
                AttributeMetaData attributeDescription = metaData.getAttributeDescription(namespace, name);
                if (attributeDescription == null || attributeDescription.isTransient() || attributeDescription.isComputed() || "element-type".equals(name) && "http://reporting.pentaho.org/namespaces/engine/attributes/core".equals(namespace)) continue;
                target.setAttribute(namespace, name, this.getAttribute(namespace, name), false);
            }
        }
        String[] attrExprNamespaces = this.getAttributeExpressionNamespaces();
        for (int i = 0; i < attrExprNamespaces.length; ++i) {
            String namespace = attrExprNamespaces[i];
            String[] attributeNames = this.getAttributeExpressionNames(namespace);
            for (int j = 0; j < attributeNames.length; ++j) {
                String name = attributeNames[j];
                AttributeMetaData attributeDescription = metaData.getAttributeDescription(namespace, name);
                if (attributeDescription == null || attributeDescription.isTransient()) continue;
                target.setAttributeExpression(namespace, name, this.getAttributeExpression(namespace, name));
            }
        }
        ElementStyleSheet styleSheet = this.getStyle();
        StyleKey[] styleKeys = styleSheet.getDefinedPropertyNamesArray();
        for (int i = 0; i < styleKeys.length; ++i) {
            StyleKey styleKey = styleKeys[i];
            if (styleKey == null) continue;
            target.getStyle().setStyleProperty(styleKey, styleSheet.getStyleProperty(styleKey));
        }
        Set<Map.Entry<StyleKey, Expression>> styleExpressionEntries = this.getStyleExpressions().entrySet();
        for (Map.Entry<StyleKey, Expression> entry : styleExpressionEntries) {
            target.setStyleExpression(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public <T> T getElementContext(Class<T> contextType) {
        if (contextType.isInstance(this.elementContext)) {
            return contextType.cast(this.elementContext);
        }
        try {
            T elementContext = contextType.newInstance();
            this.elementContext = elementContext;
            return elementContext;
        }
        catch (Exception e) {
            throw new InvalidReportStateException("Unable to create element context of " + contextType, e);
        }
    }

    public void copyAttributes(ReportAttributeMap<Object> attributes) {
        this.attributes.putAll(attributes);
        this.cachedAttributes = null;
        Object value = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "element-type");
        this.elementType = value instanceof ElementType ? (ElementType)value : LegacyType.INSTANCE;
    }

    private static class InternalElementStyleSheet
    extends ElementStyleSheet {
        private Element element;

        protected InternalElementStyleSheet(Element element) {
            this.element = element;
        }

        public Element getElement() {
            return this.element;
        }

        protected void updateElementReference(Element e) {
            if (e == null) {
                throw new NullPointerException("Invalid implementation: Self reference cannot be null after cloning.");
            }
            this.element = e;
        }

        @Override
        public void setStyleProperty(StyleKey key, Object value) {
            long l = this.getChangeTracker();
            Object oldValue = super.isLocalKey(key) ? super.getStyleProperty(key) : null;
            super.setStyleProperty(key, value);
            if (l != this.getChangeTracker()) {
                this.element.notifyNodePropertiesChanged(new StyleChange(key, oldValue, value));
            }
        }
    }
}

